
 ; setup the battle
initBattle:
 ; this is how a battle starts

 ; select enemies

 ld hl,enemyTable
 ld b,1
 ld d,24
 ld e,0
 call addEnemy

 ld hl,enemyTable+10
 ld b,1
 ld d,0
 ld e,12
 call addEnemy

 ld hl,enemyTable+20
 ld b,1
 ld d,24
 ld e,24
 call addEnemy

 ; setup party AP/DP

 ld hl,attrib1
 call setupAP
 ld (battleTable+2),a
 ld hl,attrib2
 call setupAP
 ld (battleTable+6),a
 ld hl,attrib3
 call setupAP
 ld a,230
 ld (battleTable+10),a
 ; battle enemies (prior to any of your gauges filling up)

battleLoop:
 ld a,(enemyTable)
 or a
 jp z,winBattle

 B_CALL GrBufClr
 call paintBattle		; show battle graphics
 B_CALL GrBufCpy
 
 ld a,(battleTable)		; char 1
 dec a
 jr z,setupBattleScreen
 ld a,(battleTable+4)		; char 2
 dec a
 jr z,setupBattleScreen
 ld a,(battleTable+8)		; char 3
 dec a
 jr nz,battleLoop

;-------------------------
;  999 | Cursor State 9
; 9  9 |------------------
;  999 | setupBattleScreen
;    9 |------------------  
;  99  | info:
;-------
;  gauge filled up!
;  setup battle cursor system
;----------------------------

setupBattleScreen:
 ld a,9
 ld (cursorState),a
 ld a,4			; offset by 1, b/c state 10 uses same routine
 ld (cursorMax),a	; zone for cursor
 xor a
 ld (cursorVideo),a	; reverse video (0=no,1=yes)

 ld de,plotsscreen+480	; de = where to draw cursor at
 ld hl,cursorTable

 ld b,4
setupBattleTableLoop:
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl

 push hl
  ld hl,6*12
  add hl,de
  ex de,hl
 pop hl
 djnz setupBattleTableLoop

addCursorToYourParty:
 ld a,(cursorMax)
 dec a
 ld (cursorMax),a
 ld de,plotsscreen+45
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl

 ld de,plotsscreen+224
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl

 ld de,plotsscreen+405
 ld (hl),e
 inc hl
 ld (hl),d

 ld hl,showBattleOptions
 ld (drawMenu),hl
 jp redraw

;----------------------------------
;  1  00  | Cursor State 10
; 11 0  0 |------------------------
;  1 0  0 | setupSelectCharToAttack
;  1 0  0 |------------------------ 
; 111 00  | info:
;----------
;  allows you to select the char
; that you want to attack
;----------------------------------
setupSelectCharToAttack:
 ld a,10
 ld (cursorState),a
 xor a
 ld (cursorPos),a
 ld (cursorVideo),a
 ld (cursorMax),a
 ld hl,itemSelect
 dec (hl)

 ld hl,cursorTable
 ld de,enemyTable

putCursorOnEnemyLoop:
 ld a,(de)
 or a
 jp z,addCursorToYourParty

 ld a,(cursorMax)
 inc a
 ld (cursorMax),a

 push de
 push hl
  inc de
  inc de
  inc de
  ld a,(de)	; at enemy+3
  ld b,a
  add a,b
  add a,b
  ld l,a
  ld h,0
  add hl,hl
  add hl,hl

  dec de
  ld a,(de)
  sra a
  sra a
  sra a
  ld c,a
  ld b,0
  add hl,bc
  ld bc,plotsscreen
  add hl,bc
  ex de,hl
 pop hl

  ld (hl),e
  inc hl
  ld (hl),d
  inc hl
 pop de

 push hl
  ld hl,10
  add hl,de
  ex de,hl
 pop hl
 jr putCursorOnEnemyLoop



; display the character at table entry (hl).

displayChar:
 inc hl
 ld a,(hl)
 cp 128
 jp nc,readyToFight

 dec hl
 ld a,(hl)
 or a
 jp z,skipCharInactive
 cp 1
 jp z,blinkCharBattle

 push af
  ld a,(inAttack)
  or a
  jr z,skipNotSimultaneous

  ld a,(attackerChar)
  add a,b
  cp 3
  jr z,skipNotSimultaneous
 pop af
 jp showCharPicNOW

skipNotSimultaneous:
 pop af
 inc a
 ld (hl),a
 cp 15
 jp c,showCharPicNOW

 push hl
 push bc
 push af
  ld a,(inAttack)
  or a
  call z,setupAttack
  ld a,1
  ld (inAttack),a
 pop af

 push af
  sra a
  ld b,a
  ld a,(victimHPy)
  add a,b
  ld (penrow),a
  ld a,(victimHPx)
  ld (pencol),a
  ld hl,(victimHPlost)
  B_CALL setxxxxop2
  B_CALL op2toop1
  ld a,5
  B_CALL dispop1a
 pop af
 pop bc
 pop hl

 cp 40
 jr c,skipResetAttack

 xor a
 ld (inAttack),a
 ld (hl),0
skipResetAttack:
 ld a,4
 sub b

 push af			; show weapon
  ld hl,weaponSprites
  dec a
  sla a
  sla a
  sla a
  ld e,a
  ld d,0
  add hl,de
 pop af

 push hl
 call getBattleCharSprite	; hl contains sprite

 ld a,64
 ld de,96
 add hl,de		; attack 1
 ld e,c
 push de
 push af
 call align16
 pop af
 pop de
 sub 4
 pop hl
 jp sprite8

readyToFight:
 dec hl
 ld (hl),1		; set state to gauge ready

 ld a,(charSelect)
 or a
 jr nz,blinkCharBattle

 push bc
 ld a,4			; ????? DOES THIS WORK!!!
 sub b
 ld (charSelect),a
 ld b,a
 ld a,(cursorMax)
 add a,b
 ld b,a
 ld a,(enemiesKilled)
 add a,b
 inc a
 ld (itemSelect),a
 pop bc

blinkCharBattle:
 ld a,(cursorCount)
 srl a
 and 1b
 ret z			; blinking effect

 jr showCharPicNOW

skipCharInactive:
 inc hl
 ld a,(hl)

 push af
 push bc
 push hl
  ld a,4
  sub b
  call getBattleCharSprite	; hl contains sprite
  ld a,(de)
  srl a 
  srl a
  srl a
  ld d,a
 pop hl
 pop bc
 pop af
 add a,d
 ld (hl),a

showCharPicNOW:
 push bc
  ld a,4
  sub b
  call getBattleCharSprite	; hl contains sprite
 pop bc
 ld a,b
 dec a
 jr z,battleSpriteBack
 dec a
 jr nz,battleSpriteBack

 ld a,72
 jr drawBattleSpriteNOW

battleSpriteBack:
 ld a,80
 jr drawBattleSpriteNOW

drawBattleSpriteNOW:
 ld e,c
 jp align16


getBattleCharSprite:
 ld hl,battleSprites
 ld de,char1+14
 dec a
 ret z
 ld b,a
getBattleCharSpriteLoop:
 push de
  ld de,32
  add hl,de
 pop de
 push hl
  ld hl,31
  add hl,de
  ex de,hl
 pop hl
 djnz getBattleCharSpriteLoop
 ret

;--------------------
;--------------------
; PAINT BATTLE SCREEN
;--------------------
;--------------------
paintBattle:

 ; show the outline on the ready gauge for each party member
 ; inside of gauge is 16x3

 ld a,72
 ld e,47
 call showGaugeOutline

 ld a,72
 ld e,53
 call showGaugeOutline

 ld a,72
 ld e,59
 call showGaugeOutline

 ; loop through enemies
 ;  display action if necessary

; db <sprite ID>,<state>,<xPos>,<yPos>
; db <atkPwr>,<defPwr>
; dw <currentHP>,<maxHP>

 ld hl,enemyTable
 ld a,(hl)
 or a
 jr z,noEnemiesToShow

showEnemiesLoop:
 ld b,a
 push hl
  ld hl,bird
  dec b
  jr z,skipIncEnemySprite
  ld de,32
findEnemySpriteLoop:
  add hl,de
  djnz findEnemySpriteLoop

skipIncEnemySprite:
  ex de,hl
 pop hl


 inc hl		; state
 inc hl		; xpos
 ld a,(hl)
 inc hl
 ld b,(hl)
 push hl
 ex de,hl
 ld e,b		; ypos
  call align16
 pop hl
 
 ld de,7
 add hl,de
 ld a,(hl)
 or a
 jr nz,showEnemiesLoop


noEnemiesToShow:
 ; characters blink when hit or ready to attack (menu pops up too)
 ;  enemies blink when hit or attacking

 ; loop through chars
 ;  display action if necessary

 ld hl,battleTable
 ld b,3
 ld c,0
showCharsBattleLoop:
 push bc
 push hl
  call displayChar
 pop hl
 pop bc

  ; display the gauge
 push bc
 push hl
  ld c,48

  ld a,3
  sub b
  ld b,a
  add a,a
  add a,b
  add a,a
  add a,c
  ld c,a
 inc hl

 ld a,(hl)
 srl a
 srl a
 srl a
 ld b,a
 or a
 jr z,skipDispGauge

 ld a,79
dispGaugeLoop:
 push bc
 push af
 ld e,c
 call bar_sprite
 pop af
 inc a
 pop bc
 djnz dispGaugeLoop

skipDispGauge:
 pop hl
 inc hl
 inc hl
 inc hl
 inc hl
 pop bc	; end display gauge


 ld a,15
 add a,c
 ld c,a
 djnz showCharsBattleLoop

 ; bottom bar

 ; show the names

 ld hl,256*46+40
 ld (pencol),hl
 ld hl,char1
 call vputsApp

 ld hl,256*52+40
 ld (pencol),hl
 ld hl,char2
 call vputsApp

 ld hl,256*58+40
 ld (pencol),hl
 ld hl,char3
 call vputsApp

 ; show the hp

 ld hl,256*46+60
 ld (pencol),hl
 ld hl,hp1
 call showHL

 ld hl,256*52+60
 ld (pencol),hl
 ld hl,hp2
 call showHL

 ld hl,256*58+60
 ld (pencol),hl
 ld hl,hp3
 call showHL
 ret



showBattleOptions:
 ld a,(enemyTable)
 or a
 jp z,winBattle

 call paintBattle

 ld hl,plotsscreen+481

 ld b,24
boxBattleOps:
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),11111000b
 ld de,10
 add hl,de
 djnz boxBattleOps

 set textInverse, (iy+textflags) ; sets inverse.

 ld hl,256*40+10
 ld (pencol),hl
 ld hl,battleText0
 call vputsApp

 ld hl,256*46+10
 ld (pencol),hl
 ld hl,battleText1
 call vputsApp

 ld hl,256*52+10
 ld (pencol),hl
 ld hl,battleText2
 call vputsApp

 ld hl,256*58+10
 ld (pencol),hl
 ld hl,battleText3
 call vputsApp

 res textInverse, (iy+textflags) ; resets inverse.

 jp returnToRedraw

findCharPic:
 ld hl,dknightPic
 dec a
 ret z

 ld de,32
 ld b,a
findCharPicLoop:
 add hl,de
 djnz findCharPicLoop
 ret

showGaugeOutline:
 push af
 push de
  ld hl,gaugeSprite1
  call sprite
 pop de
 pop af
 add a,8
 push af
 push de
  ld hl,gaugeSprite2
  call sprite
 pop de
 pop af
 add a,8
 ld hl,gaugeSprite3
 jp sprite
