; RPG Demo - by Harper Maddox

; 10/29/01 - converted into an app

 include "ti83plus.inc"

; ---
; equates
;------


 ; initialize

intrptEnPort    equ 3           ; interrupt enable (in/out) 
iall                    equ 1011b 
_LCD_DRIVERON   equ 4978h 
onFlags                 equ 9           ;on key flags 
onRunning               equ 3           ; 1=calculator is running 
monFlags                equ     1       ;monitor flags 
monAbandon              equ     4       ; 1=don't start any long process in put away 
_PutAway                equ 403Ch 
_reloadAppEntryVecs equ 4C36h 
_settblgraphdraw        equ 4C00h 
_ShRAcc		equ 41D4h

diDown		.equ 254 
diLeft		.equ 253 
diRight		.equ 251 
diUp		.equ 247 
diY		.equ 239
diGraph .equ 254
di2nd		.equ 223
diMode		.equ 191
diAlpha		.equ 127

;----
; Variables
;------------

items .equ appBackUpScreen
quitSP .equ items+63
randseed .equ quitSP+66
itemOffset .equ items+67
itemSelect .equ itemOffset+1
drawMenu .equ itemSelect+1
cursorPos .equ itemSelect+3
cursorCount .equ cursorPos+1
cursorScroll .equ cursorCount+1
cursorMax .equ cursorScroll+1
cursorState .equ cursorMax+1
cursorVideo .equ cursorState+1
cursorTable .equ cursorVideo+1	; 20 bytes

itemSelection .equ cursorTable+20
itemID .equ itemSelection+2
charSelect .equ itemID+2
itemXPos .equ charSelect+1
itemUseClass .equ itemXPos+1

; battle used

attackState .equ itemSelection
currentChar .equ itemUseClass+1
victimChar .equ currentChar
inAttack .equ currentChar+1
victimHPlost .equ inAttack+1
victimHPx .equ victimHPlost+2
victimHPy .equ victimHPx+1
enemiesKilled .equ victimHPy+1
attackerChar .equ enemiesKilled+1
battleTable .equ attackerChar+1
; format: 4 byte entry
; db <state>,<gauge_position>,<AP>,<DP>

enemyTable .equ battleTable+12
; format: 10 byte tag

; db <sprite ID>,<state>,<xPos>,<yPos>
; db <atkPwr>,<defPwr>
; dw <currentHP>,<maxHP>

attackQueue .equ enemyTable+60	; room for 6 enemies
; 4 byte entry format.
; db <state>,<charID>,<victimChar>,<special>
; attacks may occur every 8 cycles
;  everything freezes during an attack or spell
;  residual effects take longer (hp lost bouncing)
; states:
;  fight, magic, item, specials
; special:
;  tag reserved for a spell and/or item
; charID:
;  char1,2,3,enemy1,2,3...
; victimChar: same as charID

temp .equ attackQueue+30

;------------------------
;--      HEADER        --
;------------------------

EXT_APP equ 1   ;This definition is required of all apps
cseg            ;This linker directive is required of all apps.

;This is the application header definition area required for all apps.
 db 080h,0Fh    ;Field: Program length
 db   00h,00h,00h,00h ;Length=0 (N/A for unsigned apps)
 db 080h,012h    ;Field: Program type
 db   01h,04h    ;Type= Shareware, TI-83Plus
 db 080h,021h    ;Field: App ID
 db   01h        ;Id = 1
 db 080h,031h    ;Field: App Build
 db   01h        ;Build = 1
 db 080h,048h    ;Field: App Name
 db "RPG Demo"   ;Name = "Hello   " must be 8 characters
 db 080h,081h    ;Field: App Pages
 db 01h          ;App Pages = 1
 db 080h,090h    ;No default splash screen
 db 03h,026h ,09h,04h, 04h,06fh,01bh,80h     ;Field: Date stamp- 5/12/1999
 db 02h,0dh,040h                             ;Dummy encrypted TI date stamp signature
 db 0a1h ,06bh ,099h ,0f6h ,059h ,0bch ,067h 
 db 0f5h ,085h ,09ch ,09h ,06ch ,0fh ,0b4h ,03h ,09bh ,0c9h 
 db 03h ,032h ,02ch ,0e0h ,03h ,020h ,0e3h ,02ch ,0f4h ,02dh 
 db 073h ,0b4h ,027h ,0c4h ,0a0h ,072h ,054h ,0b9h ,0eah ,07ch 
 db 03bh ,0aah ,016h ,0f6h ,077h ,083h ,07ah ,0eeh ,01ah ,0d4h 
 db 042h ,04ch ,06bh ,08bh ,013h ,01fh ,0bbh ,093h ,08bh ,0fch 
 db 019h ,01ch ,03ch ,0ech ,04dh ,0e5h ,075h 
 db 80h,7Fh      ;Field: Program Image length
 db   0,0,0,0    ;Length=0, N/A
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 
;End of header data

;------------------------
;-- START PROGRAM CODE --
;------------------------

prog_start:
 call initialize
 set appTextSave,(iy+appFlags)
 set textwrite,(iy+sGrFlags)    ; _vputs writes directly to graph

 ld hl,appBackUpScreen
 ld (hl),0
 ld de,appBackUpScreen+1
 ld bc,256
 ldir

 ; load items
 ld de,appBackUpScreen
 ld hl,item_list
 ld bc,63
 ldir

 jp setupOverworld


 include "appvar_utility.asm"
 include "tilemap.asm"

; jp setupMenuScreen

 include "equip.asm"

 include "setupitem.asm"

redraw:
 B_CALL GrBufClr

 ld hl,(drawMenu)
 jp (hl)

returnToRedraw:

 ; draw the hand

 call displayCursor

 ld a,(itemSelect)
 cp 0FFh
 jr z,skipMoveCursor

 ld a,(cursorPos)
 push af

 ld a,(itemOffset)
 ld c,a
 ld a,(cursorState)
 cp 3
 jr z,cursorItemOKstate
 ld c,0
cursorItemOKstate:
 ld a,(itemSelect)
 sub c
 ld (cursorPos),a
 xor a
 call showCursor

 pop af
 ld (cursorPos),a

skipMoveCursor:
 B_CALL GrBufCpy

 ei
 halt

 B_CALL GetCSC

 cp skDown
 jp z,CursorDOWN
 cp skUp
 jp z,CursorUP

 cp sk2nd
 jp z,selectCursor
 cp skGraph
 jp z,showDebugScreen
 cp skMode 
 jp nz,redraw

exitMenu:
 ; exit the current menu

 call delay

 ld a,(cursorState)
 cp 2
 jr z,skipDeselectItem
 cp 6
 jp z,setupEquipScreen

 ld a,(itemSelect)
 cp 0FFh
 jr z,skipDeselectItem

 ld a,0FFh
 ld (itemSelect),a
 jp redraw

skipDeselectItem:

 ; always reset these values
 ld a,0FFh
 ld (itemSelect),a

 xor a
 ld (itemOffset),a
 ld (cursorCount),a
 ld (cursorPos),a
 ld (cursorScroll),a

 ld a,(cursorState)
 cp 1
 jp z,exit
 cp 2
 jp z,setupMenuScreen
 cp 3
 jp z,setupMenuScreen
 cp 4
 jp z,setupItemScreen
 cp 5
 jp z,setupMenuScreen
 cp 6
 jp z,setupEquipScreen
 cp 9
 jp z,setupMenuScreen
 cp 10
 jp z,setupBattleScreen
			
 jp redraw

CursorDOWN:
 ld a,(cursorMax)
 ld b,a
 ld a,(cursorPos)
 cp b
 jr z,scrollCursorDown
 inc a
 ld (cursorPos),a
 jp redraw

scrollCursorDown:
 ld a,(cursorScroll)
 ld b,a
 ld a,(itemOffset)
 cp b
 jp z,redraw
 inc a
 ld (itemOffset),a
 jp redraw 

CursorUP:
 ld a,(cursorPos)
 or a
 jr z,scrollCursorUp
 dec a
 ld (cursorPos),a
 jp redraw

scrollCursorUp:
 ld a,(itemOffset)
 or a
 jp z,redraw
 dec a
 ld (itemOffset),a
 jp redraw

selectCursor:
 call waitUntilKEYup

 ld a,(cursorState)
 cp 4
 jp z,useItem
 cp 2
 jp z,AfterCharSelect
 cp 1
 jp z,activateMenuChoice
 cp 5
 jp z,setupEquipNewItemScreen
 cp 6
 jp z,equipNewItem
 cp 9
 jp z,setupSelectCharToAttack

 cp 10
 jp z,fightSelected

 cp 3
 jp nz,redraw

 ; this is only for the item menu

 ld a,(cursorPos)
 ld b,a
 ld a,(itemOffset)
 add a,b
 ld b,a
 ld a,(itemSelect)
 cp 0FFh
 jr nz,moveItem

 ld a,b
 ld (itemSelect),a
 jp redraw

moveItem:
 ld c,a
 ld a,b
 cp c
 jr z,executeItemSelection

 ; switch the two items

 ; hl - previous, de - new

 call getItemPosition
 push hl
  ld a,c
  call getItemPosition
 pop de

 ld b,3
itemMoveLoop:
 ld a,(de)
 ld c,(hl)
 ld (hl),a
 ld a,c
 ld (de),a
 inc hl
 inc de
 djnz itemMoveLoop


resetItemSelection:
 ld a,0FFh
 ld (itemSelect),a
 jp redraw

executeItemSelection:
 ; check to see if it is a potion or equipment
 call getItemPosition

 ld a,(hl)	; 1st byte is Item Type ID

 cp 1
 jp nz,redraw

 ld (itemSelection),hl		; save the item...

 ld a,2
 ld (cursorMax),a
 xor a
 ld (cursorPos),a
 ld (cursorScroll),a

 ld de,plotsscreen+128
 ld hl,cursorTable

 call setHLinc
 ld de,plotsscreen+308
 call setHLinc
 ld de,plotsscreen+476
 call setHLinc

 ld a,4
 ld (cursorState),a
 jr resetItemSelection


setHLinc:
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 ret


useItem:
 ; character is pointed to by cursorPos

 ld a,(cursorPos)
 call findChar
 ex de,hl		; char is in de

 ld hl,(itemSelection)

 inc hl			; we dont need to know the first byte

 ld a,(hl)
 ld (itemID),a
 cp 3
 jr c,usePotion

 jr removeItem

usePotion:
 push hl

  ld hl,6
  add hl,de

  call isHPfull
  jr c,dontUsePotion

  ld bc,100

  ld a,(itemID)
  cp 1
  jr z,dontUseXPotion

  ld bc,250

dontUseXPotion:
  ex de,hl
  add hl,bc  
  ex de,hl

  dec hl
  dec hl
  
  ld (hl),d
  dec hl
  ld (hl),e 
  call fixHP

 call removeItem

dontUsePotion:
 pop hl
 ; display error

 jp exitMenu

removeItem:
 inc hl
 ld a,(hl)
 dec a
 ld (hl),a
 ret nz

 dec hl
 ld (hl),0
 dec hl
 ld (hl),0
 ret


AfterCharSelect:
 ld a,(cursorPos)
 ld (charSelect),a

 ld a,(itemSelect)
 sub 4
; jp z,setupMagicScreen

 cp 1
 jp z,setupEquipScreen

 cp 2
 jp z,showStatusScreen

 jp redraw


;--------
; execute current battle selection
;--------
;  cursor pos: 1= fight, 2=special, 3=magic, 4=item
;--------
execBattleSelection:
 ld a,(cursorPos)
 or a
 jp z,fightSelected

 jp redraw


; ---
; within Menu
; ---
activateMenuChoice:
 ld a,(cursorPos)
 or a
 jp z,setupItemScreen
 cp 1									; magic -> battle
 jp z,initBattle

 cp 4
 jp c,setupSelectChar

 jp redraw


;-------------
; fix hp - make sure that cur hp <= max hp
;-------------
fixHP:
 call isHPfull
 ret nc

 ld (hl),c
 inc hl
 ld (hl),b
 ret

;--------------
; is hp full
;--------------
; input:
;  hl = cur hp, hl+2 = max hp
; output:
;  carry set if cur >= max
;--------------
isHPfull:
 ld e,(hl)
 inc hl
 ld d,(hl)
 inc hl
 ld c,(hl)
 inc hl
 ld b,(hl)

 ld a,e
 cp c
 ret nc

 ld a,d
 cp b
 ret nc
 
 scf
 ret


;--------------
; find char
;--------------
; input:
;  a - char #.  begins with 0
;--------------
findChar:
 ld hl,char1
 or a 
 ret z
 ld b,a
 ld de,31
findCharLoop:
 add hl,de
 djnz findCharLoop
 ret

;--------------
; Get Item Position
;--------------
; input:
;  a - item #, 0 is first
; destroys b,de
;--------------
getItemPosition:
 ld hl,items
 or a 
 ret z
 ld b,a
 ld de,3
getItemLoop:
 add hl,de
 djnz getItemLoop
 ret


;---------------
; animated cursor
;  5 sprites, 8 stages
;---------------
;
displayCursor:
 ld a,(cursorCount)
 inc a
 ld (cursorCount),a
 srl a
 and 111b
 
 cp 4
 jr c,showCursor

 xor 111b
 inc a

showCursor:
 ld hl,animCursor
 or a
 jr z,drawCursorNOW


 ld de,6
 ld b,a
cursorSpriteLoop:
 add hl,de
 djnz cursorSpriteLoop

drawCursorNOW:

 push hl

 ld a,(cursorPos)
 ld hl,cursorTable
 sla a

 ld d,0
 ld e,a

 add hl,de

 ld e,(hl)
 inc hl
 ld d,(hl)		; location is in de

 pop hl

 ld a,(cursorVideo)
 or a
 jr z,cursorNormVideo

 push de
  ld de,temp
  ld c,6
reverseVideoByte:
  ld a,(hl)
  push de
  ld e,8
  ld d,0
revBYTEloop:
  srl a		; destroy a bit // set carry if it was a ONE
  rl d		; place the bit ONTO a new byte
  dec e
  jr nz,revBYTEloop

  ld a,d
  pop de
  ld (de),a
  inc hl
  inc de
  dec c
  jr nz,reverseVideoByte
  ld hl,temp
 pop de
cursorNormVideo:

 ; display aligned sprite

 jp align6

delay:
 ei
 ld b,7
delayLoop:
 halt
 djnz delayLoop
 ret

 include "item.asm"
 include "menu.asm"
 include "status.asm"
 include "equipmenu.asm"

showDebugScreen:
 B_CALL GrBufClr
 ld hl,savesscreen
 call examine
 B_CALL GrBufClr

 ld hl,charSelect
 call examine
 jp redraw

examine:
 ld b,10
 ld c,0
debugLoop:
 push bc
 push hl
 xor a
 ld (pencol),a
 ld a,c
 ld (penrow),a
 ld a,(hl)
 ld l,a
 ld h,0
 call _setxxxxop2
 call _op2toop1
 ld a,3
 call _dispop1a

 pop hl
 pop bc

 inc hl
 push bc
 push hl
 ld a,50
 ld (pencol),a
 ld a,c
 ld (penrow),a
 ld a,(hl)
 ld l,a
 ld h,0
 call _setxxxxop2
 call _op2toop1
 ld a,3
 call _dispop1a

 pop hl
 pop bc
 inc hl
 ld a,6
 add a,c
 ld c,a
 djnz debugLoop

 B_CALL GrBufCpy
 call _getkey
 ret

align6:
 ld b,6
display6Loop:
 push bc
 ldi
 push hl
  ld hl,11
  add hl,de
  ex de,hl
 pop hl
 pop bc
 djnz display6Loop
 ret

 include "battle.asm"
 include "battle_utility.asm"
 include "setup.asm"
 include "initialize.asm"
 include "utility.asm"
 include "collision.asm"

 include "maps.asm"
 include "mapsprites.asm"
 include "data.h"

.end
END






