

initialize:
 ; initialize app

 B_CALL ForceFullScreen

;
;
;   this will handle turning off, battery pulls & GOTO's on errors
;
;
;
;
strt:
    ld      hl,AppVectors
;;    B_CALL  AppInit          ; install monitor vectors to catch putaways
;
    b_call  runindicoff
	 ret
;
;   I set an error handler so that if somehow the system displays an error
;   I can block the 'GOTO' option from being given.
;
;   quitSP is some ram location defined by the app writer 2 bytes
;
;   If you do this then when you exit your app from a 'QUIT' option
;   the stak level must be what it is at immediately following
;   then 'apponerr' macro below:
;
    apponerr  NoGoTo
;
    ld      (quitSP),sp      ; save sp so can do appofferr safely
;

;
;   execute your application
;
;


 ret


exit:
 B_CALL ClrLCDFull        ;Clear the screen
 B_CALL ClrTxtShd

;
;
;   This is exitting the app by the USERS CHOICE from selecting a
;   quit option in the main loop of your app
;
;   If the 'apponerr' was done at the start of the app then the
;   stack MUST be at the level immediately after the execution
;   of the 'apponerr' inorder for the 'appofferr' below toi work
;   properly.
;
QUITApp:
    ld      sp,(quitSP)      ; restore sp so can do appofferr safely
    appofferr                ; remove error handler to kill GOTO's
;
;
;   This entry point is entered in the MON VECTOR table set up at
;   the start of the app.
;
;
AppPutaway:
    res     plotLoc,(iy+plotFlags)      ; draws to display & buffer
    res     textwrite,(iy+sGrFlags)     ; small font written to dispaly
;
    b_call  ReloadAppEntryVecs          ; reload MON VECTORS with app loaders
;
    ld      (iy+textFlags),0
;
    bit     monabandon,(iy+monFlags)    ; Is calc being turned off ?
    jr      nz,turnOff                ; jump if turning off
;
    ld      a,iall
    out     (intrptEnPort),a
    b_call  LCD_DRIVERON
    set     onRunning,(iy+onFlags)
    ei
;
    b_jump  JForceCmdNoChar
;
turnOff:
    b_jump  PutAway                     ; don't switch to home screen
;                                       ; just do putaway of app
rawkeyHand:
dummy:
    ret

;
;
;   app's MON VECTOR table
;
AppVectors:
    dw      dummy
    dw      dummy
    dw      AppPutaway
    dw      dummy
    dw      dummy
    dw      dummy
    db      0



;
;
;   system error is being generated, kill the GOTO option.
;
;
NoGoTo:
    push    af
;
;   turning of the cursor hook is optional if you need to do it
;
;;    b_call  clrcursorhook
;
    res     curable,(iy+curflags)
    pop     af
    res     e_editf,a
;;    b_jump  jError
 ret
