
mapStart .equ saveSScreen
x .equ mapStart+2
y .equ x+1
mapX .equ y+1
mapY .equ mapX+1
charX .equ mapY+1
charY .equ charX+1
charDir .equ charY+1
charTimer .equ charDir+1
mapWidth .equ charTimer+1
mapHeight .equ mapWidth+1
tempSPRITE .equ mapHeight+1
drawmapCounter .equ tempSPRITE+1
keyHeld .equ drawmapCounter+1


setupOverworld:
 ld hl,map
 ld (mapStart),hl

 xor a
 ld (mapX),a
 ld a,2
 ld (mapY),a
 ld (charDir),a
 ld (keyHeld),a
 ld (charTimer),a
 ld a,42
 ld (charX),a
 ld a,26
 ld (charY),a
 ld a,16
 ld (mapWidth),a
 ld (mapHeight),a
 push af
moveLoopP:
 pop af

moveLoop:
 ld hl,charTimer
 inc (hl)

 B_CALL GrBufClr

 call drawmap

 ld hl,demoCharSprite
 ; determine which sprite to draw
 ld a,(charDir)
 add a,a
 ld b,a

 ld a,(charTimer)
 srl a
 srl a
 srl a
 srl a
 and 1b
 add a,b

 ld b,a
 add a,a
 add a,b
 add a,a
 add a,a
 add a,a
 ld e,a
 ld d,0
 add hl,de

 ld a,(charY)
 ld (y),a
 ld e,a
 ld a,(charX)
 ld (x),a
 call show12x12

 B_CALL GrBufCpy

 ei
 halt
 halt

 B_CALL GetCSC


 cp skLeft
 jr z,moveCharLeft
 cp skRight
 jr z,moveCharRight
 cp skUp
 jp z,moveCharUp
 cp skDown
 jp z,moveCharDown

 ; reset char timer
 push af
 xor a
 ;ld (charTimer),a
 pop af

 cp skAlpha
 jp z,setupMenuScreen

 cp skEnter
 jp z,debugMap

 cp skMode
 jr nz,moveLoop
 jp setupMenuScreen

moveCharLeft:
 xor a
 ld (charDir),a
 ld a,(charX)
 dec a
 dec a

 ld (x),a
 ld (temp),a
 call collide_left
 jp c,moveLoop
 ld a,(temp)

 cp 10
 jr z,scrollMapLeft

 ld (charX),a
 jp moveLoop

scrollMapLeft:
 ld a,(mapX)
 or a
 jp z,moveLoop
 dec a
 ld (mapX),a
 ld a,(charX)
 add a,10
 ld (charX),a
 jp moveLoop

moveCharRight:
 ld a,2
 ld (charDir),a
 ld a,(charX)
 inc a
 inc a

 ld (x),a
 ld (temp),a
 call collide_right
 jp c,moveLoop
 ld a,(temp)

 cp 74
 jr z,scrollMapRight

 ld (charX),a
 jp moveLoop

scrollMapRight:
 ld a,(mapWidth)
 sub 8
 ld b,a
 ld a,(mapX)
 cp b
 jp z,moveLoop

 inc a
 ld (mapX),a
 ld a,(charX)
 sub 10
 ld (charX),a
 jp moveLoop

moveCharUp:
 ld a,1
 ld (charDir),a
 ld a,(charY)
 dec a
 dec a

 ld (y),a
 ld (temp),a
 call collide_up
 jp c,moveLoop
 ld a,(temp)

 cp 14
 jr z,scrollMapUp

 ld (charY),a
 jp moveLoop

scrollMapUp:
 ld a,(mapY)
 or a
 jp z,moveLoop

 dec a
 ld (mapY),a
 ld a,(charY)
 add a,10
 ld (charY),a
 jp moveLoop

moveCharDown:
 ld a,3
 ld (charDir),a
 ld a,(charY)
 inc a
 inc a

 ld (y),a
 ld (temp),a
 call collide_down
 jp c,moveLoop
 ld a,(temp)

 cp 40
 jr z,scrollMapDown

 ld (charY),a
 jp moveLoop

scrollMapDown:
 ld a,(mapHeight)
 sub 5
 ld b,a
 ld a,(mapY)
 cp b
 jp z,moveLoop

 inc a
 ld (mapY),a
 ld a,(charY)
 sub 10
 ld (charY),a
 jp moveLoop


adjustMap:
 ld hl,(mapStart)
 ld a,(mapY)
 ld b,a
 or a
 jr z,_dontAdjustMap

 ld a,(mapWidth)
 ld e,a
 ld d,0
_adjustMapStart:
 add hl,de
 djnz _adjustMapStart

_dontAdjustMap:
 ld a,(mapX)
 ld e,a
 ld d,0
 add hl,de
 ret

drawmap:
 ; adjust map start
 call adjustMap

 ld a,1
 ld (drawmapCounter),a

 ; map Adjusted properly to (mapX, mapY)

 ld de,plotSScreen+24		; area to be painted

 ld c,5				; number of rows to display
rowLoop:
 ld b,8			; number of columns to display
columnLoop:
 ld a,(hl)			; tile Identification
 or a
 jr z,skipBlankTile

 push bc
  push hl
   dec a			; 0 = blank space
   ld c,a
   ld b,0
   ld hl,0
   add hl,bc			; hl = a*24
   add hl,hl			;  since each sprite is 24 bytes long
	add hl,bc
   add hl,hl
   add hl,hl
	add hl,hl

   ld bc,tilemapSprites
   add hl,bc			; add offset to sprites

	; draw 12x12 sprite
	push de
    ld a,(drawmapCounter)
	 and 1
	 jr z,_drawOddTile

	 call drawEvenTile
    jr _tileDrawn

_drawOddTile:
    call drawOddTile

_tileDrawn:
	pop de
  pop hl
 pop bc

skipBlankTile:
 ; MOVE TO NEXT TILE LOCATION (DE) and NEXT MAP LOCATION (HL)

 ld a,(drawmapCounter)
 and 1
 jr nz,_skipEvenTile

 inc de
_skipEvenTile:
 ld a,(drawmapCounter)
 inc a
 ld (drawmapCounter),a
 inc de
 inc hl			; next byte = next tile ID
 djnz columnLoop

 ; tricky arithmetic is involved when moving from the right edge
 ;  and back to the left.

 push hl		; 11 rows = 132 bytes
  ld hl,132		; 12*11
  add hl,de
  ex de,hl
 pop hl

 push de
  ld a,(mapWidth)
  sub 8				; not 8, since we already incremented
  ld e,a
  ld d,0
  add hl,de
 pop de

 dec c
 jr nz,rowLoop		; do we need to loop again?
 ret


drawEvenTile:
    ld b,12
drawEvenTileLoop:
    push bc			
     ldi
	  ldi	  
	  push hl
	   ld hl,10
		add hl,de
		ex de,hl
	  pop hl
    pop bc
    djnz drawEvenTileLoop
	 ret

drawOddTile:
    ld b,12
drawOddTileLoop:
    push bc		
     ld b,(hl)
	  srl b
	  srl b
	  srl b
	  srl b
	  ld a,(de)
	  OR B
	  ld (de),a

	  inc de
     ld b,(hl)
	  sla b
	  sla b
	  sla b
	  sla b
	  inc hl
	  ld a,(hl)
	  srl a
	  srl a
	  srl a
	  srl a
     OR B
	  ld (de),a

	  inc hl
	  push hl
	   ld hl,11
		add hl,de
		ex de,hl
	  pop hl
    pop bc
    djnz drawOddTileLoop
	 ret



debugMap:
 ld hl,0
 ld (pencol),hl
 ld a,(x)
 B_CALL setxxop1
 ld a,5
 B_CALL dispop1a

 ld a,Lcomma
 B_CALL vputmap

 ld a,(y)
 B_CALL setxxop1
 ld a,5
 B_CALL dispop1a

 call getYourPosition
 ld a,(hl)
 B_CALL setxxop1
 ld a,3
 B_CALL dispop1a
  B_CALL GrBufCpy
  B_CALL GetKey
 jp moveLoop


show12x12:
 push hl		; store Sprite Pointer
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12
 
 push af
 srl a
 srl a
 srl a			; x/8
 ld e,a
 add hl,de
 ex de,hl
 ld hl,plotsscreen	; 8e29h on 83
 add hl,de		; hl = location we want to paint at
 pop af
 
 and 111b
 or a
 jr z,aligned_sprite0

 pop ix
 ld e,a

 ld c,12			; loop 'c' times, for vertical sprite size
spriteNAloop0:

 ld b,e			; 'e' - the remainder of a, determines the offset
 ld d,(ix+0)
 xor a
shlop0:
 srl d			; right piece
 rr a			; left piece
 djnz shlop0

 push af
 ld a,(hl)
 or d
 ld (hl),a		; load the 3 pieces of the sprite
 inc hl
 ld b,(hl)
 pop af
 or b
 ld (hl),a

 inc ix

 ld b,e			; 'e' - the remainder of a, determines the offset
 ld d,(ix+0)
 xor a
shlop00:
 srl d			; right piece
 rr a			; left piece
 djnz shlop00

 push af
 ld a,(hl)
 or d
 ld (hl),a		; load the 3 pieces of the sprite
 inc hl
 ld b,(hl)
 pop af
 or b
 ld (hl),a

 push de		; go to next line
  ld de,10
  add hl,de
 pop de

 inc ix

 dec c
 jr nz,spriteNAloop0
 ret 


aligned_sprite0:	; hl - pointer to buffer
 pop de			; de - pointer to sprite

 ld b,12			; loops = vertical size of sprite
alop0:
 ld a,(de)
 ld (hl),a
 inc hl
 inc de
 ex de,hl
 ld a,(de)
 and 1111b
 or (hl)
 ld (de),a
 ex de,hl

 ld (hl),a

 push de
  ld de,11
  add hl,de
 pop de
 inc de
 djnz alop0
 ret





demoCharSprite:
 db 00011100b,00000000b
 db 00100110b,00000000b
 db 00110110b,00000000b
 db 01000110b,00000000b
 db 00100011b,00000000b
 db 00011100b,10000000b
 db 00101010b,00000000b
 db 01011101b,00000000b
 db 01110010b,10000000b
 db 00011101b,01000000b
 db 00110110b,10000000b
 db 01101110b,00000000b
 db 00011100b,00000000b
 db 00100110b,00000000b
 db 00110110b,00000000b
 db 01000110b,00000000b
 db 00100011b,10000000b
 db 00011110b,01000000b
 db 00101010b,00000000b
 db 01011101b,00000000b
 db 01110010b,10000000b
 db 00011101b,01000000b
 db 00110110b,10000000b
 db 00110010b,00000000b
 db 00011110b,00000000b
 db 00111111b,00000000b
 db 00111111b,00000000b
 db 00011110b,00000000b
 db 00101101b,00000000b
 db 01111111b,10000000b
 db 01001100b,10000000b
 db 01010101b,10000000b
 db 01101010b,10000000b
 db 01010101b,10000000b
 db 01101010b,10000000b
 db 00111111b,00000000b
 db 00011110b,00000000b
 db 00111111b,00000000b
 db 00111111b,00000000b
 db 00011110b,11000000b
 db 00101101b,01000000b
 db 01111111b,01000000b
 db 01001000b,10000000b
 db 01010101b,10000000b
 db 01101010b,11000000b
 db 01010101b,11000000b
 db 00111111b,10000000b
 db 00111000b,00000000b
 db 00000111b,00000000b
 db 00001100b,10000000b
 db 00001101b,10000000b
 db 00001100b,01000000b
 db 00011000b,10000000b
 db 00100111b,00000000b
 db 00001010b,10000000b
 db 00010111b,01000000b
 db 00101001b,11000000b
 db 01010111b,00000000b
 db 00101101b,10000000b
 db 00001110b,11000000b
 db 00000111b,00000000b
 db 00001100b,10000000b
 db 01001101b,10000000b
 db 00111100b,01000000b
 db 00001000b,10000000b
 db 00001111b,00000000b
 db 00001010b,10000000b
 db 00010111b,01000000b
 db 00101001b,11000000b
 db 01010111b,10000000b
 db 00101101b,11000000b
 db 00001100b,10000000b
 db 00001110b,00000000b
 db 00010001b,00000000b
 db 00011011b,00000000b
 db 00010001b,00000000b
 db 00101010b,10000000b
 db 01011111b,01000000b
 db 01111111b,11000000b
 db 01110001b,11000000b
 db 01011111b,00000000b
 db 00101111b,10000000b
 db 00011011b,10000000b
 db 00111011b,00000000b
 db 00001110b,00000000b
 db 00010001b,00000000b
 db 00011011b,00000000b
 db 00010001b,00000000b
 db 00101010b,10000000b
 db 01011111b,01000000b
 db 01110110b,11000000b
 db 00011001b,01000000b
 db 00011111b,11000000b
 db 00111111b,10000000b
 db 00111011b,00000000b
 db 00011000b,00000000b

 ; king pause

 db 00111000b,00000000b
 db 01100101b,11000000b
 db 01101100b,01000000b
 db 01100000b,10000000b
 db 10100101b,00000000b
 db 00111001b,11000000b
 db 01011100b,00000000b
 db 10101010b,01100000b
 db 01010110b,10100000b
 db 10101111b,10100000b
 db 01011110b,10100000b
 db 10111111b,11100000b

 db 00111000b,00000000b
 db 01110100b,11100000b
 db 01101100b,00100000b
 db 10101000b,01000000b
 db 01000100b,10000000b
 db 01111000b,11100000b
 db 10111000b,00000000b
 db 01010100b,11000000b
 db 10101101b,01000000b
 db 01011111b,01000000b
 db 10111101b,01000000b
 db 01111111b,11000000b

 db 00111000b,01110000b
 db 01110100b,00010000b
 db 01101100b,00100000b
 db 10101000b,01000000b
 db 01000100b,01110000b
 db 01111000b,00000000b
 db 10111000b,00000000b
 db 01010100b,11000000b
 db 10101101b,01000000b
 db 01011111b,01000000b
 db 10111101b,01000000b
 db 01111111b,11000000b


 db 0
 db 255,0
 db 255,0
 db 255,0
  db 255,0
 db 255,0
 db 255,0
 db 255,0
  db 255,0
 db 255,0
 db 255,0
 db 255,0
  db 255
