; I tried to add comments to the source for your understanding, but since I don't
; want any super amateurs reading it (like me), the comments only allow you to know what I'm
; telling the CPU to do, not how the code runs. This particular file doesn't have many comments. :)


        .nolist				;remember, first we need the ION Header
        #include "ion.inc"
        .list

#ifdef TI83P
        .org    progstart-2
        .db     $BB,$60
#else
        .org    progstart
#endif
        ret				
        jr      nc,begin			;where to go to start the program

        .db     "Chessmaster 83",0		;the title

begin:
	ld hl, tileData			;title screen
	ld de, PLOTSSCREEN
	ld bc, 768
	ldir
	call ionFASTCOPY
	call pause
	call OptionScreen2
Startgame:
	bcall(_clrlcdf)
	ld a, (curturn)
	cp 1
	jr z, skipthisstuffdude
	ld a, (cpucolor)
	cp 2
	jr z, cpuiswhite
	jr chessloop
skipthisstuffdude:
	ld a, (cpucolor)
	cp 1
	jr z, cpuiswhite
chessloop:
	ld a, (players)
	cp 3
	jr z, twocpu
	call getlegalmoves
chessloop2:
	call drawboard
	call announcestuff			;check for and announce check, checkmate, or stalemate
	call selectpiece
	cp 255
	jr z, exitstuff				;exit
	ld hl, (selposx)
	ld (tempposx), hl
	call drawselector
	call selectpiece
	cp 255
	jr z, exitstuff				;exit
	call getboardpos
	push de
	ld bc, (selposx)
	ld hl, (tempposx)
	ld (selposx), hl
	push bc
	call getboardpos
	pop hl
	ld (selposx), hl
	push de
	call drawselector
	pop de
	pop hl
	ld a, (de)
	cp (hl)
	jr z, chessloop2
	push hl
	call isthismovelegal
	ld hl, (selposx)
	ld (nxtglmx), hl
	pop hl
	or a
	jr z, chessloop2
	call executemove
	call addscore
	ld a, (curturn)
	xor 1
	ld (curturn), a
	ld hl, (moves)
	inc hl
	ld (moves), hl
cpuiswhite:
	ld a, (players)
	cp 2
	jr z, chessloop
twocpu:
	call drawboard
	call announcestuff
	call getaimove
	call addscore
	ld a, (curturn)
	xor 1
	ld (curturn), a
	ld hl, (moves)
	inc hl
	ld (moves), hl
	jp chessloop

exitstuff:
	ret


executemove:
	ld a, (hl)
	ld b, a
	ld a, (de)
	ld (hl), a
	cp 7
	call z, checkforwhiteprogression
	cp 1
	call z, checkforblackprogression
	xor a
	ld (de), a
	ret

checkforwhiteprogression:
	ld a, (nxtglmy)
	or a
	jr nz, noprogression
	ld a, 12
	ld (hl), a
	ret
noprogression
	xor a
	ret
checkforblackprogression:
	ld a, (nxtglmy)
	cp 7
	ret nz
	ld a, 6
	ld (hl), a
	ret

whiteturn:
	ld hl, whitestring
	ld de, $1241
	jp drawstring

blackturn:
	ld hl, blackstring
	ld de, $1241
	jp drawstring

addscore:
	ld a, b
	or a
	ret z
	cp 7
	jr c, skipsub6
	sub 6
skipsub6:
	ld b, 1
	cp 2
	call nc, add2
	cp 4
	call nc, add2
	cp 6
	call z, ld9
	ld hl, blackscore
	ld a, (curturn)
	or a
	call z, addwhitescore
	ld a, (hl)
	add a, b
	ld (hl), a
	ret
addwhitescore
	dec hl
	ret
add2:
	inc b
	inc b
	ret
ld9:
	ld b, 9
	ret

#include chessgfx.asm
#include subroute.asm
#include chessai.asm
#include legalmov.asm
#include title.asm
#include options.asm

announcestuff:
	call getlegalmoves
	ld hl, blankstring
	ld de, $1841
	call drawstring
	call copyboard2
	call checkforcheck
	or a
	jr nz, checkstalemate
	ld hl, checkstring
	ld de, $1841
	call drawstring
	ld a, (freespace)
	cp 255
	ret nz
	ld hl, checkmatestring
finishupend:
	ld de, $1841
	call drawstring
	call pause
	pop hl
	call newgameload
	jp StartGame

checkstalemate:
	ld a, (freespace)
	cp 255
	ret nz
	ld hl, stalestring
	jr finishupend

Board
	.db 4, 3, 2, 6, 5, 2, 3, 4
	.db 1, 1, 1, 1, 1, 1, 1, 1
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 7, 7, 7, 7, 7, 7, 7, 7
	.db 10, 9, 8, 12, 11, 8, 9, 10
tempposx	.db 0
tempposy	.db 0
curturn .db 0
moves	.dw 0
whitescore	.db 0
blackscore	.db 0
difficulty 	.db 1
players .db 1
cpucolor .db 1
cpupriority	.db 2
graphics	.db 3
showthinking .db 1
selposx .db 4
selposy .db 4

whitestring:
	.db "White",0

blackstring:
	.db "Black",0

Checkstring:
	.db "Check!",0

blankstring:
	.db "                     ",0

Checkmatestring:
	.db "Checkmate!",0

stalestring:
	.db "Stalemate...",0

nodesstring:
	.db "Nodes:",0

movesstring:
	.db "Mvs:",0

Wscorestring:
	.db "W Sc.:",0

BScorestring:
	.db "B Sc.:",0

Author1:
	.db "By: TSW",0

piecetxt:
	.db "                     ",0
	.db "Pawn   ",0
	.db "Bishop ",0
	.db "Knight",0
	.db "Rook    ",0
	.db "King       ",0
	.db "Queen   ",0

ShellTitle:
	.db "Cmaster", 0

NewGame:
	.db 4, 3, 2, 6, 5, 2, 3, 4
	.db 1, 1, 1, 1, 1, 1, 1, 1
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 7, 7, 7, 7, 7, 7, 7, 7
	.db 10, 9, 8, 12, 11, 8, 9, 10

tempboard:
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0

tempboard2:
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0

freespace:
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	.dw 0, 0, 0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
.end
