Drawboard:
	ld hl, Board
	call drawboard2
	jp drawboard3


Drawboard2:
	push hl
	ld hl, PLOTSSCREEN
	ld de, PLOTSSCREEN+1
	ld bc, 767
	ld (Hl), 0
	ldir
	pop hl
	ld b, 64
	ld de, 0
dboardloop:
	push bc
	push hl
	push de
	ld a, (hl)
	call getdatastart
	call GridPutSprite
	pop de
	inc e
	ld a, e
	cp 8
	jr nz, noresetnextrow
	ld e, b
	inc d
noresetnextrow:
	pop hl
	inc hl
	pop bc
	djnz dboardloop
	jp drawboard4

drawboard3:
	ld de, $0041
	ld hl, ShellTitle
	call drawstring
	ld de, $0641
	ld hl, Author1
	call drawstring
	ld a, (curturn)
	or a
	call z, whiteturn
	cp 1
	call z, blackturn
	ret
getdatastart:
	add a, a
	add a, a
	add a, a
	ld l, a
	ld h, 0
	ld bc, Gfxset2
	ld a, (graphics)
	cp 1
	jr z, setgfx
	ld bc, Gfxset3
	cp 2
	jr z, setgfx
	ld bc, Gfxset1
setgfx:
	add hl, bc
	ret


GridPutSprite:
    push hl                               
    pop ix     
	ld a, d
	add a, a
	add a, a
	add a, a
	ld l, a
	ld h, 0
	add hl, hl
	add hl, hl
	push hl
	pop bc
	add hl, hl
	add hl, bc              
	ld a, l
	add a, e
	ld l, a
	ex de, hl
    ld hl, PLOTSSCREEN        
    add hl,de              
    ld b,8                
    ld de,12 
GPS_Loop:
    ld a,(ix + 0)         
    ld (hl),a            
    inc ix               
    add hl,de           
    djnz GPS_Loop
	ret



Group1 .equ 0feh 
KDown		.equ 254 
KLeft		.equ 253 
KRight		.equ 251 
KUp			.equ 247 
Group2 .equ 0fdh 
KPlus		.equ 253 
KMinus		.equ 251 
KClear		.equ 191 
Group6 .equ 0dfh 
kAlpha		.equ 127 
Group7 .equ 0bfh 
k2nd		.equ 223

keyloop:
	xor a										;most of games processing goes here, because it doubles as a null loop
	ld (keyvar), a
	ld (keycounter), a
keyloopb:
	ld c, b
	ld b, 50
keyloop2:
	ld a, 0ffh
	out (1), a
 	ld a, Group1
	out (1),a
 	in a,(1)
	ld e, 1
	cp kDown
 	call z,ldkey
	inc e
	cp kLeft
 	call z,ldkey
	inc e
	cp kRight
 	call z,ldkey
	inc e
	cp kUp
 	call z,ldkey
	inc e
	ld a, Group2
	out (1), a
	in a, (1)
	cp kClear
	call z, ldkey
	inc e
	ld a, Group7
	out (1), a
	in a, (1)
	cp k2nd
	call z, ldkey
	inc e
	ld a, Group2
	out (1), a
	in a, (1)
	cp kPlus
	call z, ldkey
	inc e
	cp kMinus
	call z, ldkey
	inc e
	ld a, Group6
	out (1), a
	in a,(1)
	cp kAlpha
	call z, ldkey
	djnz keyloop2
	ld b, c
	djnz keyloopb
	ld a, (keyvar)
	ret

ldkey:
	ld d, a
	ld a, e
	ld (keyvar), a
	ld a, (keycounter)
	cp 30
	jr z, staykey
	inc a
	ld (keycounter), a
	xor a
	ld (keyvar), a
staykey:
	ld a, d
	ret
; keys:
; 1=down
; 2=left
; 3=right
; 4=up
; 5=exit
; 6=2nd
; 7=plus
; 8=minus
; 9=alpha
keycounter:
	.db 0
keyvar:
	.db 0

waitkey:
	ld b, 1
	call keyloop
	or a
	jr nz, waitkey
	ret

pause:
	call waitkey
pause3:
	ld b, 1
	call keyloop
	cp 6
	jr nz, pause3
	jp waitkey

getkey:
	ld b, 1
	call keyloop
	or a
	jr z, getkey
	push af
	call waitkey
	pop af
	ld (keyvar), a
	ret

selectpiece:
	call drawselector
	call getboardpos			;we're gonna display the piece type!
	ld a, (de)
	cp 7
	jr c, nosub6
	sub 6
nosub6
	ld hl, piecetxt-1
	ld de, $0c41
	inc a
	ld b, a
ditemloop
	push bc
	ld b, 1
	ld a, 0						
	cpir
	pop bc
	djnz ditemloop
	call drawstring
	call getkey
	call drawselector
	ld a, (keyvar)
	ld hl, selposx
	cp 2
	call z, movehldown
	cp 3
	call z, movehlup
	ld hl, selposy
	cp 4
	call z, movehldown
	cp 1
	call z, movehlup
	cp 5
	jr z, exitme
	cp 9
	jr z, nosaveexit
	cp 6
	jr nz, selectpiece
	ret
exitme:
	ld a, 255
	ret

nosaveexit:
	pop hl
	ret

movehldown:
	ld a, (hl)
	or a
	ret z
	dec (hl)
	xor a
	ret
movehlup:
	ld a, (hl)
	cp 7
	jr z, nogoup
	inc (hl)
nogoup:
	xor a
	ret
drawselector:
	ld de, (selposx)
	ld a, d
	add a, a
	add a, a
	add a, a
	ld l, a
	ld h, 0
	add hl, hl
	add hl, hl
	push hl
	pop bc
	add hl, hl
	add hl, bc              
	ld a, l
	add a, e
	ld l, a
	ex de, hl
    ld hl, PLOTSSCREEN        
    add hl,de
	ld de, 12              
	ld b, 8
drawsellp:
	ld a, (hl)
	cpl
	ld (hl), a
	add hl, de
	djnz drawsellp
	jp drawboard4


getboardpos:
	ld a, (selposy)
	rlca
	rlca
	rlca
	ld b, a
	ld a, (selposx)
	add a, b
	ld e, a
	ld d, 0
	ld hl, Board
	add hl, de
	ex de, hl
	ret

drawstring:
	push de
	ld (PENCOL), de
	bcall(_vputs)
	pop de
	ret



drawboard4:
	ld hl,plotsscreen
	di	
	ld de, 7
	add hl, de
	ld b, 8			;8 columns
drawcolumn
	push bc
	ld a, b
	add a, $1f
	call lcdbusy
	out (16), a
	ld a, $80
	call lcdbusy
	out (16), a
	ld b, 64		;64 rows
	ld de, 12
drawbyte
	ld a, (hl)
	call lcdbusy
	out (17), a
	add hl, de
	djnz drawbyte
	or a
	ld de, 769
	sbc hl, de
	pop bc
	djnz drawcolumn
	ei	
	ret	
lcdbusy:
	push af
	inc hl
	dec hl		
	pop af		
	ret		

.end
