;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	Analyze Move
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;How the AI analyzes moves:
;	start at 32768 (highest number is what we are looking for, and if
				 ;there is a carry from a subtraction that's bad!)
;Values: (NOT in order of code)							Implemented?
; Take a queen							2304			Yes!
; Take a rook							1280			Yes!
; Take a bishop							768				Yes!
; Take a knight							768				Yes!
; Take a pawn							256				Yes!
; Attack in center four tiles			4				Yes!
; Use queen in beginning game			-10				Yes!
; Rook on blank file					32				Yes!
; Move King								-12				Yes! (If you move king in check, that's not good, if you move
															 ;king not in check, that's not good either!)
; Move Horse on first two moves			11				Yes! (My friends did the 4 man move and won!!!)
; Use pawn file C						2				Yes!
; Use pawn file D						5				Yes!
; Use pawn file E						6				Yes!
; Use pawn file F						2				Yes!
; Move pawn to 4th rank					2				Yes!
;Not until move 10:
; Move pawn to 5th rank					4				Yes!
; Move pawn to 6th rank					8				Yes!
; Move pawn to 7th rank					30				Yes!
; Move pawn to 8th rank					50				Yes!
; Attack on 5th rank					3				Yes!
; Attack on 6th rank					6				Yes!
; Attack on 7th rank					12				Yes!
; Attack on 8th rank					12				Yes!
;
; Analyze mode takes start coordinates in curglmx and curglmy, and
; goal coordinates in nxtglmx and nxtglmy
; 
; The node value is incremented here, but it has to be reset somewhere
; else

analyzemove:
	ld hl, (nodes)
	inc hl
	ld (nodes), hl
	call copyboard2
	call analyzemovemain
	call getTOAV
	call getCCV
	ld de, (aivalue)
	add hl, de
	ld de, (TOAV)
	sbc hl, de
	ret

analyzemovemain:
	ld hl, 32768
	ld (aivalue), hl
	call getaiboardpos				;get address of start location, coords, and other stuff
	ld (curglmx), de
	push hl
	ld (aitype), a
	call getaiboardpos
	ld (nxtglmx), de
	ld (aitake), a
	pop de
	call executemove
	ld a, (nxtglmy)
	ld d, a
	ld a, (curturn)
	or a
	call z, reverseb				;if you're white, your y coordinate
									;needs to be reversed
	ld a, d
	ld (aimovey), a
	ld a, (aitake)
	or a
	jr z, notakepiece
	call getpiecevalue
	call changeaivalue
	ld a, (moves)
	cp 10					;no go for beginning of game...
	jr c, notakepiece
	ld a, (aimovey)
	ld de, 3
	cp 4							;attack on 5th rank?
	call z, changeaivalue
	ld de, 6
	cp 5							;attack on 6th rank?
	call z, changeaivalue
	ld de, 12
	cp 6							;attack on 7th rank?
	call z, changeaivalue		
	cp 7
	call z, changeaivalue			;attack on 8th rank?
notakepiece:
	ld a, (aitype)
	cp 6
	jr nz, notqueen				;do queen analyze stuff
	ld a, (moves)
	cp 10
	ret nc
	ld de, -10
	call changeaivalue
	ret
notqueen:
	ld a, (aitype)
	cp 4
	jr nz, notrook				;do rook analyze stuff
	ld hl, tempboard
	ld a, (nxtglmx)				;get x value, put pointer at second line of board at x
	and %00000111
	add a, 8
	ld e, a
	ld d, 0
	add hl, de
	ld a, (hl)					;can't have anything here
	or a
	ret nz
	ld b, 4						;gonna check for blank file
	ld de, 8
rookai1:
	add hl, de
	ld a, (hl)
	cp 2
	ret nc						;pawns are okay (not in original pos.)
	djnz rookai1
	rlc e
	rlc e
	call changeaivalue			;de=8, rlc e twice then de=32
	ret
notrook:
	cp 5
	jr nz, notking
	ld de, -12
	call changeaivalue
	ret
notking:
	cp 3
	jr nz, notknight
	ld a, (moves)
	cp 3
	ret nc
	ld de, 11
	call changeaivalue
	ret
notknight
	cp 1
	ret nz							;about to do the pawn ai moves!
	ld a, (nxtglmx)
	ld de, 2
	cp 2							;up on file C?
	call z, changeaivalue
	cp 5							;up on file F?
	call z, changeaivalue
	ld de, 5
	cp 3							;up on file D?
	call z, changeaivalue
	ld de, 6
	cp 4
	call z, changeaivalue			;up on file E?
	ld a, (aimovey)
	ld de, 2
	cp 3							;up on rank 4?
	call z, changeaivalue
	ld a, (moves)
	cp 10				;no go for this stuff in beginning of the game		
	ret c
	ld a, (aimovey)
	inc de
	inc de
	cp 4							;up on rank 5?
	call z, changeaivalue
	ld de, 8
	cp 5							;up on rank 6?
	call z, changeaivalue
	ld de, 30
	cp 6							;up on rank 7?
	call z, changeaivalue
	ld de, 50
	cp 7							;up on rank 8?
	call z, changeaivalue
	ret



;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	Get AI Move
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
getaimove:
	call getlegalmoves
	ld hl, freespace
	ld (aimovepos), hl
	ld h, 0
	ld (R1), hl
	ld (nodes), hl
ailoop:
	call analyzemove
	push hl
	ld a, (showthinking)
	cp 2
	jr z, noshowthinking
	call flipboard
	ld hl, tempboard
	call drawboard2
	call flipboard
noshowthinking
	pop hl
	ld a, (difficulty)
	cp 1
	call nz, anotherlayer2
	ld de, (R1)
	call hlde
	or a
	jr nz, nonewbigdaddy1
	ld (R1), hl
	ld hl, curglmx
	ld de, M1
	ld bc, 4
	ldir
nonewbigdaddy1:
	ld hl, (aimovepos)
	ld a, (hl)
	cp 255
	jp z, domoveM1
	jr ailoop

anotherlayer2:
	push hl
	ld a, (curturn)
	xor 1
	ld (curturn), a
	ld hl, Board				;save Board in temporary area
	ld de, tempboard2
	ld bc, 64
	ldir
	ld hl, (curglmx)
	ld (selposx), hl
	call getboardpos
	push de
	ld hl, (nxtglmx)
	ld (selposx), hl
	call getboardpos
	ex de, hl
	pop de
	call executemove
	ld hl, curglmx
	ld de, M2
	ld bc, 4
	ldir
	ld hl, freespace+1200
	call getlegalmoves3
	ld hl, (aimovepos)
	ld (aimovepos2), hl
	ld hl, freespace+1200
	ld (aimovepos), hl
	ld h, 1
	ld (R2), hl
ailoop2:
	call analyzemove
	ld de, (R2)
	call hlde
	or a
	jr z, nonewbigdaddy2
	ld (R2), hl
nonewbigdaddy2:
	ld hl, (aimovepos)
	ld a, (hl)
	cp 255
	jr nz, ailoop2
	ld hl, tempboard2				;reload board
	ld de, Board
	ld bc, 64
	ldir
	ld de, curglmx
	ld hl, M2
	ld bc, 4
	ldir
	ld hl, (aimovepos2)
	ld (aimovepos), hl
	ld a, (curturn)
	xor 1
	ld (curturn), a
	ld hl, (R2)
	ld a, 4
	bcall(_divHLbyA)
	ex de, hl
	pop hl
	sbc hl, de
	ret
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	Do Moves
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
domoveM1:
	ld hl, (M1)
	ld (selposx), hl
	call getboardpos
	push de
	ld hl, (M1+2)
	ld (nxtglmx), hl
	ld (selposx), hl
	call getboardpos
	ex de, hl
	pop de
	call executemove
	ret

;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	CCV
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
; gets check
; check value = 10
getCCV:
	call flipboard
	call checkforcheck
	ld hl, 0
	or a
	jr nz, CCVequ
	ld hl, 10			;check bonus
CCVequ:
	ld (CCV), hl
	ret

CCV:
	.dw 0

;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	TOAV
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;in- tempboardset, out- TOAV=total opponent attack value (principle AI proponent)
; used while analyzing an AI move.
getTOAV:	
	ld hl, 0
	ld (TOAVcoordx), hl
	ld hl, 8192
	ld (TOAV), hl
	ld hl, tempboard
	ld b, 64
GTlp:
	push bc
	push hl
	ld a, (hl)
	or a
	jr z, nothingtocheck
	cp 7
	jr nc, nothingtocheck
	cp 5
	jr z, nothingtocheck		;can't be in check AFTER a move (not legal)
	ld (TOAVtype), a
	ld (kingpos), hl
	ld hl, (TOAVcoordx)
	ld (kingposx), hl
	call checkforcheck2
	or a
	jr nz, nothingtocheck
	ld a, (TOAVtype)
	add a, 6
	call getpiecevalue
	push de
	ld hl, (TOAV)
	add hl, de
	ld (TOAV), hl
	push bc
	call flipboard
	call checkforcheck2
	push af
	call flipboard
	pop af
	pop bc
	pop hl
	or a
	jr nz, nothingtocheck
	ld a, c
	call getpiecevalue
	call hlde
	cp 1					;if the value of the piece you're taking with that's gonna get
	jr nz, makeTOAVsmart	;taken is Greater than the value of the GUARDED piece, nothing is added
	ex de, hl
makeTOAVsmart:
	ld hl, (TOAV)
	sbc hl, de
	ld (TOAV), hl
nothingtocheck:
	ld a, (TOAVcoordx)
	inc a
	cp 8
	call z, updateTOAVy
	ld (TOAVcoordx), a
	pop hl
	inc hl
	pop bc
	djnz GTlp
	ret
updateTOAVy:
	ld hl, TOAVcoordy
	inc (hl)
	xor a
	ret

TOAVcoordx:
	.db 0
TOAVcoordy:
	.db 0
TOAV:
	.dw 0
TOAVtype:
	.db 0
TOAVmax:
	.dw 0

;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	AI subroutines
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()

getpiecevalue:
	ld de, 0				;king value = 0 (can't ever take him anyway!)
	cp 7					;notice that these are in order of occurence = less time
	jr z, gvpawn
	cp 10
	jr z, gvrook
	cp 12
	jr z, gvqueen
	cp 11
	ret z
	ld d, 3					;de=768
	ret
gvqueen
	ld d, 9					;de=2304
	ret
gvrook:
	ld d, 5					;de=1280
	ret
gvpawn:
	ld d, 1					;de=256
	ret

changeaivalue:
	ld hl, (aivalue)
	add hl, de
	ld (aivalue), hl
	xor a
	ret

reverseb:
	ld a, 7
	sub d
	ld d, a
	ret

; hl is bigger - a=0
; de is bigger - a=1
; hl = de      - a=2
hlde:
	ld a, h
	cp d
	jr z, checksmallstuffhlde
	jr nc, bighl
	ld a, 1
	ret
bighl:
	xor a
	ret
checksmallstuffhlde:
	ld a, l
	cp e
	jr z, samethinghlde
	jr nc, bighl
	ld a, 1
	ret
samethinghlde:
	ld a, 2
	ret

;in: aimovepos out: aimovepos=aimovepos+2 (next move), de=coordinated, hl=board position, a=value at pos.
getaiboardpos:
	ld hl, (aimovepos)
	ld e, (hl)
	inc hl
	ld d, (hl)
	inc hl
	ld (aimovepos), hl
	push de
	ld a, d				;get y pos
	rlca
	rlca
	rlca
	add a, e			;get x pos
	ld hl, tempboard
	ld e, a
	ld d, 0
	add hl, de
	ld a, (hl)
	pop de
	ret

;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()
;	AI variables
;()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()()

;Temporary Analyze Move Stuff:
aitake:
	.db 0
aitype:
	.db 0
aivalue:
	.dw 0
aimovey:
	.db 0

;Important Stuff:
aimovepos:
	.dw 0
aimovepos2:
	.dw 0
nodes:
	.dw 0
R1:
	.dw 0
R2:
	.dw 0
R3:
	.dw 0
M1:
	.dw 0, 0
M2:
	.dw 0, 0
.end
