#define optie 8265h
#define mines 8266h
#define Y-plane 8267h
#define score 8268h
#define hiscore 826Ah

#include "ion.inc"

#ifdef TI83P
	.org	progstart-2
	.db	$BB,$6D
#else
	.org progstart
#endif
	xor a
	jr nc,start
titel:	.db "Missle Defence Breaker",0

title:	.db "Bomb Them",0

start:
	bcall(_indicatorOff)
	xor a
	ld (optie),a

refresh:
	bcall(_cleargbuf)
	bcall(_clrlcdf)	
	ld hl,0000h
	ld (score),hl
	call display
starta:
	ld a,(optie)
	and a
	jr z,optie1
	cp 1
	jr z,optie2
	cp 2
	jr z,optie3
	
optie1:
	ld hl,0304h
	ld (currow),hl
	ld hl,txt_easy
	call invert
	call put_highscore_easy
	jr start3

optie2:
	ld hl,0304h
	ld (currow),hl
	ld hl,txt_medium
	call invert
	call put_highscore_medium
	jr start3
		
optie3:
	ld hl,0304h
	ld (currow),hl
	ld hl,txt_hard
	call invert
	call put_highscore_hard
start3:
	bcall(_getcsc)
	cp 0Fh
	jp z,einde
	cp 2
	jr z,links
	cp 3
	jr z,rechts
	cp 54
	jr z,start2
	jr start3
	
links:
	ld a,(optie)
	and a
	jr z,start3
	ld a,(optie)
	dec a
	ld (optie),a
	jp starta

rechts:
	ld a,(optie)
	cp 2
	jr z,start3
	ld a,(optie)
	inc a
	ld (optie),a
	jp starta

start2:
	ld a,(optie)
	and a
	jp z,level_easy
	cp 1
	jr z,level_medium
	cp 2
	jr z,level_hard


level_easy:
	ld a,10
	ld (mines),a
	jp do_missle

level_medium:
	ld a,5
	ld (mines),a
	jp do_missle

level_hard:
	ld a,3
	ld (mines),a

do_missle:
	bcall(_clrlcdf)
	bcall(_cleargbuf)
	call putheading	
	ld a,30
	ld (Y-plane),a

Loop_scroll:
	ld hl,(score)
	inc hl
	ld (score),hl
	call scroll
	call putplane
	call putmine	
	ld b,8
	ld a,(Y-plane)
	inc a
	inc a
	inc a
	call Hit
	jp nz,game_over
	call ionFastcopy
	ld a,0FFh
	out (1),a  
	ld a,0FEh
	out (1), a  
	in a,(1)  
	cp 0F7h
	jp z,plane_up
	cp 0FEh
	jp z,plane_down
	ld a,0FFh
	out (1),a  
	ld a,0FDh
	out (1),a  
	in a,(1) 
	cp 0BFh
	ret z       
	call putplane
	jp Loop_scroll

plane_up:
	call putplane
	ld a,(Y-plane)
	cp 7
	jp z,Loop_scroll
	ld a,(Y-plane)
	dec a
	ld (Y-plane),a
	jp Loop_scroll

plane_down:
	call putplane
	ld a,(Y-plane)
	cp 60
	jp z,Loop_scroll
	ld a,(Y-plane)
	inc a
	ld (Y-plane),a
	jp Loop_scroll

putplane:
	ld a,(Y-plane)
	ld l,a
	xor a
	ld b,4
	ld ix,sprite_plane
	call ionPutSprite
	ret

putmine:
	ld a,(mines)
	ld b,a
	call ionRandom
	cp 1
	ret nz
	ld b,56
	call ionrandom
	add a,7
	ld l,a
	ld a,89
	ld b,4
	ld ix,sprite_mine
	call ionputsprite
	ret

game_over:
	ld hl,0002h
	ld (currow),hl
	ld hl,txt_score
	bcall(_puts)
	ld hl,(score)
	bcall(_disphl)
	ld hl,0003h
	ld (currow),hl
	ld hl,txt_highscore
	bcall(_puts)
	ld a,(optie)
	and a
	call z,ld_easy
	cp 1
	call z,ld_medium
	cp 2
	call z,ld_hard
	bcall(_disphl)
	call Highscore_changer

key_loop:	
	bcall(_getcsc)
	cp 15
	ret z
	cp 54
	jr nz,key_loop
	jp refresh

ld_easy:
	ld hl,(dat_easy)
	ret
ld_medium:
	ld hl,(dat_medium)
	ret
ld_hard:
	ld hl,(dat_hard)
	ret


Highscore_changer:
	ld hl,(score)	
	push hl
	ld a,(optie)
	and a
	jr z,Highscore_updt_easy
	cp 1
	jr z,Highscore_updt_medium
	cp 2
	jr z,Highscore_updt_hard
	ret

Highscore_updt_easy:
	ld de,(dat_easy)
	bcall(_cphlde)
	jr nc,High_easy_change
	ld hl,(dat_easy)
	ld (hiscore),hl
	pop hl
	ret

High_easy_change:
	pop hl
	ld (dat_easy),hl
	ld (hiscore),hl
	ret
	
Highscore_updt_medium:
	ld de,(dat_medium)
	bcall(_cphlde)
	jr nc,High_medium_change
	ld hl,(dat_medium)
	ld (hiscore),hl
	pop hl
	ret

High_medium_change:
	pop hl
	ld (dat_medium),hl
	ld (hiscore),hl
	ret
	
Highscore_updt_hard:
	ld de,(dat_hard)
	bcall(_cphlde)
	jr nc,High_hard_change
	ld hl,(dat_hard)
	ld (hiscore),hl
	pop hl
	ret

High_hard_change:
	pop hl
	ld (dat_hard),hl
	ld (hiscore),hl
	ret


Hit:
	LD  C,A
	LD  A, B                      
	LD  B, 0
	LD  H, B
	LD  L, C
	ADD HL, HL
	ADD HL, BC
	ADD HL, HL
	ADD HL, HL
	LD  C, A
	SRL C
	SRL C
	SRL C
	ADD HL, BC
	LD  BC, GRAPH_MEM
	ADD HL, BC
	LD  B, %10000000
	AND %00000111
	JR  Z, Hitdone
	LD  C, A
	LD  A, B
	LD  B, C
ShloopGetPix:
	RRA
	DJNZ ShloopGetPix
	LD  B, A
Hitdone:
	LD  A, (HL)
	AND B
	RET

Scroll:
	LD  HL, GRAPH_MEM+767         
	LD  B, 57
_LLoop:
	SLA (HL)                      
	DEC HL
_DECHL:
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	DJNZ _LLoop
	ret

put_highscore_easy:
	call put_highscore
	ld hl,(dat_easy)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,6
	bcall(_dispop1a)
	ret

put_highscore_medium:
	call put_highscore
	ld hl,(dat_medium)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,6
	bcall(_dispop1a)
	ret
put_highscore_hard:
	call put_highscore
	ld hl,(dat_hard)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,6
	bcall(_dispop1a)
	ret

put_highscore:
	ld hl,0A20h
	ld (pencol),hl
	ld hl,txt_clearline
	bcall(_vputs)
	ld hl,0A00h
	ld (pencol),hl
	ld hl,txt_highscore
	bcall(_vputs)
	ret

putheading:
	set textwrite,(iy+SGRFLAGS)
	ld hl,001Ch
	ld (pencol),hl
	ld hl,title
	bcall(_vputs)
	res textwrite,(iy+SGRFLAGS)
	ld ix,sprite_heading
	xor a
	ld l,a
	ld b,7
	ld c,12
	call ionLargesprite
	ret

display:
	call putheading
	ld hl,3A00h
	ld (pencol),hl
	ld hl,txt_copyright
	set textwrite,(iy+SGRFLAGS)
	bcall(_vputs)
	res textwrite,(iy+SGRFLAGS)
	xor a
	ld hl,003Ah	
	ld b,7
	ld c,12
	ld ix,sprite_heading
	call ionLargesprite
	call ionFastcopy
	ret

invert:
	set textinverse, (iy+textflags)
	bcall(_puts)
	res textinverse, (iy+textflags)
	ret
einde:
	bcall(_cleargbuf)
	ret



;Sprites
sprite_plane:
	.db %11000000
	.db %11111110
	.db %11111111
	.db %11000000

sprite_mine:
	.db %00000110
	.db %01111110
	.db %11111110
	.db %00000110

sprite_heading:
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
	.db %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111

;Text-files
txt_score:
	.db "Distance=",0
txt_highscore:
	.db "Furthest=",0
txt_copyright:
	.db "(C) 2002 Krueger Systems",0
txt_easy:
	.db (0cfh)," Novice ",(005h),0
txt_medium:
	.db (0cfh)," Master ",(005h),0
txt_hard:	
	.db (0cfh),"In-Human",(005h),0
txt_clearline:
	.db "                        ",0

;Data
Dat_easy:
	.dw 0000h
Dat_medium:
	.dw 0000h
Dat_hard:
	.dw 0000h

.end
end
