.nolist              ;remember, first we need the ION Header
#include "ion.inc"

#define savesscreen saferam1
#define ifastcopy   ionFastCopy

#define curlvl  savesscreen
#define lives   savesscreen+4
#define tiley   savesscreen+5
#define shift   savesscreen+8
#define xmario  savesscreen+10
#define ymario  savesscreen+11
#define curpos  savesscreen+16
#define status  savesscreen+20
#define jumped  savesscreen+22
#define canjump savesscreen+23  ;0 = yes 1=no
#define cursprite savesscreen+24
#define isshroom  savesscreen+26
#define shroomx savesscreen+27
#define shroomy savesscreen+28
#define enemyx  savesscreen+29
#define enemyy  savesscreen+30
#define enemy   savesscreen+31
#define enemydir    savesscreen+33
#define isenemy savesscreen+34
#define enemymove savesscreen+35
#define tempx   savesscreen+36
#define tempy   savesscreen+37
#define points  savesscreen+38
#define coins   savesscreen+40
#define died    savesscreen+41
#define shroomdir savesscreen+42
#define shroommove savesscreen+43
#define quit    savesscreen+44

.list

#ifdef TI83P
        .org    progstart-2
        .db     $BB,6D
#else
        .org    progstart
#endif
        ret             
        jr      nc,begin            ;where to go to start the program

        .db     "Mario 83(+): B Detty",0     ;the title
begin:

initgame:
    ld a,3
    ld (lives),a
    ld hl,0
    ld (points),hl
    ld a,0
    ld (coins),a
    ld hl,level1
    ld (curlvl),hl
beginlevel:
    ld hl,Rmario
    ld (cursprite),hl
    ld a,0
    ld (quit),a
    ld (canjump),a
    ld (jumped),a
    ld (isenemy),a
    ld (isshroom),a
    ld (shroommove),a
    ld (enemymove),a
    ld (status),a
    ld a,7
    ld (xmario),a
    ld a,48
    ld (ymario),a
    ld a,8
    ld (shift),a
    ld hl,(curlvl)
    ld (curpos),hl
    ld a,0
    ld (died),a
    ld b,95
beginloop:
    push bc
    call scrollright
    pop bc
    djnz beginloop
    call drawmario
    call ifastcopy
    
mainloop:
    ld a,(isenemy)
    cp 1
    call z,drawenemy
    ld a,(isshroom)
    cp 1
    call z,drawshroom

    call checkenemy
    call checkshroom
    
    call drawmario

    ld a,$FE
    out (1),a
    in a,(1)
    push af
    bit 1,a
    call z,leftcheck
    pop af
    bit 2,a
    call z,rightcheck
    
    ld a,$DF
    out (1),a
    in a,(1)
    bit 7,a
    jp z,jumpcheck

mainfall:
    call fall

dmain:
    call drawmario
    
    ld a,(isenemy)
    cp 1
    call z,enemyhit
    ld a,(isshroom)
    cp 1
    call z,shroomhit

    ld a,(isenemy)
    cp 1
    call z,drawenemy
    ld a,(isshroom)
    cp 1
    call z,drawshroom
    
    ld a,$FD
    out (1),a
    in a,(1)
    bit 0,a
    ret z

    call ifastcopy

    ld a,(died)
    cp 1
    jp z,beginlevel

    ld a,(quit)
    cp 1
    ret z
    
;    ld b,1
;    call delayb
    
    jp mainloop

leftcheck:
    ld hl,(xmario)
    dec hl
    ld a,(ymario)
    call getTile
    cp 0
    ret nz

    ld hl,(xmario)
    ld a,(ymario)
    dec hl
    add a,7
    call getTile
    cp 0
    ret nz
moveleft:
    ld hl,Lmario
    ld (cursprite),hl
    ld a,(xmario)
    dec a
    ret z
    ld (xmario),a
    ret

rightcheck:
    ld hl,(xmario)
    ld de,7
    add hl,de
    ld a,(ymario)
    call getTile
    cp 0
    ret nz

    ld hl,(xmario)
    ld a,(ymario)
    ld de,7
    add hl,de
    add a,7
    call getTile
    cp 0
    ret nz
moveright:
    ld hl,Rmario
    ld (cursprite),hl
    ld a,(xmario)
    inc a
    cp 41
    jr z,mrscroll
    ld (xmario),a
    ret
mrscroll:    
    call scrollright
    ret

jumpcheck:
    ld a,(canjump)
    cp 0
    jp nz,mainfall

    ld hl,(xmario)
    ld a,(ymario)
    cp 0
    jp z,mainfall
    dec a
    call getTile
    ld de,0
    cp 2
    call z,qcoin
    cp 12
    call z,addshroom
    cp 0
    jp nz,mainfall
    
    ld hl,(xmario)
    ld a,(ymario)
    ld de,6
    add hl,de
    dec a
    call getTile
    ld de,6
    cp 2
    call z,qcoin
    cp 12
    call z,addshroom
    cp 0
    jp nz,mainfall

    ld a,(jumped)
    cp 27
    jp z,mainfall
    inc a
    ld (jumped),a

    ld a,(ymario)
    dec a
    ld (ymario),a
    jp dmain

fall:
    ld a,1
    ld (canjump),a
    ld a,0
    ld (jumped),a
    ld a,(ymario)
    add a,8
    ld hl,(xmario)
    call getTile
    cp 0
    jp nz,cantfall

    ld a,(ymario)
    ld hl,(xmario)
    ld de,6
    add hl,de
    add a,8
    call getTile
    cp 0
    jp nz,cantfall
    
    ld a,(ymario)
    inc a
    cp 56
    jp z,loselife
    ld (ymario),a

    add a,7
    ld hl,(enemyy)
    sub l
    cp 0
    jp z,fallchck
    ret
fallchck:
    ld a,(enemyx)
    ld b,a
    ld a,(xmario)
    add a,5
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jp z,eraseenemy

    ld a,(xmario)
    ld b,a
    ld a,(enemyx)
    add a,6
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jp z,eraseenemy

    ld a,(enemyx)
    ld b,a
    ld a,(xmario)
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jp z,eraseenemy

    ld a,(xmario)
    ld b,a
    ld a,(enemyx)
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jp z,eraseenemy
    ret

cantfall:
    ld a,0
    ld (canjump),a
    ret

checkenemy:
    ld a,(isenemy)
    cp 1
    ret nz

    ld a,(enemymove)
    cp 2
    jp nz,enemydelay
    call resetedelay

    ld a,(enemydir)
    cp 1
    jp z,enemyright

enemyleft:
    ld a,(enemyy)
    ld hl,(enemyx)
    dec hl
    call getTile
    cp 0
    jp nz,changedir
    ld a,(enemyx)
    cp 0
    jp z,eraseenemy
    dec a
    ld (enemyx),a
    jr enemyfall

enemyright:
    ld a,(enemyx)
    add a,7
    ld h,0
    ld l,a
    ld a,(enemyy)
    call getTile
    cp 0
    jp nz,changedir
    ld a,(enemyx)
    inc a
    ld (enemyx),a
    cp 89
    jp z,changedir
    
enemyfall:
    ld a,(enemyy)
    add a,8
    ld hl,(enemyx)
    call getTile
    cp 0
    ret nz

    ld a,(enemyy)
    ld hl,(enemyx)
    ld de,6
    add hl,de
    add a,8
    call getTile
    cp 0
    ret nz
    
    ld a,(enemyy)
    inc a
    cp 56
    jp z,eraseenemy
    ld (enemyy),a
    ret

enemydelay:
    ld a,(enemymove)
    inc a
    ld (enemymove),a
    ret

resetedelay:
    ld a,0
    ld (enemymove),a
    ret

changedir:
    ld a,(enemydir)
    xor 1
    ld (enemydir),a
    ret

eraseenemy:
    ld a,0
    ld (isenemy),a
    ret

enemyhit:
    ld a,(enemyx)
    ld b,a
    ld a,(xmario)
    add a,5
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jr z,checkvert

    ld a,(xmario)
    ld b,a
    ld a,(enemyx)
    add a,6
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jr z,checkvert

    ret

checkvert:
    ld a,(enemyy)
    ld b,a
    ld a,(ymario)
    sub b
    cp 0
    jp z,loselife
    ret

checkshroom:
    ld a,(isshroom)
    cp 1
    ret nz

    ld a,(shroommove)
    cp 2
    jp nz,shroomdelay
    call resetedelaysh

    ld a,(shroomdir)
    cp 1
    jp z,shroomright

shroomleft:
    ld a,(shroomy)
    ld hl,(shroomx)
    dec hl
    call getTile
    cp 0
    jp nz,changedirsh
    ld a,(shroomx)
    cp 0
    jp z,eraseshroom
    dec a
    ld (shroomx),a
    jr shroomfall

shroomright:
    ld a,(shroomx)
    add a,7
    ld h,0
    ld l,a
    ld a,(shroomy)
    call getTile
    cp 0
    jp nz,changedirsh
    ld a,(shroomx)
    inc a
    ld (shroomx),a
    cp 89
    jp z,changedirsh
    
shroomfall:
    ld a,(shroomy)
    add a,8
    ld hl,(shroomx)
    call getTile
    cp 0
    ret nz

    ld a,(shroomy)
    ld hl,(shroomx)
    ld de,6
    add hl,de
    add a,8
    call getTile
    cp 0
    ret nz
    
    ld a,(shroomy)
    inc a
    cp 56
    jp z,eraseshroom
    ld (shroomy),a
    ret

shroomdelay:
    ld a,(shroommove)
    inc a
    ld (shroommove),a
    ret

resetedelaysh:
    ld a,0
    ld (shroommove),a
    ret

changedirsh:
    ld a,(shroomdir)
    xor 1
    ld (shroomdir),a
    ret

eraseshroom:
    ld a,0
    ld (isshroom),a
    ret

shroomhit:
    ld a,(shroomx)
    ld b,a
    ld a,(xmario)
    add a,5
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jr z,checkvertsh

    ld a,(xmario)
    ld b,a
    ld a,(shroomx)
    add a,6
    srl a
    srl a
    srl a
    srl b
    srl b
    srl b
    sub b
    cp 0
    jr z,checkvertsh
    ret

checkvertsh:
    ld a,(shroomy)
    ld b,a
    ld a,(ymario)
    sub b
    cp 0
    jp z,big
    ret

big:
    ld a,1
    ld (status),a
    call eraseshroom
    ret

addshroom:
    ld a,1
    ld (isshroom),a
    ld (shroomdir),a
    call hitqmark
    ld a,(tempx)
    ld (shroomx),a
    ld a,(tempy)
    sub 8
    ld (shroomy),a
    ret

qcoin:
    call hitqmark
addcoin:
    ld a,(coins)
    inc a
    ld (coins),a    
    ld hl,0
    ld (pencol),hl
    ld hl,coins
    ;call vputsc
    ret
    
hitqmark:
    ld a,4
    ld (hl),a

    ld hl,(xmario)
    add hl,de
    ld de,(shift)
    add hl,de
    ld a,l
    and %11111000
    ld de,(shift)
    sub e
    ld (tempx),a
    cp 0
    ret m
   
    ld a,(ymario)
    sub 8
    ld (tempy),a
    
    ld a,(tempy)
    ld l,a
    ld a,(tempx)
    ld ix,QMark
    call putsprite8
    
    ld a,(tempy)
    ld l,a
    ld a,(tempx)
    ld ix,metal
    call putsprite8
    ret
    
loselife:
    ld a,(status)
    cp 0
    jr z,a
    dec a
    ld (status),a
    call eraseenemy
    ret
a:
    ld a,(lives)
    cp 0
    jp z,exitlevel
    dec a
    ld (lives),a
    ld a,1
    ld (died),a
    ret
    

getTile:
    push af
    ld de,(shift)
    add hl,de
    ld a,l
    and %11111000
    ld l,a
    ld h,0
    ld de,tempscr
    add hl,de
    pop af

    srl a
    srl a
    srl a
    ld e,a
    ld d,0
    add hl,de

    ld a,(hl)
    cp 10
    jr z,out0
    cp 11
    jr z,out0
    ret
out0:
    ld a,0
    ret

drawenemy:
    ld a,(enemyy)
    ld l,a
    ld a,(enemyx)
    ld ix,(enemy)
    call putsprite8
    ret

drawmario:
    ld a,(ymario)
    ld l,a
    ld a,(xmario)
    ld ix,(cursprite)
    call putsprite8
    ret
    
drawshroom:
    ld a,(shroomy)
    ld l,a
    ld a,(shroomx)
    ld ix,shroom
    call putsprite8
    ret
    
zeroscroll:
    ld a,0
    ld (shift),a
    call showlevel
scrollright:
    ld a,(shift)
    cp 8
    jp z,zeroscroll
    inc a
    ld (shift),a
    
    ld a,(isenemy)
    cp 1
    call z,enemyleft
    ld a,(isshroom)
    cp 1
    call z,shroomleft

label:
    ld  hl,plotsscreen+768
    ld  b,64
scrollloop:
    ld a,(hl)
    and %01111111
    ld (hl),a
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    dec hl
    rl  (hl)
    djnz scrollloop
    ret

showlevel:
    ld de,tempscr
    ld hl,tempscr+8
    ld bc,88
    ldir
    
    ld hl,(curpos)
    ld de,tempscr+88
    ld bc,8
    call dispRLEL
    ld (curpos),hl

    ld a,0
    ld (tiley),a
    ld hl,tempscr+88
showlevloop:
    push hl
    ld a,(hl)
    cp 0
    jr z,skip
    cp 10
    jp z,addgumba
    cp 11
    jp z,addkoopa
    cp 127
    jp z,endlevel

    ld d,0
    ld e,a
    ld ix,0
    add ix,de
    add ix,ix
    add ix,ix
    add ix,ix
    ld de,shroom
    add ix,de
    ld a,(tiley)
    ld l,a             
    ld a,88
    call putsprite8

skip:
    pop hl
    inc hl
    ld a,(tiley)
    add a,8
    cp 64
    ret z
    ld (tiley),a
    jr showlevloop

addgumba:
    ld hl,gumba
    ld (enemy),hl
    ld a,(tiley)
    ld (enemyy),a
    ld a,88
    ld (enemyx),a
    ld a,1
    ld (isenemy),a
    ld a,0
    ld (enemydir),a
    jp skip

addkoopa:
    ld hl,koopa
    ld (enemy),hl
    ld a,(tiley)
    ld (enemyy),a
    ld a,88
    ld (enemyx),a
    ld a,1
    ld (isenemy),a
    ld a,0
    ld (enemydir),a
    jp skip

endlevel:
    pop hl
exitlevel:
    ld a,1
    ld (quit),a
    ret

putsprite8:
    ld b,8
    call ionPutSprite
    ret



;========================================================;
; RLE picture displayer v1.1                             ;
; Decodes a RLE picture made by RLE2PIC                  ;
;                                                        ;
; written by David Phillips <electrum@tfs.net>           ;
; started: 8/19/98                                       ;
; last update: 11/05/98                                  ;
; modified a little by Aaron on 8/25/99                  ;
;                                                        ;
; input: HL = RLE encoded picture, DE = where to display ;
; output: 768 byte decoded picture                       ;
; destroys: AF, BC, DE, HL                               ;
; current size: 25 bytes                                 ;
;========================================================;

DispRLE:
    ld bc, 768          ; we need to copy 768 for 83/83+ pics
DispRLEL:
    ld a, (hl)          ; get the next byte
    cp $91              ; is it a run?
    jr z, DispRLERun    ; then we need to decode the run
    ldi                 ; copy the byte, and update counters
DispRLEC:
    ret po              ; ret if bc hit 0
    jr DispRLEL         ; otherwise do next byte
DispRLERun:
    inc hl
    inc hl              ; move to the run count
    ld a, (hl)          ; get the run count
DispRLERunL:
    dec hl              ; go back to run value
    dec a               ; decrease run counter
    ldi                 ; copy byte, dec bc, inc de, inc hl
    jr nz, DispRLERunL  ; if we're not done, then loop
    inc hl              ; advance the source pointer
    jr DispRLEC         ; check to see if we should loop

; Copyright  1998-2000 ACZ (Assembly Coder's Zenith, Inc.)


Rmario:
.db %00111000
.db %01111110
.db %01101000
.db %10000100
.db %01001000
.db %11111100
.db %01001000
.db %01101100

Lmario:
.db %00011100
.db %01111110
.db %00010110
.db %00100001
.db %00010010
.db %00111111
.db %00010010
.db %00110110

shroom:
.db %00000000
.db %00111000
.db %01010100
.db %11111110
.db %10101010
.db %01111100
.db %01000100
.db %00111000

block:                      ;1
.db %11111111
.db %10001001
.db %10001001
.db %11111111
.db %10100101
.db %11111111
.db %10010001
.db %11111111

QMark:                      ;2
.db %01111110
.db %10011001
.db %10100101
.db %10000101
.db %10001001
.db %10000001
.db %10001001
.db %01111110

ground:                     ;3
.db %11110111
.db %10001001
.db %10001001
.db %10001110
.db %10001001
.db %11010001
.db %10100001
.db %11111111


metal:                      ;4
.db %01111110
.db %10000001
.db %10100101
.db %10000001
.db %10000001
.db %10100101
.db %10000001
.db %01111110

ULpipe:                     ;5
.db %11111111
.db %11101000
.db %11110000
.db %11101000
.db %11110000
.db %11101000
.db %11110000
.db %11111111

URpipe:                     ;6
.db %11111111
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %11111111

Lpipe:                      ;7
.db %01111000
.db %01110100
.db %01111000
.db %01110100
.db %01111000
.db %01110100
.db %01111000
.db %01110100

Rpipe:                      ;8
.db %00000010
.db %00000010
.db %00000010
.db %00000010
.db %00000010
.db %00000010
.db %00000010
.db %00000010

stone:              ;9
.db %11111111
.db %11000011
.db %10111101
.db %10100101
.db %10100101
.db %10111101
.db %11000011
.db %11111111

gumba:              ;10
.db %00000000
.db %00111000
.db %01000100
.db %10101010
.db %10000010
.db %11111110
.db %01111100
.db %11000110

koopa:              ;11
.db %01100000
.db %11100000
.db %00111000
.db %00100110
.db %00100010
.db %00110001
.db %00111001
.db %01101110

QMarkshroom:        ;12
.db %01111110
.db %10011001
.db %10100101
.db %10000101
.db %10001001
.db %10000001
.db %10001001
.db %01111110


level1:
     .db  145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,4,2,0,0
     .db  3,145,0,7,3,145,0,7,3,145,0,4,1,0,0,3,145,0,4,12,0,0,3,0,2,0,0,1,0,0
     .db  3,145,0,4,2,0,0,3,145,0,4,1,0,10,3,145,0,7,3,145,0,7,3,145,0,6,5,7,145,0
     .db  6,6,8,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,5
     .db  5,7,7,145,0,5,6,8,8,145,0,6,10,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3
     .db  145,0,4,5,145,7,3,145,0,4,6,145,8,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3
     .db  145,0,6,10,3,145,0,4,5,145,7,3,145,0,4,6,145,8,3,145,0,7,3,145,0,7,3,145,0,7
     .db  3,145,0,7,3,145,0,8,145,0,8,145,0,7,3,145,0,7,3,145,0,4,1,0,0,3
     .db  145,0,4,2,0,0,3,0,1,0
     .db  0,1,0,0,3,0,1,145,0,5,3,0,1,145,0,5,3,0,1,145,0,6,0,1,145,0,6
     .db  145,0,7,3,145,0,7
     .db  3,0,1,145,0,5,3,0,1,145,0,5,3,0,2,0,0,1,0,0,3,145,0,7,3,145,0,6,10,3
     .db  145,0,7,3,145,0,4,1,0,0,3,145,0,4,1,0,0,3,145,0,7,3,145,0,7,3,145,0,7,3
     .db  145,0,7,3,145,0,4,2,0,11,3,145,0,7,3,0,12,0,0,2,0,0,3,145,0,7,3,145,0,4
     .db  2,0,0,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,4,1,0,0,3,145,0,7
     .db  3,145,0,7,3,0,1,145,0,5,3,0,1,145,0,5,3,0,1,145,0,5,3,145,0,7,3,145,0,7
     .db  3,0,1,145,0,5,3,0,2,0,0,1,0,10,3,0,2,0,0,1,0,0,3,0,1,145,0,5,3,145
     .db  0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,6,9,3,145,0,5,9,9,3,145,0,4,145
     .db  9,3,3,145,0,7,3,145,0,7,3,145,0,4,145,9,3,3,145,0,5,9,9,3,145,0,6,9,3,145
     .db  0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,6,9,3,145,0,5,9,9,3
     .db  145,0,4,145,9,3,3,145,0,4,145,9,3,3,145,0,8,145,0,8,145,0,4
     .db  145,9,3,3,145,0,5,9,9,3,145,0,6
     .db  9,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,5,5,7,7,145,0,5,6,8,8
     .db  145,0,7,3,145,0,7,3,145,0,4,1,0,0,3,145,0,4,1,0,0,3,145,0,4,2,0,0,3,145
     .db  0,4,1,0,0,3,145,0,6,10,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0,7
     .db  3,145,0,7,3,145,0,6,5,7,145,0,6,6,8,145,0,6,9,3,145,0,5,9,9,3,145,0,4,145
     .db  9,3,3,145,0,3,145,9,4,3,0,0,145,9,5,3,145,0,7,3,145,0,7,3,145,0,7,3,145,0
     .db  7,3,145,0,6,9,3,145,0,7,3,145,0,7,3,127

tempscr:
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0

.end
END      
    
