; TI-83+ Header File for TSE
; Based on the 83+ include by Texas Instruments
;
;
;======================================================================
;           TSE Specific
;======================================================================
;

krnlbase        .equ 9872h
_tseKrnlVer     .equ krnlbase + 2
_tseChkProg     .equ krnlbase + 5
_tseExitShell   .equ krnlbase + 8
_tseSwitchTask  .equ krnlbase + 11
_tseStartTask   .equ krnlbase + 14
_tseEndTask     .equ krnlbase + 17
_tseForceYield  .equ krnlbase + 20

libsbase        .equ 8A3Ah
_tseLibsVer     .equ libsbase + 0
_tseRandom      .equ libsbase + 3
_tseSprite      .equ libsbase + 6
_tseLargeSprite .equ libsbase + 9
_tseGetPixel    .equ libsbase + 12
_tseDecompress  .equ libsbase + 15
_tseFastcopy    .equ libsbase + 18
_tseFindVar     .equ libsbase + 21

ionRandom       .equ _tseRandom
ionPutSprite    .equ _tseSprite
ionLargeSprite  .equ _tseLargeSprite
ionGetPixel     .equ _tseGetPixel
ionFastCopy     .equ _tseFastCopy
ionDecompress   .equ _tseDecompress
ionDetect	.equ 8508h

; Kernel Memory Structure
pptr_code         .equ 8C4Ch - 2
pptr_preserve     .equ pptr_code - 2
progsize          .equ pptr_preserve - 2
sysstack          .equ progsize - 2
sysflags          .equ sysstack - 60
cprogram          .equ sysflags - 9
fptr_varsize      .equ cprogram - 2
fptr_prgtitle     .equ fptr_varsize - 2
fptr_memreq       .equ fptr_prgtitle - 2
fptr_end          .equ fptr_memreq - 2

;
;======================================================================
;           System Variable .equates
;======================================================================
;       Entry Points : RclSysTok, StoSysTok
;
XSCLt           .equ 2
YSCLt           .equ 3
XMINt           .equ 0Ah
XMAXt           .equ 0Bh
YMINt           .equ 0Ch
YMAXt           .equ 0Dh
TMINt           .equ 0Eh
TMAXt           .equ 0Fh
THETMINt        .equ 10h
THETMAXt        .equ 11h
TBLMINt         .equ 1Ah
PLOTSTARTt      .equ 1Bh
NMAXt           .equ 1Dh
NMINt           .equ 1Fh
TBLSTEPt        .equ 21h
TSTEPt          .equ 22h
THETSTEPt       .equ 23h
DELTAXt         .equ 26h
DELTAYt         .equ 27h
XFACTt          .equ 28h
YFACTt          .equ 29h
FINNt           .equ 2Bh
FINIt           .equ 2Ch
FINPVt          .equ 2Dh
FINPMTt         .equ 2Eh
FINFVt          .equ 2Fh
FINPYt          .equ 30h
FINCYt          .equ 31h
PLOTSTEPt       .equ 34h
XRESt           .equ 36h
;
;
;======================================================================
;           Run indicators
;======================================================================
;
busyPause       .equ    10101010b
busyNormal      .equ    11110000b
;
;======================================================================
; Macros to call base code
;======================================================================
;
APP_PUSH_ERRORH .equ 59h
APP_POP_ERRORH  .equ 5Ch


#define bcall(xxxx)     rst 28h         \ .dw xxxx
#define bcallz(xxxx)    jr nz,$+5       \ rst 28h \ .dw xxxx
#define bcallnz(xxxx)   jr      z,$+5   \ rst 28h \ .dw xxxx
#define bcallc(xxxx)    jr      nc,$+5  \ rst 28h \ .dw xxxx
#define bcallnc(xxxx)   jr      c,$+5   \ rst 28h \ .dw xxxx
#define bjump(xxxx)     call 50h        \ .dw xxxx
#define AppOnErr(xxxx)  ld hl, xxxx     \ call APP_PUSH_ERRORH
#define AppOffErr()     call APP_POP_ERRORH
;
;======================================================================
;           Common subroutine RST numbers  
;======================================================================
;
rOP1TOOP2       .equ 08h
rFINDSYM        .equ 10h
rPUSHREALO1     .equ 18h
rMOV9TOOP1      .equ 20h
rFPADD          .equ 30h
;
;======================================================================
;           Entry points  
;======================================================================
;
_AbsO1O2Cp      =$410E
_AbsO1PAbsO2    =$405A
_ACos           =$40DE
_ACosH          =$40F0
_ACosRad        =$40D2
_AdrLEle        =$462D
_AdrMEle        =$4609
_AdrMRow        =$4606
_AllEq          =$4876
_AllocFPS       =$43A5
_AllocFPS1      =$43A8
_Angle          =$4102
_AnsName        =$4B52
_ApdSetup       =$4C93
_AppGetCalc     =$4C78
_AppGetCbl      =$4C75
_Arc_Unarc      =$4FD8
_ASin           =$40E4
_ASinH          =$40ED
_ASinRad        =$40DB
_ATan           =$40E1
_ATan2          =$40E7
_ATan2Rad       =$40D8
_ATanH          =$40EA
_ATanRad        =$40D5

_BinOPExec      =$4663
_Bit_VertSplit  =$4FA8
_BufClr         =$5074
_BufCpy         =$5071

_CAbs           =$4E97
_CAdd           =$4E88
_CanAlphIns     =$4C69
_CDiv           =$4E94
_CDivByReal     =$4EBB
_CEtoX          =$4EA9
_CFrac          =$4EC1
_CheckSplitFlag =$49F0
_ChkFindSym     =$42F1
_CIntgr         =$4EC4
_CircCmd        =$47D4
_CkInt          =$4234
_CkOdd          =$4237
_CkOP1C0        =$4225
_CkOP1Cplx      =$40FC
_CkOP1FP0       =$4228
_CkOP1Pos       =$4258
_CkOP1Real      =$40FF
_CkOP2FP0       =$422B
_CkOP2Pos       =$4255
_CkOP2Real      =$42DF
_CkPosInt       =$4231
_CkValidNum     =$4270
_CleanAll       =$4A50
_ClearRect      =$4D5C
_Cleargbuf	=$4BD0
_ClearRow       =$4CED
_CLine          =$4798
_CLineS         =$479B
_CLN            =$4EA0
_CLog           =$4EA3
_CloseEditBufNoR        =$476E
_CloseProg      =$4A35
_ClrGraphRef    =$4A38
_ClrLCD         =$4543
_ClrLCDFull     =$4540
_ClrLp          =$41D1
_ClrOP1S        =$425E
_ClrOP2S        =$425B
_ClrScrn        =$4549
_ClrScrnFull    =$4546
_ClrTxtShd      =$454C
_CMltByReal     =$4EB8
_CmpSyms        =$4A4A
_CMult          =$4E8E
_Conj           =$4EB5
_ConvDim        =$4B43
_ConvDim00      =$4B46
_ConvLcToLr     =$4A23
_ConvLrToLc     =$4A56
_ConvOP1        =$4AEF
_COP1Set0       =$4105
_Cos            =$40C0
_CosH           =$40CC
_CpHLDE         =$400C
_CPoint         =$4DC8
_CPointS        =$47F5
_CpOP1OP2       =$4111
_CpOP4OP3       =$4108
_CpyO1ToFPS1    =$445C
_CpyO1ToFPS2    =$446B
_CpyO1ToFPS3    =$4477
_CpyO1ToFPS4    =$4489
_CpyO1ToFPS5    =$4483
_CpyO1ToFPS6    =$447D
_CpyO1ToFPS7    =$4480
_CpyO1ToFPST    =$444A
_CpyO2ToFPS1    =$4459
_CpyO2ToFPS2    =$4462
_CpyO2ToFPS3    =$4474
_CpyO2ToFPS4    =$4486
_CpyO2ToFPST    =$4444
_CpyO3ToFPS1    =$4453
_CpyO3ToFPS2    =$4465
_CpyO3ToFPST    =$4441
_CpyO5ToFPS1    =$4456
_CpyO5ToFPS3    =$4471
_CpyO6ToFPS2    =$4468
_CpyO6ToFPST    =$4447
_CpyStack       =$4429
_CpyTo1FPS1     =$4432
_CpyTo1FPS10    =$43F3
_CpyTo1FPS11    =$43D8
_CpyTo1FPS2     =$443B
_CpyTo1FPS3     =$4408
_CpyTo1FPS4     =$440E
_CpyTo1FPS5     =$43DE
_CpyTo1FPS6     =$43E4
_CpyTo1FPS7     =$43EA
_CpyTo1FPS8     =$43ED
_CpyTo1FPS9     =$43F6
_CpyTo1FPST     =$4423
_CpyTo2FPS1     =$442F
_CpyTo2FPS2     =$4438
_CpyTo2FPS3     =$4402
_CpyTo2FPS4     =$43F9
_CpyTo2FPS5     =$43DB
_CpyTo2FPS6     =$43E1
_CpyTo2FPS7     =$43E7
_CpyTo2FPS8     =$43F0
_CpyTo2FPST     =$4420
_CpyTo3FPS1     =$442C
_CpyTo3FPS2     =$4411
_CpyTo3FPST     =$441D
_CpyTo4FPST     =$441A
_CpyTo5FPST     =$4414
_CpyTo6FPS2     =$43FF
_CpyTo6FPS3     =$43FC
_CpyTo6FPST     =$4417
_CpyToFPS1      =$445F
_CpyToFPS2      =$446E
_CpyToFPS3      =$447A
_CpyToFPST      =$444D
_CpyToStack     =$4450
_Create0Equ     =$432A
_CreateAppVar   =$4E6A
_CreateCList    =$431B
_CreateCplx     =$430C
_CreateEqu      =$4330
_CreatePair     =$4B0D
_CreatePict     =$4333
_CreateProg     =$4339
_CreateProtProg =$4E6D
_CreateReal     =$430F
_CreateRList    =$4315
_CreateRMat     =$4321
_CreateStrng    =$4327
_CRecip         =$4E91
_CSqRoot        =$4E9D
_CSquare        =$4E8B
_CSub           =$4E85
_CTenX          =$4EA6
_CTrunc         =$4EBE
_Cube           =$407B
_CursorOff      =$45BE
_CursorOn       =$45C4
_CXrootY        =$4EAC
_CYtoX          =$4EB2

_DarkLine       =$47DD
_DarkPnt        =$47F2
_DataSize       =$436C
_DataSizeA      =$4369
_DeallocFPS     =$439F
_DeallocFPS1    =$43A2
_DecO1Exp       =$4267
_DelListEl      =$4A2F
_DelMem         =$4357
_DelRes         =$4A20
_DelVar         =$4351
_DelVarArc      =$4FC6
_DelVarNoArc    =$4FC9
_DisableApd     =$4C84
_Disp           =$4F45
_DispDone       =$45B5
_DispEOL        =$45A6
_DispHL         =$4507
_DisplayImage   =$4D9B
_DispOP1A       =$4BF7
_DivHLBy10      =$400F
_DivHLByA       =$4012
_DrawCirc2      =$4C66
_DrawCmd        =$48C1
_DrawRectBorder =$4D7D
_DrawRectBorderClear   =$4D8C
_DToR           =$4075

_EditProg       =$4A32
_EnableApd      =$4C87
_EnoughMem      =$42FD
_EOP1NotReal    =$4279
_EraseEOL       =$4552
_EraseRectBorder       =$4D86
_ErrArgument    =$44AD
_ErrBadGuess    =$44CB
_ErrBreak       =$44BF
_ErrD_OP1_0     =$42D3
_ErrD_OP1_LE_0  =$42D0
_ErrD_OP1Not_R  =$42CA
_ErrD_OP1NotPos =$42C7
_ErrD_OP1NotPosInt     =$42CD

_ErrDataType    =$44AA
_ErrDimension   =$44B3
_ErrDimMismatch =$44B0
_ErrDivBy0      =$4498
_ErrDomain      =$449E
_ErrIncrement   =$44A1
_ErrInvalid     =$44BC
_ErrIterations  =$44C8
_ErrLinkXmit    =$44D4
_ErrMemory      =$44B9
_ErrNon_Real    =$44A4
_ErrNonReal     =$4A8C
_ErrNotEnoughMem       =$448C
_ErrOverflow    =$4495
_ErrSignChange  =$44C5
_ErrSingularMat =$449B
_ErrStat        =$44C2
_ErrStatPlot    =$44D1
_ErrSyntax      =$44A7
_ErrTolTooSmall =$44CE
_ErrUndefined   =$44B6
_EToX           =$40B4
_Exch9          =$43D5
_ExLp           =$4222
_ExpToHex       =$424F

_Factorial      =$4B85
_FillRect       =$4D62
_FillRectPattern       =$4D89
_Find_Parse_Formula    =$4AF2
_FindAlphaDn    =$4A47
_FindAlphaUp    =$4A44
_FindApp               =$4C4E
_FindAppDn             =$4C4B
_FindAppNumPages       =$509B
_FindAppUp             =$4C48
_FindSym        =$42F4
_FiveExec       =$467E
_FixTempCnt     =$4A3B
_FlashToRam     =$5017
_ForceFullScreen       =$508F
_FormBase       =$50AA
_FormDCplx      =$4996
_FormEReal      =$4990
_FormReal       =$4999
_FourExec       =$467B
_FPAdd          =$4072
_FPDiv          =$4099
_FPMult         =$4084
_FPRecip        =$4096
_FPSquare       =$4081
_FPSub          =$406F
_Frac           =$4093

_GetBaseVer     =$4C6F
_GetCSC         =$4018
_GetKey         =$4972
_GetLToOP1      =$4636
_GetMToOP1      =$4615
_GetTokLen      =$4591
_GrBufClr       =$4BD0
_GrBufCpy       =$486A
_GrphCirc       =$47D7

_HLTimes9       =$40F9
_homeup		=$4558
_HorizCmd       =$48A6
_HTimesL        =$4276

_IBounds        =$4C60
_IBoundsFull    =$4D98
_ILine          =$47E0
_IncLstSize     =$4A29
_InsertList     =$4A2C
_InsertMem      =$42F7
_Int            =$40A5
_Intgr          =$405D
_InvCmd         =$48C7
_InvertRect     =$4D5F
_InvOP1S        =$408D
_InvOP1SC       =$408A
_InvOP2S        =$4090
_InvSub         =$4063
_IOffset        =$4C63
_IPoint         =$47E3

_JError         =$44D7
_JErrorNo       =$4000
_JForceCmdNoChar       =$4027
_JForceGraphKey =$5005
_JForceGraphNoKey      =$5002

_KeyToString    =$45CA

_LdHLind        =$4009 ; Non standard
_LineCmd        =$48AC
_LnX            =$40AB
_Load_SFont     =$4783
_LoadCIndPaged  =$501D
_LoadDEIndPaged =$501A
_LoadPattern    =$4CB1
_LogX           =$40AE

_Max            =$4057
_MemChk         =$42E5
_MemClear       =$4C30
_MemSet         =$4C33
_Min            =$4054
_Minus1         =$406C
_Mov10B         =$415C
_Mov18B         =$47DA
_Mov7B          =$4168
_Mov8B          =$4165
_Mov9B          =$415F
_Mov9OP1OP2     =$417D
_Mov9OP2Cp      =$410B
_Mov9ToOP1      =$417A
_Mov9ToOP2      =$4180
_MovFrOP1       =$4183

_NewLine        =$452E

_OneVar         =$4BA3
_OP1ExOP2       =$421F
_OP1ExOP3       =$4219
_OP1ExOP4       =$421C
_OP1ExOP5       =$420D
_OP1ExOP6       =$4210
_OP1ExpToDec    =$4252
_OP1Set0        =$41BF
_OP1Set1        =$419B
_OP1Set2        =$41A7
_OP1Set3        =$41A1
_OP1Set4        =$419E
_OP1ToOP2       =$412F
_OP1ToOP3       =$4123
_OP1ToOP4       =$4117
_OP1ToOP5       =$4153
_OP1ToOP6       =$4150
_OP2ExOP4       =$4213
_OP2ExOP5       =$4216
_OP2ExOP6       =$4207
_OP2Set0        =$41BC
_OP2Set1        =$41AD
_OP2Set2        =$41AA
_OP2Set3        =$4198
_OP2Set4        =$4195
_OP2Set5        =$418F
_OP2Set60       =$4AB0
_OP2Set8        =$418C
_OP2SetA        =$4192
_OP2ToOP1       =$4156
_OP2ToOP3       =$416E
_OP2ToOP4       =$411A
_OP2ToOP5       =$414A
_OP2ToOP6       =$414D
_OP3Set0        =$41B9
_OP3Set1        =$4189
_OP3Set2        =$41A4
_OP3ToOP1       =$413E
_OP3ToOP2       =$4120
_OP3ToOP4       =$4114
_OP3ToOP5       =$4147
_OP4Set0        =$41B6
_OP4Set1        =$4186
_OP4ToOP1       =$4138
_OP4ToOP2       =$411D
_OP4ToOP3       =$4171
_OP4ToOP5       =$4144
_OP4ToOP6       =$4177
_OP5ExOP6       =$420A
_OP5Set0        =$41B3
_OP5ToOP1       =$413B
_OP5ToOP2       =$4126
_OP5ToOP3       =$4174
_OP5ToOP4       =$412C
_OP5ToOP6       =$4129
_OP6ToOP1       =$4135
_OP6ToOP2       =$4132
_OP6ToOP5       =$4141
_OutputExpr     =$4BB2

_PagedGet       =$5023
_ParseInp       =$4A9B
_PDspGrph       =$48A3
_PixelTest      =$48B5
_Plus1          =$4069
_PointCmd       =$48B2
_PointOn        =$4C39
_PopOP1         =$437E
_PopOP3         =$437B
_PopOP5         =$4378
_PopReal        =$4393
_PopRealO1      =$4390
_PopRealO2      =$438D
_PopRealO3      =$438A
_PopRealO4      =$4387
_PopRealO5      =$4384
_PopRealO6      =$4381
_PosNo0Int      =$422E
_PtoR           =$40F3
_PushOP1        =$43C9
_PushOP3        =$43C3
_PushOP5        =$43C0
_PushReal       =$43BD
_PushRealO1     =$43BA
_PushRealO2     =$43B7
_PushRealO3     =$43B4
_PushRealO4     =$43B1
_PushRealO5     =$43AE
_PushRealO6     =$43AB
_PutC           =$4504
_PutMap         =$4501
_PutPS          =$4510
_PutS           =$450A
_PutTokString   =$4960
_PutToL         =$4645
_PutToMat       =$461E

_RandInit       =$4B7F
_Random         =$4B79
_Rcl_StatVar    =$42DC
_RclAns         =$4AD7
_RclGDB2        =$47D1
_RclN           =$4ADD
_RclSysTok      =$4AE6
_RclVarSym      =$4AE3
_RclX           =$4AE0
_RclY           =$4ADA
_Rec1stByte     =$4EFA
_Rec1stByteNC   =$4EFD
_RecAByteIO     =$4F03
_RedimMat       =$4A26
_Regraph        =$488E
_ReloadAppEntryVecs    =$4C36
_RestoreDisp    =$4870
_RName          =$427F
_RndGuard       =$409F
_RnFx           =$40A2
_Round          =$40A8
_RToD           =$4078
_RToP           =$40F6
_RunIndicOff    =$4570
_RunIndicOn     =$456D

_SaveDisp       =$4C7B
_SendAByte      =$4EE5
_SetAllPlots    =$4FCC
_SetFuncM       =$4840
_SetNorm_Vals   =$49FC
_SetParM        =$4849
_SetPolM        =$4846
_SetSeqM        =$4843
_SetTblGraphDraw       =$4C00
_SetupPagedPtr  =$5020
_SetXXOP1       =$478C
_SetXXOP2       =$478F
_SetXXXXOP2     =$4792
_SFont_Len      =$4786
_Sin            =$40BD
_SinCosRad      =$40BA
_SinH           =$40CF
_SinHCosH       =$40C6
_SqRoot         =$409C
_SrchVLstDn     =$4F12
_SrchVLstUp     =$4F0F
_SStringLength  =$4CB4
_StMatEl        =$4AE9
_StoAns         =$4ABF
_StoGDB2        =$47CE
_StoN           =$4ACB
_StoOther       =$4AD4
_StoR           =$4AC5
_StoRand        =$4B7C
_StoSysTok      =$4ABC
_StoT           =$4ACE
_StoTheta       =$4AC2
_StoX           =$4AD1
_StoY           =$4AC8
_StrCopy        =$44E3
_StrLength      =$4C3F   

_Tan            =$40C3
_TanH           =$40C9
_TanLnF         =$48BB
_TenX           =$40B7
_ThetaName      =$427C
_ThreeExec      =$4675
_Times2         =$4066
_TimesPt5       =$407E
_TName          =$428E
_ToFrac         =$4657
_Trunc          =$4060

_UCLineS        =$4795
_UnLineCmd      =$48AF
_UnOPExec       =$4672

_VertCmd        =$48A9
_VPutMap        =$455E
_VPutS          =$4561
_VPutSN         =$4564
_VtoWHLDE       =$47FB

_XftoI          =$4804
_Xitof          =$47FE
_XName          =$4288
_XRootY         =$479E

_YftoI          =$4801
_YName          =$428B
_YToX           =$47A1

_Zero16D        =$41B0
_ZeroOP         =$41CE
_ZeroOP1        =$41C5
_ZeroOP2        =$41C8
_ZeroOP3        =$41CB
_ZmDecml        =$484F
_ZmFit          =$485B
_ZmInt          =$484C
_ZmPrev         =$4852
_ZmSquare       =$485E
_ZmStats        =$47A4
_ZmTrig         =$4861
_ZmUsr          =$4855
_ZooDefault     =$4867

;======================================================================
;           System-defined RAM Variable Address .equates
;======================================================================

saferam1        =9872h ;(appram - 768 bytes) 
saferam2        =8A3Ah ;(statram - 531 bytes) NOTE: b_call(_DelRes)
saferam3        =8508h ;(textmem - 128 bytes)
saferam4        =8478h ;(ops - 66 bytes)

saferam5        =86ECh ;(apdram - 768 bytes) NOTE: b_call(_DisableApd)

ramStart             .equ 8000h
appData              .equ 8000h
ramCode              .equ 8100h
ramCodeEnd           .equ 822Fh
baseAppBrTab         .equ 8230h
bootTemp             .equ 8251h
appSearchPage        .equ 82A3h
tempSwapArea         .equ 82A5h
appID                .equ 838Dh
ramReturnData        .equ 83EDh
arcInfo              .equ 83EEh
savedArcInfo         .equ 8406h
appInfo              .equ 8432h
appBank_jump         .equ 843Ch
appPage              .equ 843Eh
kbdScanCode          .equ 843Fh
kbdKey               .equ 8444h
kbdGetKy             .equ 8445h
keyExtend            .equ 8446h
contrast             .equ 8447h
apdSubTimer          .equ 8448h
apdTimer             .equ 8449h
curTime              .equ 844Ah
curRow               .equ 844Bh
curCol               .equ 844Ch
curOffset            .equ 844Dh
curUnder             .equ 844Eh
curY                 .equ 844Fh
curType              .equ 8450h
curXRow              .equ 8451h
prevDData            .equ 8452h
lFont_record         .equ 845Ah
sFont_record         .equ 8462h
tokVarPtr            .equ 846Ah
tokLen               .equ 846Ch
indicMem             .equ 846Eh
indicCounter         .equ 8476h
indicBusy            .equ 8477h
OP1                  .equ 8478h
OP1M                 .equ 847Ah
OP2                  .equ 8483h
OP2M                 .equ 8485h
OP2EXT               .equ 848Ch
OP3                  .equ 848Eh
OP3M                 .equ 8490h
OP4                  .equ 8499h
OP4M                 .equ 849Bh
OP5                  .equ 84A4h
OP5M                 .equ 84A6h
OP6                  .equ 84AFh
OP6M                 .equ 84B1h
OP6EXT               .equ 84B8h
progToEdit           .equ 84BFh
nameBuff             .equ 84C7h
equ_edit_save        .equ 84D2h
iMathPtr1            .equ 84D3h
iMathPtr2            .equ 84D5h
iMathPtr3            .equ 84D7h
iMathPtr4            .equ 84D9h
iMathPtr5            .equ 84DBh
chkDelPtr1           .equ 84DDh
chkDelPtr2           .equ 84DFh
insDelPtr            .equ 84E1h
upDownPtr            .equ 84E3h
fOutDat              .equ 84E5h
asm_data_ptr1        .equ 84EBh
asm_data_ptr2        .equ 84EDh
asm_sym_ptr1         .equ 84EFh
asm_sym_ptr2         .equ 84F1h
asm_ram              .equ 84F3h
asm_ind_call         .equ 8507h
textShadow           .equ 8508h
textShadCur          .equ 8588h
textShadTop          .equ 858Ah
textShadAlph         .equ 858Bh
textShadIns          .equ 858Ch
cxMain               .equ 858Dh
cxPPutAway           .equ 858Fh
cxPutAway            .equ 8591h
cxRedisp             .equ 8593h
cxErrorEP            .equ 8595h
cxSizeWind           .equ 8597h
cxPage               .equ 8599h
cxCurApp             .equ 859Ah
cxPrev               .equ 859Bh
monQH                .equ 85AAh
monQT                .equ 85ABh
monQueue             .equ 85ACh
onSP                 .equ 85BCh
promptRow            .equ 85C0h
promptCol            .equ 85C1h
promptIns            .equ 85C2h
promptShift          .equ 85C3h
promptRet            .equ 85C4h
promptValid          .equ 85C6h
promptTop            .equ 85C8h
promptCursor         .equ 85CAh
promptTail           .equ 85CCh
promptBtm            .equ 85CEh
varType              .equ 85D0h
varCurrent           .equ 85D1h
varClass             .equ 85D9h
menuActive           .equ 85DCh
menuAppDepth         .equ 85DDh
MenuCurrent          .equ 85DEh
ProgCurrent          .equ 85E8h
userMenuSA           .equ 85FEh
ioPrompt             .equ 865Fh
dImageWidth          .equ 8660h
ioFlag               .equ 8670h
sndRecState          .equ 8672h
ioErrState           .equ 8673h
header               .equ 8674h
ioData               .equ 867Dh
ioNewData            .equ 8689h
bakHeader            .equ 868Bh
penCol               .equ 86D7h
penRow               .equ 86D8h
rclQueue             .equ 86D9h
rclQueueEnd          .equ 86DBh
errNo                .equ 86DDh
errSP                .equ 86DEh
errOffset            .equ 86E0h
saveSScreen          .equ 86ECh
bstCounter           .equ 89EEh
flags                .equ 89F0h
statVars             .equ 8A3Ah
anovaf_vars          .equ 8C17h
infVars              .equ 8C4Dh
curGStyle            .equ 8D17h
curGY                .equ 8D18h
curGX                .equ 8D19h
curGY2               .equ 8D1Ah
curGX2               .equ 8D1Bh
freeSaveY            .equ 8D1Ch
freeSaveX            .equ 8D1Dh
XOffset              .equ 8DA1h
YOffset              .equ 8DA2h
lcdTallP             .equ 8DA3h
pixWideP             .equ 8DA4h
pixWide_m_1          .equ 8DA5h
pixWide_m_2          .equ 8DA6h
lastEntryPTR         .equ 8DA7h
lastEntryStk         .equ 8DA9h
numLastEntries       .equ 8E29h
currLastEntry        .equ 8E2Ah
curInc               .equ 8E67h
uXmin                .equ 8E7Eh
uXmax                .equ 8E87h
uXscl                .equ 8E90h
uYmin                .equ 8E99h
uYmax                .equ 8EA2h
uYscl                .equ 8EABh
uThetMin             .equ 8EB4h
uThetMax             .equ 8EBDh
uThetStep            .equ 8EC6h
uTmin                .equ 8ECFh
uTmax                .equ 8ED8h
uTStep               .equ 8EE1h
uPlotStart           .equ 8EEAh
unMax                .equ 8EF3h
uu0                  .equ 8EFCh
uv0                  .equ 8F05h
unMin                .equ 8F0Eh
uu02                 .equ 8F17h
uv02                 .equ 8F20h
uw0                  .equ 8F29h
uPlotStep            .equ 8F32h
uXres                .equ 8F3Bh
uw02                 .equ 8F44h
Xmin                 .equ 8F50h
Xmax                 .equ 8F59h
Xscl                 .equ 8F62h
Ymin                 .equ 8F6Bh
Ymax                 .equ 8F74h
Yscl                 .equ 8F7Dh
ThetaMin             .equ 8F86h
ThetaMax             .equ 8F8Fh
ThetaStep            .equ 8F98h
TminPar              .equ 8FA1h
TmaxPar              .equ 8FAAh
Tstep                .equ 8FB3h
PlotStart            .equ 8FBCh
nMax                 .equ 8FC5h
u0                   .equ 8FCEh
v0                   .equ 8FD7h
nMin                 .equ 8FE0h
u02                  .equ 8FE9h
v02                  .equ 8FF2h
w0                   .equ 8FFBh
PlotStep             .equ 9004h
XresO                .equ 900Dh
w02                  .equ 9016h
un1                  .equ 901Fh
un2                  .equ 9028h
vn1                  .equ 9031h
vn2                  .equ 903Ah
wn1                  .equ 9043h
wn2                  .equ 904Ch
fin_N                .equ 9055h
fin_I                .equ 905Eh
fin_PV               .equ 9067h
fin_PMT              .equ 9070h
fin_FV               .equ 9079h
fin_PY               .equ 9082h
fin_CY               .equ 908Bh
cal_N                .equ 9094h
cal_I                .equ 909Dh
cal_PV               .equ 90A6h
cal_PMT              .equ 90AFh
cal_FV               .equ 90B8h
cal_PY               .equ 90C1h
smallEditRAM         .equ 90D3h
XFact                .equ 913Fh
YFact                .equ 9148h
Xres_int             .equ 9151h
deltaX               .equ 9152h
deltaY               .equ 915Bh
shortX               .equ 9164h
shortY               .equ 916Dh
lower                .equ 9176h
upper                .equ 917Fh
XOutSym              .equ 918Ch
XOutDat              .equ 918Eh
YOutSym              .equ 9190h
YOutDat              .equ 9192h
inputSym             .equ 9194h
inputDat             .equ 9196h
prevData             .equ 9198h
TblMin               .equ 92B3h
TblStep              .equ 92BCh
plotSScreen          .equ 9340h
seed1                .equ 9640h
seed2                .equ 9649h
cmdShadow            .equ 966Eh
cmdShadCur           .equ 96EEh
cmdShadAlph          .equ 96F0h
cmdShadIns           .equ 96F1h
cmdCursor            .equ 96F2h
editTop              .equ 96F4h
editCursor           .equ 96F6h
editTail             .equ 96F8h
editBtm              .equ 96FAh
editSym              .equ 9706h
editDat              .equ 9708h
winTop               .equ 97A5h
winBtm               .equ 97A6h
winLeftEdge          .equ 97A7h
winLeft              .equ 97A8h
winAbove             .equ 97AAh
winRow               .equ 97ACh
winCol               .equ 97AEh
fmtDigits            .equ 97B0h
fmtString            .equ 97B1h
fmtConv              .equ 97F2h
fmtLeft              .equ 9804h
fmtIndex             .equ 9806h
fmtMatSym            .equ 9808h
fmtMatMem            .equ 980Ah
EQS                  .equ 980Ch
tSymPtr1             .equ 9818h
tSymPtr2             .equ 981Ah
chkDelPtr3           .equ 981Ch
chkDelPtr4           .equ 981Eh
tempMem              .equ 9820h
fpBase               .equ 9822h
FPS                  .equ 9824h
OPBase               .equ 9826h
OPS                  .equ 9828h
pTempCnt             .equ 982Ah
cleanTmp             .equ 982Ch
pTemp                .equ 982Eh
progPtr              .equ 9830h
newDataPtr           .equ 9832h
pagedCount           .equ 9834h
pagedPN              .equ 9835h
pagedGetPtr          .equ 9836h
pagedPutPtr          .equ 9838h
pagedBuf             .equ 983Ah
appErr1              .equ 984Dh
appErr2              .equ 985Ah
flashByte1           .equ 9867h
flashByte2           .equ 9868h
freeArcBlock         .equ 9869h
arcPage              .equ 986Bh
arcPtr               .equ 986Ch
appRawKeyHandle      .equ 9870h
appBackUpScreen      .equ 9872h
customHeight         .equ 9B72h
localLanguage        .equ 9B73h
cursorHookPtr        .equ 9B7Ch
rawKeyHookPtr        .equ 9B84h
getKeyHookPtr        .equ 9B88h
fontHookPtr          .equ 9B9Ch
restartClr           .equ 9BD0h
localTokStr          .equ 9D65h
keyForStr            .equ 9D76h
keyToStrRam          .equ 9D77h
sedMonSp             .equ 9D88h
bpSave               .equ 9D8Ah
userMem              .equ 9D95h
symTable             .equ 0FE66h

;======================================================================
;           System and State Flags
;======================================================================

trigFlags       .equ 0          ;Trigonometry mode settings
trigDeg         .equ   2        ; 1=degrees, 0=radians

kbdFlags        .equ 0          ;Keyboard scan
kbdSCR          .equ   3        ; 1=scan code ready
kbdKeyPress     .equ   4        ; 1=key has been pressed

doneFlags       .equ 0          ;display "Done"
donePrgm        .equ   5        ; 1=display "Done" after prgm

ioDelFlag       .equ 0
inDelete        .equ   0        ;1 = DELETE SCREEN 

;----------------------------------------------------------------------
editFlags       .equ 1
editOpen        .equ   2        ; 1=edit buffer is open

monFlags        .equ 1          ;monitor flags
monAbandon      .equ   4        ; 1=don't start any long process
                               ; in put away (#715)
;----------------------------------------------------------------------
plotFlags       .equ 2          ;plot generation flags
plotLoc         .equ   1        ; 0=bkup & display, 1=display only
plotDisp        .equ   2        ; 1=plot is in display, 0=text in display

grfModeFlags    .equ 2          ;graph mode settings
grfFuncM        .equ   4        ; 1=function graph
grfPolarM       .equ   5        ; 1=polar graph
grfParamM       .equ   6        ; 1=parametric graph
grfRecurM       .equ   7        ; 1=RECURSION graph

graphFlags      .equ 3
graphDraw       .equ   0        ; 0=graph is valid, 1=redraw graph

grfDBFlags      .equ 4
grfDot          .equ   0        ; 0=line, 1=dot
grfSimul        .equ   1        ; 0=s.equential, 1=simultaneous
grfGrid         .equ   2        ; 0=no grid, 1=grid
grfPolar        .equ   3        ; 0=rectangular, 1=polar coordinates
grfNoCoord      .equ   4        ; 0=display coordinates, 1=off
grfNoAxis       .equ   5        ; 0=axis, 1=no axis
grfLabel        .equ   6        ; 0=off, 1=axis label

textFlags       .equ 5          ;Text output flags
textEraseBelow  .equ   1        ; 1=erase line below small char
textScrolled    .equ   2        ; 1=screen scrolled
textInverse     .equ   3        ; 1=display inverse bit-map
textInsMode     .equ   4        ; 0=overstrike, 1=insert mode

ParsFlag2       .equ 7          ;PARSER flags
numOP1          .equ   0        ; 1=RESULT IN OP1, 0=NO RESULT

newDispF        .equ 8          ;Derivative mode flags
preClrForMode   .equ   0        ; 1=HELP BLINK ON MODE SCREEN

apdFlags        .equ 8          ;Automatic power-down
apdAble         .equ   2        ; 1=APD enabled
apdRunning      .equ   3        ; 1=APD clock running

web_err_mask    .equ 60h

onFlags         .equ 9          ;on key flags
onInterrupt     .equ   4        ; 1=on key interrupt request

statFlags       .equ 9          ;statistics flags
statsValid      .equ   6        ; 1=stats are valid

fmtFlags        .equ 10         ;numeric format flags
fmtExponent     .equ   0        ; 1=show exponent, 0=no exponent
fmtEng          .equ   1        ; 1=engineering notion, 0=scientific
fmtHex          .equ   2        ; 1=hexadecimal
fmtOct          .equ   3        ; 1=octal
fmtBin          .equ   4        ; 1=binary

numMode         .equ 10
fmtReal         .equ   5
fmtRect         .equ   6
fmtPolar        .equ   7

realMode        .equ   5
rectMode        .equ   6
polarMode       .equ   7
                                      ;   if Hex and Oct both = 1
                                      ;   then Bin=0 means >Frac                                      ;        Bin=1 means >DMS
fmtBaseMask     .equ 00011100B          ; mask to base flags
fmtBaseShift    .equ 2                  ; offset to base flags
fmtOverride     .equ 11         ;copy of fmtFlags with conversion override
fmtEditFlags    .equ 12         ;numeric editing flags
fmtEdit         .equ   0        ; 1=format number for editing

curFlags        .equ 12         ;Cursor
curAble         .equ   2        ; 1=cursor flash is enabled
curOn           .equ   3        ; 1=cursor is showing
curLock         .equ   4        ; 1=cursor is locked off

appFlags        .equ 13         ;application flags
appWantIntrpt   .equ   0                ; 1=want ON key interrupts
appTextSave     .equ   1                ; 1=save characters in textShadow
appAutoScroll   .equ   2                ; 1=auto-scroll text on last line
appMenus        .equ   3                ; 1=process keys that bring up menus
                                       ; 0=check Lock menu flag
appLockMenus    .equ   4                ; 1=ignore menu keys
                                      ; 0=switch to home screen and bring up menu
appCurGraphic   .equ   5                ; 1=graphic cursor
appCurWord      .equ   6                ; 1=text cursor covers entire word
appExit         .equ   7                ; 1=application handles [EXIT] key itself

appWantIntrptF  .equ    1<<appWantIntrpt
appTextSaveF    .equ    1<<appTextSave
appAutoScrollF  .equ    1<<appAutoScroll
appMenusF       .equ    1<<appMenus
appLockMenusF   .equ    1<<appLockMenus
appCurGraphicF  .equ    1<<appCurGraphic
appCurWordF     .equ    1<<appCurWord
appExitF        .equ    1<<appExit

seqFlags        .equ 15              ; S.equential Graph flags
webMode         .equ   0             ; 0 = NORMAL SEQ MODE, 1 = WEB MODE
webVert         .equ   1             ;
sequv           .equ   2             ; U vs V
seqvw           .equ   3             ; V vs W
sequw           .equ   4             ; U vs W

promptFlags     .equ 17         ;prompt line flags
promptEdit      .equ   0        ; 1=editing in prompt buffer

indicFlags      .equ 18         ;Indicator flags
indicRun        .equ   0        ; 1=run indicator ON
indicInUse      .equ   1        ; indicator save area in use=1, free=0
indicOnly       .equ   2        ; interrupt handler only checks run indicator

shiftFlags      .equ 18         ;[2nd] and [ALPHA] flags
shift2nd        .equ   3        ; 1=[2nd] has been pressed
shiftAlpha      .equ   4        ; 1=[ALPHA] has been pressed
shiftLwrAlph    .equ   5        ; 1=lower case, 0=upper case
shiftALock      .equ   6        ; 1=alpha lock has been pressed
shiftKeepAlph   .equ   7        ; 1=cannot cancel alpha shift

tblFlags        .equ 19         ;table flags.
autoFill        .equ   4        ; 1=prompt, 0=fillAuto
autoCalc        .equ   5        ; 1=prompt, 0=CalcAuto
reTable         .equ   6        ; 0=table is ok, 1=must recompute table.

sGrFlags        .equ 20
grfSplit        .equ   0        ; 1=Split Graph, 0=Normal
vertSplit       .equ   1        ; 1=Vertical (left-right) Split
grfSChanged     .equ   2        ; 1=Graph just changed Split <-> normal
grfSplitOverride .equ  3        ; 1 = ignore graph split flag if set
write_on_graph  .equ   4        ; 1 = TEXT OR .equ WRITING TO GRAPH SCREEN
g_style_active  .equ   5        ; 1 = GRAPH STYLES ARE ENABLED, USE THEM
cmp_mod_box     .equ   6        ; 1 = DOING MOD BOX PLOT COMPUTATION
textWrite       .equ   7

newIndicFlags   .equ 21
extraIndic      .equ   0
saIndic         .equ   1

smartFlags      .equ 23
smarter_mask    .equ 3
smarter_test    .equ 1
smartGraph      .equ 0
smartGraph_inv  .equ 1

asm_Flag1       .equ 33          ; ASM CODING
asm_Flag2       .equ 34          ; ASM CODING
asm_Flag3       .equ 35          ; ASM CODING

getSendFlg      .equ 36
comFailed       .equ 1        ; 1 = Get/Send Communication Failed

appLwrCaseFlag  .equ 36
lwrCaseActive   .equ 3

apiFlg3         .equ 42 
apiFlg4         .equ 43
fullScrnDraw    .equ   2        ; DRAW INTO LAST ROW/COL OF SCREEN

groupFlags      .equ 38
inGroup         .equ 1          ;1 = IN GROUP CONTEXT


xapFlag0        .equ 46      ; external app flags
xapFlag1        .equ 47
xapFlag2        .equ 48
xapFlag3        .equ 49

fontFlags       .equ 50
fracDrawLFont   .equ   2
fracTallLFont   .equ   3
customFont      .equ   7  

plotFlag3       .equ 60  
bufferOnly      .equ   0
useFastCirc     .equ   4

varTypeMask     .equ 1FH             
varGraphRef     .equ   6

;======================================================================
;           Keypad scancodes and group codes
;======================================================================

kReset          .equ 0ffh

Group1          .equ 0feh
KDown           .equ 254
KLeft           .equ 253
KRight          .equ 251
KUp             .equ 247

Group2          .equ 0fdh
KEnter          .equ 254
KPlus           .equ 253
KMinus          .equ 251
KMul            .equ 247
KDiv            .equ 239
KPower          .equ 223
KClear          .equ 191

Group3          .equ 0fbh
kMinus2         .equ 254
kThree          .equ 253
kSix            .equ 251
kNine           .equ 247
kRbracket       .equ 239
kTan            .equ 223
kVars           .equ 191

Group4          .equ 0f7h
KPoint          .equ 254
KTwo            .equ 253
KFive           .equ 251
KEight          .equ 247
KLbracket       .equ 239
KCos            .equ 223
KPrgm           .equ 191
KStat           .equ 127

Group5          .equ 0efh
KZero           .equ 254
KOne            .equ 253
KFour           .equ 251
KSeven          .equ 247
KComma          .equ 239
KSin            .equ 223
KApps           .equ 191
KGraphvar       .equ 127

Group6          .equ 0dfh
KSto            .equ 253
KLn             .equ 251
KLog            .equ 247
kX2             .equ 239
kX-1            .equ 223
kMath           .equ 191
kAlpha          .equ 127

Group7          .equ 0bfh
KGraph          .equ 254
KTrace          .equ 253
KZoom           .equ 251
KWindow         .equ 247
KY              .equ 239
k2nd            .equ 223
kMode           .equ 191
kDel            .equ 127

kMatrx          .equ kApps ; Compatibility

;======================================================================
;           Scan Code Equates
;======================================================================;
skDown          .equ 01h
skLeft          .equ 02h
skRight         .equ 03h
skUp            .equ 04h
skEnter         .equ 09h
skAdd           .equ 0Ah
skSub           .equ 0Bh
skMul           .equ 0Ch
skDiv           .equ 0Dh
skPower         .equ 0Eh
skClear         .equ 0Fh
skChs           .equ 11h
sk3             .equ 12h
sk6             .equ 13h
sk9             .equ 14h
skRParen        .equ 15h
skTan           .equ 16h
skVars          .equ 17h
skDecPnt        .equ 19h
sk2             .equ 1Ah
sk5             .equ 1Bh
sk8             .equ 1Ch
skLParen        .equ 1Dh
skCos           .equ 1Eh
skPrgm          .equ 1Fh
skStat          .equ 20h
sk0             .equ 21h
sk1             .equ 22h
sk4             .equ 23h
sk7             .equ 24h
skComma         .equ 25h
skSin           .equ 26h
skApps          .equ 27h
skGraphvar      .equ 28h
skStore         .equ 2Ah
skLn            .equ 2Bh
skLog           .equ 2Ch
skSquare        .equ 2Dh
skRecip         .equ 2Eh
skMath          .equ 2Fh
skAlpha         .equ 30h
skGraph         .equ 31h
skTrace         .equ 32h
skZoom          .equ 33h
skWindow        .equ 34h
skYEqu          .equ 35h
sk2nd           .equ 36h
skMode          .equ 37h
skDel           .equ 38h

skMatrx         .equ skApps ; Compatibility

;======================================================================
;           Data Type Equates                                                    
;======================================================================

RealObj         .equ 0
ListObj         .equ 1
MatObj          .equ 2
EquObj          .equ 3
StrngObj        .equ 4
ProgObj         .equ 5
ProtProgObj     .equ 6
PictObj         .equ 7
GDBObj          .equ 8
UnknownObj      .equ 9
UnknownEquObj   .equ 0Ah
NewEquObj       .equ 0Bh
CplxObj         .equ 0Ch
CListObj        .equ 0Dh
UndefObj        .equ 0Eh
WindowObj       .equ 0Fh
ZStoObj         .equ 10h
TblRngObj       .equ 11h
LCDObj          .equ 12h
BackupObj       .equ 13h
AppObj          .equ 14h           ;application, only used in menus/link
AppVarObj       .equ 15h           ;application variable
TempProgObj     .equ 16h           ;program, home deletes when finished
GroupObj        .equ 17h           ;group.

