; Hello World - Sample Program
; By Robin Kay
;

; You may not distribute a modified version of this program. However, you
; may take code from or base your program on this code providing that the
; resulting program is at least 50% of your own work.

.nolist
#include "tse.inc"
.list

.org    userMem-3
.db     $BB,$6D
 ret

.db "TSE",1           ; Header
.db " Hello World", 0 ; Title
.dw 50                ; Stack Required

start:

 ; Clear Screen 
 bcall(_clrLCDFull)

 ; Reset textInverse flag
 res textInverse, (iy+textFlags)

 ; Move cursor to topleft
 ld hl, 0
 ld (currow), hl

 ; Display title string
 ld hl,titlestr
 bcall(_puts)

 ; Display author string
 ld hl, 0A1Ch
 ld (pencol), hl
 ld hl,authorstr
 bcall(_vputs)

loopy:
 ; Invert text flag
 ld a, (iy+textflags)
 ld b, 8
 xor b
 ld (iy+textflags), a

 ; Set cursor row
 ld hl, 0006h
 ld (currow), hl

 ; Display flashing string
 ld hl, hellostr
 bcall(_puts)

 ; Initalise loop
 ld b, 00fh
subloopy:

 ; Yield
 bcall(_GetCSC)
 cp skStat
 jr nz, dontYield
 call _tseForceYield
 jr start
dontYield:

 ; Delay
 ei
 halt ; Save power
 djnz subloopy
 jr loopy

titlestr:
.db " Assembler Demo",0
authorstr:
.db "By Robin Kay",0
hellostr:
.db "  Hello World!  ",0
.end
