;--------------->Plasma<------------------
;Version 1.4
;
;The source code to Plasma is freely available.
;(This includes plasma.asm, gui.asm and load.asm. [It does not include
;ionlibs.asm this code was written by Joe Wingbermuehle and 
;used with permission. If you would like to use it in your code 
;you must contact Joe Wingbermuehle <jwing@umr.edu>
;and get his permission.])
;The source must be packaged with the compiled binaries.
;Any one can modify, recompile, then distribute the source code.
;The source must be released on the modified version and must
;carry this copy right at the top of the source files.
;Before releasing the program a 
;e-mails explaining what kind of program the code was used for
;should be sent to the following people:
;Joe Flint <Joe-F@columbus.rr.com>
;Brandon Engelberth <reddwarf_lester@yahoo.com>
;This is so we know if the code is ever actualy used. If you optimize 
;or fix a bug it would be very much appreciated if you would email
;it to the above people. This way they can be included in the official
;releases of Plasma.

;Authors:
;Joe Flint - GUI
;Joe-F@columbus.rr.com
;
;Brandon Engelberth - CORE, LOADER
;reddwarf_lester@yahoo.com
;
;Enjoy!
GDown       .equ 01h
GLeft       .equ 02h
GRight      .equ 03h
GUp     .equ 04h
GMode       .equ 37h
GAlpha      .equ 30h
G2nd        .equ 36h
GEnter      .equ 09h
GF1     .equ 35h 
progx   =  gui
numback =   gui+2
count   =   gui+3
Plasmatxt:
#ifdef DEVEL
	.db " Plasma 1.4-dev",0
#else
    .db " Plasma 1.4",0
#endif
#ifdef DEVEL
invalid_key_text:
	.db "Invalid Key:    ",0
wait_key:
	bcall(_getcsc)
	or a
	jr z,wait_key
	ret
#endif
startgui:
    bcall(_indicatoroff)
    bcall(_cleargbuf)
    ld a,8
    ld (progx),a
    xor a
    ld (barup),a
    ld (numback),a
    ld hl,0
    ld (count),hl
    call drawscreen    
    call drawprogtext1
   call drawrect
   call fastcopy    
keyloop:

    bcall(_getcsc)
    cp GMODE
    jp z,exit
	or a
	
    call nz,resetcount
	ld hl,keyloop
	push hl
    
    cp GDown
    jp z,movedown
    cp GUP
    jp z,moveup

    cp Galpha
    jp z,showbar
    cp Genter
    jr z,runprog
    cp gf1
    jr z,runprog
    cp g2nd
    jr z,runprog
    cp Gright
    jp z,pagedown
    cp gleft
    jp z,pageup

	pop hl
#ifdef DEVEL
	push af
#endif
    in a,(0)
    cp 3
    jp nz,exit
    ld hl,(count)
    inc hl
    ld (count),hl
    ld de,40000
    bcall(_cphlde)
    jp z,exit
#ifdef DEVEL
	pop af
	or a
	jr z,keyloop
    set textInverse, (iy+textflags)
	ld h,$00
	ld l,a
	xor a
    ld (penrow),a   
    ld a,70
    ld (pencol),a
    bcall(_setxxxxop2)
    bcall(_op2toop1)
    ld a,5
    bcall(_dispop1a)
    res textInverse, (iy+textflags)
	;call FastCopy
	
#endif
	jr keyloop
resetcount:

    ld hl,0
    ld (count),hl
    ret        
runprog:
    ;bcall(_cleargbuf)
    call exec_prog
    bcall(_cleargbuf)
    call redrawt
    call drawscreen
    call drawrect
    jp fastcopy

redrawt:
    ld a,(numback)
    ld b,a
    ;inc b
    or a
    call nz,jump_prev_b_progs
    call drawprogtext1
    ld a,(numback)
    ld b,a
    or a
    ret z
    call jump_next_b_progs
    ret        
drawscreen:
   ld d,0
   ld e,6
   ld c,1
   ld b,96
   call H_line
   ld e,5
   ld b,95
   call H_line
    ld e,1
    ld b,6
    call V_line
    ld d,37
    call V_line    
    
    ld a,1
    ld (pencol),a
    xor a
    ld (penrow),a
    ld hl,plasmatxt
   SET textwrite, (IY+sgrflags)
    set textInverse, (iy+textflags) ; Sets inverse.
   bcall(_vputs)    
    res textInverse, (iy+textflags) ; Sets inverse.   
    res textwrite, (iy+sgrflags)    
    ret
barup:
    .db 0
     
exit:
    bcall(_clrscrf)    
    bcall(_homeup)
    bcall(_cleargbuf)
    set 3, (iy+$24)
    ret
drawprogtext1:
   SET textwrite, (IY+sgrflags)
    xor a
    ld (pencol),a
    ld a,8
    ld (penrow),a 
    ld e,0  
   ld b,9    
drawprogtext:   
    push bc
    push de
    ld hl,Data_Prog_Desc
    bcall(_vputs)
    xor a
    ld (pencol),a
    call next_prog
    or a
    jp z,nomoreprogs
    pop de
    inc e
    ld a,(penrow)
    add a,6
    ld (penrow),a
    pop bc
    djnz drawprogtext
    ld a,56
    ld (mstop+1),a
backtothis:
    ld a,e
    ld b,e
    or a
    call nz,jump_prev_b_progs            
    res textwrite, (IY+sgrflags)
    ret
nomoreprogs:
    pop de
    pop bc
    ld a,(penrow)
    ld (mstop+1),a
    jp backtothis        
movedown:
    ld a,(barup)
    dec a
    call z,fixtext
    ld a,(progx)
mstop:    
    cp 56
    jp z,newprogdown
    ld b,6
movedownl:
    push bc
    call drawrect
    ld a,(progx)
    inc a
    ld (progx),a 
    call drawrect
    call FastCopy
    pop bc    
    djnz movedownl
    xor a
    ld (barup),a
    ld a,(numback)
    inc a
    ld (numback),a
    jp next_prog
moveup:
    ld a,(barup)
    dec a
    call z,fixtext
    ld a,(progx)
    cp 8
    jp z,newprogup
    ld b,6
moveupl:
    push bc
    call drawrect
    ld a,(progx)
    dec a
    ld (progx),a 
    call drawrect
    call FastCopy
    pop bc    
    djnz moveupl
    xor a
    ld (barup),a
    ld a,(numback)
    dec a
    ld (numback),a
    jp prev_prog
dispsize: 
    ld a,(progx)
    ld (penrow),a   
    ld a,40
    ld (pencol),a
    ld hl,(Data_Prog_Size)
    bcall(_setxxxxop2)
    bcall(_op2toop1)
    ld a,5
    bcall(_dispop1a)
    ret
pageup:
    ;ld b,9
pageup1:
    ;push bc
    ;call moveup
    ;pop bc
    ;djnz pageup1    
    ;ret
    ld b,9
    call jump_prev_b_progs
    cp 9
    jp nz,fix2
    ld a,(numback)
    ld b,a
    or a
    call nz,jump_prev_b_progs
    bcall(_cleargbuf)
    call drawscreen
    call drawprogtext1
    ld a,(numback)
    ld b,a
    or a
    call nz,jump_next_b_progs
    call drawrect
    call fastcopy    
    ret    
  
pagedown:
    ;ld b,9
pagedown1:
    xor a
    ld (pencol),a
    ld (penrow),a
    ;push bc
    ;call movedown
    ;pop bc
    ;djnz pagedown1
    ;ret    
    ld a,(numback)
    ld b,a
    or a
    call nz,jump_prev_b_progs
    ld b,9
    call jump_next_b_progs
    cp 9
    jp z,godraw
nogo:
    ld b,a
    or a
    call nz,jump_prev_b_progs
    ld a,(numback)
    ld b,a
    or a
    call nz,jump_next_b_progs
    xor a ;Yes i'm cheating, so what
    ret        
    
godraw:
    bcall(_cleargbuf)
    call drawscreen
    call drawprogtext1
    ld a,(numback)
    ld b,a
    or a
    call nz,jump_next_b_progs
    ld (numback),a
    ld a,(mstop+1)
    ld b,a
    ld a,(progx)
    cp b
    call p,nomore
    call drawrect
    call fastcopy
    ret
fix2:
    ld b,a
    or a
    call nz,jump_next_b_progs
    ret        
    
nomore:
    ld a,(mstop+1)
    ld (progx),a
    ret        
newprogdown:
    call next_prog
    or a
    ret z
    ld a,(numback)
    ld b,a
    call jump_prev_b_progs
    ld a,(progx)
    sub 6
    ld (progx),a
    bcall(_cleargbuf)
    call drawscreen
    call drawprogtext1
    ld a,(numback)
    dec a
    ld b,a
    call jump_next_b_progs
    call drawrect
    ld a,(numback)
    dec a
    ld (numback),a    
    jp movedown
    ret
newprogup:
    call prev_prog
    or a
    ret z
    ld a,(progx)
    add a,6
    ld (progx),a
    bcall(_cleargbuf)
    call drawscreen
    call drawprogtext1
    call next_prog
    call drawrect
    ld a,(numback)
    inc a
    ld (numback),a    
    jp moveup
    ret
showbar:

    ld c,1
    ld b,96
    ld d,0
    ld a,(progx)
    ld e,a
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    ld a,(progx)
    ld (penrow),a
    xor a
    ld (pencol),a

    set textInverse, (iy+textflags) ; Sets inverse.
  
   set textwrite, (IY+sgrflags)
   ld a,(Data_Flash_off_set)
   or a
   jp z,inram
   ld hl,ast
   bcall(_vputs)
inram:
    ld hl,Data_Prog_Name   
    bcall(_vputs)
    call dispsize
   res textwrite, (IY+sgrflags)
    res textInverse, (iy+textflags) ; Sets inverse.
   
    call FastCopy
    ld a,1
    ld (barup),a    
    ret
 
drawrect:
    ld c,2
    ld b,96
    ld d,0
    ld a,(progx)
    ld e,a
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    ret    
ast:
    .db "*",0           
fixtext:
    ld c,1
    ld b,96
    ld d,0
    ld a,(progx)
    ld e,a
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line
    inc e
    call h_line    
    ld a,(progx)
    ld (penrow),a
    xor a
    ld (pencol),a
    ld hl,Data_Prog_Desc
    set textInverse, (iy+textflags) ; Sets inverse.
  
   set textwrite, (IY+sgrflags)    
    bcall(_vputs)
   res textwrite, (IY+sgrflags)
    res textInverse, (iy+textflags) ; Sets inverse.
    ret                 

    
                     

Getpix: ld d, 0
        ld h, d
        ld l, e
        add hl, de
        add hl, de
        add hl, hl
        add hl, hl
        ld de, Plotsscreen
        add hl, de
Getbit: ld b, 0
        ld c, a
        and %00000111
        srl c
        srl c
        srl c
        add hl, bc
        ld b, a
        inc b
        ld a, %00000001
GBLoop: RRCA
        djnz GBLoop
        ret
V_Line:
        push de
        push hl
        push bc
        ld a, d
        call Getpix
        pop bc
        push bc
        ld d, c
        ld c, a
        ld a, d
        ld de, 12
        or a
        call z, V_White_Line
        dec a
        call z, V_Black_Line
        dec a
        call z, V_XORed_Line
        pop bc
        pop hl
        pop de
        ret

V_White_Line:
        ld a, c
        CPL
        ld c, a 
V_White_Line_2:
        ld a, (hl)
        and c
        ld (hl), a
        add hl, de
        DJNZ V_White_Line_2
        xor a
        ret

V_Black_Line:
        ld a, (hl)
        or c
        ld (hl), a
        add hl, de
        DJNZ V_Black_Line
        xor a
        ret

V_XORed_Line:
        ld a, (hl)
        xor c
        ld (hl), a
        add hl, de
        DJNZ V_XORed_Line
        ret

H_Line:
        push de
        push hl
        push bc
        ld a, d
        call Getpix
        pop bc
        push bc
        ld d, c
        ld c, a
        ld a, d
        or a
        call z, H_White_Line
        dec a
        call z, H_Black_Line
        dec a
        call z, H_XORed_Line
        pop bc
        pop hl
        pop de
        ret

H_White_Line:
        ld a, c
        CPL
        ld c, a
H_White_Line_2:
        ld a, (hl)
        and c
        ld (hl), a
        RR c
        jr c, Cont_H_White_Line 
        inc hl
        RR c
Cont_H_White_Line:
        DJNZ H_White_Line
        xor a
        ret

H_Black_Line:
        ld a, (hl)
        or c
        ld (hl), a
        RR c
        jr nc, Cont_H_Black_Line
        inc hl
        RR c
Cont_H_Black_Line:
        DJNZ H_Black_Line
        xor a
        ret

H_XORed_Line:
        ld a, (hl)
        xor c
        ld (hl), a
        RR c
        jr nc, Cont_H_XORed_Line
        inc hl
        RR c
Cont_H_XORed_Line:
        DJNZ H_XORed_Line
        ret
