;--------------->Plasma<------------------
;Version 1.4
;
;The source code to Plasma is freely available.
;(This includes plasma.asm, gui.asm and load.asm. [It does not include
;ionlibs.asm this code was written by Joe Wingbermuehle and 
;used with permission. If you would like to use it in your code 
;you must contact Joe Wingbermuehle <jwing@umr.edu>
;and get his permission.])
;The source must be packaged with the compiled binaries.
;Any one can modify, recompile, then distribute the source code.
;The source must be released on the modified version and must
;carry this copy right at the top of the source files.
;Before releasing the program a 
;e-mails explaining what kind of program the code was used for
;should be sent to the following people:
;Joe Flint <Joe-F@columbus.rr.com>
;Brandon Engelberth <reddwarf_lester@yahoo.com>
;This is so we know if the code is ever actualy used. If you optimize 
;or fix a bug it would be very much appreciated if you would email
;it to the above people. This way they can be included in the official
;releases of Plasma.

;Authors:
;Joe Flint - GUI
;Joe-F@columbus.rr.com
;
;Brandon Engelberth - CORE, LOADER
;reddwarf_lester@yahoo.com
;
;Enjoy!



#ifdef TI83P
    .nolist         ;\
    #include "ion.inc"  ; \
    .list       
    .org progstart-2
shell:
    .db $bb,$6d

;#define RAMHOOK 0
;#define DEVEL 1

;Ion DEFINES
#define TI83P_USE_FLASH_DETECT
#define VERSION_MAJOR			1	; Version (major)
#define VERSION_MINOR			4	; Version (minor)
#define ION_COMPATIBILITY		0	; Ion compatibility number
#define	LIBRARY_COMPATIBILITY		1	; Library compatibility number
#define NUMBER_OF_LIBRARIES		10
randData =cmdshad+80+(3*8)


_flashtoram = $5017
_runindicoff = $4570
_delmem = $4357
_enoughmem = $42fd
_CreateAppVar = $4E6A
AppVarObj = $15

ram_loader = plotsscreen
;Flash offset = 10 + name length
Desc_len = 30
END_VAT = $982E
PROT_PRGM = $6
PLUGIN_COMPAT = $00
LIST = $1
unsafe_ram = saferam1
;Global Vars
Data_Prog_Name = unsafe_ram+0   ;10bytes        
Data_Prog_Desc = unsafe_ram+10  ;30bytes    
Data_Prog_Size = unsafe_ram+40  ;2bytes     
Data_Num_Progs = unsafe_ram+42  ;1byte      
Data_Prog_Name_Size = unsafe_ram+43 ;1byte
Data_Flash_Off_Set = unsafe_ram+44  ;1byte

current = cmdshad       ;2bytes MUST be in safe_ram not unsafe_ram

Plugin_Run_Code = cmdshad+2 ;1byte
Plasma = cmdshad+3
Global_end = unsafe_ram+45
;Core Vars

Prog_Table =Global_end  ;450bytes
Loader_Code = Global_end+450    ;200
Plugin_Table = saferam3
Plasma_Loader_Location = Global_end+450 ;2bytes
Core_end = Global_end+650
;Temp area - 40 bytes big
temp = core_end     ;20bytes

;Core Functions

start:

    call Clean  
    call Prog_Init
    ;Run the GUI.
    call startgui
	set 3, (iy+$24)
    res onInterrupt,(iy+onFlags)
    call loadhook
    ld de,plotsscreen+2
    ld hl,loader_loader
    ld bc,loader_loader_end-loader_loader
    ldir
    ld hl,loader_name
    rst 20h;bcall(_mov9toop1)
    bcall(_chkfindsym)
    ret c
    ex de,hl
    ld c,(hl)
    inc hl
    ld b,(hl)
    inc hl
    ld de,progstart-2
    jp plotsscreen+2
loadhook:
	ld hl,hook
	ld de,9872h
	ld bc,hook_end-hook
	ldir
	ld a,41h
	ld hl,9872h
	bcall(4F66h)
	ret
;Label-Startof_data+start_of_copy_to
plasmaload = $9872

loaderstart:
hook:
	add a,e
	cp 08Ah
	jr z,ignorekey
	or a
	ret
;#include "extraequ.inc"
_BufClear	= 4936h
_BufReplace	= 490Fh
_BufRight	= 4906h
_bufInsert	= 4909h
ignorekey:
	IN  A, ($04)  ; Checking if on is pressed
	BIT 3, A
	jr NZ,onNot
	ld a,40h
	bcall(4030h) ;Restore homescreen
	bcall(_BufClear)
	ld hl,progA-loaderstart+plasmaload
	rst 20h ;bcall(_mov9toop1)
	bcall(_chkfindsym)
	jr c,noA
	ld a,b
	or a
	jr nz,noA
	;ld de,$5f
	ld hl, progA+1-loaderstart+plasmaload
	jr LoadBuffer
noA:
	ld hl,progLOAD-loaderstart+plasmaload
	rst 20h ;bcall(_mov9toop1)
	bcall(_chkfindsym)
	jr c,noLOAD
	ld a,b
	or a
	jr nz,noLOAD
	ld de,$BB6A ;Asm
	bcall(_BufInsert)
	ld hl,progLOAD+1-loaderstart+plasmaload
	jr LoadBuffer
noLOAD:
	ld hl,progPLASMA-loaderstart+plasmaload
	rst 20h ;bcall(_mov9toop1)
	bcall(_chkfindsym)
	jr c,onNot
	ld a,b
	or a
	jr nz,onNot
	ld de,$BB6A ;Asm
	bcall(_BufInsert)
	ld hl, progPLASMA+1-loaderstart+plasmaload
	jr LoadBuffer
onNot:
	ld a,08Ah
	or a
	ret
;hl->string
;de=initial
LoadBuffer:
	ld de,$5f
LoadBufferLoop:
	push hl
	bcall(_BufInsert)
	pop hl
	xor a
	cp (hl)
	jr z,LoadBufferFinish
	ld d,$00
	ld e,(hl)
	inc hl
	jr LoadBufferLoop
LoadBufferFinish:
	ld a,5
	or a
	ret



progA:
LET            =       41h
vToks   =     LET+27    ;
tProg          =       vToks+3     ; 5Fh
    .db 6,"A",0
progLOAD:
loader_name:
    .db 6,"LOAD",0
shell_name:	;Used for backwards compatability, and not to have reaccuring crap.
progPLASMA:
    .db 6,"PLASMA",0
loaderend:   
hook_end:

loader_loader:
    ldir
    xor a
    ld hl,shell_end-shell
    ret
loader_loader_end:
Clean:
    ld hl,unsafe_ram
    ld de,unsafe_ram+1
    ld (hl),$00
    ld bc,768
    ldir

    ret

;Core Functions

Prog_Find:
    ;xor a
    ;ld (Data_Num_Progs),a
    ld hl,Prog_Table
    ld (Table_Pointer),hl
    ld hl,(VAT)
NEXT_ENTRY:
    ld de,(END_VAT)
    ld a,h      ;Mabe change this to a bcall(_cphlde)....?
    cp d
    jr nz,CONTINUE_SEARCH
    ld a,l
    cp e
    jr z,END_OF_SEARCH
CONTINUE_SEARCH
    ld a,(hl)
    cp LIST
    jr z,MOVE_PAST_LIST
    ld a,(hl)
    ld (PRGM_PROT),a
    dec hl \ dec hl \ dec hl
    ld a,(hl)
    ld (PRGM_LOC),a
    dec hl
    ld a,(hl)
    ld (PRGM_LOC+1),a
    dec hl
    ld a,(hl)
    ld (PRGM_ARCH_PAGE),a
    dec hl
    ld b,(hl)
    ld de,PRGM_NAME
    dec hl
GET_NAME_LOOP:
    ld a,(hl)
    ld (de),a
    inc de
    dec hl
    djnz GET_NAME_LOOP
    xor a
    ld (de),a
    push hl
;ARCHIVED_SIZE:
    call Addtotable
    pop hl
    jr NEXT_ENTRY
MOVE_PAST_LIST:
    dec hl \ dec hl \ dec hl \ dec hl \ dec hl \ dec hl
    ld b,(hl)
    dec hl
SKIP_LIST_NAME_LOOP:
    dec hl
    djnz SKIP_LIST_NAME_LOOP
    ;dec hl
    jr NEXT_ENTRY

END_OF_SEARCH:
    ret
PRGM_ARCH_PAGE = temp       ;1
PRGM_NAME = temp+2      ;10 needs an extra byte in the front
PRGM_PROT = temp+12     ;1
PRGM_LOC = temp+13      ;2
PRGM_SIZE = temp+15     ;2
Table_Pointer = temp+17     ;2
Plugin_Pointer = temp+19    ;2
Arch_Data = temp+21
Prog_Init:
    call Prog_Find
    ld hl,Prog_Table
    ld (current),hl
    call Set_Prog_Data
    ret
addtotable:
    ld a,(PRGM_ARCH_PAGE)
    or a
    jr z,addtotable_not_Archived

    
Offset_fine:

    ld hl,PRGM_NAME-1
    ld (hl),$06
    bcall(_mov9toop1)
    bcall(_chkfindsym)
    ;ret c  ;will crash 
    ld a,b
    or a
    ;ret z
    ;dec hl \ dec hl \ dec hl \ dec hl \ dec hl \ dec hl    ;36 Cycles!
    ld bc,6     ;
    sbc hl,bc   ;18 cycles!
    ld c,(hl)
    ld b,$00
    
    ld hl,10
    add hl,bc
    add hl,de
    ld bc,8
    ld de,Arch_data
    bcall(_flashtoram)
    ld hl,Arch_data
    ld (PRGM_LOC),hl
    ;bcall(_puts)
    ;jr set
addtotable_not_archived:
    ld a,(PRGM_PROT)
    cp 6
    ret nz
    ld ix,(PRGM_LOC)
    ld a,$30
    cp (ix+5)
    ret nz
set:
    ld de,(Table_Pointer)
    ld hl,PRGM_NAME
    ld a,6
    ld (de),a
    inc de
    ld bc,8
    ldir
    ex de,hl
    ld (Table_Pointer),hl
    ld hl,Data_Num_Progs
    inc (hl)
    ret
Set_Prog_Data:
    xor a
    ld (Data_Flash_Off_Set),a
    ld hl,(current)
    rst 20h;bcall(_mov9toop1)
    bcall(_chkfindsym)
    ;ret c
    ld a,b
    or a
    jr  z,Set_Not_Arc
    ;dec hl \ dec hl \ dec hl \ dec hl \ dec hl \ dec hl    ;36 Cycles!
    ld bc,6     ;
    sbc hl,bc   ;18 cycles!
    ld c,(hl)
    ld b,$00
    ld hl,10
    add hl,bc
    ld b,a
    ld a,l
    ld (Data_Flash_Off_Set),a
    add hl,de
    ld a,b
    ld de,temp
    ld bc,35
    bcall(_flashtoram)
    ld de,temp
Set_Not_Arc:
    ld a,(de)
    ld (Data_Prog_Size),a
    inc de
    ld a,(de)
    ld (Data_Prog_Size+1),a
    ld hl,6
    add hl,de
    ld de,Data_Prog_Desc
    ld bc,30
    ldir
    ld de,Data_Prog_Name
    ld hl,(current)
    inc hl
    ld bc,8
    ldir
    ret



Prev_Prog:
    ld b,1

Jump_Prev_b_Progs:

    ld c,$00
Prev_Prog_Loop:
    xor a
    ld hl,(current)
    ld de,9
    sbc hl,de
    ld de,Prog_Table-9
    ld a,d
    cp h
    jr nz,Prev_Prog2
    ld a,e
    cp l
    jr z,Prev_Prog_Ext
Prev_Prog2:
    inc c
    ld (current),hl
    push bc
    call Set_Prog_Data
    pop bc
    djnz Prev_Prog_Loop
Prev_Prog_Ext:
    ld a,c

    ret
;Input b=number of programs to Jump past
;   b=1 will go to next one
;output a=number of programs that were actually jumped
;   a may not equal b if there weren't enough programs left in the table
;Next_Prog now calls Jump_Next_b_Progs so checking the flag won't do
;or a jr z,DID_NOT_ADVANCE
Next_Prog:
    ld b,1
Jump_Next_b_Progs:

    ld c,$00
Next_Prog_Loop:
    ld hl,(current)

    ld de,9
    add hl,de
    xor a
    cp (hl)
    jr nz,Next_Prog2
    inc hl
    cp (hl)

    jr z,Next_Prog_Ext
    dec hl
Next_Prog2:
    inc c
    ld (current),hl
    push bc
    call Set_Prog_Data
    pop bc
    djnz Next_Prog_Loop

    
Next_Prog_Ext:
    ld a,c

    ret
get_ram_to_insert:
    ld hl,(Data_Prog_Size)
    ld de,Lib_End-Lib_start
    add hl,de
    ld de,shell_end-shell   
    bcall(_cphlde)
    jr c,Exit_c_0
    xor a       ;carry = 0
    sbc hl,de   ;hl = How much ram needs to be inserted.
    bcall(_enoughmem)
    ret
Exit_c_0:
    xor a
    ret
Exec_Prog:
	#ifdef RAMHOOK
	call Load_ramHook
	#endif
    ld hl,plotsscreen
    ld de,plotsscreen+1
    ld (hl),$00
    ld bc,767
    ldir
    bcall(_clrscrf)
Exec_Plugin:
    call exec_prog_real

    call clean
    call Prog_Find
    call Set_Prog_Data
    call get_ram_to_insert
    ld hl,Prog_end
    ;ex de,hl
    bcall(_delmem)
    xor a
    ret
DontDelete:
    call clean
    call Prog_Find
    call Set_Prog_Data
    ret
exec_prog_real:
    ;testing insertmem

    call get_ram_to_insert
    jr nc,DontForceExit
    pop hl
    jr DontDelete
DontForceExit:

    ex de,hl
    ld de,prog_end
    bcall(_insertmem)
    ld hl,shell_name
    rst 20h;bcall(_mov9toop1)
    bcall(_chkfindsym)
    ld a,b
    or a
    ex de,hl
    push bc ;Flash page!
    push hl
    jr z,Shell_Not_In_Flash

    ld de,16
    add hl,de
    ld bc,2
    ld de,temp
    bcall(_flashtoram)
    ld hl,temp
Shell_Not_In_Flash:

    ld e,(hl)
    
    inc hl
    ld d,(hl)
    pop hl
    inc hl \ inc hl

    push hl ;start

    push de ;size

    ld hl,Prog_Loader
    ld de,saferam3
    ld bc,Prog_Loader_end-Prog_Loader
    ldir
    ld hl,Plasma_Loader
    ld de,Plasma
    push de
    ld bc,Plasma_Loader_end-Plasma_Loader
    ldir
    ld hl,(Data_Prog_Size)
    ld de,progstart-2
    add hl,de
    ;inc hl     ;Don't think it needs this!
    push hl
    ld (temp),hl
;Generate ionLibrary Jump Table starting at cmdshad+80
    ld b,NUMBER_OF_LIBRARIES
    ld ix,routinePointers
    ld hl,cmdshad+80
Ion_Table_Loop:
    push bc
    ld de,(temp)
    ld c,(ix)
    ld b,(ix+1)
    inc ix \ inc ix
    ex de,hl
    add hl,bc
    ex de,hl

    ld (hl),$c3
    inc hl
    ld (hl),e
    inc hl
    ld (hl),d
    inc hl
    pop bc
    djnz Ion_Table_Loop

    ld hl,(Data_Prog_Size)
    push hl
    ld a,(Data_Flash_Off_Set)
    push af




    ld hl,Data_Prog_Name-1

    rst 20h;bcall(_mov9toop1)
    ld bc,lib_end-lib_Start
    push bc
    pop hl
    ld (appbackupscreen),hl
    
    ld de,appbackupscreen+2
    ld hl,lib_Start

    ldir
    ld a,6
    ld (op1),a
    bcall(_chkfindsym)
    ;jr c,Return_nz ;It better exist!
    ;Undocumented function of flashtoram. If a=0 it copies form Ram! Me like this:)
    ;Thank you joe f for discovering this.
    ret c
    pop af
    
    ld l,a
    ld h,$00
    add hl,de
    ld de,progstart-2
    ld a,b
    pop bc
    inc hl \ inc hl ;move past size bytes
    ld de,progstart-2
    jp saferam3
Prog_Loader:


    bcall(_flashtoram)
    ld bc,(appbackupscreen)
    pop de
    ld hl,appbackupscreen+2
    ldir
    ;ld a,(Plugin_Run_Code)
    jp progstart+1

Prog_Loader_end:
Plasma_Loader:      ;16
    pop bc  ;1
    pop hl  ;1
    pop af  ;1
    
    or a
    jr z,Plasma_Loader_inRam
    ;pop hl
    ;ret
    ld de,16    ;offset
    add hl,de
    ld de,progstart-2   ;3
    bcall(_flashtoram)      ;2
    ret
Plasma_Loader_inRam:
    ld de,progstart-2   ;3
    ldir

    ret     ;1
Plasma_Loader_End:

#include "ionlibs.asm"
gui = plasma+Plasma_loader_end-Plasma_Loader
#include "gui.asm"
#ifdef RAMHOOK
#include "ramhook.asm"
#endif
prog_end:
shell_end:
#else
;Thats right there is a working ti-83 Version!!!
;Send it to your calc and run send(9prgmPLASMA hahahaha
;If you use the 83 you should use Ion. Ion is smaller and has better mem handling of programs
;in ram. Plasma was designed to take advantage of flash memory.
    ret
#endif
.end
end