;##################################################################
;
;   Phoenix-Z80 (New game initialization)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated June 26, 2001.
;
;##################################################################     

difficulty_msg:
        .db     "Choose Difficulty",0
        .db     0
        .db     "F3) Beginner",0
        .db     "F4) Intermediate",0
        .db     "F5) Advanced",0
        .db     -1

speed_msg:
        .db     "Choose Speed",0
        .db     0
        .db     "F3) Slow",0
        .db     "F4) Medium",0
        .db     "F5) Fast",0
        .db     -1

;############## Prepare new game

initialize_game:
        ld      hl,perm_var_start
        ld      bc,perm_vars_to_zero-1
        call    OTH_CLEAR
        ld      a,4
        ld      (speed),a

        ld      hl,player_y
        ld      (hl),70         ; Player Y coord = 70
        inc     hl
        ld      (hl),60         ; Player X coord = 60
        inc     hl
        inc     hl
        inc     hl
        ld      (hl),16         ; Status of player's ship

        call    CLEARLCD
        ld      hl,difficulty_msg
        call    display_hl_msgs

dsel_loop:
        call    scroll_sides
        call    display_sides
        
        call    synchronize
        call    GET_KEY
#ifdef ENABLE_CHEATS
        cp      K_3
        jr      z,play_cheat
#endif
        sub     K_F3
        jr      z,play_easy
        inc     a
        jr      z,play_medium
        inc     a    
        jr      z,play_hard
        cp      K_EXIT-K_F5
        jr      nz,dsel_loop
        jp      game_exit
       
#ifdef ENABLE_CHEATS
play_cheat:
        ld      de,-1
        ld      a,255
        ld      (weapon_5),a
        ld      (weapon_upgrade),a
        ld      (player_pwr),a
        jr      install_game_variables
#endif

play_hard:
        ld      a,25
        ld      de,15000
        jr      install_game_variables
play_medium:
        ld      a,50
        ld      de,5000
        jr      install_game_variables
play_easy:
        ld      de,0
        ld      a,100
install_game_variables:
        ld      (bonus_score),de
        ld      (difficulty),a

        ld      hl,19000
        ld      (time_score),hl

        call    CLEARLCD
        ld      hl,speed_msg
        call    display_hl_msgs

ssel_loop:
        call    scroll_sides
        call    display_sides
        
        call    synchronize
        call    GET_KEY
        cp      K_F3
        jr      z,play_7
        cp      K_F4
        jr      z,play_6
        cp      K_F5
        jr      z,play_5
        cp      K_EXIT
        jr      nz,ssel_loop
        jp      game_exit

play_7: ld      a,6
        ld      de,0
        jr      speed_chosen
play_6: ld      a,5
        ld      de,1000
        jr      speed_chosen
play_5: ld      a,4
        ld      de,5000
speed_chosen:
        ld      (speed),a
        ld      hl,(bonus_score)
        add     hl,de
        ld      (bonus_score),hl

        ld      hl,data_zero_start
        ld      bc,data_zero_end-data_zero_start-1
        jp      OTH_CLEAR
