 include "ti83plus.inc"

 db 080h, 00Fh
 db 000h, 000h, 000h, 000h
 db 080h, 012h
 db 001h, 004h
 db 080h, 021h
 db 001h
 db 080h, 031h
 db 001h
 db 080h, 048h
 db "FinnPack"
 db 080h, 081h
 db 001h
 db 080h, 090h
 db 003h, 026h, 009h, 004h
 db 00Ah, 074h, 02Bh, 00Ah
 db 002h, 00Dh, 040h, 0A1h, 06Bh, 099h, 0F6h, 059h, 0BCh, 067h
 db 0F5h, 085h, 09Ch, 009h, 06Ch, 00Fh, 0B4h, 003h, 09Bh, 0C9h
 db 003h, 032h, 02Ch, 0E0h, 003h, 020h, 0E3h, 02Ch, 0F4h, 02Dh
 db 073h, 0B4h, 027h, 0C4h, 0A0h, 072h, 054h, 0B9h, 0EAh, 07Ch
 db 03Bh, 0AAh, 016h, 0F6h, 077h, 083h, 07Ah, 0EEh, 01Ah, 0D4h
 db 042h, 04Ch, 06Bh, 08Bh, 013h, 01Fh, 0BBh, 093h, 08Bh, 0FCh
 db 019h, 01Ch, 03Ch, 0ECh, 04Dh, 0E5h, 075h
 db 080h, 07Fh
 db 000h, 000h, 000h, 000h
 db 000h, 000h, 000h, 000h
 db 000h, 000h, 000h, 000h
 db 000h, 000h, 000h, 000h
 db 000h, 000h, 000h, 000h



; Common stuff ---------------------------------------------------------------------------------------------------------------------------------

HelpValue .equ textShadow+79         ;NEW
Menu .equ textShadow+80
Menu2 .equ textShadow+81
MenuMax .equ textShadow+82
SecondFlag .equ textShadow+83
CurrentMenu .equ textShadow+84      ;2 bytes
HelpText .equ textShadow+86         ;2 bytes
HelpLines .equ textShadow+88
Chosen .equ textShadow+89
ConfData .equ textShadow+90

savevals .equ textShadow+100         ;6 bytes


; Init stuff -----------------------------------------------------------------------------------------------------------------------------------

setToFull:
    ld hl, YOffset
    ld de, savevals
    ld bc, 5
    ldir
    ld a,(iy+sGrFlags)
    ld (de),a
    res grfSplit,(iy+sGrFlags)
    res vertSplit,(iy+sGrFlags)
    B_CALL SetNorm_Vals
    set grfSplitOverride,(iy+sGrFlags)
    set textWrite,(iy+sGrFlags)

    B_CALL RunIndicOff

    xor a
    ld (Chosen),a
    ld (SecondFlag),a

StartOfMain:    
    B_CALL ClrLCDFull
    ld hl,TitlePic
    ld de,plotsscreen
    ld bc,768
    ldir

    call InvertTitle

StartFlashLoop:
    call GetCSC
    cp skEnter
    jr z,GameChosen
    cp skLeft
    jr z,SetDots
    cp skRight
    jr z,SetTower
    cp skClear
    jp z,Quit
    jr StartFlashLoop

GameChosen:
    ld a,(Chosen)
    or a
    jp z,DotsStartApp
    jp TowerStartApp

SetDots:
    call InvertTitle
    xor a
    ld (Chosen),a
    call InvertTitle
    jr StartFlashLoop

SetTower:
    call InvertTitle
    ld a,1
    ld (Chosen),a
    call InvertTitle
    jr StartFlashLoop

InvertTitle:
    ld hl,plotsscreen+180
    ld de,6
    ld c,41
    ld a,(Chosen)
    or a
    jr z,InvertTitleSkip
    ld hl,plotsscreen+186
InvertTitleSkip:
    ld b,6
InvertTitleLoop:
    ld a,(hl)
    cpl
    ld (hl),a
    inc hl
    djnz InvertTitleLoop
    add hl,de
    dec c
    jr nz,InvertTitleSkip
    B_CALL GrBufCpy
    ret


; Dots application starts here -----------------------------------------------------------------------------------------------------------------

DotsStartApp:                 ;The app starts here

board   .equ   textShadow
ThinkMem    .equ   statVars


Width .equ textShadow+60
Height .equ textShadow+61
Coords .equ textShadow+62
OldCoords .equ textShadow+64
Mode .equ textShadow+66
Player .equ textShadow+67
Order .equ textShadow+68
Flag .equ textShadow+69
Exist01Flag .equ textShadow+70
Exist3Flag .equ textShadow+71
NumOfS .equ textShadow+72
NumOfFS .equ textShadow+73
Points .equ textShadow+74       ; two bytes
;Menu .equ textShadow+76
;Menu2 .equ textShadow+77
NumberOfChecks .equ textShadow+78



    B_CALL DelRes
    B_CALL RunIndicOff
    B_CALL ClrLCDFull
    res appTextSave,(iy+appflags)
    res indicOnly,(iy+indicFlags)
    set apdRunning,(iy+apdFlags)
    set textEraseBelow,(iy+textFlags)

    
    ld hl,DotsTitlePic
    ld de,plotsscreen
    ld bc,768
    ldir  
    
    B_CALL GrBufCpy
    call PauseLoop

FirstBegin:
    ld hl,textShadow
    ld d,h
    ld e,l
    inc de
    ld (hl),0
    ld bc,83
    ldir
    ld a,5
    ld (Width),a
    ld (Height),a
    ld a,10
    ld (NumberOfChecks),a

SecondBegin:
    ld hl,textShadow
    ld d,h
    ld e,l
    inc de
    ld (hl),0
    ld bc,59
    ldir
    xor a
    ld (Menu),a
    ;ld (Menu2),a
    ld hl,plotsscreen
    ld de,plotsscreen+1
    ld bc,767
    ld (hl),0
    ldir

    set textWrite,(iy+sGrFlags)
    set fracDrawLFont,(iy+fontFlags)
    ld hl,1*256+17
    ld (pencol),hl
    ld hl,Text
    call PutvText                ;Dots
    res fracDrawLFont,(iy+fontFlags)

    call InvertTopRow

DotsMenuRoutine:

    ld hl,ModeTxt
    ld bc,11*256+0
    ld (pencol),bc
    call PutvText               ;Game mode
    ld hl,SizeTxt
    ld bc,18*256+1
    ld (pencol),bc
    call PutvText               ;board size

    ld hl,Human
    ld bc,11*256+41
    ld (pencol),bc
    ld a,(Mode)
    or a
    jr z,HumanvsHuman
    ld hl,TI86
HumanvsHuman:
    call PutvText

    ld hl,18*256+41
    ld (pencol),hl
    ld a,(Width)
    add a,'0'
    B_CALL VPutMap
    ld a,'x'
    B_CALL VPutMap
    ld a,(Height)
    add a,'0'
    B_CALL VPutMap

    B_CALL GrBufCpy

    ld hl,DotsMenu
    call HandleMenuRoutine

    ld a,(Menu)
    or a
    jp z,DotsBegin
    dec a
    jp z,DotsOptions
    dec a
    call z,DotsHelp     ;Preserves A
    dec a
    jp nz,SecondBegin
    jp StartOfMain

DotsHelp:
    ld hl,DotsHelpTxt
    jp Help
    
DotsOptions:
    ld hl,plotsscreen
    ld de,plotsscreen+1
    ld bc,767
    ld (hl),0
    ldir

    set textWrite,(iy+sGrFlags)
    set fracDrawLFont,(iy+fontFlags)
    ld hl,1*256+17
    ld (pencol),hl
    ld hl,Text
    call PutvText                ;Dots
    res fracDrawLFont,(iy+fontFlags)

    call InvertTopRow

    xor a
    ld (Menu),a

DOptions2:
    ld hl,DOptionsMenu
    call DispMenuRoutine

    ld hl,21*256+42
    ld (pencol),hl
    ld hl,Human
    ld a,(Mode)
    or a
    jr z,Optionsskiplittle
    ld hl,TI86
Optionsskiplittle:
    call PutvText
    ld hl,28*256+42
    ld (pencol),hl
    ld a,(Height)
    add a,'0'
    B_CALL VPutMap
    ld hl,35*256+42
    ld (pencol),hl
    ld a,(Width)
    add a,'0'
    B_CALL VPutMap

    B_CALL GrBufCpy

DOptionsKeyLoop:
    call GetCSC
    cp skDown
    jr z,ODownPressed
    cp skLeft
    jr z,OLeftPressed
    cp skRight
    jr z,ORightPressed
    cp skUp
    jr z,OUpPressed
    cp skEnter
    jp z,OEnterPressed
    jr DOptionsKeyLoop

ODownPressed:
    ld a,(Menu)
    cp 3
    jr z,DOptionsKeyLoop
    inc a
    ld (Menu),a
    jp DOptions2

OUpPressed:
    ld a,(Menu)
    or a
    jr z,DOptionsKeyLoop
    dec a
    ld (Menu),a
    jp DOptions2

OLeftPressed:
    ld a,(Menu)
    or a
    jr z,ChangeMode
    dec a
    jr z,DecHeight
    dec a
    jr z,DecWidth
    jr DOptionsKeyLoop

ORightPressed:
    ld a,(Menu)
    or a
    jr z,ChangeMode
    dec a
    jr z,IncHeight
    dec a
    jr z,IncWidth
    jr DOptionsKeyLoop

IncWidth:
    ld a,(Width)
    cp 9
    jr z,DOptionsKeyLoop
    inc a
    ld (Width),a
    jp DOptions2

ChangeMode:
    ld a,(Mode)
    xor 1
    ld (Mode),a
    jp DOptions2

DecHeight:
    ld a,(Height)
    cp 3
    jr z,DOptionsKeyLoop
    dec a
    ld (Height),a
    jp DOptions2

DecWidth:
    ld a,(Width)
    cp 3
    jp z,DOptionsKeyLoop
    dec a
    ld (Width),a
    jp DOptions2

IncHeight:
    ld a,(Height)
    cp 6
    jp z,DOptionsKeyLoop
    inc a
    ld (Height),a
    jp DOptions2

OEnterPressed:
    ld a,(Menu)
    or a
    jp z,ChangeMode
    dec a
    jr z,IncHeight2
    dec a
    jr z,IncWidth2
;ReturnToMain:
    jp SecondBegin


IncHeight2:
    ld a,(Height)
    cp 6
    jr nz,IH2Skip
    ld a,2
IH2Skip:
    inc a
    ld (Height),a
    jp DOptions2

IncWidth2:
    ld a,(Width)
    cp 9
    jr nz,IW2Skip
    ld a,2
IW2Skip:
    inc a
    ld (Width),a
    jp DOptions2

DotsBegin:
    B_CALL ClrLCDFull
    ld hl,plotsscreen
    ld d,h
    ld e,l
    inc de
    ld (hl),0
    ld bc,767
    ldir
    call DrawDots
    ld hl,0
    ld (Coords),hl
    ld (OldCoords),hl
    ld (Points),hl
    xor a
    ld (Flag),a
    ld (Order),a
    ld (NumOfFS),a
    inc a
    ld (Player),a
    ld bc,0101h
    ld de,marker
    call PutSprite
    call UpdateMenu


MainLoop:
    ld hl,(Coords)
    ld (OldCoords),hl
    ld a,(Mode)
    or a
    jr z,GetInput
    ld a,(Order)
    ld b,a
    ld a,(Player)
    cp b
    jp z,CalcsTurn
GetInput:
    call GetCSC
    cp skDown
    jr z,MoveDown
    cp skLeft
    jr z,MoveLeft
    cp skRight
    jr z,MoveRight
    cp skUp
    jr z,MoveUp
    ;cp skMode
    ;jp z,FirstBegin         ;Quit
    cp skYEqu               ;2nd
    jr z,DrawLineMode
    cp skZoom
    call z,DotsConf				;Hr r det som confirm ska komma
    cp skGraph
    call z,DotsHelp
    jr GetInput

MoveDown:
    ld a,(Height)
    ld b,a
    ld a,(Coords+1)
    inc a
    cp b
    jr z,GetInput
    ld (Coords+1),a
    jp PutMarker

MoveLeft:
    ld a,(Coords)
    or a
    jr z,GetInput
    dec a
    ld (Coords),a
    jp PutMarker

MoveRight:
    ld a,(Width)
    ld b,a
    ld a,(Coords)
    inc a
    cp b
    jr z,GetInput
    ld (Coords),a
    jp PutMarker

MoveUp:
    ld a,(Coords+1)
    or a
    jr z,GetInput
    dec a
    ld (Coords+1),a
    jp PutMarker

DrawLineMode:
    call PutPen
DLMKLoop:
    call GetCSC
    cp skDown
    jr z,DrawDown
    cp skLeft
    jr z,DrawLeft
    cp skRight
    jr z,DrawRight
    cp skUp
    jr z,DrawUp
    cp skZoom
    call z,DotsConf
    cp skGraph
    call z,DotsHelp
    ;cp skMode
    ;jp z,FirstBegin             ;Quit
    cp skYEqu                    ;2nd
    jr nz,DLMKLoop

EndDrawMode2:
    call PutPen
    ld a,10
    ld (NumberOfChecks),a
    jp MainLoop ;GetInput

DrawDown:
    call CalcAddr
    bit 0,(hl)
    jr nz,DLMKLoop
    set 0,(hl)
    ld a,(Coords+1) ;y
    inc a
    ld b,a
    ld a,(Height)
    cp b
    jp z,DrawDLine
    add hl,de
    set 1,(hl)
    jp DrawDLine

DrawLeft:
    call CalcAddr
    bit 3,(hl)
    jr nz,DLMKLoop
    set 3,(hl)
    ld a,(Coords)   ;x
    or a
    jp z,DrawLLine
    dec hl
    set 2,(hl)
    jp DrawLLine

DrawRight:
    call CalcAddr
    bit 2,(hl)
    jr nz,DLMKLoop
    set 2,(hl)
    ld a,(Coords)   ;x
    inc a
    ld b,a
    ld a,(Width)
    cp b
    jp z,DrawRLine
    inc hl
    set 3,(hl)
    jp DrawRLine

DrawUp:
    call CalcAddr
    bit 1,(hl)
    jp nz,DLMKLoop
    set 1,(hl)
    ld a,(Coords+1) ;y
    or a
    jp z,DrawULine
    and a
    sbc hl,de
    set 0,(hl)
    jp DrawULine


DrawDLine:
    call CalculateLine
    add hl,de
CommonUD:
    ld a,255
    ld (hl),a
    jp EndDrawMode

DrawLLine:
    call CalculateLine
CommonLR:
    ld de,12
    ld b,7
DrawLLLoop:
    ld a,10000000b
    add hl,de
    xor (hl)
    ld (hl),a
    djnz DrawLLLoop
    jp EndDrawMode

DrawRLine:
    call CalculateLine
    inc hl
    jr CommonLR

DrawULine:
    call CalculateLine
    jr CommonUD

    
CalculateLine:          ;Makes hl point to the square in videomem
    ld hl,plotsscreen+85-96 ;$FC71
    ld de,96
    ld bc,(Coords)
    inc b
CLLoop:
    add hl,de
    djnz CLLoop
    add hl,bc
    ret


CalcAddr:           ;makes hl point to the square pointed to by the coords
    ld bc,(Coords)  ;c.equx b.equy
    ld hl,board     ;y.equcoords+1
    ld a,(Width)
    ld e,a
    ld d,0
    and a
    sbc hl,de
    inc b
CALoop:
    add hl,de
    djnz CALoop
    add hl,bc
    ret             ;Returns with de.equamount to add to get to the next line

DrawDots:
    ld hl,plotsscreen+85    ;$FC71
    ld a,(Height)
    inc a
    ld b,a
DDLoop1:
    push bc
    ld a,(Width)
    ld c,a
    inc a
    ld b,a
    ld a,11
    sub c
    ld e,a
    ld d,0
    ld a,10000000b
DDLoop2:
    ld (hl),a
    inc hl
    djnz DDLoop2
    add hl,de
    ld de,84        ;112
    add hl,de
    pop bc
    djnz DDLoop1
    ret

CalcsTurn:
    xor a
    ld (Exist3Flag),a
    ld (Exist01Flag),a
    call NumberOfSquares
    ld (NumOfS),a
    ld b,a
    ld hl,board     ;Coords
                    ;y.equcoords+1
QuestFor013:
    ld a,(hl)
    and 00001111b
    or a
    jp z,Set01Flag2
    call CheckFor3
    call CheckFor1
    inc hl
    djnz QuestFor013

SkipTheRest1:
    ld de,0000h     ;d.equy e.equx
    ld c,d
    ld hl,ThinkMem
    push hl
    ld a,(NumOfS)
    ld b,a
    ld hl,board
WriteCoords:
    ld a,(Exist3Flag)
    or a
    jr nz,WeHaveA3
    ld a,(Exist01Flag)
    or a
    jr nz,WeHaveA0Or1
    ld a,(hl)
    and 00001111b
    cp 00001100b
    jp z,WriteCoord
    cp 00001010b
    jp z,WriteCoord
    cp 00000110b
    jp z,WriteCoord
    cp 00001001b
    jp z,WriteCoord
    cp 00000101b
    jp z,WriteCoord
    cp 00000011b
    jp z,WriteCoord
    call IncreaseCoord
    djnz WriteCoords
    jp CoordsAreWritten

WeHaveA0Or1:    
    ld a,(hl)
    and 00001111b
    or a
    jp z,WriteCoord
    cp 00000001b
    jp z,WriteCoord
    cp 00000010b
    jp z,WriteCoord
    cp 00000100b
    jp z,WriteCoord
    cp 00001000b
    jp z,WriteCoord
    call IncreaseCoord
    djnz WriteCoords
    jp CoordsAreWritten

WeHaveA3:
    ld a,(hl)
    and 00001111b
    cp 00001110b
    jp z,WriteCoord
    cp 00001101b
    jp z,WriteCoord
    cp 00001011b
    jp z,WriteCoord
    cp 00000111b
    jp z,WriteCoord
    call IncreaseCoord
    djnz WriteCoords

CoordsAreWritten:
    call Delay
    pop hl              ;EndOfThinkMem
    ld bc,ThinkMem
    and a
    sbc hl,bc
    ld a,l
    ;or a
    ;jp z,_jforcecmdnochar
    sra a
    call Random
    add a,a
    ld hl,ThinkMem
    ld c,a
    ld b,0
    add hl,bc
    ld a,(hl)
    ld (Coords),a
    inc hl
    ld a,(hl)
    ld (Coords+1),a

    ld bc,(OldCoords)
    ld de,marker
    inc b
    inc c
    call PutSprite
    ld bc,(Coords)
    ld de,marker
    inc b
    inc c
    call PutSprite

    ld hl,(Coords)
    ld (OldCoords),hl

    call PutPen
    call Delay

GetLRUD:
    ld a,4
    call Random
    or a
    jr z,TestLeft
    cp 1
    jr z,TestRight
    cp 2
    jr z,TestUp
    ;jr TestDown

TestDown:
    call CalcAddr
    bit 0,(hl)
    jr nz,GetLRUD
    ld a,(Difficulty)
    cp 1
    call z,LevelTwoCheckDown
    set 0,(hl)
    ld a,(Coords+1) ;y
    inc a
    ld b,a
    ld a,(Height)
    cp b
    jp z,DrawDLine
    add hl,de
    set 1,(hl)
    jp DrawDLine

TestLeft:
    call CalcAddr
    bit 3,(hl)
    jr nz,GetLRUD
    ld a,(Difficulty)
    cp 1
    call z,LevelTwoCheckLeft
    set 3,(hl)
    ld a,(Coords)   ;x
    or a
    jp z,DrawLLine
    dec hl
    set 2,(hl)
    jp DrawLLine

TestRight:
    call CalcAddr
    bit 2,(hl)
    jr nz,GetLRUD
    ld a,(Difficulty)
    cp 1
    call z,LevelTwoCheckRight
    set 2,(hl)
    ld a,(Coords)   ;x
    inc a
    ld b,a
    ld a,(Width)
    cp b
    jp z,DrawRLine
    inc hl
    set 3,(hl)
    jp DrawRLine

TestUp:
    call CalcAddr
    bit 1,(hl)
    jr nz,GetLRUD
    ld a,(Difficulty)
    cp 1
    call z,LevelTwoCheckUp
    set 1,(hl)
    ld a,(Coords+1) ;y
    or a
    jp z,DrawULine
    and a
    sbc hl,de
    set 0,(hl)
    jp DrawULine


LevelTwoCheckDown:
    ld a,(Coords+1) ;y
    inc a
    ld b,a
    ld a,(Height)
    cp b
    ret z
    push hl
    add hl,de

Controlling:
    ld a,(hl)
    and 00001111b
    cp 00001100b
    jr z,NewDir
    cp 00001010b
    jr z,NewDir
    cp 00000110b
    jr z,NewDir
    cp 00001001b
    jr z,NewDir
    cp 00000101b
    jr z,NewDir
    cp 00000011b
    jr z,NewDir
    pop hl
    ret

LevelTwoCheckLeft:
    ld a,(Coords)   ;x
    or a
    ret z
    push hl
    dec hl
    jr Controlling

LevelTwoCheckRight:
    ld a,(Coords)   ;x
    inc a
    ld b,a
    ld a,(Width)
    cp b
    ret z
    push hl
    inc hl
    jr Controlling


LevelTwoCheckUp:
    ld a,(Coords+1) ;y
    or a
    ret z
    push hl
    and a
    sbc hl,de
    jr Controlling

NewDir:
    pop hl
    ld a,(NumberOfChecks)
    dec a
    or a
    ret z
    ld (NumberOfChecks),a
    pop hl                  ;Get rid of garbage address
    jp GetLRUD

WriteCoord:
    pop hl
    ld (hl),e
    inc hl
    ld (hl),d
    inc hl
    push hl
    push bc
    ld b,0
    ld hl,board
    add hl,bc
    pop bc
    call IncreaseCoord
    dec b
    jp nz,WriteCoords
    jp CoordsAreWritten

IncreaseCoord:
    inc c
    inc hl
    ld a,(Width)
    dec a
    cp e
    jr z,NextLineOfS
    inc e
    ret
NextLineOfS:
    inc d
    ld e,0
    ret

CheckFor1:
    cp 00000001b
    jr z,Set01Flag
    cp 00000010b
    jr z,Set01Flag
    cp 00000100b
    jr z,Set01Flag
    cp 00001000b
    ret nz
Set01Flag:
    pop de          ;Remove call
Set01Flag2:
    ld a,1
    ld (Exist01Flag),a
    inc hl
    dec b
    jp nz,QuestFor013
    jp SkipTheRest1

CheckFor3:
    cp 00001110b
    jr z,Set3Flag
    cp 00001101b
    jr z,Set3Flag
    cp 00001011b
    jr z,Set3Flag
    cp 00000111b
    ret nz
Set3Flag:
    ld a,1
    ld (Exist3Flag),a
    pop hl              ;Remove the call
    jp SkipTheRest1

DotsConf:
    call Confirm
    ld a,(ConfData)
    cp 1
    jr nz,DotsConfSkip
    xor a
    ret
DotsConfSkip:
    pop hl
    jp SecondBegin


NumberOfSquares:
    ld a,(Width)
    ld b,a
    ld a,(Height)
    ld c,a
    xor a
NOSLoop:
    add a,c
    djnz NOSLoop
    ret



EndDrawMode:
    call NumberOfSquares
    ld b,a
    ld hl,board
CheckForFullLoop:
    ld a,(hl)
    bit 7,a
    jr nz,SkipSomething
    and 00001111b
    cp 00001111b
    call z,FullSquare
SkipSomething:
    inc hl
    djnz CheckForFullLoop
    call UpdateMenu
    jp EndDrawMode2

FullSquare:
    push bc
    push hl
    set 7,a
    ld (hl),a
    ld bc,textShadow
    ld de,0
    and a
    sbc hl,bc
    ld a,(Width)
    ld c,a
    ld a,l
FullSquareCalc:
    cp c
    jr c,TakeItEasy
    inc d               ;y
    sub c
    jr FullSquareCalc
TakeItEasy:
    inc e           ;x
    dec a
    jr nz,TakeItEasy

    ld b,d
    ld c,e
    inc b
    inc c
    ld de,circle
    ld a,(Player)
    or a
    jr nz,LoadCross
Return:
    call PutSprite
    ld hl,Points
    ld a,(Player)
    ld c,a
    ld b,0
    add hl,bc
    inc (hl)
    ld a,1
    ld (Flag),a
    call NumberOfSquares
    ld b,a
    ld a,(NumOfFS)
    inc a
    ld (NumOfFS),a
    cp b
    jr z,FullBoard
    pop hl
    pop bc
    ret

LoadCross:
    ld de,cross
    jr Return


FullBoard:
    pop hl
    pop hl
    pop hl
    call UpdateMenu
    ;call BlackBar
    call PutPen
    ld a,(Points)
    ld b,a
    ld a,(Points+1)
    cp b
    jr z,ItsADraw
    jr c,FirstWins
SecondWins:
    ld a,(Mode)         ;0.equhuman vs. human 1.equhuman vs. calc
    or a
    jr nz,YouWin
    ld hl,24*256+12     ;;;;;;;;;;;;;;
    ld (pencol),hl      ;;;;;;;;;;;;;;
    ld hl,Win2txt
    jr DisplayWintxt
YouWin:
    ld hl,24*256+30     ;;;;;;;;;;;;;;
    ld (pencol),hl      ;;;;;;;;;;;;;;
    ld hl,YouWintxt
    jr DisplayWintxt
ItsADraw:
    ld hl,24*256+18     ;;;;;;;;;;;;;;
    ld (pencol),hl
    ld hl,Drawtxt
    jr DisplayWintxt
FirstWins:
    ld a,(Mode)
    or a
    jr nz,CalcWin
    ld hl,24*256+12     ;;;;;;;;;;;;;;
    ld (pencol),hl      ;;;;;;;;;;;;;;
    ld hl,Win1txt
    jr DisplayWintxt
CalcWin:
    ld hl,24*256+12     ;;;;;;;;;;;;;;
    ld (pencol),hl      ;;;;;;;;;;;;;;
    ld hl,CalcWintxt

DisplayWintxt:
    set textWrite,(iy+sGrFlags)
    set fracDrawLFont,(iy+fontFlags)
    push hl
    call ClearBar
    pop hl
    call PutvText
    call BlackBar
    res fracDrawLFont,(iy+fontFlags)
    res textWrite,(iy+sGrFlags)

WinLoop:
    call GetCSC
    or a
    jr z,WinLoop
    jp SecondBegin              ;FirstBegin

UpdateMenu:
    set textwrite,(iy+sgrflags)
    ld a,(Flag)
    or a
    jr nz,SkipSwitch
    ld a,(Player)
    xor 1
    ld (Player),a
SkipSwitch:
    xor a
    ld (Flag),a
    ld a,(Player)
    or a
    jr nz,SkipInvert1
    set textInverse,(iy+textflags)
SkipInvert1:
    ld hl,5*256+85
    ld (pencol),hl
    ld hl,Player1txt
    call PutvText
    res textInverse,(iy+textflags)
    ld a,(Player)
    or a
    jr z,SkipInvert2
    set textInverse,(iy+textflags)
SkipInvert2:
    ld bc,36*256+85
    ld (pencol),bc
    ld hl,Player2txt
    call PutvText
    res textInverse,(iy+textflags)
    ld hl,13*256+85
    ld (pencol),hl
    ld a,(Points)
    call DispA
    ld hl,44*256+85
    ld (pencol),hl
    ld a,(Points+1)
    call DispA

    ld de,plotsscreen+(12*57)
    ld hl,Grid
    ld bc,84
    ldir
    ld hl,58*256+5
    ld (pencol),hl
    ld hl,LineTxt
    call PutvText
    ld hl,58*256+79
    ld (pencol),hl
    ld hl,HelpTxt
    call PutvText
    ld hl,58*256+42
    ld (pencol),hl
    ld hl,QuitTxt
    call PutvText

    B_CALL GrBufCpy
    res textwrite,(iy+sgrflags)
    ret

    
DispA:
    B_CALL SetXXOP1
    ld a,2
    B_CALL DispOP1A
    ret

Delay:
    ei
    ld b,050h
DelayLoop:
    halt
    djnz DelayLoop
    ret

PutMarker:
    ld bc,(OldCoords)
    ld de,marker
    inc b
    inc c
    call PutSprite
    ld bc,(Coords)
    ld de,marker
    inc b
    inc c
    call PutSprite
    jp MainLoop

PutPen:
    ld b,3
    ld c,11
    ld de,pen
    jp PutSprite

; de .equ sprite
; b,c .equ y,x

PutSprite:
    push de
    ld hl,plotsscreen-96
    inc b
    ld de,96
PSLoop:
    add hl,de
    djnz PSLoop
    add hl,bc
    pop de
    ld b,8
PSLoop2:
    push bc
    ld bc,12
    ld a,(de)
    xor (hl)
    ld (hl),a
    inc de
    add hl,bc
    pop bc
    djnz PSLoop2
    B_CALL GrBufCpy
    ret


InvertTopRow:
    ld hl,plotsscreen
    ld b,9*12
    ld c,255
ITRLoop:
    ld a,(hl)
    xor c
    ld (hl),a
    inc hl
    djnz ITRLoop
    ret
    
    
    
Difficulty:
    db 1

Player1txt:
    db " P 1",0
Player2txt:
    db " P 2",0

Text:
    db "Dots  v1.0",0

ModeTxt:
    db " Game mode:",0
SizeTxt:
    db "Board size:",0

Human:
    db "Human vs Human",0
TI86:
    db "Human vs Calc      ",0

HeightTxt:
    db " Height:",0
WidthTxt:
    db " Width:",0

Win1txt:
    db "Player 1 wins",0
Win2txt:
    db "Player 2 wins",0
CalcWintxt:
    db "The calc wins",0
YouWintxt:
    db "You win",0
Drawtxt:
    db "It's a draw",0


LineTxt:
    db "Pen",0
    
cross:
    db 00000000b
    db 00100010b
    db 00010100b
    db 00001000b
    db 00010100b
    db 00100010b
    db 00000000b
    db 00000000b


circle:
    db 00000000b
    db 00011100b
    db 00100010b
    db 00100010b
    db 00100010b
    db 00011100b
    db 00000000b
    db 00000000b

marker:
    db 00000000b
    db 00000000b
    db 00011100b
    db 00011100b
    db 00011100b
    db 00000000b
    db 00000000b
    db 00000000b

pen:
    db 00001100b
    db 00010010b
    db 00100001b
    db 01000001b
    db 10000010b
    db 10000100b
    db 11001000b
    db 11110000b

DotsTitlePic:
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00111111b,11000000b,00000000b,00000000b,00000000b
  db 00000111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111000b,00110000b,01110000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000100b,00110000b,00110000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000100b,00110000b,00011000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000111b,00110000b,00011000b,11111001b,11111110b,01111000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00110000b,00011001b,10001100b,00110000b,11000100b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00110000b,00011001b,10001100b,00110000b,11000000b
  db 00000100b,00000111b,00000000b,11100000b,00011100b,00000011b,10000101b,00110000b,00011001b,10001100b,00110000b,11111000b
  db 00011111b,00000111b,11111111b,11100000b,00011100b,00000011b,10000101b,00110000b,00011001b,10001100b,00110000b,01111100b
  db 00111111b,10000111b,00000000b,11100000b,00011100b,00001111b,10000101b,00110000b,00110001b,10001100b,00110000b,00001100b
  db 01111111b,10000010b,00000000b,00000000b,00001000b,00010010b,00000101b,00110000b,01110001b,10001100b,00110000b,10001100b
  db 01111101b,10000010b,00000000b,00000000b,00001000b,01100001b,00000101b,00111111b,11000000b,11111000b,00110000b,01111000b
  db 01111100b,00000010b,00000000b,00000000b,00001000b,10000001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00011100b,00000010b,00000000b,00000000b,00001001b,00000000b,10000101b,00000000b,00000000b,00100000b,00000000b,00000000b
  db 00000100b,00000010b,00000000b,00000000b,00001111b,11000000b,10000101b,00000000b,00000000b,00000000b,00000110b,00001000b
  db 00000100b,00000010b,00000000b,00000000b,00001111b,11000001b,00000101b,00010100b,10010101b,10100100b,11100010b,00010100b
  db 00000100b,00000010b,00000000b,00000000b,00010011b,11100110b,00000101b,00010101b,01011001b,00101010b,10100010b,00010100b
  db 00000100b,00000010b,00000000b,00000000b,00100101b,11101100b,00000101b,00010101b,11010001b,10101010b,10100010b,00010100b
  db 00000100b,00000111b,00000000b,11100000b,11001001b,11110011b,10000101b,00001001b,00010000b,10101010b,10100010b,00010100b
  db 00000100b,00000111b,00000000b,11100001b,00010010b,11100011b,10000101b,00001000b,11010001b,10100100b,10100111b,01001000b
  db 00000100b,00000111b,00000000b,11100010b,01100100b,11000011b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00011111b,00000000b,00000000b,00001100b,10011001b,10000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00111111b,10000000b,00000000b,00010001b,00100010b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 01111111b,10000000b,00000000b,00100010b,01001100b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 01111101b,10000000b,00000000b,01001101b,10011000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 01111100b,00000000b,00000001b,10010010b,00100000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00011100b,00000000b,00000010b,00100100b,11000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000111b,11001001b,10000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00001001b,00110011b,00000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000111b,00010010b,11000100b,00011100b,00000011b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000111b,00100000b,11011111b,11111111b,11111111b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000111b,00100001b,01110000b,00011100b,00000011b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000010b,01000000b,11000000b,00001000b,00000001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000010b,11000001b,10000000b,00001011b,00001101b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00011111b,00000010b,11011110b,00000000b,00001001b,10011001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00111111b,10000011b,11100000b,00000000b,00001000b,11110001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 01111111b,10000011b,00000000b,00000000b,00001000b,01100001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 01111101b,10000000b,00000000b,00000000b,00001000b,11110001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 01111100b,00000000b,00000000b,00000000b,00001001b,10011001b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00011100b,00000000b,00000000b,00000000b,00001011b,00001101b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000111b,00000000b,11100000b,00011100b,00000011b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000111b,11111111b,11100000b,00011111b,11111111b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000111b,00000000b,11100000b,00011100b,00000011b,10000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000100b,00000000b,00000000b,00000000b,00000000b,00000000b,00000101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111101b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000001b,00000000b,00000000b,00000000b,00000000b,00000000b,00000001b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000001b,00000000b,00000000b,00000000b,00000000b,00000000b,00000001b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000001b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000001b,11110000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000010b,01101001b,10001000b,10001000b,01000000b,00100000b,00000000b,00001110b,10000000b,00000000b,00000000b
  db 00000000b,00000010b,10001000b,01010101b,01011000b,10101100b,01101010b,01000110b,11001000b,00110011b,00010000b,00000000b
  db 00000000b,00000010b,10001000b,10010101b,01001000b,11101010b,10101100b,10101010b,10001100b,10101010b,10101000b,00000000b
  db 00000000b,00000010b,01101001b,00010101b,01001000b,10101010b,10101000b,11001010b,01001000b,10101010b,10110000b,00000000b
  db 00000000b,00000001b,11110001b,11001000b,10011100b,10101010b,01101000b,01100110b,11001000b,10101010b,10011000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b





; Tower application starts here ----------------------------------------------------------------------------------------------------------------

TowerStartApp:                 ;The app starts here

Pile1 .equ textShadow        ;Number of bricks, Size of bricks
Pile2 .equ textShadow+11
Pile3 .equ textShadow+22
Temp .equ  textShadow+33            ;Pile XCoord, which brick, which size
PP .equ	textShadow+38			;Picked piece
From .equ textShadow+39
NoM .equ textShadow+40			;Number of moves
Counter .equ textShadow+42
PXCoord .equ textShadow+43
XCoord .equ textShadow+44
YCoord .equ textShadow+45
CMode .equ textShadow+46
Blocks .equ textShadow+47
;Menu .equ textShadow+49
;Menu2 .equ textShadow+50
ScoreStr .equ textShadow+51
Initials .equ textShadow+57


start:
    B_CALL RunIndicOff
    B_CALL ClrLCDFull
    res appTextSave,(iy+appflags)
    res indicOnly,(iy+indicFlags)
    set apdRunning,(iy+apdFlags)
    set textEraseBelow,(iy+textFlags)

    
    ld hl,TowerTitlePic
    ld de,plotsscreen
    ld bc,768
    ldir
    B_CALL GrBufCpy
    call PauseLoop

    res appAutoScroll,(iy+appflags)


    call FindAppVar
    call c,CreateAppVar
    call FindAppVar
    ld a,b
    or a
    call nz,UnarchiveAppVar
 
    xor a
    ld (Menu),a
    ld (CMode),a

    ld hl,textShadow
    ld de,textShadow+1
    ld bc,65
    ld (hl),a
    ldir

    ld a,5
    ld (Blocks),a

Message:
    ld hl,Pile1
    ld de,Pile1+1
    ld bc,43
    ld (hl),0
    ldir
TMenuRoutine:
    B_CALL ClrLCDFull
  	B_CALL GrBufClr
	ld hl,Pic
	ld de,plotsscreen
	ld bc,120
	ldir

	set textwrite,(iy+sgrflags)

    ld hl,Modetxt
    ld bc,11*256+1
    ld (pencol),bc
    call PutvText               ;Game mode

    ld hl,NormalTxt
    ld a,(CMode)
    or a
    jr z,NormalMode
    ld hl,PuzzleTxt
NormalMode:
    ld a,(pencol)
    add a,4
    ld (pencol),a
    call PutvText


    ld hl,NumberTxt
    ld bc,18*256+1
    ld (pencol),bc
    call PutvText               ;board size

    ld a,(pencol)
    add a,4
    ld (pencol),a
    ld a,(Blocks)
    add a,'0'
    B_CALL VPutMap

    ld hl,TowerMenu
    call HandleMenuRoutine

;    B_CALL GrBufCpy

;SecondPressed:
    ld a,(Menu)
    or a
    jp z,StartGame
    dec a
    jp z,TOptions
    dec a
    jp z,HighScores
    dec a
    call z,TowerHelp
    dec a
    jp nz,TMenuRoutine
    jp StartOfMain

TowerHelp:
    ld hl,TowerHelpTxt
    jp Help

TOptions:
  	B_CALL GrBufClr
	ld hl,Pic
	ld de,plotsscreen
	ld bc,120
	ldir

    xor a
    ld (Menu),a

;-------------------------------------------------------------
Options2:
    ld hl,TOptionsMenu
    call DispMenuRoutine
;Write settings
    ld hl,NormalTxt
    ld a,(CMode)
    or a
    jr z,ONormalMode
    ld hl,PuzzleTxt
ONormalMode:
    ld bc,26*256+58
    ld (pencol),bc
    call PutvText

    ld hl,33*256+77
    ld (pencol),hl
    ld a,(Blocks)
    add a,'0'
    B_CALL VPutMap
;------^


    B_CALL GrBufCpy

OptionsKeyLoop:
    call GetCSC
    cp skDown
    jr z,TODownPressed
    cp skLeft
    jr z,TOLeftPressed
    cp skRight
    jr z,TORightPressed
    cp skUp
    jr z,TOUpPressed
    cp skEnter
    jp z,TOEnterPressed
    jr OptionsKeyLoop

TODownPressed:
    ld a,(Menu)
    cp 2
    jr z,OptionsKeyLoop
    inc a
    ld (Menu),a
    jp Options2

TOUpPressed:
    ld a,(Menu)
    or a
    jr z,OptionsKeyLoop
    dec a
    ld (Menu),a
    jp Options2

TOLeftPressed:
    ld a,(Menu)
    or a
    jr z,TChangeMode
    dec a
    jr z,DecBlocks
    jr OptionsKeyLoop

TORightPressed:
    ld a,(Menu)
    or a
    jr z,TChangeMode
    dec a
    jr z,IncBlocks
    jr OptionsKeyLoop

IncBlocks:
    ld a,(Blocks)
    cp 8
    jr z,OptionsKeyLoop
    inc a
    ld (Blocks),a
    jp Options2

TChangeMode:
    ld a,(CMode)
    xor 1
    ld (CMode),a
    jp Options2

DecBlocks:
    ld a,(Blocks)
    cp 3
    jr z,OptionsKeyLoop
    dec a
    ld (Blocks),a
    jp Options2

TOEnterPressed:
    ld a,(Menu)
    or a
    jp z,TChangeMode
    dec a
    jr z,IncBlocks2
;ReturnToMain:
    xor a
    ld (Menu),a
    jp Message


IncBlocks2:
    ld a,(Blocks)
    cp 8
    jr nz,IB2Skip
    ld a,2
IB2Skip:
    inc a
    ld (Blocks),a
    jp Options2

;-------------------------------------------------------------

StartGame:
	ld a,(CMode)
	or a
	jr z,Begin
	jp Puzzle

Begin:
	B_CALL ClrLCDFull
	B_CALL GrBufClr


	ld hl,Pile1
	ld a,(Blocks)
    ld (hl),a
    inc hl
    ld b,a
Loop:
    ld (hl),a
    dec a
    inc hl
    djnz Loop
Loopend:
	ld a,-16
	ld (PXCoord),a
    call DrawFirst
        
Move:
	ld a,-16
	ld (PXCoord),a
	call GetCSC
	;cp skMode
	;jp z,EndRound
    cp skWindow
    call z,TowerHelp
    cp skTrace
    call z,TowerConf
	cp skYEqu
	jr z,FromLeftRoutine
	cp skZoom
	jr z,FromMiddleRoutine
	cp skGraph
	jr nz,Move

FromRightRoutine:
	ld a,2
	ld (From),a
	jr FromRoutine

FromMiddleRoutine:
	ld a,1
	ld (From),a
	jr FromRoutine

FromLeftRoutine:
	ld a,0
	ld (From),a

FromRoutine:

    ld h,6
    ld b,a
    add a,a     ;*2
    add a,a     ;*4
    ld c,a
    add a,a     ;*8
    add a,a     ;*16
    add a,a     ;*32
    add a,14
    ld l,a
    ld (pencol),hl
    
    xor a
    add a,c     ;*4
    add a,a     ;*8
    add a,c     ;*12
    sub b       ;*11

;	ld l,7
;	ld b,a
;	add a,a		;*2
;	add a,a		;*4
;	add a,b		;*5
;	add a,3
;	ld h,a
;	sub 3
;	sub b		;*4
;	ld c,a
;	add a,a		;*8
;	add a,c		;*12
;	sub b		;*11
;	ld (curRow),hl
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
	ld a,7
    res textWrite,(iy+sGrFlags)
    set fracDrawLFont,(iy+fontFlags)
	B_CALL VPutMap
    res fracDrawLFont,(iy+fontFlags)
    set textWrite,(iy+sGrFlags)
	ld c,(hl)
	xor a
	cp c
	jr z,MoveNot
	dec (hl)
	ld b,0
	add hl,bc
	ld a,(hl)
	ld (PP),a
	xor a
	ld (hl),a
	jr To
MoveNot:
	call DrawFirst
	jr Move

To:
	call GetCSC
	;cp skMode
	;jp z,EndRound
    cp skWindow
    call z,TowerHelp
    cp skTrace
    call z,TowerConf
	cp skYEqu
	jr z,ToLeftRoutine
	cp skZoom
	jr z,ToMiddleRoutine
	cp skGraph
	jr nz,To


ToRightRoutine:
	ld a,2
	jr ToRoutine

ToMiddleRoutine:
	ld a,1
	jr ToRoutine

ToLeftRoutine:
	ld a,0

ToRoutine:
	ld b,a
	ld a,(From)
	cp b
	jr z,CouldntMove
	ld a,b
	add a,a		;*2
	add a,a		;*4
	ld c,a
	add a,a		;*8
	add a,c		;*12
	sub b		;*11
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
	ld d,h
	ld e,l
	ld c,(hl)
	xor a
	cp c
	jr nz,NotZ
	inc hl
NotZ:
	ld b,0
	add hl,bc
	ld b,(hl)
	xor a
	cp b
	jr z,Zero
	ld a,(PP)
	cp b
	jr nc,CouldntMove
Zero:
	ld h,d
	ld l,e
	inc (hl)
	ld c,(hl)
	ld b,0
	add hl,bc
	ld a,(PP)
	ld (hl),a
	ld hl,(NoM)
	inc hl
	ld (NoM),hl
	call DrawFirst

CheckDone:
	ld hl,Pile2
	ld a,(Blocks)
	ld b,(hl)
	cp b
	jr z,Done
	ld hl,Pile3
	ld a,(Blocks)
	ld b,(hl)
	cp b
	jr z,Done
	jp Move

CouldntMove:
	ld a,(From)
	ld b,a
	add a,a
	add a,b
	add a,a
	add a,a
	sub b
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
CMRoutine:
	inc (hl)
	ld c,(hl)
	ld b,0
	add hl,bc
	ld a,(PP)
	ld (hl),a
	call DrawFirst
	jp Move

Done:
    ld hl,24*256+20
    ld (pencol),hl
    ld hl,Congrats
    set textWrite,(iy+sGrFlags)
    set fracDrawLFont,(iy+fontFlags)
    push hl
    call ClearBar
    pop hl
    call PutvText
    call BlackBar
    res fracDrawLFont,(iy+fontFlags)

;	ld hl,0001h
;	ld (curRow),hl
;	ld hl,Congrats
;	call PutText
Label:
	call GetCSC
	or a
	jr z,Label
    jp CheckForHi
	;jp Message

TowerConf:
    call Confirm
    ld a,(ConfData)
    cp 1
    jr nz,TowerConfSkip
    xor a
    ret
TowerConfSkip:
    pop hl
    jp EndRound

DrawFirst:
	B_CALL GrBufClr
        ld hl,Pile1-1
DrawPile1:
        ld a,0
        ld (Temp+1),a
        inc hl
        ld b,10
        ld a,(PXCoord)
        add a,32
        ld (PXCoord),a
DrawP1Loop:
        push bc
        ld a,(Temp+1)
        inc a
        ld (Temp+1),a
        inc hl
        ld a,(hl)
        push hl
        call CheckSize
        pop hl
        pop bc
        djnz DrawP1Loop
        ld a,(Counter)
        inc a
        ld (Counter),a
        cp 3
        jr nz,DrawPile1

;Return:
    ld hl,0
    ld (pencol),hl
    ld hl,MovesTxt
    call PutvText

	ld hl,(NoM)
	B_CALL setxxxxop2
	B_CALL op2toop1
	;ld bc,0
	;ld (pencol),bc
	ld a,5
	B_CALL dispop1a
	xor a
	ld (Counter),a
	ld b,4
	ld hl,Temp
RetLoop:
	ld (hl),a
	inc hl
	djnz RetLoop




    ld de,plotsscreen+(12*57)
    ld hl,Grid
    ld bc,84
    ldir
    ld hl,58*256+3
    ld (pencol),hl
    ld hl,OneTxt
    call PutvText
    ld hl,58*256+43
    ld (pencol),hl
    ld hl,TwoTxt
    call PutvText
    ld hl,58*256+78
    ld (pencol),hl
    ld hl,ThreeTxt
    call PutvText

    ld hl,58*256+22
    ld (pencol),hl
    ld hl,HelpTxt
    call PutvText
    ld hl,58*256+61
    ld (pencol),hl
    ld hl,QuitTxt
    call PutvText




	B_CALL GrBufCpy

	ret

CheckSize:
        or a
        jr z,DrawPin

        ld (Temp+2),a
        ld a,(Temp+1)
		add a,a
		add a,a
        ld b,a
        ld a,63
        sub b
        ld (YCoord),a
        call PutItOut
        ret

DrawPin:
        ld a,(PXCoord)
        dec a
        ld (XCoord),a
        ld a,(Temp+1)
		add a,a
		add a,a
        ld b,a
        ld a,63
        sub b
        ld (YCoord),a
        ld a,(YCoord)
        ld b,4
        sub b
        ld d,a
        ld (YCoord),a
        ld c,4
PinYLoop:        
        ld b,2
        ld a,(YCoord)
        dec a
        ld (YCoord),a
        ld a,(XCoord)
        ld e,a

PinXLoop:
        call PutPixel
        inc e
        djnz PinXLoop
        dec c
        jr nz,PinYLoop
        ret
        
PutItOut:
        ld a,(Temp+2)
        add a,a
        ld b,a
        ld a,(PXCoord)
        sub b
        ld e,a
        ld (XCoord),a
        ld a,(YCoord)
        ld b,8
        sub b
        ld d,a
        ld (YCoord),a
        push de
        ld a,(Temp+2)
		add a,a
		add a,a
        ld b,a
        ld c,3
YLoop:
        ld a,(YCoord)
        inc a
        ld (YCoord),a
        ld a,(Temp+2)
		add a,a
		add a,a
        ld b,a
        ld a,(XCoord)
        ld e,a

XLoop:
        call PutPixel
        inc e
        djnz XLoop
        dec c
        jr nz,YLoop
        pop de
        ret

PutPixel:
        push bc
	push de
        ld a,(YCoord)
        ld c,e
	ld e,a
	ld a,c
        call FindPixel
        or (hl)
        ld (hl),a
	pop de
        pop bc
        ret



Puzzle:
	ld a,(Blocks)
	ld b,a
PuzzleLoop:
	push bc
	ld a,3
	call Random
	pop bc
	ld e,a
	add a,a	;*2
	add a,e	;*3
	add a,a	;*6
	add a,a	;*12
	sub e	;*11
	ld e,a
	ld d,0
	ld hl,Pile1
	add hl,de
	inc (hl)
	ld e,(hl)
	add hl,de
	ld (hl),b	
	djnz PuzzleLoop
	jp Loopend

EndRound:
	B_CALL GrBufClr
	jp Message

FindPixel:
	ld	d,00h
	ld	h,d
	ld	l,e
	add	hl,de
	add	hl,de
	add	hl,hl
	add	hl,hl
	ld	de,plotsscreen
	add	hl,de
	ld	b,00h
	ld	c,a
	and	00000111b
	srl	c
	srl	c
	srl	c
	add	hl,bc
	ld	b,a
	inc	b
	ld	a,00000001b
FindPixelLoop:
	rrca
	djnz	FindPixelLoop
	ret

HighScores:
    B_CALL GrBufClr

    ld hl,0
    ld (pencol),hl
    ld hl,ScoreRub
    call PutvText


;------------ Horisontella linjer ---------------

    ld hl,plotsscreen+(7*12)
    ld a,255
    ld b,12
    ld de,plotsscreen+(63*12)
    ld ix,plotsscreen+(15*12)
TopHorzLoop:
    ld (hl),a
    ld (de),a
    ld (ix),a
    inc hl
    inc de
    inc ix
    djnz TopHorzLoop


;------------- Vertikala linjer -----------------

    ld hl,plotsscreen+(8*12)
    ld b,7
    ld c,00001000b
    ld de,5
VertLineLoop:
    ld a,10000000b
    ld (hl),a
    inc hl
    ld (hl),a
    add hl,de
    ld (hl),c
    add hl,de
    ld a,00000001b
    ld (hl),a
    inc hl
    djnz VertLineLoop

    ld hl,plotsscreen+(16*12)
    ld b,47
    ld c,00001000b
    ld de,5
VertLineLoop2:
    ld a,10000000b
    ld (hl),a
    inc hl
    ld (hl),a
    add hl,de
    ld (hl),c
    add hl,de
    ld a,00000001b
    ld (hl),a
    inc hl
    djnz VertLineLoop2



    ld hl,8*256+18
    ld (pencol),hl
    ld hl,NormalTxt
    call PutvText

    ld hl,8*256+63
    ld (pencol),hl
    ld hl,PuzzleTxt
    call PutvText

;    ld hl,plotsscreen+6
;    ld a,00001000b
;    ld de,12
;    ld b,64
;HSL2Loop:
;    ld (hl),a
;    add hl,de
;    djnz HSL2Loop

;    ld hl,plotsscreen
;    ld a,00000001b
;    ld de,12
;    ld b,64
;HSL3Loop:
;    ld (hl),a
;    add hl,de
;    djnz HSL3Loop
    
;    ld hl,plotsscreen+(12*7)
;    ld b,12
;    ld a,255
;HSLLoop:
;    ld (hl),a
;    inc hl
;    djnz HSLLoop

    ld hl,8*256+2
    ld (pencol),hl
    ld a,Lpound
    B_CALL VPutMap


    ld b,8
    ld hl,16*256+3
    ld (pencol),hl
HSL4Loop:
    ld a,b
    add a,'0'
    B_CALL VPutMap
    ld a,(penrow)
    add a,8
    ld (penrow),a
    ld a,3
    ld (pencol),a
    dec b
    ld a,2
    cp b
    jr nz,HSL4Loop


;==========================================================================

    ld hl,16*256+11
    ld (pencol),hl
    call FindAppVar
    inc de
    inc de
    ex de,hl
    ld a,(hl)
    cp 'H'
    jp nz,Quit
    inc hl
    ld a,(hl)
    cp 'A'
    jp nz,Quit
    inc hl
    ld a,(hl)
    cp 'N'
    jp nz,Quit
    inc hl
    ld b,6

DispRealHi:
    call PutvText
    ld a,31
    ld (pencol),a
    push hl
    ld a,(hl)
    inc hl
    ld l,(hl)
    ld h,a
    push bc
    call DispHiScore
    pop bc
    pop hl
    inc hl
    inc hl
    ld a,55
    ld (pencol),a
    call PutvText
    ld a,74
    ld (pencol),a
    push hl
    ld a,(hl)
    inc hl
    ld l,(hl)
    ld h,a
    push bc
    call DispHiScore
    pop bc
    pop hl
    inc hl
    inc hl
    ld a,11
    ld (pencol),a
    ld a,(penrow)
    add a,8
    ld (penrow),a
    djnz DispRealHi
    jp HiScoreDone


    ;ld hl,11*256+30
    ;ld (pencol),hl
    ;ld hl,12345

;==========================================================================

DispHiScore:
    ;ld a,6
    ;ld hl,ScoreStr
    ;ld b,5
;HSL6Loop:
;    ld (hl),a
;    inc hl
;    djnz HSL6Loop
;    xor a
;    ld (hl),a

    ld b,5
    ld de,ScoreStr+4
HSL5Loop:
    B_CALL DivHLBy10
    or a
    call z,CheckExtra
    add a,'0'
    ex de,hl
    ld (hl),a
    dec hl
    ex de,hl
    djnz HSL5Loop

    ld hl,ScoreStr
    call PutvText
    ret

HiScoreDone:

    B_CALL GrBufCpy
HSLoop:
    call GetCSC
    or a
    jr z,HSLoop
    jp Message


CheckExtra:
    push af
    ld a,l
    or h
    jr z,CEReturn
    pop af
    ret
CEReturn:
    pop af
    ld a,0D6h
    ret


    
FindAppVar:
    ld hl,AppVarName
    rst 20h
    B_CALL ChkFindSym
    ret
    
CreateAppVar:
    B_CALL MemChk
    ld de,100
    or a
    sbc hl,de
    jr c,NotEnoughMem
    ld hl,AppVarName
    rst 20h
    ld hl,75
    B_CALL CreateAppVar
    call InitAppVar
    ret

UnarchiveAppVar:
    B_CALL MemChk
    ld de,100
    or a
    sbc hl,de
    jr c,NotEnoughMem
    ld hl,AppVarName
    rst 20h
    B_CALL Arc_Unarc
    ret


NotEnoughMem:
    B_CALL ClrLCDFull
	res textwrite,(iy+sgrflags)
    ld hl,0
    ld (currow),hl
    ld hl,ErrorTxt
    call PutText
ErrorLoop:
    call GetCSC
    or a
    jr z,ErrorLoop
    jp Quit

InitAppVar:
    inc de      ;Skip size bytes
    inc de
    ex de,hl
    ld a,'H'
    ld (hl),a
    inc hl
    ld a,'A'
    ld (hl),a
    inc hl
    ld a,'N'
    ld (hl),a
    inc hl
    ld b,12
    ld a,'.'
    ld c,0
IAVLoop:
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),c
    inc hl
    ld (hl),c
    inc hl
    ld (hl),c
    inc hl
    djnz IAVLoop
    ret


CheckForHi:
    ld hl,96
    ld a,(Blocks)
    ld b,a
    ld de,12
CFHLoop:
    or a
    sbc hl,de
    djnz CFHLoop
    push hl
    call FindAppVar
    ld hl,9
    add hl,de
    pop de
    add hl,de
    ld a,(CMode)
    or a
    jr z,CFHSkip
    ld bc,6
    add hl,bc
CFHSkip:
    push hl
    ld d,(hl)
    inc hl
    ld e,(hl)
    ld a,d
    or e
    jr z,NewHighScore
    ld hl,(NoM)
    B_CALL CpHLDE
    jr c,NewHighScore
    pop hl
    jp Message
    ;ret

NewHighScore:
    call EnterName
    ld hl,(NoM)
    pop de
    push de
    ex de,hl
    ld (hl),d
    inc hl
    ld (hl),e
    pop hl
    dec hl
    dec hl
    dec hl
    dec hl

    ld de,Initials
    ld b,3
NHSLoop:
    ld a,(de)
    ld (hl),a
    inc hl
    inc de
    djnz NHSLoop
    jp HighScores
    ;ret


EnterName:
    ld hl,plotsscreen+((12*11)+2)
    ld de,plotsscreen+((12*51)+2)
    ld ix,plotsscreen+((12*12)+2)
    ld a,01111111b
    ld b,7
ENHorzLoop:
    ld (hl),a
    ld (de),a
    ld (ix),a
    ld (ix+12),a
    ld (ix+24),a
    ld (ix+36),a
    ld (ix+48),a
    ld (ix+60),a
    ld (ix+72),a
    ld a,255
    inc hl
    inc de
    inc ix
    djnz ENHorzLoop
    ld a,11111110b
    ld (hl),a
    ld (de),a
    ld (ix),a
    ld (ix+12),a
    ld (ix+24),a
    ld (ix+36),a
    ld (ix+48),a
    ld (ix+60),a
    ld (ix+72),a

    ld hl,plotsscreen+((12*18)+2)
    ld b,33
    ld de,5
ENVertLoop:
    ld a,01000000b
    ld (hl),a
    xor a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld a,00000010b
    ld (hl),a
    add hl,de
    djnz ENVertLoop

    ld hl,plotsscreen+((12*52)+2)
    xor a
    ld b,8
ENVertLoop2:
    ld (hl),a
    inc hl
    djnz ENVertLoop2

    ld hl,11*256+26
    ld (pencol),hl
    ld hl,ScoreTxt
    set textInverse,(iy+textflags)
    call PutvText
    res textInverse,(iy+textflags)

    ld de,19*256+20
    ld (pencol),de
    call PutvText

    ld de,26*256+20
    ld (pencol),de
    call PutvText

    B_CALL GrBufCpy

    ld hl,Initials
    ld a,Lunderscore
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    xor a
    ld (hl),a
    ld (Pile1),a            ;Vilket av tecknen
    call PutOutInitials

InitKeyLoop:
    call GetCSC
    cp skDel
    jp z,BackUp
    cp skEnter
    jp z,DoneEntering
    cp sk2nd
    jp z,SInitKeyLoop
    cp 0Bh
    jr c,InitKeyLoop
    cp 30h
    jr nc,InitKeyLoop
    sub 0Bh
    ld e,a
    ld d,0
    ld hl,KeyTable
    add hl,de
    ld a,(hl)
    or a
    jr z,InitKeyLoop
    call GotKey
    jr InitKeyLoop


BackUp:
    ld a,(Pile1)
    or a
    jr z,SkipBackDec
    dec a
SkipBackDec:
    ld hl,Initials
    ld e,a
    ld d,0
    add hl,de
    ld (Pile1),a
    ld a,Lunderscore
    ld (hl),a
    call PutOutInitials
    jp InitKeyLoop

DoneEntering:
    ld hl,Initials
    ld b,3
DELoop:
    ld a,(hl)
    cp Lunderscore
    call z,SetBlank
    inc hl
    djnz DELoop
    ret

SetBlank:
    ld a,Lspace
    ld (hl),a
    ret


SInitKeyLoop:
    call GetCSC
    or a
    jr z,SInitKeyLoop
    cp skDel
    jp z,BackUp
    cp skEnter
    jp z,DoneEntering
    cp sk2nd
    jp z,SInitKeyLoop
    cp skMode
    jp z,Quit
    cp 0Bh
    jp c,InitKeyLoop
    cp 30h
    jp nc,InitKeyLoop
    sub 0Bh
    ld e,a
    ld d,0
    ld hl,KeyTable
    add hl,de
    ld a,(hl)
    or a
    jp z,InitKeyLoop
    call GotKey
    jp InitKeyLoop


GotKey:         ;A contains character
    ld b,a
    ld a,(Pile1)
    cp 3
    ret z
    ld e,a
    ld d,0
    ld hl,Initials
    add hl,de
    ld (hl),b
    inc a
    ld (Pile1),a
SkipGotInc:
    call PutOutInitials
    ret


PutOutInitials:
    res textWrite,(iy+sGrFlags)
    set fracDrawLFont,(iy+fontFlags)
    ld hl,38*256+39
    ld (pencol),hl
    ld hl,Initials
    call PutvText
    res fracDrawLFont,(iy+fontFlags)
    set textWrite,(iy+sGrFlags)
    ret



KeyTable:
    db 'W','R','M','H',0,0,0,0,'V','Q','L','G',0,0,'.','Z','U','P','K','F','C',0,Lspace,'Y','T','O','J','E','B',0,0,'X','S','N','I','D','A'


Pic:
  db 11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b
  db 11111000b,00101111b,11111111b,00000111b,11111111b,11111111b,11111111b,11111111b,00111011b,10111111b,11111111b,11011111b
  db 11111110b,11101111b,11111111b,11011111b,11111111b,11111111b,11111111b,11111111b,01111011b,10111111b,11111111b,11111111b
  db 11111110b,11101011b,10011111b,11011110b,01101101b,10110011b,01001001b,11110010b,00111011b,10100011b,01011100b,11011111b
  db 11111110b,11100101b,01101111b,11011101b,10101010b,10101101b,00110110b,11101101b,01111000b,00111101b,00101011b,01011111b
  db 11111110b,11101101b,00001111b,11011101b,10101010b,10100001b,01111011b,11101101b,01111011b,10110001b,01101011b,01011111b
  db 11111110b,11101101b,01111111b,11011101b,10101010b,10101111b,01111101b,11101101b,01111011b,10101101b,01101011b,01011111b
  db 11111110b,11101101b,01101111b,11011101b,10101010b,10101101b,01110110b,11101101b,01111011b,10101101b,01101011b,01011111b
  db 11111110b,11101101b,10011111b,11011110b,01110111b,01110011b,01111001b,11110011b,01111011b,10110001b,01101100b,11011111b
  db 11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b


TowerTitlePic:
  db 00111101b,10000000b,00000111b,10000000b,00000000b,00000000b,00000000b,00000001b,11001101b,10000000b,00000000b,00001100b
  db 00011001b,10000000b,00000011b,00000000b,00000000b,00000000b,00000000b,00000001b,10001101b,10000000b,00000000b,00000000b
  db 00011001b,11110011b,10000011b,00011100b,11010110b,01110011b,10111100b,00111001b,11001101b,10011100b,11111001b,11001100b
  db 00011001b,10110110b,11000011b,00110110b,11010110b,11011011b,10101100b,01101101b,10001101b,10110110b,11011011b,01101100b
  db 00011001b,10110110b,11000011b,00110110b,11010110b,11011011b,00110000b,01101101b,10001111b,10110110b,11011011b,01101100b
  db 00011001b,10110111b,11000011b,00110110b,01110100b,11111011b,00011100b,01101101b,10001101b,10011110b,11011011b,01101100b
  db 00011001b,10110110b,00000011b,00110110b,01110100b,11000011b,00001100b,01101101b,10001101b,10110110b,11011011b,01101100b
  db 00011001b,10110110b,11000011b,00110110b,01101100b,11011011b,00110100b,01101101b,10001101b,10110110b,11011011b,01101100b
  db 00011001b,10110011b,10000011b,00011100b,01101100b,01110011b,00111100b,00111001b,10001101b,10111110b,11011001b,11001100b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000100b,00000000b,01000001b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000010b,10010010b,10110000b,10011000b,11000010b,10000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000010b,10101011b,00100101b,01010100b,01000010b,10000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000010b,10110010b,00010101b,01010100b,01000010b,10000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000001b,00011010b,00110100b,10010100b,11101001b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,11100000b,00000000b,00000000b,00000001b,11000000b,00000000b,00000000b,00011100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000000b,00000000b,10100000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000011b,11111111b,11111111b,11111000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000011b,01000000b,00000001b,01111000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000011b,01010000b,00000000b,10101000b,00000000b,00000001b,01000000b,00000000b,00000000b,00010100b,00000000b,00000000b
  db 00000011b,01000000b,00000010b,10111000b,00000000b,00000001b,01000000b,00000000b,00000011b,11111111b,11100000b,00000000b
  db 00000011b,01010000b,00000001b,01011000b,00000000b,00000001b,01000000b,00000000b,00000011b,00000000b,10100000b,00000000b
  db 00001111b,11111111b,11111111b,11111110b,00000000b,00000001b,01000000b,00000000b,00000010b,10000000b,11100000b,00000000b
  db 00001110b,10000000b,00000000b,01011110b,00000000b,00000001b,01000000b,00000000b,00000011b,00000001b,01100000b,00000000b
  db 00001101b,01000000b,00000001b,01010110b,00000000b,00001111b,11111000b,00000000b,00001111b,11111111b,11111000b,00000000b
  db 00001110b,10100000b,00000000b,10101110b,00000000b,00001100b,00101000b,00000000b,00001100b,00000000b,00101000b,00000000b
  db 00001101b,01000000b,00000001b,00110110b,00000000b,00001100b,00011000b,00000000b,00001101b,00000000b,10111000b,00000000b
  db 00111111b,11111111b,11111111b,11111111b,10000000b,00001000b,00111000b,00000000b,00001101b,00000000b,01011000b,00000000b
  db 00111010b,00000000b,00000000b,00101011b,10000000b,00111111b,11111110b,00000000b,00111111b,11111111b,11111110b,00000000b
  db 00111011b,01000000b,00000000b,10101111b,10000000b,00110000b,00001110b,00000000b,00110100b,00000000b,00101110b,00000000b
  db 00110101b,00100000b,00000000b,01010101b,10000000b,00110100b,00010110b,00000000b,00110100b,00000000b,01010110b,00000000b
  db 00111101b,00000000b,00000001b,00101111b,10000000b,00110000b,00001110b,00000000b,00110101b,00000000b,00101010b,00000000b
  db 01111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111110b
  db 01000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000010b
  db 01000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000010b
  db 01000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000010b
  db 01111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111110b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000011b,11100000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
  db 00000000b,00000100b,11010011b,00010001b,00010000b,10000000b,01000000b,00000000b,00011101b,00000000b,00000000b,00000000b
  db 00000000b,00000101b,00010000b,10101010b,10110001b,01011000b,11010100b,10001101b,10010000b,01100110b,00100000b,00000000b
  db 00000000b,00000101b,00010001b,00101010b,10010001b,11010101b,01011001b,01010101b,00011001b,01010101b,01010000b,00000000b
  db 00000000b,00000100b,11010010b,00101010b,10010001b,01010101b,01010001b,10010100b,10010001b,01010101b,01100000b,00000000b
  db 00000000b,00000011b,11100011b,10010001b,00111001b,01010100b,11010000b,11001101b,10010001b,01010101b,00110000b,00000000b


NormalTxt:	db "Normal",0
PuzzleTxt:	db "Puzzle",0

MovesTxt:   db "Number of moves: ",0

OneTxt:     db "Left",0
TwoTxt:     db "Mid",0
ThreeTxt:   db "Right",0

AppVarName:
    db AppVarObj,"finnpack",0

ErrorTxt:
    db "You need least  100 bytes free  to run this app",0

NumberTxt:
    db " Number of blocks:",0
Modetxt:
    db " Game mode:",0

Congrats:	db "Well Done!",0


ScoreRub:
    db "TOWERS OF HANOI  SCORES",0

ScoreTxt:
    db "New top score",0

ScoreTxt1:
    db "Please enter",0
ScoreTxt2:
    db "your initials",0


; Common routines ------------------------------------------------------------------------------------------------------------------------------

PauseLoop:
    call GetCSC
    or a
    jr z,PauseLoop
    ret

;---------------------------
; HandleMenuRoutine
;
; Input: hl = Pointer to Menu
;---------------------------
HandleMenuRoutine:
    ld (CurrentMenu),hl
PreHMRLoop:
    ld hl,(CurrentMenu)
    call DispMenuRoutine
HMRLoop:
    call GetCSC
    cp skDown
    jr z,ChangeMenuDown
    cp skUp
    jr z,ChangeMenuUp
    cp skEnter
    ret z
    jr HMRLoop

ChangeMenuDown:
    ld a,(Menu)
    inc a
    ld b,a
    ld a,(MenuMax)
    cp b
    jr z,HMRLoop
    ld a,b
    ld (Menu),a
    jr PreHMRLoop

ChangeMenuUp:
    ld a,(Menu)
    or a
    jr z,HMRLoop
    dec a
    ld (Menu),a
    jr PreHMRLoop

; --------------------------
; DispMenuRoutine
;
; Input: hl = Pointer to Menu
; --------------------------
DispMenuRoutine:
    ld a,(hl)
    ld (MenuMax),a
    ld b,0
    inc hl
DMRLoop:
    ld e,(hl)
    inc hl
    ld d,(hl)
    inc hl
    ld (pencol),de

    ld a,(hl)
	inc hl
	push hl
	ld h,(hl)
	ld l,a

    ld a,(Menu)
    cp b
    jr nz,DMRLSkip
    set textInverse,(iy+textflags)
DMRLSkip:
    call PutvText
    res textInverse,(iy+textflags)
    pop hl
    inc hl
    inc b
    ld a,(MenuMax)
    cp b
    jr nz,DMRLoop
    B_CALL GrBufCpy
    ret

Quit:
rstrYOffset:
    res grfSplitOverride,(iy+sGrFlags)
    ld de,YOffset
    ld hl,savevals
    ld bc,5
    ldir
    ld a,(hl)
    ld (iy+sGrFlags),a

    B_CALL ClrScrnFull
    ld hl,plotsscreen
    ld de,plotsscreen+1
    ld bc,767
    ld (hl),0
    ldir
    set appTextSave,(iy+appflags)
    set graphDraw,(iy+graphFlags)
    res textEraseBelow,(iy+textFlags)
    set appAutoScroll,(iy+appflags)
    B_JUMP JForceCmdNoChar

GetCSC:
    di
    ld a,(kbdScanCode)
    ld b,a
    xor a
    ld (kbdScanCode),a
    res kbdSCR,(iy+kbdFlags)
    ld a,b
    or a
    jr z,GCSCSkip
    B_CALL ApdSetup
    cp skMode
    jr nz,GCSCSkipF
    ld a,(SecondFlag)
    or a
    jp nz,Quit
GCSCSkipF:
    ld a,b
    cp sk2nd
    jr nz,GCSCSkip
    ld a,(SecondFlag)
    xor 1
    ld (SecondFlag),a
    ld a,b
GCSCSkip:
    ei
    ret

BlackBar:
    ld hl,plotsscreen+(12*23)
    ld c,255
    ld b,120
BBLoop:
    ld a,(hl)
    xor c
    ld (hl),a
    inc hl
    djnz BBLoop
    B_CALL GrBufCpy
    ret

ClearBar:
    ld hl,plotsscreen+(12*23)
    xor a
    ld b,120
CBLoop:
    ld (hl),a
    inc hl
    djnz CBLoop
    ret

PutvText:
    push af
    push de
    push ix
vLabel10:
    ld a,(hl)
    inc hl
    or a
    jr z,vLabel20
    B_CALL VPutMap
    jr nc,vLabel10
vLabel20:
    pop ix
    pop de
    pop af
    ret

PutText:
    push af
    push de
    push ix
Label10:
    ld a,(hl)
    inc hl
    or a
    jr z,Label20
    B_CALL PutC
    jr nc,Label10
Label20:
    pop ix
    pop de
    pop af
    ret

Random:                ; Creates a random number 0 <= x < A
    ld b,a
    ld a,r
    add a,a
    ld hl,0
    ld d,0
    ld e,a
RMul:
    add hl,de
    djnz RMul
    ld a,h
    ret


Help:
    push af
    ld a,(iy+sgrflags)
    push af
    ld (HelpText),hl
    ld hl,appBackUpScreen
    B_CALL SaveDisp         ;Disables interrupts
    ei

    xor a
    ld (HelpValue),a

HelpStart:
    ld hl,(HelpText)
    call DrawHelpScreen  

HelpLine:
    ld bc,11*256+3      ;HL points to start of text
    ld (pencol),bc
    ld a,(HelpValue)
    or a
    jr z,HelpBeginning
    ld b,a
HelpLineLoop:
    ld a,(hl)
    inc hl
    or a
    jr nz,HelpLineLoop
    djnz HelpLineLoop

HelpBeginning:
    ld b,7
DispHelpLoop:
    call PutvText
    ld a,(penrow)
    add a,6
    ld (penrow),a
    ld a,3
    ld (pencol),a
    djnz DispHelpLoop
    
    B_CALL GrBufCpy    

HelpKeyLoop:
    call GetCSC
    cp skDown
    jp z,HelpDown
    cp skUp
    jp z,HelpUp
    cp skEnter
    jp z,ExitHelp
    jr HelpKeyLoop
    
HelpUp:
    ld a,(HelpValue)
    or a
    jr z,HelpKeyLoop
    dec a
    ld (HelpValue),a
    jp HelpStart

HelpDown:
    ld a,(HelpLines)
    ld b,a
    ld a,(HelpValue)
    cp b
    jr nc,HelpKeyLoop
    inc a
    ld (HelpValue),a
    jp HelpStart

ExitHelp:
    pop af
    ld (iy+sGrFlags),a
    ld hl,appBackUpScreen
    ld b,64
    B_CALL RestoreDisp      ;Disables interrrupts
    ld hl,plotsscreen
    B_CALL SaveDisp         ;Disables interrupts
    ei
    pop af
    ret

DrawHelpScreen:
    push hl
    ld hl,plotsscreen
    ld de,plotsscreen+1
    ld bc,767
    ld (hl),0
    ldir

    set textWrite,(iy+sGrFlags)
    ld hl,0
    ld (pencol),hl
    pop hl
    call PutvText           ;Headline
    ld a,(hl)
    ld (HelpLines),a
    inc hl
    push hl
    ld hl,57*256+42
    ld (pencol),hl
    ld hl,EnterReturn
    call PutvText

    ld hl,plotsscreen+(12*8)
    ld de,10
    ld a,00000001b
    ld c,10000000b
    ld b,48
VLineLoop:
    ld (hl),c
    add hl,de
    ld (hl),a
    inc hl
    ld (hl),a
    inc hl
    djnz VLineLoop
    
    set fullScrnDraw,(iy+apiflg4)
    set fracDrawLFont,(iy+fontFlags)
    ld a,LsqUp
    ld hl,9*256+89
    ld (pencol),hl
    B_CALL VPutMap

    ld a,LsqDown
    ld hl,48*256+89
    ld (pencol),hl
    B_CALL VPutMap

    res fracDrawLFont,(iy+fontFlags)
    res fullScrnDraw,(iy+apiflg4)

    ld hl,plotsscreen+(12*7)
    ld de,plotsscreen+(12*56)
    ld b,12
    ld a,255
HLineLoop:
    ld (hl),a
    ld (de),a
    inc hl
    inc de
    djnz HLineLoop

    ld hl,plotsscreen+(12*15)+11
    ld a,255
    ld (hl),a
    ld hl,plotsscreen+(12*48)+11
    ld (hl),a

    ld hl,16*256+90
    ld (pencol),hl
    ld a,(HelpValue)        ;25 positions
    ld l,a
    ld h,25
    B_CALL HTimesL
    ld a,(HelpLines)
    B_CALL DivHLByA
    ld b,l
    ld a,(penrow)
    add a,b
    ld (penrow),a
    ld a,127
    B_CALL VPutMap
    pop hl
    ret


Confirm:
    xor a
    ld (ConfData),a
    ld hl,appBackUpScreen
    B_CALL SaveDisp         ;Disables interrupts
    ei

    set textWrite,(iy+sGrFlags)
    ld hl,plotsscreen+((15*12)+3)
    ld de,6
    ld c,24
    xor a
ConfClear:
    ld b,6
ConfClearL:
    ld (hl),a
    inc hl
    djnz ConfClearL
    add hl,de
    dec c
    jr nz,ConfClear
    ld hl,plotsscreen+((14*12)+3)
    ld de,plotsscreen+((39*12)+3)
    ld b,6
    ld a,255
ConfHorz:
    ld (hl),a
    ld (de),a
    inc hl
    inc de
    djnz ConfHorz
    ld hl,plotsscreen+((14*12)+3)
    ld de,6
    ld b,52
ConfVert:
    ld a,10000000b
    or (hl)
    ld (hl),a
    add hl,de
    djnz ConfVert

    ld hl,16*256+27
    ld (pencol),hl
    ld hl,ConfTxt
    call PutvText
    ld de,23*256+27
    ld (pencol),de
    call PutvText

ConfYesNo:
    ld a,(ConfData)
    or a
    jr nz,ConfSkip1
    set textInverse,(iy+textflags)
ConfSkip1:
    ld hl,31*256+31
    ld (pencol),hl
    ld hl,YesTxt
    call PutvText
    res textInverse,(iy+textflags)
    ld a,(ConfData)
    or a
    jr z,ConfSkip2
    set textInverse,(iy+textflags)
ConfSkip2:
    ld de,31*256+56
    ld (pencol),de
    call PutvText
    res textInverse,(iy+textflags)
    B_CALL GrBufCpy

ConfKeyLoop:
    call GetCSC
    cp skLeft
    jr z,ConfSetYes
    cp skRight
    jr z,ConfSetNo
    cp skEnter
    jr z,ConfChosen
    jr ConfKeyLoop

ConfSetYes:
    xor a
    ld (ConfData),a
    jr ConfYesNo

ConfSetNo:
    ld a,1
    ld (ConfData),a
    jr ConfYesNo

ConfChosen:
    ld hl,appBackUpScreen
    ld b,64
    B_CALL RestoreDisp      ;Disables interrrupts
    ld hl,plotsscreen
    B_CALL SaveDisp         ;Disables interrupts
    ei
    ret

; New Data stuff -------------------------------------------------------------------------------------------------------------------------------

DotsMenu:
 db 4
 dw 30*256+37
 dw StartTxt
 dw 37*256+33
 dw OptionsTxt
 dw 44*256+39
 dw MHelpTxt
 dw 51*256+39
 dw MQuitTxt

TowerMenu:
 db 5
 dw 27*256+37
 dw StartTxt
 dw 34*256+33
 dw OptionsTxt
 dw 41*256+28
 dw MHiTxt
 dw 48*256+39
 dw MHelpTxt
 dw 55*256+39
 dw MQuitTxt

DOptionsMenu:
 db 4
 dw 21*256+0
 dw ModeTxt
 dw 28*256+16
 dw HeightTxt
 dw 35*256+20
 dw WidthTxt
 dw 42*256+31
 dw MainTxt
TOptionsMenu:
 db 3
 dw 26*256+14
 dw ModeTxt
 dw 33*256+14
 dw NumberTxt
 dw 43*256+31
 dw MainTxt

DotsHelpTxt:
    db "DOTS  HELP",0       ;Headline
    db 43                   ;Info of number of lines

    db "INTRODUCTION:",0
    db " ",0
    db "In Dots you have a screen",0
    db "filled with dots. Take",0
    db "turns with your opponent",0
    db "connecting adjacent",0
    db "dots. Your opponent can",0

    db "be the calculator or",0
    db "another person. The",0
    db "object of the game is to",0
    db "complete the fourth side",0
    db "of as many squares as",0
    db "possible. After a square is",0
    db "completed the same",0

    db "player must continue",0
    db "connecting dots until a",0
    db "square is not completed.",0
    db "The game is over when all",0
    db "of the squares have been",0
    db "completed. The winner is",0
    db "the player who has",0

    db "completed the most",0
    db "squares.",0
    db " ",0
    db "CONTROLS:",0
    db " ",0
    db "Main menu:",0
    db 6,6,"UP/DOWN",6,"Move sel. bar",0

    db 6,6,"ENTER",6,"Confirm",0
    db " ",0
    db "Options menu:",0
    db 6,6,"UP/DOWN",6,"Move sel. bar",0
    db 6,6,"LEFT/RIGHT",6,"Change",0
    db 6,6,"ENTER",6,"Change/Conf.",0
    db " ",0

    db "In game:",0
    db 6,6,"Arrows",6,"Move",0
    db 6,6,"Y=",6,"Enter draw mode",0
    db 6,6,"ZOOM",6,"To menu",0
    db 6,6,"GRAPH",6,"Help",0
    db " ",0
    db "In draw mode:",0

    db 6,6,"Arrows",6,"Draw line",0
    db 6,6,"Y=",6,"Exit draw mode",0
    db " ",0
    db "Any time:",0
    db 6,6,"2nd QUIT",6,"Homescreen",0
    db " ",0
    db "(c)2001 Andreas Finne",0
    db "andreas@calc.org",0    

TowerHelpTxt:
    db "TOWERS OF HANOI  HELP",0
    db 48

    db "INTRODUCTION:",0
    db " ",0
    db "The object of the game is",0
    db "to move all the pieces",0
    db "from one pin to another.",0
    db "The problem is that you",0
    db "can only move one piece",0

    db "at a time, and you are",0
    db "only allowed to put a",0
    db "smaller piece on a larger",0
    db "one, never a larger one",0
    db "onto a smaller one. When",0
    db "all the pieces have been",0
    db "moved to another pin, the",0

    db "puzzle is completed.",0
    db "The minimum number of",0
    db "moves needed to finish",0
    db "the puzzle can be",0
    db "calculated using the",0
    db "formula 2^n - 1, where n",0
    db "is the number of pieces.",0

    db " ",0
    db "PUZZLE MODE:",0
    db " ",0
    db "The difference from",0
    db "normal mode is that your",0
    db "calculator has tried to",0
    db "solve the puzzle, but it",0
    db "has given up. Your task is",0
    db "to complete the puzzle",0
    db "for it.",0
    db " ",0
    db "CONTROLS:",0
    db " ",0
    db "Main menu:",0
    db 6,6,"UP/DOWN",6,"Move sel. bar",0

    db 6,6,"ENTER",6,"Confirm",0
    db " ",0
    db "Options menu:",0
    db 6,6,"UP/DOWN",6,"Move sel. bar",0
    db 6,6,"LEFT/RIGHT",6,"Change",0
    db 6,6,"ENTER",6,"Change/Conf.",0
    db " ",0

    db "In game:",0
    db 6,6,"Y=",6,"First pin",0
    db 6,6,"ZOOM",6,"Second pin",0
    db 6,6,"GRAPH",6,"Third pin",0
    db 6,6,"WINDOW",6,"Help",0
    db 6,6,"TRACE",6,"To menu",0
    db " ",0
    db "Any time:",0
    db 6,6,"2nd QUIT",6,"Homescreen",0
    db " ",0
    db "(c)2001 Andreas Finne",0
    db "andreas@calc.org",0    

; Common data stuff ----------------------------------------------------------------------------------------------------------------------------

StartTxt:
    db " START",0
OptionsTxt:
    db " OPTIONS",0
MHiTxt:
    db " TOP SCORES",0
MHelpTxt:
    db " HELP",0
MQuitTxt:
    db " QUIT",0

MainTxt:
    db " Main menu",0

HelpTxt:
    db "Help",0
QuitTxt:
    db "Quit",0

EnterReturn:
    db "ENTER exits help",0

ConfTxt:
    db "Do you really",0
    db "want to quit?",0

YesTxt:
    db " yes",0
NoTxt:
    db " no",0

Grid:
  db 11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b,11111111b
  db 10000000b,00000000b,00010000b,00000000b,00000010b,00000000b,00000000b,01000000b,00000000b,00001000b,00000000b,00000001b
  db 10000000b,00000000b,00010000b,00000000b,00000010b,00000000b,00000000b,01000000b,00000000b,00001000b,00000000b,00000001b
  db 10000000b,00000000b,00010000b,00000000b,00000010b,00000000b,00000000b,01000000b,00000000b,00001000b,00000000b,00000001b
  db 10000000b,00000000b,00010000b,00000000b,00000010b,00000000b,00000000b,01000000b,00000000b,00001000b,00000000b,00000001b
  db 10000000b,00000000b,00010000b,00000000b,00000010b,00000000b,00000000b,01000000b,00000000b,00001000b,00000000b,00000001b
  db 10000000b,00000000b,00010000b,00000000b,00000010b,00000000b,00000000b,01000000b,00000000b,00001000b,00000000b,00000001b

TitlePic:
 db 00011111b,11110011b,11000000b,00000000b,00000000b,01111111b,10000000b,00000000b,00000000b,00111100b,00000000b,00000000b
 db 00010000b,00010010b,01000000b,00000000b,00000000b,01000000b,01000000b,00000000b,00000000b,00100100b,00000000b,00000000b
 db 00010011b,11110011b,11000000b,00000000b,00000000b,01001111b,00100000b,00000000b,00000000b,00100100b,00000000b,00000000b
 db 00010010b,00000011b,11011111b,11100011b,11111100b,01001001b,00100011b,11110000b,01111110b,00100100b,11111000b,00000000b
 db 00010010b,00000010b,01010000b,00010010b,00000010b,01001001b,00100100b,00001000b,11000001b,00100101b,00010000b,00000000b
 db 00010011b,11100010b,01010011b,11001010b,01111001b,01001111b,00101100b,11100101b,10011101b,00100110b,00100000b,00000000b
 db 00010000b,00100010b,01010010b,01001010b,01001001b,01000000b,01000111b,01100101b,00100111b,10100100b,01000000b,00000000b
 db 00010011b,11100010b,01010010b,01001010b,01001001b,01001111b,10000011b,10000101b,00100000b,00100000b,01000000b,00000000b
 db 00010010b,00000010b,01010010b,01001010b,01001001b,01001000b,00000100b,01100101b,00100000b,00100010b,00100001b,00001000b
 db 00010010b,00000010b,01010010b,01001010b,01001001b,01001000b,00001001b,10100101b,00100111b,10100101b,00100011b,00010100b
 db 00010010b,00000010b,01010010b,01001010b,01001001b,01001000b,00001001b,11000101b,10011000b,10100101b,00010001b,00010100b
 db 00010010b,00000010b,01010010b,01001010b,01001001b,01001000b,00000100b,00100100b,11000001b,00100100b,10010001b,00010100b
 db 00011110b,00000011b,11011110b,01111011b,11001111b,01111000b,00000011b,11011100b,00111110b,00111100b,01111011b,10101000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000001b,11111111b,11111111b,11111111b,11111000b,00000000b,00000000b,00000000b,00000001b,11000000b,00000000b,00000000b
 db 00000001b,00000000b,00000000b,00000000b,00001000b,00000000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b
 db 00000001b,00000000b,00000000b,00000000b,00001110b,00000000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b
 db 00000001b,00000000b,00000000b,00000000b,00001010b,00000000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b
 db 00000001b,00000000b,00000000b,00000000b,00001010b,00000000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b
 db 00000011b,10000011b,10000111b,00001110b,00001010b,00000000b,00000000b,00000000b,00000001b,01000000b,00000000b,00000000b
 db 00000111b,11000011b,11111111b,00001110b,00001010b,00000000b,00000000b,00000000b,00001111b,11111000b,00000000b,00000000b
 db 00000111b,01000011b,10000111b,00001110b,00001010b,00000000b,00000000b,00000000b,00001100b,00101000b,00000000b,00000000b
 db 00000001b,00000001b,00110010b,00000000b,00001010b,00000000b,00000000b,00000000b,00001100b,00011000b,00000000b,00000000b
 db 00000001b,00000001b,01001010b,00000000b,00001010b,00000000b,00000000b,00000000b,00001000b,00111000b,00000000b,00000000b
 db 00000001b,00000001b,01001010b,00000000b,00001010b,00000000b,00000000b,00000000b,00111111b,11111110b,00000000b,00000000b
 db 00000001b,00000001b,00110010b,00000000b,00001010b,00000000b,00000000b,00000000b,00110000b,00001010b,00000000b,00000000b
 db 00000011b,10000011b,10000111b,00001110b,00001010b,00000000b,00000000b,00000000b,00101000b,00001110b,00000000b,00000000b
 db 00000111b,11000011b,11111111b,00001110b,00001010b,00000000b,00000000b,00000000b,00110000b,00010110b,00000000b,00000000b
 db 00000111b,01000011b,10000111b,00001110b,00001010b,00000000b,00000000b,00000000b,11111111b,11111111b,10000000b,00000000b
 db 00000001b,00000000b,00000000b,00000100b,00001010b,00000000b,00000000b,00000000b,11000000b,00000010b,10000000b,00000000b
 db 00000001b,00000000b,00000000b,00000100b,00001010b,00000000b,00000000b,00000000b,11010000b,00001011b,10000000b,00000000b
 db 00000001b,00000000b,00000000b,00000100b,00001010b,00000000b,00000000b,00000000b,11010000b,00000101b,10000000b,00000000b
 db 00000001b,00000000b,00000000b,00000100b,00001010b,00000000b,00000000b,00000011b,11111111b,11111111b,11100000b,00000000b
 db 00000011b,10000011b,10000111b,00001110b,00001010b,00000000b,00000000b,00000011b,01000000b,00000010b,11100000b,00000000b
 db 00000111b,11000011b,11111111b,00001110b,00001010b,00000000b,00000000b,00000011b,01000000b,00000101b,01100000b,00000000b
 db 00000111b,01000011b,10000111b,00001110b,00001010b,00000000b,00000000b,00000011b,01010000b,00000010b,10100000b,00000000b
 db 00000001b,00000000b,00000000b,00000000b,00001010b,00000000b,00000001b,11111111b,11111111b,11111111b,11111111b,11100000b
 db 00000001b,00000000b,00000000b,00000000b,00001010b,00000000b,00000001b,00000000b,00000000b,00000000b,00000000b,00100000b
 db 00000001b,00000000b,00000000b,00000000b,00001010b,00000000b,00000001b,00000000b,00000000b,00000000b,00000000b,00100000b
 db 00000001b,00000000b,00000000b,00000000b,00001010b,00000000b,00000001b,00000000b,00000000b,00000000b,00000000b,00100000b
 db 00000001b,11111111b,11111111b,11111111b,11111010b,00000000b,00000001b,11111111b,11111111b,11111111b,11111111b,11100000b
 db 00000000b,01000000b,00000000b,00000000b,00000010b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,01111111b,11111111b,11111111b,11111110b,00000000b,00000011b,10100000b,00011100b,00000000b,00000000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000001b,00110001b,00001000b,10010001b,00100101b,01100000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000001b,00101010b,10001001b,01010101b,01010110b,01000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000001b,00101011b,00001001b,01010101b,01100100b,00100000b
 db 00000000b,00000000b,11000000b,10000000b,00000000b,00000000b,00000001b,00101001b,10001000b,10001010b,00110100b,01100000b
 db 00000000b,00000000b,10100100b,11011000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00000000b,10101010b,10010000b,00000000b,00000000b,00000000b,00000000b,01001010b,00000000b,00001000b,00000000b
 db 00000000b,00000000b,10101010b,10001000b,00000000b,00000000b,00000000b,00000100b,10001010b,01101100b,01000000b,00000000b
 db 00000000b,00000000b,11000100b,01011000b,00000000b,00000000b,00000000b,00001010b,11001110b,10101010b,10101000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00001010b,10001010b,10101010b,10101000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000100b,10001010b,01101010b,01001000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00000111b,11000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
 db 00000000b,00001001b,10100110b,00100010b,01100001b,00000000b,10000000b,00000000b,00111010b,00000000b,00000000b,00000000b
 db 00000000b,00001010b,00100001b,01010101b,00010010b,10110001b,10101001b,00011011b,00100000b,11001100b,01000000b,00000000b
 db 00000000b,00001010b,00100010b,01010101b,00100011b,10101010b,10110010b,10101010b,00110010b,10101010b,10100000b,00000000b
 db 00000000b,00001001b,10100100b,01010101b,01000010b,10101010b,10100011b,00101001b,00100010b,10101010b,11000000b,00000000b
 db 00000000b,00000111b,11000111b,00100010b,01110010b,10101001b,10100001b,10011011b,00100010b,10101010b,01100000b,00000000b

.end
