;##################################################################
;
;   P H O E N I X         F O R        T I - 8 3 / +      ( I o n )
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated June 22, 2002.
;
;##################################################################     

#define __TI83__

#include "ion.inc"
#include "keys.i"

#define TEXT_MEM saferam2+200

#define ROM_CALL(kewl_routinez) bcall(kewl_routinez)

#ifdef TI83P
        .org    progstart-2
        .db     $BB,$6D

interrupt_entry =$9898
interrupt_byte  =$98
interrupt_table =$9900
interrupt_reg   =$99
backup_storage  =$9A01

#else
        .org    progstart

interrupt_entry =$8282
interrupt_byte  =$82
interrupt_table =$8300
interrupt_reg   =$83
backup_storage  =$8401

#endif

GFX_AREA        =plotsscreen

    ret
    jr  nc,start

D_ZT_STR        =_puts
D_HL_DECI       =_disphl
TX_CHARPUT      =_putc
CLEARLCD        =_clrlcdf
CURSOR_ROW      =currow
CURSOR_COL      =curcol

#include "phoenixz.i"

        .db     "Phoenix X",0

start:
        ld      de,backup_storage       ; Save data after GRAPH_MEM
        ld      hl,GFX_AREA+768
        ld      bc,256
        ldir
        call    main
        ld      (iy+13),6
restore_memory:
        ld      hl,backup_storage      ; Restore data after GRAPH_MEM
        ld      de,GFX_AREA+768
        ld      bc,256
        ldir
        ret

GET_KEY:
        bcall(_getcsc)
        ret

;############## Include remainder of game files

#include "main12.asm"
#include "extlev12.asm"
#include "exchange.asm"
#include "lib12.asm"
#include "lib.asm"
#include "new12.asm"
#include "disp12.asm"
#include "drwspr.asm"
#include "player12.asm"
#include "shoot.asm"
#include "bullets.asm"
#include "enemies.asm"
#include "init.asm"
#include "enemyhit.asm"
#include "collide.asm"
#include "ebullets.asm"
#include "hityou.asm"
#include "shop12.asm"
#include "helper.asm"
#include "eshoot.asm"
#include "score12.asm"
#include "emove.asm"
#include "images.asm"
#include "data.asm"
#include "levels.asm"
#include "storage.asm"

        .end
