.nolist
#include "ion.inc"

;-----------= Variables =-----------
spd     =sram       ;1 byte  - speed of the balls
pos     =spd+1      ;1 byte  - pos of the guy (1=left, 2=mid, 3=right)
score   =pos+1      ;2 bytes - current score
high    =score+2    ;2 bytes - high score
time1   =high+2     ;1 byte  - timer for ball 1
time2   =time1+1    ;1 byte  - timer for ball 2
time3   =time2+1    ;1 byte  - timer for ball 3
pos1    =time3+1    ;1 byte  - pos of ball 1
pos2    =pos1+1     ;1 byte  - pos of ball 2
pos3    =pos2+1     ;1 byte  - pos of ball 3
dir1    =pos3+1     ;1 byte  - dir of ball 1
dir2    =dir1+1     ;1 byte  - dir of ball 2
dir3    =dir2+1     ;1 byte  - dir of ball 3
timer   =dir3+1     ;1 byte  - timer for each increment of the other 3 timers
ball1   =timer+1    ;1 byte  - check if caught ball 1
ball2   =ball1+1    ;1 byte  - check if caught ball 2
ball3   =ball2+1    ;1 byte  - check if caught ball 3
ct      =ball3+1    ;1 byte  - counter
dif     =ct+1       ;2 bytes - difficulty
spdscore =dif+2     ;2 bytes - a score which always counts by 1 for speed increases

.list
#ifdef TI83P
        .org    progstart-2
        .db     $BB,$6D
#else
        .org    progstart
#endif

;-----------= Beginning of ASM code =-----------
        ret
        jr      nc,progbegin
        .db     "Ball  v1.1",0
progbegin:
        ld      hl,(highsc)
        ld      (high),hl
        ld      hl,2
        ld      (dif),hl
main_menu:
        bcall(_clrlcdf)
        bcall(_cleargbuf)
        bcall(_homeup)
        ld      hl,txt_main
        call    draw_inv
        bcall(_newline)
        ld      hl,txt_play
        bcall(_puts)
        bcall(_newline)
        ld      hl,txt_quit
        bcall(_puts)
        bcall(_newline)
        ld      hl,txt_mode
        bcall(_puts)
        bcall(_newline)
        bcall(_newline)
        ld      hl,txt_high
        bcall(_puts)
        ld      hl,(high)
        bcall(_disphl)
        call    getname
        bcall(_newline)
        ld      hl,txt_name
        bcall(_puts)
mode_set:
        ld      hl,0804h
        ld      (currow),hl
        ld      hl,(dif)
        ld      a,l
        cp      1
        jr      z,mode_easy
        cp      2
        jr      z,mode_norm
        jr      mode_hard
main_wait:
        bcall(_getk)
        cp      55
        jr      z,mode_ch
        cp      9
        jr      z,play
        cp      15
        jp      z,quit
        jr      main_wait
mode_ch:
        ld      hl,0004h
        ld      (currow),hl
        ld      hl,txt_mode
        bcall(_puts)
        ld      hl,(dif)
        ld      a,l
        cp      1
        jr      z,mode_norm
        cp      2
        jr      z,mode_hard
mode_easy:
        ld      hl,1
        ld      (dif),hl
        ld      hl,txt_easy
        bcall(_puts)
        jr      main_wait
mode_norm:
        ld      hl,2
        ld      (dif),hl
        ld      hl,txt_norm
        bcall(_puts)
        jr      main_wait
mode_hard:
        ld      hl,5
        ld      (dif),hl
        ld      hl,txt_hard
        bcall(_puts)
        jr      main_wait
play:
        ld      a,2
        ld      (dir2),a
        ld      a,1
        ld      (ball1),a
        ld      (ball2),a
        ld      (ball3),a
        ld      (pos1),a
        ld      (pos3),a
        ld      a,10
        ld      (pos2),a
        ld      hl,0
        ld      (score),hl
        ld      (spdscore),hl
        xor     a       ;ld a,0
        ld      (time3),a
        ld      (timer),a
        ld      (dir1),a
        ld      (dir3),a
        ld      a,60
        ld      (time1),a
        ld      a,120
        ld      (time2),a
        ld      a,180
        ld      (spd),a
        ld      a,2
        ld      (pos),a
        call    draw_guy
        call    guy_mid
        call    draw_ball1
        call    draw_ball2
        call    draw_ball3
        call    ionFastCopy
        ld      hl,(dif)
        ld      a,l
        cp      1
        jr      z,play_easy
        cp      2
        jr      z,play_loop
play_hard:
        ld      a,35
        ld      (time1),a
        ld      a,70
        ld      (time2),a
        ld      a,105
        ld      (spd),a
        jr      play_loop
play_easy:
        ld      a,85
        ld      (time1),a
        ld      a,170
        ld      (time2),a
        ld      a,255
        ld      (spd),a
play_loop:
        call    check_balls
        ld      a,(timer)
        inc     a
        ld      (timer),a
        cp      17
        jr      nz,no_inc_time
        xor     a       ;ld a,0
        ld      (timer),a
        ld      a,(time1)
        inc     a
        ld      (time1),a
        ld      a,(time2)
        inc     a
        ld      (time2),a
        ld      a,(time3)
        inc     a
        ld      (time3),a
        ld      a,(spd)
        ld      b,a
        ld      a,(time1)
        cp      b
        jp      z,mv_ball1
        ld      a,(time2)
        cp      b
        jp      z,mv_ball2
        ld      a,(time3)
        cp      b
        jp      z,mv_ball3
no_inc_time:
        bcall(_getk)
        cp      2
        jp      z,left
        cp      3
        jp      z,right
        cp      15
        jp      z,pause
        jr      play_loop
ch_score:
        ld      de,(dif)
        ld      hl,(score)
        add     hl,de
        ld      (score),hl
        ld      hl,(spdscore)
        inc     hl
        ld      (spdscore),hl
        ret
ch_speed:
        ld      a,(spd)
        cp      3
        ret     z
        ld      hl,(spdscore)
        ld      a,l
        and     %00000011
        or      a       ;cp 0
        ret     nz
        ld      a,(time1)
        or      a       ;cp 0
        jr      nz,t1_not0
        ld      a,(time2)
        dec     a
        ld      (time2),a
        ld      a,(time3)
        sub     2
        ld      (time3),a
        jr      ch_spd
t1_not0:
        ld      a,(time2)
        or      a       ;cp 0
        jr      nz,t2_not0
        ld      a,(time3)
        dec     a
        ld      (time3),a
        ld      a,(time1)
        sub     2
        ld      (time1),a
        jr      ch_spd
t2_not0:
        ld      a,(time1)
        dec     a
        ld      (time1),a
        ld      a,(time2)
        sub     2
        ld      (time2),a
ch_spd:
        ld      a,(spd)
        sub     3
        ld      (spd),a
        ret
check_balls:
        ld      a,(pos)
        cp      1
        jr      z,check_left
        cp      2
        jr      z,check_mid
        jr      check_right
check_left:
        ld      a,(pos1)
        cp      8
        jr      nz,l_not1
        ld      a,(ball1)
        cp      1
        ret     z
        ld      a,1
        ld      (ball1),a
        call    ch_score
l_not1:
        ld      a,(pos3)
        cp      1
        jr      nz,l_not3
        ld      a,(ball3)
        cp      1
        ret     z
        ld      a,1
        ld      (ball3),a
        call    ch_score
l_not3:
        ret
check_mid:
        ld      a,(ball2)
        cp      1
        ret     z
        ld      a,(pos2)
        cp      1
        jr      nz,m_not2a
        ld      a,1
        ld      (ball2),a
        call    ch_score
m_not2a:
        ld      a,(pos2)
        cp      10
        jr      nz,m_not2b
        ld      a,1
        ld      (ball2),a
        call    ch_score
m_not2b:
        ret
check_right:
        ld      a,(pos1)
        cp      1
        jr      nz,r_not1
        ld      a,(ball1)
        cp      1
        ret     z
        ld      a,1
        ld      (ball1),a
        call    ch_score
r_not1:
        ld      a,(pos3)
        cp      12
        jr      nz,l_not3
        ld      a,(ball3)
        cp      1
        ret     z
        ld      a,1
        ld      (ball3),a
        call    ch_score
r_not3:
        ret

mv_ball1:
        xor     a       ;ld a,0
        ld      (time1),a
        ld      a,(pos1)
        cp      1
        jr      nz,ball1_not1
        ld      a,(ball1)
        or      a       ;cp 0
        jp      z,miss
        cp      2
        call    nz,ch_speed
ball1_not1:
        ld      a,(pos1)
        cp      8
        jr      nz,ball1_not8
        ld      a,(ball1)
        or      a       ;cp 0
        jp      z,miss
        call    ch_speed
ball1_not8:
        xor     a       ;ld a,0
        ld      (ball1),a
        call    draw_ball1
        ld      a,(dir1)
        ld      b,a
        ld      a,(pos1)
        inc     a
        sub     b
        ld      (pos1),a
        cp      8
        call    z,bl_ball1
        cp      1
        call    z,br_ball1
        call    draw_ball1
        call    ionFastCopy
        jp      play_loop
draw_ball1:
        ld      a,(pos1)
        cp      1
        jr      z,pos1_ball1
        cp      2
        jr      z,pos2_ball1
        cp      3
        jr      z,pos3_ball1
        cp      4
        jr      z,pos4_ball1
        cp      5
        jr      z,pos5_ball1
        cp      6
        jr      z,pos6_ball1
        cp      7
        jr      z,pos7_ball1
        jr      pos8_ball1
pos1_ball1:
        ld      l,32
        ld      a,29
        jp      draw_ball
pos2_ball1:
        ld      l,28
        ld      a,32
        jp      draw_ball
pos3_ball1:
        ld      l,25
        ld      a,36
        jp      draw_ball
pos4_ball1:
        ld      l,22
        ld      a,41
        jp      draw_ball
pos5_ball1:
        ld      l,22
        ld      a,46
        jp      draw_ball
pos6_ball1:
        ld      l,25
        ld      a,51
        jp      draw_ball
pos7_ball1:
        ld      l,28
        ld      a,55
        jp      draw_ball
pos8_ball1:
        ld      l,32
        ld      a,58
        jp      draw_ball
br_ball1:
        xor     a       ;ld a,0
        ld      (dir1),a
        ret
bl_ball1:
        ld      a,2
        ld      (dir1),a
        ret

mv_ball2:
        xor     a       ;ld a,0
        ld      (time2),a
        ld      a,(pos2)
        cp      1
        jr      nz,ball2_not1
        ld      a,(ball2)
        or      a       ;cp 0
        jp      z,miss
        call    ch_speed
ball2_not1:
        ld      a,(pos2)
        cp      10
        jr      nz,ball2_not10
        ld      a,(ball2)
        or      a       ;cp 0
        jp      z,miss
        cp      2
        call    nz,ch_speed
ball2_not10:
        xor     a       ;ld a,0
        ld      (ball2),a
        call    draw_ball2
        ld      a,(dir2)
        ld      b,a
        ld      a,(pos2)
        inc     a
        sub     b
        ld      (pos2),a
        cp      10
        call    z,bl_ball2
        cp      1
        call    z,br_ball2
        call    draw_ball2
        call    ionFastCopy
        jp      play_loop
draw_ball2:
        ld      a,(pos2)
        cp      1
        jr      z,pos1_ball2
        cp      2
        jr      z,pos2_ball2
        cp      3
        jr      z,pos3_ball2
        cp      4
        jr      z,pos4_ball2
        cp      5
        jr      z,pos5_ball2
        cp      6
        jr      z,pos6_ball2
        cp      7
        jr      z,pos7_ball2
        cp      8
        jr      z,pos8_ball2
        cp      9
        jr      z,pos9_ball2
        jr      pos10_ball2
pos1_ball2:
        ld      l,32
        ld      a,20
        jp      draw_ball
pos2_ball2:
        ld      l,26
        ld      a,23
        jp      draw_ball
pos3_ball2:
        ld      l,21
        ld      a,27
        jp      draw_ball
pos4_ball2:
        ld      l,16
        ld      a,32
        jp      draw_ball
pos5_ball2:
        ld      l,12
        ld      a,38
        jp      draw_ball
pos6_ball2:
        ld      l,12
        ld      a,49
        jp      draw_ball
pos7_ball2:
        ld      l,16
        ld      a,55
        jp      draw_ball
pos8_ball2:
        ld      l,21
        ld      a,60
        jp      draw_ball
pos9_ball2:
        ld      l,26
        ld      a,64
        jp      draw_ball
pos10_ball2:
        ld      l,32
        ld      a,67
        jp      draw_ball
br_ball2:
        xor     a       ;ld a,0
        ld      (dir2),a
        ret
bl_ball2:
        ld      a,2
        ld      (dir2),a
        ret
mv_ball3:
        xor     a       ;ld a,0
        ld      (time3),a
        ld      a,(pos3)
        cp      1
        jr      nz,ball3_not1
        ld      a,(ball3)
        or      a       ;cp 0
        jp      z,miss
        cp      2
        call    nz,ch_speed
ball3_not1:
        ld      a,(pos3)
        cp      12
        jr      nz,ball3_not12
        ld      a,(ball3)
        or      a       ;cp 0
        jp      z,miss
        call    ch_speed
ball3_not12:
        xor     a       ;ld a,0
        ld      (ball3),a
        call    draw_ball3
        ld      a,(dir3)
        ld      b,a
        ld      a,(pos3)
        inc     a
        sub     b
        ld      (pos3),a
        cp      12
        call    z,bl_ball3
        cp      1
        call    z,br_ball3
        call    draw_ball3
        call    ionFastCopy
        jp      play_loop
draw_ball3:
        ld      a,(pos3)
        cp      1
        jr      z,pos1_ball3
        cp      2
        jr      z,pos2_ball3
        cp      3
        jr      z,pos3_ball3
        cp      4
        jr      z,pos4_ball3
        cp      5
        jr      z,pos5_ball3
        cp      6
        jr      z,pos6_ball3
        cp      7
        jr      z,pos7_ball3
        cp      8
        jr      z,pos8_ball3
        cp      9
        jr      z,pos9_ball3
        cp      10
        jr      z,pos10_ball3
        cp      11
        jr      z,pos11_ball3
        jr      pos12_ball3
pos1_ball3:
        ld      l,32
        ld      a,12
        jp      draw_ball
pos2_ball3:
        ld      l,24
        ld      a,15
        jp      draw_ball
pos3_ball3:
        ld      l,17
        ld      a,19
        jp      draw_ball
pos4_ball3:
        ld      l,11
        ld      a,24
        jp      draw_ball
pos5_ball3:
        ld      l,6
        ld      a,30
        jp      draw_ball
pos6_ball3:
        ld      l,2
        ld      a,37
        jp      draw_ball
pos7_ball3:
        ld      l,2
        ld      a,50
        jp      draw_ball
pos8_ball3:
        ld      l,6
        ld      a,57
        jp      draw_ball
pos9_ball3:
        ld      l,11
        ld      a,63
        jp      draw_ball
pos10_ball3:
        ld      l,17
        ld      a,68
        jp      draw_ball
pos11_ball3:
        ld      l,24
        ld      a,72
        jp      draw_ball
pos12_ball3:
        ld      l,32
        ld      a,75
        jp      draw_ball
br_ball3:
        xor     a       ;ld a,0
        ld      (dir3),a
        ret
bl_ball3:
        ld      a,2
        ld      (dir3),a
        ret
draw_ball:
        ld      b,5
        ld      ix,spr_ball
        call    ionPutSprite
        ret

left:
        ld      a,(pos)
        cp      1
        jp      z,play_loop
        call    draw_pos
        ld      a,(pos)
        dec     a
        ld      (pos),a
        call    draw_pos
        call    ionFastCopy
        jp      play_loop
right:
        ld      a,(pos)
        cp      3
        jp      z,play_loop
        call    draw_pos
        ld      a,(pos)
        inc     a
        ld      (pos),a
        call    draw_pos
        call    ionFastCopy
        jp      play_loop
draw_pos:
        ld      a,(pos)
        cp      1
        jr      z,draw_left
        cp      2
        jr      z,draw_mid
        jr      draw_right
draw_left:
        call    guy_left
        ret
draw_mid:
        call    guy_mid
        ret
draw_right:
        call    guy_right
        ret
guy_left:
        ld      l,37
        ld      a,12
        ld      c,2
        ld      b,12
        ld      ix,spr_arml1
        call    ionLargeSprite
        ld      l,37
        ld      a,58
        ld      b,10
        ld      ix,spr_armr3
        call    ionPutSprite
        ld      l,55
        ld      a,38
        ld      b,9
        ld      c,3
        ld      ix,spr_legsleft
        call    ionLargeSprite
        ret
guy_mid:
        ld      l,37
        ld      a,20
        ld      b,11
        ld      ix,spr_arml2
        call    ionPutSprite
        ld      l,37
        ld      a,64
        ld      b,11
        ld      ix,spr_armr2
        call    ionPutSprite
        ld      l,55
        ld      a,38
        ld      b,9
        ld      c,2
        ld      ix,spr_legsmid
        call    ionLargeSprite
        ret
guy_right:
        ld      l,37
        ld      a,26
        ld      b,10
        ld      ix,spr_arml3
        call    ionPutSprite
        ld      l,37
        ld      a,64
        ld      c,2
        ld      b,12
        ld      ix,spr_armr1
        call    ionLargeSprite
        ld      l,55
        ld      a,30
        ld      b,9
        ld      c,3
        ld      ix,spr_legsright
        call    ionLargeSprite
        ret
pause:
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_pause
        call    draw_inv
        ld      hl,0202h
        ld      (currow),hl
        ld      hl,txt_score
        bcall(_puts)
        ld      hl,0902h
        ld      (currow),hl
        ld      hl,(score)
        bcall(_disphl)
        bcall(_newline)
        ld      hl,txt_pausemenu
        bcall(_puts)
pause_loop:
        bcall(_getk)
        cp      15      ;[CLEAR]
        jp      z,main_menu
        cp      9       ;[ENTER]
        jp      z,play_loop
        cp      55      ;[MODE]
        call    z,calc_off
        jr      pause_loop
miss:
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txt_miss
        call    draw_inv
        ld      hl,0203h
        ld      (currow),hl
        ld      hl,txt_score
        bcall(_puts)
        ld      hl,0903h
        ld      (currow),hl
        ld      hl,(score)
        bcall(_disphl)
        ld      hl,0304h
        ld      (currow),hl
        ld      hl,txt_ohigh
        bcall(_puts)
        ld      hl,(high)
        bcall(_disphl)
        ld      hl,(high)
        ld      de,(score)
        bcall(_cphlde)
        jr      nc,miss_loop
        ld      hl,(score)
        ld      (high),hl
        ld      (highsc),hl
        jp      newhigh
miss_loop:
        bcall(_getk)
        cp      9
        jr      nz,miss_loop
        jp      main_menu

quit:
        bcall(_clrlcdf)
        ret

;Input:  N/A
;Output:  N/A
;Destroys  a ??
calc_off:               ;not exactly sure how this works, but it does
        ld      a,1
        out     (3),a
        ei
        halt
back:   ret

;Input:  hl=text to 'bcall(_puts)' (like normal)  cursor must also be placed normally
;Output:  N/A
;Destroys  ?? whatever is destroyed with 'bcall(_puts)'
draw_inv:
        set     textInverse,(IY+textflags)
        bcall(_puts)
        res     textInverse,(IY+textflags)
        ret
draw_guy:
        ld      a,44
        ld      l,a
        ld      a,25
        ld      c,2
        ld      b,7
        ld      ix,spr_arml
        call    ionLargeSprite

        ld      a,44
        ld      l,a
        ld      a,51
        ld      c,2
        ld      b,7
        ld      ix,spr_armr
        call    ionLargeSprite

        ld      a,30
        ld      l,a
        ld      a,35
        ld      c,3
        ld      b,25
        ld      ix,spr_guy
        call    ionLargeSprite
        ret

newhigh:
        bcall(_getk)
        cp      9               ; [enter]
        jr      nz,newhigh      ; if not enter then goto newhigh
        bcall(_clrlcdf)
        bcall(_homeup)
        ld      hl,txtnhigh
        call    draw_inv
        bcall(_newline)
        ld      hl,txtinit
        bcall(_puts)
        ld      ix,highname
        inc     ix
        inc     ix
        ld      b,32
        ld      a,3
clrloop:
        ld      (ix),b
        inc     ix
        dec     a
        or      a
        jr      nz,clrloop
        dec     ix
        dec     ix
        dec     ix
        xor     a
        ld      (ct),a
        ld      b,0
        jr      drawcur
enter_name_loop:
        ld      a,(ix)
        ld      (ct),a
        push bc
        bcall(_getK)
        pop bc
        or       a
        jr       z,enter_name_loop
        cp       $38
        jr       z,backup
        cp       $09
        jp       z,nomore
        cp      2
        jp      z,backcur
        ld       c,a
        ld       a,3
        cp       b
        jr       z,enter_name_loop
        ld      a,c
        cp      4
        jr      z,nextchar
        cp      1
        jr      z,prevchar
        cp      3
        jr      z,writechar
        ld       hl,chartable-10
        ld       e,c
        ld       d,0
        add      hl,de
        ld       a,(hl)
writecharret:
        ld       (ix),a
        bcall(_putc)
        inc      b
        inc      ix
        ld      a,3
        cp      b
        jr      z,too_much
        jr      drawcur
too_much:
        ld      hl,CURROW
        inc     (hl)
        ld      hl,CURCOL
        dec     (hl)
        ld      a,32
        bcall(_putc)
        ld      hl,CURROW
        dec     (hl)
        jr      enter_name_loop
drawcur:
        ld      hl,CURROW
        inc     (hl)
        ld      hl,CURCOL
        dec     (hl)
        ld      a,32
        bcall(_putc)
        ld      a,6
        bcall(_putc)
        ld      a,32
        bcall(_putc)
        ld      hl,CURROW
        dec     (hl)
        ld      hl,CURCOL
        dec     (hl)
        dec     (hl)
        jr      enter_name_loop
backup:
        dec      b
        ld       a,255
        cp       b
        jr       z,too_far
        dec      ix
        ld       (ix),32
        ld       hl,CURCOL
        dec      (hl)
        ld       a,32
        bcall(_putc)
        dec      (hl)
        jr      drawcur
too_far: inc      b
        jp       enter_name_loop
nextchar:
        ld      a,(ct)
        inc     a
        ld      (ct),a
        jr      putchar
prevchar:
        ld      a,(ct)
        dec     a
        ld      (ct),a
        jr      putchar
writechar:
        ld      a,(ct)
        jr      writecharret
putchar:
        ld      d,214
        cp      d
        jr      z,badchar
        ld      (ix),a
        bcall(_putc)
        ld      hl,CURCOL
        dec     (hl)
        jr      drawcur
backcur:
        dec     b
        ld       a,255
        cp       b
        jr       z,too_far
        dec     ix
        ld      hl,CURCOL
        dec     (hl)
        ld      a,(ix)
        ld      (ct),a
        jr      drawcur
badchar:
        ld      a,c
        cp      4
        jr      z,nextchar
        jr      prevchar
nomore:
        ld      (highname),ix
        jp      main_menu

getname:
        ld      de,highname
        inc     de
        inc     de
        ld      b,3
        ld      a,32
        bcall(_putc)
writenameloop:
        ld      a,(de)
        bcall(_putc)
        inc     de
        dec     b
        ld      a,b
        or      a
        jr      nz,writenameloop
        ret

spr_ball:
        .db %01110000
        .db %11111000
        .db %11111000
        .db %11111000
        .db %01110000

spr_legsmid:
        .db %00000111, %11100000
        .db %00001110, %01110000
        .db %00011100, %00111000
        .db %00111000, %00011100
        .db %00110000, %00001100
        .db %00111000, %00011100
        .db %00011000, %00011000
        .db %01111000, %00011110
        .db %11111000, %00011111
spr_legsleft:
        .db %00000111, %11110000, %00000000
        .db %00001110, %01111100, %00000000
        .db %00011100, %00111111, %00000000
        .db %00111000, %00001111, %10000000
        .db %00110000, %00000011, %10011000
        .db %00111000, %00000001, %11111000
        .db %00011000, %00000000, %11100000
        .db %01111000, %00000000, %01000000
        .db %11111000, %00000000, %00000000
spr_legsright:
        .db %00000000, %00001111, %11100000
        .db %00000000, %00111110, %01110000
        .db %00000000, %11111100, %00111000
        .db %00000001, %11110000, %00011100
        .db %00011001, %11000000, %00001100
        .db %00011111, %10000000, %00011100
        .db %00000111, %00000000, %00011000
        .db %00000010, %00000000, %00011110
        .db %00000000, %00000000, %00011111

spr_arml1:
        .db %10001000, %00000000
        .db %11110000, %00000000
        .db %01110000, %00000000
        .db %00111100, %00000000
        .db %00011110, %00000000
        .db %00001111, %00000000
        .db %00000111, %10000000
        .db %00000011, %11000000
        .db %00000001, %11100000
        .db %00000000, %11110000
        .db %00000000, %01111000
        .db %00000000, %00110000
spr_armr1:
        .db %00000000, %00010001
        .db %00000000, %00001111
        .db %00000000, %00001110
        .db %00000000, %00111100
        .db %00000000, %01111000
        .db %00000000, %11110000
        .db %00000001, %11100000
        .db %00000011, %11000000
        .db %00000111, %10000000
        .db %00001111, %00000000
        .db %00011110, %00000000
        .db %00001100, %00000000
spr_arml2:
        .db %10001000
        .db %01110000
        .db %01110000
        .db %00111000
        .db %00111000
        .db %00111000
        .db %00011100
        .db %00011100
        .db %00011110
        .db %00001110
        .db %00001000
spr_armr2:
        .db %00010001
        .db %00001110
        .db %00001110
        .db %00011100
        .db %00011100
        .db %00011100
        .db %00111000
        .db %00111000
        .db %01111000
        .db %01110000
        .db %00010000
spr_arml3:
        .db %00010001
        .db %00001110
        .db %00001110
        .db %00011100
        .db %00011100
        .db %00111100
        .db %00111000
        .db %01111000
        .db %01110000
        .db %11000000
spr_armr3:
        .db %10001000
        .db %01110000
        .db %01110000
        .db %00111000
        .db %00111000
        .db %00111100
        .db %00011100
        .db %00011110
        .db %00001110
        .db %00000011
spr_arml:
        .db %00000000, %00000111
        .db %00000000, %00111111
        .db %00000001, %11111110
        .db %00001111, %11111000
        .db %01111111, %11000000
        .db %11111110, %00000000
        .db %01110000, %00000000
spr_armr:
        .db %11100000, %00000000
        .db %11111100, %00000000
        .db %01111111, %10000000
        .db %00011111, %11110000
        .db %00000011, %11111110
        .db %00000000, %01111111
        .db %00000000, %00001110

spr_guy:
        .db %00000000, %00110000, %00000000
        .db %00000000, %01111000, %00000000
        .db %00000000, %01111000, %00000000
        .db %00000000, %00110000, %00000000
        .db %00000001, %11111110, %00000000
        .db %00000010, %10110101, %00000000
        .db %00010110, %00110001, %10100000
        .db %00011111, %11111111, %11100000
        .db %00011111, %11111111, %11100000
        .db %00010111, %11111111, %10100000
        .db %00000011, %11111111, %00000000
        .db %00000001, %11111110, %00000000
        .db %00000000, %00110000, %00000000
        .db %00000000, %00110000, %00000000
        .db %00000000, %01111000, %00000000
        .db %00000001, %11111110, %00000000
        .db %00000011, %11111111, %00000000
        .db %00000111, %11111111, %10000000
        .db %00000111, %11111111, %10000000
        .db %00000111, %11111111, %10000000
        .db %00000111, %11111111, %10000000
        .db %00000111, %11111111, %10000000
        .db %00000011, %11111111, %00000000
        .db %00000001, %11111110, %00000000
        .db %00000000, %01111000, %00000000

txt_main:
        .db     "***** Ball *****",0
txt_play:
        .db     "Enter - Play",0
txt_quit:
        .db     "Clear - Quit",0
txt_mode:
        .db     "Mode  - ",0
txt_easy:
        .db     "Easy",0
txt_norm:
        .db     "Norm",0
txt_hard:
        .db     "Hard",0
txt_high:
        .db     "High:",0
txt_score:
        .db     "Score: ",0
txt_ohigh:
        .db     "High:",0
txt_miss:
        .db     "----- MISS -----",0
txt_pause:
        .db     "---- PAUSED ----",0
txt_pausemenu:
        .db     "Enter - continue"
        .db     "Clear - quit    "
        .db     "Mode  - calc off",0
txt_name:
        .db     "   R. Bolyard",0
txtnhigh:
        .db     "-New High Score-",0
txtinit:
        .db     "  Please enter  "
        .db     " your initials: "
        .db     "      ",0
chartable:
         .db      "'WRMH_"
         .DB      ".-[VQLG"
         .DB      00h
         .DB      "..ZUPKFC"
         .DB      "@ YTOJEBX.XSNIDA"
         .DB      ".54321!#"

highsc:
        .dw     0000h
highname:
        .dw     0000h
        .dw     0000h
        .dw     00h
.end
