; R E D O X X
;
; Your flying falling fun fix.
;
;
; Special thanks to:
;  Joe W. (for sprite routine)
;  The authors of --==7G==--, Bob the Cat et al. (for scroll routine)
;  Sarkis H. (for the inspiration)
;  Jon H. (for the ideas)
;

#include "ti83plus.inc"
#include "mirage.inc"

ysminor    = saferam1		;y coord of ship (lsb), fractions of pixels, for smoothness
yship      = saferam1+1		;y coord (msb), used for display
fallspeedm = saferam1+2		;first (lsb) of 2 bytes  \_,-> current falling velocity
fallspeed  = saferam1+3		;second (msb) of 2 bytes /
heightcnt  = saferam1+4		;height counter, inc'd every frame
height     = saferam1+5		;height of tunnel
top        = saferam1+6		;top row of tunnel
points     = saferam1+7		;current score (2 bytes)
delay      = saferam1+9		;number of delays per frame

#define GRAV_ACCEL 6
#define BOOST_ACCEL -6
#define SHRINKSPEED 4			;must be a divisor of 256

	.org $9d93
	.db $BB,$6D
	ret
	.db 1
	.db %00000000,%00000000
	.db %01100110,%00000000
	.db %01010100,%01111100
	.db %01100110,%00101000
	.db %01010100,%00101000
	.db %01010110,%00000000
	.db %00000000,%00000000
	.db %01111111,%11111100
	.db %00000000,%00000000
	.db %01100010,%01010100
	.db %01010101,%01010100
	.db %01010101,%00101000
	.db %01010101,%01010100
	.db %01100010,%01010100
	.db %00000000,%00000000
titlestr:
	.db "Redoxx v1.0",0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       HERE BEGINS THE CODE         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start_of_prog:
	res plotloc,(iy+plotflags)
	res textwrite,(iy+sgrflags)
	bcall(_clrlcdf)
	ld bc,0*256+(63-8)
	ld de,95*256+(63-8)
	bcall(_darkline)
	ld hl,2*256+0
	ld (currow),hl
	ld hl,titlestr
	bcall(_puts)
	ld hl,namestr
	ld de,9*256+3
	call setvputs
	ld hl,startstr
	ld de,24*256+10
	call setvputs
	ld hl,quitstr
	ld de,38*256+10
	call setvputs
	ld hl,histr
	ld de,56*256+3
	call setvputs
	ld hl,(hiscore)
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,5
	bcall(_dispop1a)
_start_redraw:
	ld hl,speedstr
	ld de,31*256+10
	call setvputs
	ld a,(speed)
	bcall(_setxxop1)
	ld a,2
	bcall(_dispop1a)
_start_wait_loop:
	call waitkey
	cp skClear
	ret z
	cp sk2nd
	jr z,start
	cp skMode
	jr nz,_start_wait_loop
	ld hl,speed
	inc (hl)
	bit 2,(hl)
	jr z,_start_redraw
	ld (hl),1
	jr _start_redraw


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;    HERE BEGINS THE MAIN PROGRAM    ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start:
	bcall(_clrgbuf)
initvars:
	ld de,saferam1
	ld hl,firstvars
	ld bc,9
	ldir
	ld a,(speed)
	cpl
	add a,5
	add a,a
	ld (delay),a
mainloop:

Scroll:
	LD  HL, Plotsscreen+767
	LD  B, 64
_LLoop:
	SLA (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	DJNZ _LLoop
givepoints:
	ld hl,(points)
	inc hl
	ld (points),hl
getnewvel:
	ld a,$FF
	out (1),a
	ld a,$FD
	out (1),a
	in a,(1)
	cp $BF
	ret z
	ld a,$FE
	out (1),a
	in a,(1)
	ld de,GRAV_ACCEL
	cp $F7
	jr nz,_down
	ld de,BOOST_ACCEL
_down:
	ld hl,(fallspeedm)
	add hl,de
	ld (fallspeedm),hl
moveship:
	ld de,(ysminor)
	add hl,de
	ld (ysminor),hl
chkhit:
	ld a,h
	bit 7,a      ;negative: off top of screen
	jp nz,dead
	bit 6,a      ; >=64: off bottom
	jp nz,dead
	ld e,a
	ld d,0
	ld h,d
	ld l,e
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld de,gbuf
	add hl,de
	ld a,(hl)
	and %00011111
	jr nz,dead
	ld de,24
	add hl,de
	ld a,(hl)
	and %00001010
	jr nz,dead
	call drawship
randomizetop:	
	ld b,3
	call iRandom
	dec a
	ld hl,top
	add a,(hl)
	ld (hl),a
	or a
	jr nz,_noinc
	inc (hl)
_noinc:
	ld a,(height)
	add a,(hl)
	cp 62
	jr c,_nodec
	dec (hl)
_nodec:
manipheight:
	dec hl
	dec hl		; ld hl,heightcnt
	ld a,SHRINKSPEED
	add a,(hl)
	ld (hl),a
	jr nz,mh_done
	inc hl		; ld hl,height
	dec (hl)
	ld a,5
	cp (hl)
	jr nz,mh_done
	inc (hl)
mh_done:
drawwalls:
	ld a,(top)
	ld b,a
	ld c,64
	ld hl,plotsscreen+11
	ld de,12
_drawtwall_loop:
	set 0,(hl)
	add hl,de
	dec c
	djnz _drawtwall_loop
	ld a,(height)
	ld b,a
_drawmiddle_loop:
	res 0,(hl)
	add hl,de
	dec c
	djnz _drawmiddle_loop
	ld b,c
_drawbwall_loop:
	set 0,(hl)
	add hl,de
	djnz _drawbwall_loop
	call iFastCopy
do_delay:
	ld a,(delay)
	ld b,a
	call delayb
	call drawship	;erases it
	jp mainloop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          ROUTINES            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
drawship:
	ld ix,shipsprite
	ld b,3
	ld a,(yship)
	ld l,a
	ld a,3
	call iSprite
	ret

dead:
	set textwrite,(iy+sgrflags)
	ld de,$0202
	ld hl,scorestr
	call setvputs
	ld hl,(points)
	push hl
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,5
	bcall(_dispop1a)
	pop de
	ld hl,(hiscore)
	call cphlde
	jr nc,_nohighscore
	ld (hiscore),de
	ld de,$0802
	ld hl,hiscorestr
	call setvputs
_nohighscore:
	call iFastCopy
_dead_loop:
	call waitkey
	cp sk2nd
	jr z,_end_restart
	cp skClear
_end_restart:
	jp z,start_of_prog
	jr _dead_loop

waitkey:
	ei
	halt
	bcall(_getcsc)
	or a
	jr z,waitkey
	ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;              DATA              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
firstvars:
	.db 0,31,128,-1,0,50,12,0,0

hiscore:    .db 0,0
speed:      .db 1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             SPRITES            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
shipsprite:
	.db %11111000
	.db %01010000
	.db %01010000

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;              TEXT              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
namestr:
	.db "From the KrYpT",0
scorestr:
	.db " Score: ",0
hiscorestr:
	.db " New High Score!",0
startstr:
	.db "2nd - Start",0
quitstr:
	.db "Clear - Quit",0
histr:
	.db "High: ",0
speedstr:
	.db "Mode - Speed: ",0

.end
