#define LINKPORT 0

D0LD1L      EQU              03H
D0LD1H      EQU              01H
D0HD1L      EQU              02H
D0HD1H      EQU              00H

#define LINKMASK 3


;#ifndef TI83
LinkPrep:
        ex (sp),hl
        push bc
        push de
        set 2,(iy+12h)
        ld b,8
        jp (hl)

checkbyte:
TryReceiveByte:
   IN    A, (LINKPORT)                 ; check link port
   AND   LINKMASK
   CP    LINKMASK
   CCF
   RET   C
;        in a,(LINKPORT)
;        and LINKMASK
;        cp LINKMASK
;        scf
;        ret z
ReceiveByteCont:
        call LinkPrep
        jr ReceiveCont
ReceiveByte:
        call LinkPrep
ReceiveBits:
        ld de,-1
WaitRecBit:
        call CheckLink
        jr z,LinkFailed
        cp LINKMASK
        jr z,WaitRecBit
ReceiveCont:
        sub LINKMASK/3*2
        ld a,LINKMASK/3*2
        ld d,D0LD1H
        jr c,ReceiveLow
        rra
        ld d,D0HD1L
ReceiveLow:
        rr c
        ld (AckBit),a
        ld a,d
        out (LINKPORT),a
        ld de,-1
WaitAckRec:
        call CheckLink
        cp 0
AckBit =$-1
        jr nz,WaitAckRec
        ld a,D0HD1H
        out (LINKPORT),a
        ld d,4
WaitReadyRec:
        dec d
        jr z,ReadyRec
        in a,(LINKPORT)
        cp LINKMASK
        jr nz,WaitReadyRec
ReadyRec:
        djnz ReceiveBits
        jr LinkSuccess
  
send_outbyte:
sendbyte:
SendByte:
        call LinkPrep
        ld c,a
SendBits:
        rr c
        ld a,D0LD1H
        jr nc,SendLow
        ld a,D0HD1L
SendLow:
        out (LINKPORT),a
        ld de,-1
WaitAckSend:
        call CheckLink
        jr nz,WaitAckSend
SendAcked:
        ld a,D0HD1H
        out (LINKPORT),a
        ld de,-1
WaitReadySend:
        call CheckLink
        cp LINKMASK
        jr nz,WaitReadySend
        djnz SendBits
LinkSuccess:
        or 0
.org $-1
LinkFailed:
        scf
        res 2,(iy+12h)
;#ifdef TI83
;        ld a,0D0h
;        out (0),a
;#endif
        ld a,c
        pop de
        pop bc
        pop hl
        ret

CheckLink:
        pop hl
        dec de
        ld a,d
        or e
        jr z,LinkFailed
;        ld a,0BFh
;        call _readkeypad
;        bit 6,a
;        jr z,LinkFailed
        in a,(LINKPORT)
        and LINKMASK
        jp (hl)

;
;
;checkbyte:
;TryReceiveByte:
;        in a,(LINKPORT)
;        and LINKMASK
;        cp LINKMASK
;        scf
;        ret z
;ReceiveByteCont:
;        call LinkPrep
;        jr ReceiveCont
;ReceiveByte:
;        call LinkPrep
;ReceiveBits:
;        ld de,-1
;WaitRecBit:
;        call CheckLink
;        jr z,LinkFailed
;        cp LINKMASK
;        jr z,WaitRecBit
;ReceiveCont:
;        sub LINKMASK/3*2
;        ld a,LINKMASK/3*2
;        ld d,D0LD1H
;        jr c,ReceiveLow
;        rra
;        ld d,D0HD1L
;ReceiveLow:
;        rr c
;        ld (AckBit),a
;        ld a,d
;        out (LINKPORT),a
;        ld de,-1
;WaitAckRec:
;        call CheckLink
;        cp 0
;AckBit =$-1
;        jr nz,WaitAckRec
;        ld a,D0HD1H
;        out (LINKPORT),a
;        ld d,4
;WaitReadyRec:
;        dec d
;        jr z,ReadyRec
;        in a,(LINKPORT)
;        cp LINKMASK
;        jr nz,WaitReadyRec
;ReadyRec:
;        djnz ReceiveBits
;        jr LinkSuccess
;
;
;LinkPrep:
;        ex (sp),hl
;        push bc
;        push de
;        set 2,(iy+12h)
;        ld b,8
;        jp (hl)
;
;send_outbyte:
;;SendByte:
;        call LinkPrep
;        ld c,a
;        ;ld a, 255
;        ;ld (stime), a
;SendBits:
;        rr c
;        ld a,D0LD1H
;        jr nc,SendLow
;        ld a,D0HD1L
;SendLow:
;        out (LINKPORT),a
;        ld de,-1
;WaitAckSend:
;        call CheckLink
;        jr nz,WaitAckSend
;SendAcked:
;        ld a,D0HD1H
;        out (LINKPORT),a
;        ld de,-1
;WaitReadySend:
;        call CheckLink
;        cp LINKMASK
;        jr nz,WaitReadySend
;        djnz SendBits
;LinkSuccess:
;        or 0
;;.org $-1
;LinkFailed:
;        scf
;        res 2,(iy+12h)
;;#ifdef TI83
;;        ld a,0D0h
;;        out (0),a
;;#endif
;        ld a,c
;        pop de
;        pop bc
;        pop hl
;        ret
;
;CheckLink:
;        pop hl
;        dec de
;        ld a,d
;        or e
;        jr z,LinkFailed
;        ld a,0BFh
;        ;call stimeout
;        ;cp      0
;        ;call  _readkeypad
;        ;bit 6,a
;        ;jr z,LinkFailed
;        in a,(LINKPORT)
;        and LINKMASK
;        jp (hl)
