;-----------+----------------------------------------------------+----------+
; Telnet 8x | Z80 Source Code for the TI-83 plus                 | Infiniti |
;-----------+----------------------------------------------------+----------+
;
;       1998 Justin Karneges
;
;       Telnet8x V1.9
;
;       Telnet8x is a terminal program for the TI-83+.  It has an 80x25
;       scrolling view and vt100 emulation.
;
;       To Use:
;               -Link two calcs together with the regular link and talk.
;               -Connect a Graphlink to a device such as a modem or TNC and
;                then connect the Graphlink to the calculator.
;               -It will work with anything that uses the linkport.  Try the
;                IR link. =)
;
;       Note:   There are a few vt100 sequences that telnet8x will recognize
;               but not do anything in response.  These are mainly sequences
;               that either the calculator can't do OR they are so old and
;               unused that I left it out.
;
;
;
;       Programming Note:
;               The instruction:
;
;               call    catchup         ; *-* LINK CHECK *+*
;
;               appears VERY often in the code (like a hundred times).
;               In order to get 9600bps out of the calc, I have to check
;               the link port insanely often.  It makes the code very ugly
;               to read, but it is a necessary step.
;
;-----------+----------------------------------------------------+----------+
; Telnet 8x | Includes/Defines/Program Start                     | Infiniti |
;-----------+----------------------------------------------------+----------+
.nolist

#define TI83P
#include    "ion.inc"

GRAPH_MEM = plotsscreen

   .org progstart-2
   .db $BB,$6D

;#include "crash82.inc"

#define equ .equ
#define EQU .equ
#define end .end

NONE            .equ    0
BOLD            .equ    1
UNDERLINE       .equ    4
BLINK           .equ    5
INVERSE         .equ    7

.LIST
;   RET
   XOR   A
   JR    NC, start

PORT    .equ    0

Description:
        .db "Affinix Telnet 83 Plus SE v1.9",0

;-----------+----------------------------------------------------+----------+
; Telnet 8x | Data                                               | Infiniti |
;-----------+----------------------------------------------------+----------+
curx    .db     0       ; - Cursor position (in characters)
cury    .db     8       ; /

sx      .db     0       ; - Screen position (in characters)
sy      .db     0       ; /

scr_top .db     0       ; top of scrolling region
scr_bot .db     23      ; bottom of scrolling region

timer   .db     0       ; Timer used for flashing cursor
curstat .db     0       ; Current status of cursor
curshad .db     32      ; Character that's behind the cursor
curattr .db     0       ; cursor attributes (bold, inverse, etc)

sendstat .db    0       ; flag to force statusbar to display send status
                        ; upon keypress even if it was sent so fast that
                        ; there's no data pending

panned   .db    0       ; did you pan the screen during the previous loop?
mm_mode  .db    $FF     ; minimap mode on?
inv_mode .db    $FF     ; invert screen mode

n       .dw     0       ; temp var
n2      .dw     0       ; temp var
;-----------+----------------------------------------------------+----------+
; Telnet 8x | Buffers                                            | Infiniti |
;-----------+----------------------------------------------------+----------+
#define BUFSIZE 32

; buffer for vt100 sequences
#define ESC     27
seqbuf  .db     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
in_seq  .db     0
scurx   .db     0
scury   .db     0

; backup of register SP
;spbackup .dw    0

;-----------+----------------------------------------------------+----------+
; Telnet 8x | Program                                            | Infiniti |
;-----------+----------------------------------------------------+----------+
start:
;        call    RINDOFF         ; Turn off runindicator
;        call    BUFCLR          ; Clear the graphbuf
;        call    CR_GRBCopy       ; Copy the graphbuf to the LCD
;        call    GET_KEY         ; Clear out the keypad buffer
;        ld      (spbackup), sp  ; backup the stack (for use with quitting)

;        call    buildtable      ; build the font table

mainloop:
      call    catchup         ; *-* LINK CHECK *+*
        ; --- render the screen ---
        call    fix_bound       ; make sure the scrolling screen is inbounds
        call    render_text     ; draw up the terminal
        call    render_stat     ; draw the status bar at the bottom

      call    catchup         ; *-* LINK CHECK *+*

        ld      a, (panned)
        cp      1
        jr      nz, no_minimap
        ld      a, (mm_mode)
        or      a
        call    nz, render_minimap
no_minimap:

      call    catchup         ; *-* LINK CHECK *+*

        xor     a
        ld      (panned), a
        ld      (sendstat), a   ; flag the status bar to indicate no send

        call    zap             ; copy to LCD
        ; --- end ---

      call    catchup         ; *-* LINK CHECK *+*

        ; --- check with direct input (for scrolling) ---
        ld      a, (shift)
        cp      3
        jr      z, no_directarrow

        ; Credit goes to Hideaki Omuro (CRASHMAN) for this.
        ; I didn't feel like writing it. =)

   LD    A, $FF
   OUT   ($01), A                      ; Reset Port
   DEC   A
   OUT   ($01), A                      ; Mask out Arrows
   IN    A, ($01)
   RRCA
   CALL  NC, scroll_down
   RRCA
   CALL  NC, scroll_left
   RRCA
   CALL  NC, scroll_right
   RRCA
   CALL  NC, scroll_up

no_directarrow:
        ; --- end ---

        ; --- check keypad the normal way and respond accordingly ---
      call    catchup         ; *-* LINK CHECK *+*

   CALL  getch
   CP    $15
   RET   Z                                ; quit
        cp      45h
        call    z, reset_term
        cp      13h
        call    z, jumphome     ; zoom to the left edge [ZOOM] button
        cp      14h
        call    z, mm_mode_swap ; toggle minimap mode
        cp      12h
        call    z, invert_swap  ; toggle the invert
        cp      11h
        call    z, setwrap      ; toggle the character wrap
        cp      21h
        call    z, set2nd       ; set numeric
        cp      31h
        call    z, setalph      ; set capital
        cp      22h
        call    z, setmode      ; set extra
        cp      32h
        call    z, setctrl      ; set ctrl

      call    catchup         ; *-* LINK CHECK *+*
        ld      d, a
        ld      a, (shift)
        cp      3
        ld      a, d
        jr      nz, no_vtarrows

        cp      25h
        call    z, send_vt100_up
        cp      34h
        call    z, send_vt100_down
        cp      24h
        call    z, send_vt100_left
        cp      26h
        call    z, send_vt100_right
no_vtarrows:
   OR    A
   JR    Z, no_key                     ; no key

      call    catchup         ; *-* LINK CHECK *+*

   CALL  keypad2ascii                  ; convert the key into ASCII

      call    catchup         ; *-* LINK CHECK *+*

   OR    A
   JR    Z, no_key                     ; key doesn't have an entry

   LD    HL, sendstat
   LD    (HL), 1                       ; flag the status bar to indicate send

      call    catchup         ; *-* LINK CHECK *+*

   CALL  sendbyte                      ; chuck it out the window

      call    catchup         ; *-* LINK CHECK *+*
no_key:
        ; --- end ---

        ; --- check for incoming data ---
more_data:
      call    catchup         ; *-* LINK CHECK *+*

   CALL  recvbyte                      ; get a byte from the recv buffer
   OR    A
   JP    Z, no_data                    ; it's empty
   CP    $0F
   JP    Z, no_data

      call    catchup         ; *-* LINK CHECK *+*

   LD    B, A
   LD    HL, in_seq
   XOR   A
   OR    (HL)
   LD    A, B
   JR    NZ, add2esc                   ; continue the current vt100 sequence

   CP    ESC
   JR    Z, handle_esc                 ; begin tracking a new vt100 sequence

      call    catchup         ; *-* LINK CHECK *+*

   CALL  putchar                       ; display the character
   JR    more_data

handle_esc:
   LD    (HL), $01                     ; flag that we're in sequence
   LD    HL, seqbuf
   LD    (HL), ESC
   JR    more_data                     ; load ESC char into sequence

add2esc:
   LD    B, 0
   LD    C, (HL)
   INC   (HL)
   LD    HL, seqbuf
   ADD   HL, BC

   LD    (HL), A                       ; add new char to sequence

   CALL  check_seq                     ; see if the sequence has a match

   OR    A
   JR    Z, seqoverflow                ; no match or sequence to big?
   CP    2
   CALL  Z, erase_esc                  ; perfect match executed, delete old
   JR    more_data

seqoverflow:
      call    catchup         ; *-* LINK CHECK *+*

   CALL  killesc                       ; output the sequence to the screen

      call    catchup         ; *-* LINK CHECK *+*

   XOR   A
   LD    (in_seq), A                   ; flag out the sequence pointer
   JR    more_data

no_data:
        ; --- end ---

        ; --- change cursor status ---
      call    catchup         ; *-* LINK CHECK *+*

   LD    HL, timer
   PUSH  HL
   LD    A, (HL)
   CP    4
   JR    NZ, noswap                    ; not time to swap yet

   LD    (HL), $FF                     ; zero out the cursor timer

   LD    A, (curstat)
   OR    A
   JR    Z, curisoff
   CALL  cursor_off                    ; if on, turn back off
   JR    done_cursor
curisoff:
   CALL  cursor_on                     ; if off, turn back on
done_cursor:
noswap:
   POP   HL
   INC   (HL)                          ; increment the timer
aftertimer:
        ; --- end ---

   JP    mainloop                      ; loop back to the top!

default_settings:
   .db   0,0,0,23

reset_term:
   LD    HL, default_settings
   LD    DE, sx
   LD    BC, 4
   LDIR
   JP    vt100entirescreen

;exit:
;        ld      sp, (spbackup)
;        call    CLRTSHD         ; Clear textshadow
;        call    GOHOME          ; Leave graphscreen and go to homescreen
;        call    BUFCLR          ; Clear the graphbuf
;        call    READKEY         ; Catch the clear press
;        call    HOMEUP          ; Place cursor at home
;        jp      GET_KEY
;        ret                     ; Exit program

;-----------+----------------------------------------------------+----------+
; Telnet 8x | Helper functions                                   | Infiniti |
;-----------+----------------------------------------------------+----------+
send_vt100_up:
      call    catchup         ; *-* LINK CHECK *+*
        push    af
        ld      a, ESC
        call    sendbyte
        ld      a, '['
        call    sendbyte
        ld      a, 'A'
        call    sendbyte
        pop     af
      call    catchup         ; *-* LINK CHECK *+*
        ret
send_vt100_down:
      call    catchup         ; *-* LINK CHECK *+*
        push    af
        ld      a, ESC
        call    sendbyte
        ld      a, '['
        call    sendbyte
        ld      a, 'B'
        call    sendbyte
        pop     af
      call    catchup         ; *-* LINK CHECK *+*
        ret
send_vt100_left:
      call    catchup         ; *-* LINK CHECK *+*
        push    af
        ld      a, ESC
        call    sendbyte
        ld      a, '['
        call    sendbyte
        ld      a, 'D'
        call    sendbyte
        pop     af
      call    catchup         ; *-* LINK CHECK *+*
        ret
send_vt100_right:
      call    catchup         ; *-* LINK CHECK *+*
        push    af
        ld      a, ESC
        call    sendbyte
        ld      a, '['
        call    sendbyte
        ld      a, 'C'
        call    sendbyte
        pop     af
      call    catchup         ; *-* LINK CHECK *+*
        ret

killesc:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (in_seq)
        ld      b, a
        ld      hl, seqbuf
kill_lp:
      call    catchup         ; *-* LINK CHECK *+*
        push    bc
        push    hl
        ld      a, (hl)
      call    catchup         ; *-* LINK CHECK *+*
        call    putchar
      call    catchup         ; *-* LINK CHECK *+*
        pop     hl
        inc     hl
        pop     bc
        djnz    kill_lp
        ld      a, 0
        ld      (in_seq), a
        ret

erase_esc:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, 0
        ld      (in_seq), a
        ret

scroll_down:
   LD    HL, sy
   INC   (HL)

pan_set:
   LD    HL, panned
   LD    (HL), 1

   JP    catchup         ; *-* LINK CHECK *+*

scroll_left:
   LD    HL, sx
   DEC   (HL)
   DEC   (HL)
   JR    pan_set

scroll_right:
   LD    HL, sx
   INC   (HL)
   INC   (HL)
   JR    pan_set

scroll_up:
   LD    HL, sy
   DEC   (HL)
   JR    pan_set

jumphome:
   XOR   A
   LD    (sx), A
   RET

mm_mode_swap:
   LD    HL, mm_mode
cpl_mhl:
   LD    A, (HL)
   CPL
   LD    (HL), A
   XOR   A
   RET

invert_swap:
   LD    HL, inv_mode
   JR    cpl_mhl

shift   .db     0
set2nd:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (shift)
        cp      1
        jr      z, setshiftOff
        ld      a, 1
        ld      (shift), a
        ld      a, 0
        ret
setshiftOff
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, 0
        ld      (shift), a
        ld      a, 0
        ret
setalph:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (shift)
        cp      2
        jr      z, setshiftOff
        ld      a, 2
        ld      (shift), a
        ld      a, 0
        ret
setmode:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (shift)
        cp      3
        jr      z, setshiftOff
        ld      a, 3
        ld      (shift), a
        ld      a, 0
        ret
setctrl:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (shift)
        cp      4
        jr      z, setshiftOff
        ld      a, 4
        ld      (shift), a
        ld      a, 0
        ret

wrap    .db     80
setwrap:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (wrap)
        cp      80
        jr      z, setwrap24
        ld      a, 80
        ld      (wrap), a
        ld      a, 0
        ret
setwrap24:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, 24
        ld      (wrap), a
        ld      a, 0
        ret

putchar:
      call    catchup         ; *-* LINK CHECK *+*

   PUSH  AF
   CALL  cursor_off
   POP   AF

   OR    A
   RET   Z
   CP    128
   JR    C, putchar_next1
   XOR   A
putchar_next1:
      call    catchup         ; *-* LINK CHECK *+*

        cp      10
        jp      z, putnewline
        cp      12
        jp      z, vt100entirescreen
        cp      13
        jp      z, putreturn
        cp      8
        jp      z, putbs
        cp      7
        jp      z, putbeep
        cp      9
        jp      z, puttab

      call    catchup         ; *-* LINK CHECK *+*
        ld      d, a
        ld      a, (curattr)
        cp      INVERSE
        jr      nz, putchar_normal
        set     7, d
putchar_normal:
        ld      a, d

      call    catchup         ; *-* LINK CHECK *+*

   LD    (curshad), A

        ld      a, (wrap)
        ld      b, a
        ld      a, (curx)
        cp      b
      call    catchup         ; *-* LINK CHECK *+*
        call    nc, putcr
      call    catchup         ; *-* LINK CHECK *+*

   LD    HL, (curx)
   INC   L
   CALL  move_cursor

;        ld      a, (curx)
;        inc     a
;        ld      (curx), a

      call    catchup         ; *-* LINK CHECK *+*
        ret

putnewline:
        ld      a, (scr_bot)
        ld      c, a
        ld      a, (cury)
        cp      c
        jr      nc, putscroll

   LD    HL, (curx)
   INC   H
   CALL  move_cursor

;        inc     a
;        ld      (cury), a
        ret
putreturn:
   LD    HL, (curx)
   LD    L, 0
   CALL  move_cursor

;        ld      a, 0
;        ld      (curx), a
        ret
putbs:
   LD    HL, (curx)
   XOR   A
   OR    L
   RET   Z
   DEC   L
   CALL  move_cursor
;        ld      a, (curx)
;        cp      0
;        ret     z
;        dec     a
;        ld      (curx), a
        ret
putscroll:
      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (scr_top)
   LD    H, A
   LD    L, 0

   CALL  find_scr_ofs

      call    catchup         ; *-* LINK CHECK *+*

   LD    (n), HL
   EX    DE, HL               ; DE = (n)
   LD    HL, 80
   ADD   HL, DE               ; HL = (n) + 80
   LD    (n2), HL

   LD    A, (scr_top)
   LD    H, A
   LD    A, (scr_bot)
   SUB   H

   LD    H, A
   ADD   A, A                          ; A = sy*2
   ADD   A, A                          ; A = sy*4
   ADD   A, H                          ; A = sy*5

   RLCA
   RLCA
   RLCA
   RLCA

   LD    C, A
   AND   $0F
   LD    B, A
   XOR   C
   LD    C, A

      call    catchup         ; *-* LINK CHECK *+*

   LD    DE, (n)
   LD    HL, (n2)
   LDIR

      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (scr_bot)
   LD    H, A
   LD    L, 0
   CALL  find_scr_ofs

      call    catchup         ; *-* LINK CHECK *+*

   LD    HL, whitespace
   LD    BC, 80
   LDIR

   LD    HL, (curx)
   CALL  move_cursor_only

      call    catchup         ; *-* LINK CHECK *+*

   RET

putcr:
      call    catchup         ; *-* LINK CHECK *+*
        call    putreturn
      call    catchup         ; *-* LINK CHECK *+*
        call    putnewline
      call    catchup         ; *-* LINK CHECK *+*
        ret
setzero:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, 0
        ret

putbeep:
      call    catchup         ; *-* LINK CHECK *+*
        ld      hl, GRAPH_MEM
        ld      bc, 768
xorlp:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (hl)
        cpl
        ld      (hl), a
        inc     hl
        dec     bc
        ld      a, b
        or      c
        jr      nz, xorlp
      call    catchup         ; *-* LINK CHECK *+*
        call    zap
      call    catchup         ; *-* LINK CHECK *+*
        ret

puttab:
        ld      a, (curx)
        cp      79
        ret     z
tablp:
      call    catchup         ; *-* LINK CHECK *+*
        ld      b, a
        sub     8
        jr      nc, tablp

        ld      a, 8
        sub     b
        ld      b, a
        ld      a, (curx)
        add     a, b
        cp      80
        call    nc, fixtab

   LD    HL, (curx)
   LD    L, A
   CALL  move_cursor
;        ld      (curx), a

      call    catchup         ; *-* LINK CHECK *+*
        ret
fixtab:
        ld      a, 79
      call    catchup         ; *-* LINK CHECK *+*
        ret

;  L = x, H = y
find_scr_ofs:
   LD    A, H
   ADD   A, A                          ; A = sy*2
   ADD   A, A                          ; A = sy*4
   ADD   A, H                          ; A = sy*5

   LD    H, 0

   RLCA
   RLCA
   RLCA
   RLCA

   LD    C, A
   AND   $0F
   LD    B, A
   XOR   C
   LD    C, A

   ADD   HL, BC

   LD    BC, term
   ADD   HL, BC

   RET

; input:  A:iccccccc->i=invert on/off, c=character num
; output: C=invert mask, HL->font

get_font_addr:
   ADD   A, A                          ; check carry/double (A=num*2)

   LD    B, 0                          ; store to multiply
   LD    C, A                          ;                    (BC=num*2)

   LD    HL, inv_mode                  ; are we in inverted mode?
   SBC   A, A                          ;
   XOR   (HL)                          ;
   AND   $F0                           ;

   LD    H, B                          ; get to multiply
   LD    L, C                          ;                    (HL=num*2)

   ADD   HL, BC                        ; do actual multiply
   ADD   HL, BC                        ;                    (HL=num*6)
   LD    BC, font                      ;
   ADD   HL, BC                        ;               (HL=font+num*6)

   LD    C, A                          ; set up C=invert mask

   RET

render_text:
      call    catchup         ; *-* LINK CHECK *+*

   LD    IX, GRAPH_MEM

   LD    HL, (sx)
   CALL  find_scr_ofs

   LD    C, 10
st1:
   LD    B, 12
st2:
   PUSH  BC

      call    catchup         ; *-* LINK CHECK *+*

   PUSH  HL
   LD    A, (HL)                       ; Get byte
   CALL  get_font_addr

   LD    A, (HL)
   XOR   C
   LD    (IX), A
   INC   HL

      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (HL)
   XOR   C
   LD    (IX+12), A
   INC   HL

   LD    A, (HL)
   XOR   C
   LD    (IX+24), A
   INC   HL

   LD    A, (HL)
   XOR   C
   LD    (IX+36), A
   INC   HL

   LD    A, (HL)
   XOR   C
   LD    (IX+48), A
   INC   HL

   LD    A, (HL)
   XOR   C
   LD    (IX+60), A
   POP   HL

   INC   HL

   PUSH  HL
   LD    A, (HL)
   CALL  get_font_addr

      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (HL)
   XOR   C
   RRCA
   RRCA
   RRCA
   RRCA
   OR    (IX)
   LD    (IX), A
   INC   HL

   LD    A, (HL)
   XOR   C
   RRCA
   RRCA
   RRCA
   RRCA
   OR    (IX+12)
   LD    (IX+12), A
   INC   HL

   LD    A, (HL)
   XOR   C
   RRCA
   RRCA
   RRCA
   RRCA
   OR    (IX+24)
   LD    (IX+24), A
   INC   HL

   LD    A, (HL)
   XOR   C
   RRCA
   RRCA
   RRCA
   RRCA
   OR    (IX+36)
   LD    (IX+36), A
   INC   HL

      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (HL)
   XOR   C
   RRCA
   RRCA
   RRCA
   RRCA
   OR    (IX+48)
   LD    (IX+48), A
   INC   HL

   LD    A, (HL)
   XOR   C
   RRCA
   RRCA
   RRCA
   RRCA
   OR    (IX+60)
   LD    (IX+60), A
   POP   HL

   INC   IX
   INC   HL

   POP   BC
   DEC   B
   JP    NZ, st2

   LD    DE, 60
   ADD   IX, DE

   LD    E, 56
   ADD   HL, DE

   DEC   C
   JP    NZ, st1

   RET

drw_spr:
   PUSH  HL
   ADD   A, A
   ADD   A, A

   ADD   A, L
   LD    L, A
   ADC   A, H
   SUB   L
   LD    H, A
   JR    drw_spr_merge

drw_spr_main:
   PUSH  HL
drw_spr_merge:
   LD    A, (HL)
   XOR   C
   LD    (IX), A
   INC   HL
   LD    A, (HL)
   XOR   C
   LD    (IX+12), A
   INC   HL
   LD    A, (HL)
   XOR   C
   LD    (IX+24), A
   INC   HL
   LD    A, (HL)
   XOR   C
   LD    (IX+36), A
   INC   IX
   POP   HL
      call    catchup         ; *-* LINK CHECK *+*

   RET

status_graphics:

statusleft
   .db %00000000
   .db %00010000
   .db %00101000
   .db %00011000
statusshade
   .db %10110110
   .db %10010011
   .db %10100001
   .db %10110110
statusfill
   .db %00010000
   .db %00101000
   .db %00111000
   .db %00101000
statusjail
   .db %00000000
   .db %00101000
   .db %00010000
   .db %00101000
statusctrl
   .db %00000000
   .db %00010000
   .db %00101000
   .db %01000100

wrap_graphics:

wrap_off
   .db %01101110
   .db %11101010
   .db %10101010
   .db %11101110
wrap_on
   .db %01100110
   .db %00101010
   .db %01001110
   .db %01100010

mm_graphics:

mm_on
   .db %00000000
   .db %00011110
   .db %00010010
   .db %00011110
mm_off

recv_graphics:
send_graphics:

statusbar
   .db %00000000
   .db %00000000
   .db %00000000
   .db %00000000

recv_on
   .db %00000100
   .db %11001100
   .db %11011111
   .db %11000000

send_on
   .db %00000100
   .db %11000110
   .db %11011111
   .db %11000000

render_stat:
      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (inv_mode)
   CPL
   LD    C, A

   LD    IX, GRAPH_MEM + 720
   LD    HL, status_graphics
   LD    A, (shift)
   CALL  drw_spr

      call    catchup         ; *-* LINK CHECK *+*

   LD    HL, statusbar
   CALL  drw_spr_main

   LD    HL, wrap_graphics
   LD    A, (wrap)
   SUB   80
   SBC   A, A
   AND   1
   CALL  drw_spr

   LD    HL, statusbar
   CALL  drw_spr_main

      call    catchup         ; *-* LINK CHECK *+*

   LD    HL, mm_graphics
   LD    A, (mm_mode)
   SUB   1
   SBC   A, A
   AND   1
   CALL  drw_spr

   LD    HL, statusbar
   CALL  drw_spr_main
   CALL  drw_spr_main
   CALL  drw_spr_main
   CALL  drw_spr_main

      call    catchup         ; *-* LINK CHECK *+*

   LD    A, (sendstat)
   ADD   A, $FF
   SBC   A, A
   AND   2
   LD    HL, send_graphics
   CALL  drw_spr

   LD    HL, statusbar
   CALL  drw_spr_main

   PUSH  BC
   CALL  check_recv
   POP   BC

   LD    HL, send_graphics
   ADD   A, $FF
   SBC   A, A
   AND   1
   CALL  drw_spr

      call    catchup         ; *-* LINK CHECK *+*
        ret

render_minimap:
        ld      ix, GRAPH_MEM + 390 - 13
        ld      b, 0

        ld      a, (ix+0)
        and     %11111110
        ld      (ix+0), a
        ld      (ix+1), b
        ld      (ix+2), b
        ld      (ix+3), b
        ld      (ix+4), b
        ld      (ix+5), b
        ld      a, (ix+6)
        and     %01111111
        ld      (ix+6), a

        ld      ix, GRAPH_MEM + 390 - 13 + 300
        ld      a, (ix+0)
        and     %11111110
        ld      (ix+0), a
        ld      (ix+1), b
        ld      (ix+2), b
        ld      (ix+3), b
        ld      (ix+4), b
        ld      (ix+5), b
        ld      a, (ix+6)
        and     %01111111
        ld      (ix+6), a

        ld      b, 24
        ld      de, 12
        ld      hl, GRAPH_MEM + 390 - 1
mmprelp1:
        ld      a, (hl)
        and     %11111110
        ld      (hl), a
        add     hl, de
        djnz    mmprelp1

        ld      b, 24
        ld      hl, GRAPH_MEM + 390 + 5
mmprelp2:
        ld      a, (hl)
        and     %01111111
        ld      (hl), a
        add     hl, de
        djnz    mmprelp2

        ld      hl, GRAPH_MEM + 390
        ld      ix, term
        ld      b, 24
        ld      de, 7
mmlp:
        push    bc
      call    catchup         ; *-* LINK CHECK *+*
        ld      b, 5
mmlp2:
        push    bc

        ld      c, 0
        ld      b, 8
mmlp3:
        ld      a, (ix+0)
        cp      32
        jr      nz, mmfilled
        ld      a, (ix+1)
        cp      32
        jr      nz, mmfilled
mmblank:
        scf
        rl      c
        jr      mmnext
mmfilled:
        sla     c
mmnext:
        inc     ix
        inc     ix
        djnz    mmlp3

        ld      (hl), c
        inc     hl
        pop     bc
        djnz    mmlp2

        add     hl, de
        pop     bc
        djnz    mmlp

        ld      a, (sy)
        add     a, 32
        ld      e, a
        ld      a, (sx)
        srl     a
        add     a, 48
        ld      bc, mmg1
        call    SPRXOR

        ld      a, (sy)
        add     a, 32
        ld      e, a
        ld      a, (sx)
        srl     a
        add     a, 48+8
        ld      bc, mmg2
        call    SPRXOR

        ld      a, (sy)
        add     a, 32+8
        ld      e, a
        ld      a, (sx)
        srl     a
        add     a, 48
        ld      bc, mmg3
        call    SPRXOR

        ld      a, (sy)
        add     a, 32+8
        ld      e, a
        ld      a, (sx)
        srl     a
        add     a, 48+8
        ld      bc, mmg4
        call    SPRXOR

        ret


fix_bound:
   CALL  fix_boundsx

fix_boundsy:
   LD    A, (sy)
   OR    A
   JP    M, sy_neg
   CP    15
   RET   C
sy_pos:
   LD    A, 14
   LD    (sy), A
   RET
sy_neg:
   XOR   A
   LD    (sy), A
   RET

fix_boundsx:
   LD    A, (sx)
   OR    A
   JP    M, sx_neg
   CP    57
   RET   C
sx_pos:
   LD    A, 56
   LD    (sx), A
   RET
sx_neg:
   XOR   A
   LD    (sx), A
   RET

getxy:
      call    catchup         ; *-* LINK CHECK *+*

   LD    HL, (curx)
   JP    find_scr_ofs

cursor_on:
   CALL  getxy
   LD    (HL), 0
   LD    A, 1
   LD    (curstat), A
   RET

cursor_off:
   CALL  getxy
   LD    A, (curshad)
   LD    (HL), A
   XOR   A
   LD    (curstat), A
   RET

move_cursor:
   PUSH  HL
   CALL  cursor_off
   POP   HL
move_cursor_only:
   LD    (curx), HL
   CALL  find_scr_ofs
   LD    A, (HL)
   LD    (curshad), A
   XOR   A
   LD    (curstat), A
   RET

; getch - gets a keypress.  //save row:col in b:c
getch:
        call    catchup
        push    hl
;        call    GET_KEY  ;_GetK
   bcall(_getk)
        ld      hl, dumb_key_table
        add     a, l
        ld      l, a
        adc     a, h
        call    catchup
        sub     l
        ld      h, a
        ld      a, (hl)
        pop     hl

        ret

keypad2ascii:
      call    catchup         ; *-* LINK CHECK *+*
        cp      26h                     ; the right arrow is a special case
        jr      nz, no_keypad_right     ; because it is the only key in
        ld      a, 0                    ; column 6.  since column 6 isn't in
        ret                             ; the key tables, it must be filtered
no_keypad_right:                        ; out now.

        ld      b, a
        and     15
        ld      e, a
        ld      a, b
        srl     a
        srl     a
        srl     a
        srl     a
        and     15
        ld      d, a
        dec     d
        dec     e
        push    de
        ld      a, d
        ld      d, 0
        ld      e, a

      call    catchup         ; *-* LINK CHECK *+*
        ld      hl, keypad_table
        ld      b, 5
keypad_lp:
      call    catchup         ; *-* LINK CHECK *+*
        add     hl, de
        djnz    keypad_lp

        pop     de
        ld      d, 0
        add     hl, de

      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (shift)
        cp      1
        call    z, keypad_2nd
        cp      2
        call    z, keypad_alph
        cp      3
        call    z, keypad_mode
        cp      4
        call    z, keypad_ctrl

        ld      a, (hl)
      call    catchup         ; *-* LINK CHECK *+*
        ret

keypad_2nd:
        ld      bc, 50
        add     hl, bc
      call    catchup         ; *-* LINK CHECK *+*
        ret
keypad_alph:
        ld      bc, 100
        add     hl, bc
      call    catchup         ; *-* LINK CHECK *+*
        ret
keypad_mode:
        ld      bc, 150
        add     hl, bc
      call    catchup         ; *-* LINK CHECK *+*
        ret
keypad_ctrl:
        ld      bc, 200
        add     hl, bc
        ld      a, 0
        ld      (shift), a
      call    catchup         ; *-* LINK CHECK *+*
        ret

zap:
bufcopy_catchup:
	di
	ld	a,$80				; 7
	out	($10),a				; 11
	ld	hl,gbuf-12-(-(12*64)+1)		; 10
	ld	a,$20				; 7
	ld	c,a				; 4
	inc	hl				; 6 waste
	dec	hl				; 6 waste
fastCopyAgain:
	ld	b,64				; 7
	inc	c				; 4
	ld	de,-(12*64)+1			; 10
	out	($10),a				; 11
	add	hl,de				; 11
	ld	de,10				; 10
fastCopyLoop:
	call    catchup
	add	hl,de				; 11
	inc	hl				; 6 waste
	inc	hl				; 6 waste
	inc	de				; 6
	ld	a,(hl)				; 7
	out	($11),a				; 11
	dec	de				; 6
	djnz	fastCopyLoop			; 13/8
	ld	a,c				; 4
	cp	$2B+1				; 7
	jr	nz,fastCopyAgain		; 10/1
	ret					; 10


;bufclr_catchup:
;        ld      de, 768
;        ld      b, 0
;        ld      hl, GRAPH_MEM
;bufclrlp:
;        call    catchup
;        ld      (hl), b
;        inc     hl
;        dec     de
;        ld      a, d
;        or      e
;        jr      nz, bufclrlp
;        ret

;-----------+----------------------------------------------------+----------+
; Telnet 8x | ROM Call Defines                                   | Infiniti |
;-----------+----------------------------------------------------+----------+
;WAITKEY .equ     4CFEh  ; Wait for a key and read
;BUFCLR  .equ     515Bh  ; Clear the graph backup
;BUFCOPY .equ     5164h  ; Copy the graph backup to the screen
;RINDOFF .equ     4795h  ; Turn off runindicator
;PRINTHL .equ     4709h  ; Print HL in dec. on the screen
;OP2TOP1 .equ     41C2h  ; Move OP2 to OP1
;CONVOP1 .equ     4EFCh  ; Convert fp value in OP1 to a 2 byte hex
;READKEY .equ     4A18h  ; Read key and place it in OP2 as a fp value
;GOHOME  .equ     47A1h  ; Go to home screen (finish gfx program)
;CLRTSHD .equ     4765h  ; Clear text shadow
;HOMEUP  .equ     4775h  ; Place cursor at home
;STRING  .equ     470Dh  ; Print 0 terminated string to screen (hl->string)

;-----------+----------------------------------------------------+----------+
; Telnet 8x | Include files                                      | Infiniti |
;-----------+----------------------------------------------------+----------+
#include "sprxor.h"     ; movax's sprxor

;-----------+----------------------------------------------------+----------+
; Telnet 8x | VT100 functions                                    | Infiniti |
;-----------+----------------------------------------------------+----------+
check_partial   .db     0
check_seq:
        ld      ix, vt100table
check_mainlp:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (ix)
        ld      b, a
        cp      255
        jr      z, check_done_nomatch
        push    bc
        push    ix
      call    catchup         ; *-* LINK CHECK *+*
        call    check_seqn
      call    catchup         ; *-* LINK CHECK *+*
        pop     ix
        pop     bc

        cp      1
        jp      z, check_done_partial
        cp      2
        jp      z, check_done_executed
        ld      a, b
        inc     a
        ld      c, a
        ld      b, 0
        add     ix, bc
        inc     ix
        inc     ix
        jp      check_mainlp

check_done_nomatch:
        ld      a, 0
        ret
check_done_partial:
        ld      a, 1
        ret
check_done_executed:
        ld      a, 2
        ret

check_seqn:
        ld      hl, seqbuf+1
        ld      a, 0
        ld      (check_partial), a
        ld      a, (ix)
        ld      b, a
        ld      a, (in_seq)
        dec     a
        cp      b
        call    c, check_resize
        inc     ix
check_seqlp:
      call    catchup         ; *-* LINK CHECK *+*
        push    bc
        ld      a, (ix)
        cp      0
        jr      z, check_digit
        jr      check_norm
check_digit:
        ld      a, (hl)
        sub     '0'
        jr      c, check_bad
        ld      a, (hl)
        sub     '9'+1
        jr      nc, check_bad
        jr      check_ok

check_norm:
        ld      b, a
        ld      a, (hl)
        cp      b
        jr      nz, check_bad
        jr      check_ok

check_ok:
        inc     hl
        inc     ix
        pop     bc
        djnz    check_seqlp

        ld      a, (check_partial)
        cp      1
        ret     z

        ld      hl, check_return_from
        push    hl
        call    cursor_off

        ld      hl, seqbuf+2
        ld      a, (ix)
        ld      c, a
        ld      a, (ix+1)
        ld      b, a
        push    bc
        pop     ix
        jp      (ix)
check_return_from:
        ld      a, 2
      call    catchup         ; *-* LINK CHECK *+*
        ret

check_bad:
        pop     bc
        ld      a, 0
        ret

check_resize:
        ld      b, a
        ld      a, 1
        ld      (check_partial), a
        ret


;-----------+----------------------------------------------------+----------+
; Telnet 8x | VT100 escape sequences                             | Infiniti |
;-----------+----------------------------------------------------+----------+
;i've never had more fun programming...

vt100cursorleftpress:
        ld      b, 1
        jr      vtcurleft
vt100cursorleft:
        call    getparam
        jr      vtcurleft
vt100cursorleftlots:
        call    getparam2
vtcurleft:
        ld      a, (curx)
        sub     b
        call    under0

   LD    HL, (curx)
   LD    L, A
   CALL  move_cursor

;        ld      (curx), a
        ret

vt100cursorrightpress:
        ld      b, 1
        jr      vtcurright
vt100cursorright:
        call    getparam
        jr      vtcurright
vt100cursorrightlots:
        call    getparam2
vtcurright:
        ld      a, (wrap)
        dec     a
        ld      c, a
        ld      a, (curx)
        add     a, b
        call    over_c

   LD    HL, (curx)
   LD    L, A

   CALL  move_cursor
;        ld      (curx), a
        ret

vt100cursoruppress:
        ld      b, 1
        jr      vtcurup
vt100cursorup:
        call    getparam
        jr      vtcurup
vt100cursoruplots:
        call    getparam2
vtcurup:
        ld      a, (cury)
        sub     b
        call    under0

   LD    HL, (curx)
   LD    H, A
   CALL  move_cursor
;        ld      (cury), a
        ret

vt100cursordownpress:
        ld      b, 1
        jr      vtcurdown
vt100cursordown:
        call    getparam
        jr      vtcurdown
vt100cursordownlots:
        call    getparam2
vtcurdown:
        ld      c, 25-1
        ld      a, (cury)
        add     a, b
        call    over_c

   LD    HL, (curx)
   LD    H, A
   CALL  move_cursor
;        ld      (cury), a
        ret

vt100cursorreset:
        ld      c, 1
        ld      b, 1
        jr      vt_gotoxy
vt100changecursor:
        call    getparam
        ld      a, b
        ld      c, a
        inc     hl
        call    getparam
        jr      vt_gotoxy
vt100changeud:
        call    getparam2
        ld      a, b
        ld      c, a
        inc     hl
        call    getparam
        jr      vt_gotoxy
vt100changelr:
        call    getparam
        ld      a, b
        ld      c, a
        inc     hl
        call    getparam2
        jr      vt_gotoxy
vt100changeudlr:
        call    getparam2
        ld      a, b
        ld      c, a
        inc     hl
        call    getparam2
vt_gotoxy:
        ld      a, c
        ld      d, a
        ld      a, b
        ld      c, a
        ld      a, d
        ld      b, a

        dec     c
        dec     b
        ld      a, c
        cp      80
        ret     nc
        ld      a, b
        cp      25
        ret     nc

   LD    H, B
   LD    L, C
   CALL  move_cursor

;        ld      a, c
;        ld      (curx), a
;        ld      a, b
;        ld      (cury), a
        ret

vt100entirescreen:
        ld      hl, term
        ld      bc, 2000
vtclearlp:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, ' '
        ld      (hl), a
        inc     hl
        dec     bc
        ld      a, b
        or      c
        jr      nz, vtclearlp

   LD    HL, 0
   CALL  move_cursor_only
;        ld      a, 0
;        ld      (curx), a
;        ld      (cury), a
        ret

vt100erasebegcursor:
vt100erasecursorend:
;vt100erasecursorend:
        ret

vt100setscrolling:
        call    getparam
        dec     a
        cp      24
        ret     nc
        ld      (n), a
        inc     hl
        call    getparam
        dec     a
        cp      24
        ret     nc
        ld      (n2), a
        jp      vt100ss1
vt100setscrollingb:
        call    getparam
        dec     a
        cp      24
        ret     nc
        ld      (n), a
        inc     hl
        call    getparam2
        dec     a
        cp      24
        ret     nc
        ld      (n2), a
        jp      vt100ss1
vt100setscrollingt:
        call    getparam2
        dec     a
        cp      24
        ret     nc
        ld      (n), a
        inc     hl
        call    getparam
        dec     a
        cp      24
        ret     nc
        ld      (n2), a
        jp      vt100ss1
vt100setscrollingtb:
        call    getparam2
        dec     a
        cp      24
        ret     nc
        ld      (n), a
        inc     hl
        call    getparam2
        dec     a
        cp      24
        ret     nc
        ld      (n2), a
        jp      vt100ss1
vt100ss1:
        ld      a, (n)
        ld      b, a
        ld      a, (n2)
        cp      b
        ret     c
        ld      a, (n)
        ld      (scr_top), a
        ld      a, (n2)
        ld      (scr_bot), a
        ret

vt100storecoords:
vt100restorecoords:
vt100index:
vt100reverseindex:
vt100nextline:
vt100eraseline:
        ret

vt100eraseendline:
        call    getxy
        ld      a, (curx)
        ld      b, a
        ld      a, 80
        sub     b
        cp      0
        ret     z
        ld      b, a

        ld      d, 32
        ld      a, (curattr)
        cp      INVERSE
        jr      nz, vteel_1
        set     7, d
vteel_1:
        ld      a, d
vteel_lp:
        ld      (hl), a
        inc     hl
        djnz    vteel_lp
        ret

;vt100eraseendline:
vt100erasecursor:
        ret

vt100cursorstyle0:
        ld      a, 0
        ld      (curattr), a
        ret
vt100cursorstyle1:
        call    getparam
        ld      (curattr), a
        ret
vt100cursorstyle2:
        call    getparam
        inc     hl
        call    getparam
        ld      (curattr), a
        ret
vt100cursorstyle3:
        call    getparam
        inc     hl
        call    getparam
        inc     hl
        call    getparam
        ld      (curattr), a
        ret
vt100cursorstyle4:
        call    getparam
        inc     hl
        call    getparam
        inc     hl
        call    getparam
        inc     hl
        call    getparam
        ld      (curattr), a
        ret

vt100settab:
vt100cleartab:
;vt100cleartab:
vt100clearalltabs:
vt100statusrep:
vt100whatareyou:
;vt100whatareyou:
vt100reset:
vt100cursorreport:

vt100timefinish:
        ret

getparam:
      call    catchup         ; *-* LINK CHECK *+*
        ld      a, (hl)
        inc     hl
        sub     '0'
        ld      b, a
        ret

getparam2:
      call    catchup         ; *-* LINK CHECK *+*
        push    bc
        ld      a, (hl)
        inc     hl
        sub     '0'
        ;slr     a
        ld      c, a
        ld      b, 9
getparam2lp:
        add     a, c
        djnz    getparam2lp
        ld      c, a
        ld      a, (hl)
        inc     hl
        sub     '0'
        add     a, c
        pop     bc
        ld      b, a
      call    catchup         ; *-* LINK CHECK *+*
        ret

under1:
        jr      c, under1fix
        jr      z, under1fix
        ret
under1fix:
        ld      a, 1
        ret

under0:
        ret     nc
        ld      a, 0
        ret

over_c:
        cp      c
        ret     c
        ret     z
        ld      a, c
        ret

#include "tl8x.h"         ; the file containing the linkport routines

;-----------+----------------------------------------------------+----------+
; Telnet 8x | Code from Zterm for the TI-85 (Zshell)             | Infiniti |
;-----------+----------------------------------------------------+----------+

; The following was taken directly from Zterm.  I love the function table
; concept.  I'm not to fond of the sequence parameter method, though...


    ;format \/\/\/ - - first byte - length of command
    ;                  next few from first byte - command
    ;          next two - place to jump execution
    ;          last in table - $FF, terminator

vt100table:
    .db $04,'[',$00,$00,'D'
    .dw vt100cursorleftlots
    .db $03,'[',$00,'D'
    .dw vt100cursorleft
    .db $02,'[','D'
    .dw vt100cursorleftpress
    .db $03,'[',$00,'C'
    .dw vt100cursorright
    .db $04,'[',$00,$00,'C'
    .dw vt100cursorrightlots
    .db $02,'[','C'
    .dw vt100cursorrightpress
    .db $03,'[',$00,'A'
    .dw vt100cursorup
    .db $04,'[',$00,$00,'A'
    .dw vt100cursoruplots
    .db $02,'[','A'
    .dw vt100cursoruppress
    .db $03,'[',$00,'B'
    .dw vt100cursordown
    .db $04,'[',$00,$00,'B'
    .dw vt100cursordownlots
    .db $02,'[','B'
    .dw vt100cursordownpress

    .db $02,'[','H'
    .dw vt100cursorreset
    .db $03,'[',';','H'
    .dw vt100cursorreset
    .db $05,'[',$00,';',$00,'H'
    .dw vt100changecursor
    .db $06,'[',$00,$00,';',$00,'H'
    .dw vt100changeud
    .db $06,'[',$00,';',$00,$00,'H'
    .dw vt100changelr
    .db $07,'[',$00,$00,';',$00,$00,'H'
    .dw vt100changeudlr
    .db $05,'[',$00,';',$00,'f'
    .dw vt100changecursor
    .db $06,'[',$00,$00,';',$00,'f'
    .dw vt100changeud
    .db $06,'[',$00,';',$00,$00,'f'
    .dw vt100changelr
    .db $07,'[',$00,$00,';',$00,$00,'f'
    .dw vt100changeudlr

    .db $02,'[','J'
    .dw vt100entirescreen
    .db $03,'[','2','J'
    .dw vt100entirescreen
    .db $03,'[','1','J'
    .dw vt100erasebegcursor
    .db $03,'[','0','J'
    .dw vt100erasecursorend
    .db $05,'[',$00,';',$00,'r'
    .dw vt100setscrolling
    .db $06,'[',$00,';',$00,$00,'r'
    .dw vt100setscrollingb
    .db $06,'[',$00,$00,';',$00,'r'
    .dw vt100setscrollingt
    .db $07,'[',$00,$00,';',$00,$00,'r'
    .dw vt100setscrollingtb

    .db $01,'7'
    .dw vt100storecoords
    .db $01,'8'
    .dw vt100restorecoords
    .db $01,'D'
    .dw vt100index
    .db $01,'M'
    .dw vt100reverseindex
    .db $01,'E'
    .dw vt100nextline
    .db $03,'[','2','K'
    .dw vt100eraseline
    .db $02,'[','K'
    .dw vt100eraseendline
    .db $03,'[','0','K'
    .dw vt100eraseendline
    .db $03,'[','1','K'
    .dw vt100erasecursor
    .db $02,'[','m'
    .dw vt100cursorstyle0                       ;vt100cursorstyle
    .db $03,'[',$00,'m'
    .dw vt100cursorstyle1                       ;vt100cursorstyle
    .db $05,'[',$00,';',$00,'m'
    .dw vt100cursorstyle2                       ;vt100cursorstyle
    .db $07,'[',$00,';',$00,';',$00,'m'
    .dw vt100cursorstyle3                       ;vt100cursorstyle
    .db $09,'[',$00,';',$00,';',$00,';',$00,'m'
    .dw vt100cursorstyle4                       ;vt100cursorstyle

    .db $01,'H'
    .dw vt100settab
    .db $02,'[','g'
    .dw vt100cleartab
    .db $03,'[','0','g'
    .dw vt100cleartab
    .db $03,'[','3','g'
    .dw vt100clearalltabs
    .db $03,'[','5','n'
    .dw vt100statusrep
    .db $02,'[','c'
    .dw vt100whatareyou
    .db $03,'[','0','c'
    .dw vt100whatareyou
    .db $01,'c'
    .dw vt100reset
    .db $03,'[','6','n'
    .dw vt100cursorreport

    .db $02,'#',$00             ;this accounts for vt100 commands impossible on 85
    .dw vt100timefinish         ;this label just jumps them back to the end of vt100
    .db $03,'[',$00,'q'
    .dw vt100timefinish
    .db $05,'[',$00,';',$00,'q'
    .dw vt100timefinish
    .db $07,'[',$00,';',$00,';',$00,'q'
    .dw vt100timefinish
    .db $09,'[',$00,';',$00,';',$00,';',$00,'q'
    .dw vt100timefinish
    .db $02,'(','A'
    .dw vt100timefinish
    .db $02,')','A'
    .dw vt100timefinish
    .db $02,'(','B'
    .dw vt100timefinish
    .db $02,')','B'
    .dw vt100timefinish
    .db $02,'(',$00
    .dw vt100timefinish
    .db $02,')',$00
    .dw vt100timefinish
    .db $01,'O'
    .dw vt100timefinish
    .db $01,'N'
    .dw vt100timefinish
    .db $05,'[','2',';',$00,'y'
    .dw vt100timefinish
    .db $03,'[',$00,'h'
    .dw vt100timefinish
    .db $03,'[',$00,'l'
    .dw vt100timefinish
    .db $04,'[',$00,$00,'h'
    .dw vt100timefinish
    .db $04,'[',$00,$00,'l'
    .dw vt100timefinish
    .db $04,'[','?',$00,'h'
    .dw vt100timefinish
    .db $04,'[','?',$00,'l'
    .dw vt100timefinish
    .db $05,'[','?',$00,$00,'h'
    .dw vt100timefinish
    .db $05,'[','?',$00,$00,'l'
    .dw vt100timefinish
    .db $01,'='
    .dw vt100timefinish
    .db $01,'>'
    .dw vt100timefinish
    .db $FF

dumb_key_table:
   .db  $00
   .db  $34,$24,$26,$25,$00,$00,$00,$00
   .db  $A5,$95,$85,$75,$65,$55,$45,$00
   .db  $A4,$94,$84,$74,$64,$54,$44,$00
   .db  $A3,$93,$83,$73,$63,$53,$43,$33
   .db  $A2,$92,$82,$72,$62,$52,$42,$32
   .db  $A1,$91,$81,$71,$61,$51,$41,$31
   .db  $15,$14,$13,$12,$11,$21,$22,$23


keypad_table
        .db   0,  0,  0,  0,  0
        .db   0,  0,  8,  0,  0
        .db   0,  0, 27,  0,  0
        .db 'a','b','c',  9,  0
        .db 'd','e','f','g','h'
        .db 'i','j','k','l','m'
        .db 'n','o','p','q','r'
        .db 's','t','u','v','w'
        .db 'x','y','z','@', 34
        .db   0,' ','.','/', 13

        .db   0,  0,  0,  0,  0
        .db   0,  0,  8,  0,  0
        .db   0,  0, 27,  0,  0
        .db   0,  0,  0,  9,  0
        .db   0,  0,  0,  0,'^'
        .db   0,',','(',')','/'
        .db   0,'7','8','9','*'
        .db '<','4','5','6','-'
        .db '>','1','2','3','+'
        .db   0,'0','.','\', 13

        .db   0,  0,  0,  0,  0
        .db   0,  0,  8,  0,  0
        .db   0,  0, 27,  0,  0
        .db 'A','B','C',  9,  0
        .db 'D','E','F','G','H'
        .db 'I','J','K','L','M'
        .db 'N','O','P','Q','R'
        .db 'S','T','U','V','W'
        .db 'X','Y','Z','@', 39
        .db   0,' ',':','?', 13

        .db   0,  0,  0,  0,  0
        .db   0,  0,  8,  0,  0
        .db   0,  0, 27,  0,  0
        .db   0,  0,  0,  9,  0
        .db   0,  0,  0,  0,'_'
        .db   0,'`','{','}','|'
        .db   0,'&','*','(','['
        .db '<','$','%','^',']'
        .db '>','!','@','#','~'
        .db   0,')',';','?','='

        .db   0,  0,  0,  0,  0
        .db   0,  0,127,  0,  0
        .db   0,  0, 27,  0,  0
        .db   1,  2,  3,  7,  0
        .db   4,  5,  6,  7,  8
        .db   9, 10, 11, 12, 13
        .db  14, 15, 16, 17, 18
        .db  19, 20, 21, 22, 23
        .db  24, 25, 26, 27, 29
        .db   0,')',';','?','='

;-----------+----------------------------------------------------+----------+
; Telnet 8x | The 80x25 display                                  | Infiniti |
;-----------+----------------------------------------------------+----------+
term
         .db "Telnet83 Plus v1.9      "
         .db "                        "
         .db "                        "
         .db "        "

        .db "by Justin Karneges, 2001"
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "[GRAPH]=Quit            "
         .db "                        "
         .db "                        "
         .db "        "

        .db "[2nd]  =Numeric         "
         .db "                        "
         .db "                        "
         .db "        "

        .db "[ALPHA]=Capital         "
         .db "                        "
         .db "                        "
         .db "        "

        .db "[MODE] =Extra           "
         .db "                        "
         .db "                        "
         .db "        "

        .db "[X]    =Ctrl            "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

        .db "                        "
         .db "                        "
         .db "                        "
         .db "        "

         .db 0                         ; cursor goes here when screen full

whitespace
        .db 32,32,32,32,32,32,32,32,32,32,32,32
        .db 32,32,32,32,32,32,32,32,32,32,32,32
        .db 32,32,32,32,32,32,32,32,32,32,32,32
        .db 32,32,32,32,32,32,32,32,32,32,32,32
        .db 32,32,32,32,32,32,32,32,32,32,32,32
        .db 32,32,32,32,32,32,32,32,32,32,32,32
        .db 32,32,32,32,32,32,32,32

erase
        .db 11110000b
        .db 11110000b
        .db 11110000b
        .db 11110000b
        .db 11110000b
        .db 11110000b
        .db 00000000b
        .db 00000000b

mmg1
        .db 11111111b
        .db 10000000b
        .db 10000000b
        .db 10000000b
        .db 10000000b
        .db 10000000b
        .db 10000000b
        .db 10000000b
mmg2
        .db 11110000b
        .db 00010000b
        .db 00010000b
        .db 00010000b
        .db 00010000b
        .db 00010000b
        .db 00010000b
        .db 00010000b
mmg3
        .db 10000000b
        .db 11111111b
        .db 00000000b
        .db 00000000b
        .db 00000000b
        .db 00000000b
        .db 00000000b
        .db 00000000b
mmg4
        .db 00010000b
        .db 11110000b
        .db 00000000b
        .db 00000000b
        .db 00000000b
        .db 00000000b
        .db 00000000b
        .db 00000000b

#include "font.h"       ; the file containing the font

;-----------+----------------------------------------------------+----------+
; Telnet 8x | Well, that's all folks!                            | Infiniti |
;-----------+----------------------------------------------------+----------+
.end
