; TL.H
;
; sendrecv.h MUST contain the following functions:
;
; checkbyte -
;       input: none
;       return: carry flag set if no byte was recieved, otherwise A = byte
;
; send_outbyte -
;       input: A = byte to send
;       return: none
;
#include "sndrec8x.h"

check_recv:
   XOR   A
   LD    BC, (recv_start)
   LD    HL, (recv_end)
   SBC   HL, BC
   RET   Z
   INC   A
   RET

;check_send:
;        ret
;sendbyte:
;        call    send_outbyte
;        ret

catchup:
        push    af

        call    checkbyte
        jr      c, catchupnofirst

        push    hl
        push    de
        push    bc
        jr      catchupnext

catchuplp:
        call    checkbyte
        jr      c, catchupdone

catchupnext:
        ld      bc, (recv_end)
        ld      hl, recvbuf
        add     hl, bc
        ld      (hl), a
        ld      hl, MAXRECV
        inc     bc
        sbc     hl, bc
        jr      nz, catchup2
        ld      bc, 0
catchup2:
        ld      (recv_end), bc
        jr      catchuplp

catchupnofirst:
        pop     af
        ret

catchupdone:
        pop     bc
        pop     de
        pop     hl
        pop     af
        ret

recvbyte:
        xor     a
        ld      hl, (recv_start)
        ld      bc, (recv_end)
        sbc     hl, bc
        ret     z

        ld      hl, recvbuf
        ld      bc, (recv_start)
        add     hl, bc
        ld      a, (hl)
        ld      hl, MAXRECV
        inc     bc
        sbc     hl, bc
        jr      nz, recvbyte2
        ld      bc, 0
recvbyte2:
        ld      (recv_start), bc

        ld      b, a
        xor     a
        inc     a
        ld      a, b
        ret

;#define MAXSEND 96
MAXRECV  = 2000
;send_start      .dw     0
;send_end        .dw     0
recv_start      .dw     0
recv_end        .dw     0

;sendbuf
;.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

recvbuf
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.dw     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
