	.nolist		
	#include "ion.inc"
	.list		
#ifdef TI83P		
	.org progstart-2
	.db $BB,$6D

TEXT_MEM  = $8508
APD_BUF   = $86EC
TEXT_MEM2 = $8A3A
hxl = $4276

#else		
	.org progstart

TEXT_MEM  = $80c9
APD_BUF   = $8265
TEXT_MEM2 = $858f
hxl = $4382


#endif		
	xor a	
	jr nc,Start
	.db "BaseBall 99 1.0",0

_clearlcdf = _clrlcdf

curspos = TEXT_MEM
outs = TEXT_MEM+1
strikes = TEXT_MEM+2
balls = TEXT_MEM+3
innings = TEXT_MEM+4
player1score = TEXT_MEM+5
player2score = TEXT_MEM+6
Turn = TEXT_MEM+7
SPEED = TEXT_MEM+8
answer = TEXT_MEM+9
string = TEXT_MEM+15
sprY = TEXT_MEM+22
sprX = TEXT_MEM+23
ballX = TEXT_MEM+24
ballY = TEXT_MEM+25

;Flags

Base1Flag = TEXT_MEM+26
Base2Flag = TEXT_MEM+27
Base3Flag = TEXT_MEM+28
players = TEXT_MEM+29
DerbyFlag = TEXT_MEM+30 
BallFlag  = TEXT_MEM+31

;Counters

HitCounter = TEXT_MEM+32
player1name = TEXT_MEM+33
player2name = TEXT_MEM+38

Start:
 res 2,(iy+13)
 res 1,(iy+13)

 bcall(_cleargbuf) ;Clear Graph Buffer

 call ClearTxt 


        ld      DE,Title1           ; HL = address of ZCP compressed data
        ld      HL,GRAPH_MEM         ; DE = address of where uncompressed
                                      ;      data will come
        Call DecodeZCP
 bcall(_copygbuf)
 call OTH_PAUSE2

 ld a,(SGAME)
 dec a
 jp nz,ReStart

 ld a,1
 ld (innings),a
 ld (Base1Flag),a
 ld (Base2Flag),a
 ld (Base3Flag),a

Title:
	bcall(_clrlcdf)
        ld h,1
        ld      BC, 0*256+55
        ld      DE, 96*256+55
         bcall(_iline)

         ld       de,$0200
         ld       hl,title2
	 call DTX

	 ld       hl,copy
         ld       de,$0913
         call DMX
         
         ld       de,$101f-2
         call DMX

         ld       de,$2019
         call DMX

         ld       de,$2819
         call DMX

	 ld hl,seas
         ld       de,$3019
         call DMX

	ld hl,portmaster
	ld de,57*256+5
	call DMX

intro_loop:

       ld       hl,curspos                 ; Redraw arrow
       ld       a,(hl)
       cp       255
       jr       c,duh
       ld       a,2
duh:
       cp       3
       jr       c,position_ok
       ld  a,0

position_ok:
        ld       (hl),a

        LD a,(curspos)
        inc a
	  ld d,$03
 	  add a,d
        ld e,a
 	  ld a,5
 	  ld (currow),de
	bcall(_putc)
Title_key
        bcall(_getK)  ; Read and process keystrokees

         ld       hl,curspos
         cp       $0f
         jp z,quit2
         cp       $09
         jr       z,selected
         cp       $04
         jr       nz,no_up
         call ClearArrow
         dec      (hl)
         jr        intro_loop

no_up:   cp       $01
         jr       nz,Title_key
         call ClearArrow
         inc      (hl)
         jr       intro_loop

selected:
         ld       a,(curspos)
         or a
         jr       z,HomeRunDerby_Mode
         dec      a
         jr       z,Exhibition_Mode
         jp       Season_Mode

ClearArrow:
 ld a,(curspos)
 add a,4
 ld e,a
 ld d,$03
 ld a,32
 ld (currow),de
 bcall(_putc)
 ret

ReStart:
 ld de,outs
 ld hl,SaveData
 ld bc,41
 ldir
 ld a,1
 ld (SGAME),a
 call DisplayInfo
 call LoadSprData
 ld hl,Batter
 call PutSprite
 bcall(_copygbuf)
 jp Wait

HomeRunDerby_Mode:
 ld a,2
 ld (DerbyFlag),a
 dec a
 ld (SeasonFlag),a
 jr PROGSTART2
Exhibition_Mode:
 ld a,1
 ld (DerbyFlag),a
 ld (SeasonFlag),a
PROGSTART2:
 bcall(_clrlcdf)
 ld de,$1010
 ld hl,PlayerChoose
 call DMX              ; "Choose player mode"
 ld de,$0404
 call DTX              ; "1 player"
 inc e
 call DTX              ; "2 players"
 ld a,1
 ld (players),a        ; Default option, 1 player
ChoosePlayers:
 ld a,(players)
 ld d,$03
 push af
 add a,d
 ld e,a
 ld a,5
 call DCX   ; Put the small arrow
 pop af
 sub 6
 neg
 ld e,a
 ld   a,32
 call DCX
WKCP:
 bcall(_getK)
 ld hl,players
 cp $0f
 jp z,quit2
 cp $09
 jp z,G_Start
 cp $04
 jr z,ChangePlayers
 cp $01
 jr z,ChangePlayers
 jr WKCP
ChangePlayers:
 ld a,(hl)
 xor 3                 ; This will turn 1 -> 2 and 2 -> 1
 ld (hl),a
 jr ChoosePlayers


WriteName:
 bcall(_clrlcdf)
 ld hl,seasonname
 call Write
 xor a
 ld (wins),a
 ld (losses),a
 ld (runs),a
 ld (homeruns),a
 ld a,50
 ld (games),a
 jr SeasonStart

StartSeasonOver:
 ld a,1
 ld (SeasonFlag2),a
Season_Mode:
 bcall(_clrlcdf)
 ld a,1
 ld (players),a
 ld (DerbyFlag),a
 ld a,(SeasonFlag2)
 dec a
 jr z,WriteName
 bcall(_clrlcdf)
 ld de,$1017
 ld hl,Season_2
 call DMX
 ld de,$0704
 call DTX             
 inc e
 call DTX       
 ld a,1
 ld (answer),a
ChooseAnswer:
 ld a,(answer)
 ld d,$06
 push af
 add a,d
 add a,-3
 ld e,a
 ld a,5
 call DCX   ; Put the small arrow
 pop af
 sub 6
 neg
 ld e,a
 ld a,32
 call DCX   ; And remove it from the other position
WKCP2:
 bcall(_getK)
 ld hl,answer
 cp $0f
 jp z,quit2
 cp $09
 jr z,SeasonStarter
 cp $04
 jr z,ChangeAnswer
 cp $01
 jr z,ChangeAnswer
 jr WKCP2
ChangeAnswer:
 ld a,(hl)
 xor 3                 ; This will turn 1 -> 2 and 2 -> 1
 ld (hl),a
 jr ChooseAnswer

SeasonStarter:
 ld a,(answer)
 dec a
 jp nz,StartSeasonOver

SeasonStart:
 call ShowSeasonInfo
 call OTH_PAUSE2
 ld a,2
 ld (SeasonFlag2),a
 ld (SeasonFlag),a
 ld a,(seasonname)
 ld (player1name),a
 ld a,(seasonname+1)
 ld (player1name+1),a
 ld a,(seasonname+2)
 ld (player1name+2),a
 jr SeasJump
Quitter:
 ld a,1
 ld (SeasonFlag),a
 ret

G_Start:
 bcall(_clrlcdf)
 ld hl,player1name
 call Write
 ld a,(players)
 dec a
 jr nz,Write2
SeasJump:
 ld a,25
 call RANDOM
 ld h,4
 ld l,a
 bcall(hxl)  ;32 teams times 4 gaps per team
 ld d,h
 ld e,l
 ld hl,Teams
 add hl,de
 ld de,player2name
 ld bc,3
 ldir
 jr GameStart
Write2:
 bcall(_clrlcdf)
 ld hl,P2
 ld de,$1420
 call DMX
 ld hl,player2name
 call Write
GameStart:
 call DisplayInfo
 ld b,$41
 ld c,$33
 ld a,b
 ld (sprX),a
 ld a,c
 ld (sprY),a
 ld hl,Runner
 call PutSprite
 bcall(_copygbuf)
 ld b,3
Intro:
 push bc
 call DELAY
 call DELAY
 call LoadSprData
 ld hl,Runner
 call PutSprite
 ld a,c
 inc a
 ld (sprY),a
 ld c,a
 ld a,b
 add a,-4
 ld (sprX),a
 ld b,a
 call PutSprite
 bcall(_copygbuf)
 pop bc
 djnz Intro

 call DELAY
 call DELAY
 call LoadSprData
 ld hl,Runner
 call PutSprite
 ld a,c
 add a,3
 ld c,a
 ld (sprY),a
 ld a,b
 add a,-11
 ld (sprX),a
 ld b,a
 ld hl,Batter
 call PutSprite
 bcall(_copygbuf)
Wait:
 bcall(_getK)
 cp $09
 jp z,StartPitch
 cp $37
 jr z,Pause
 cp $38
 jr z,Save
 cp $0f
 jr nz,Wait
 ld a,(SeasonFlag)
 dec a
 call nz,Save
Quit2:
 set 1,(iy+13)
 set 2,(iy+13)
 call ClearTxt
 ret 

Save:
 ld hl,outs
 ld de,SaveData
 ld bc,41
 ldir
 ld a,2
 ld (SGAME),a
 ret

Pause:
  RES 4, (IY $09)     ; Turn off 'ON' flag
  DI                  ; disable interrupts
  LD  A, 01           ; bit 3 = lcd status
  OUT ($03), A        ; bit 0 = ON-interrupt status
  XOR A               ; make interrupts go fast
  OUT ($04), A
  EI                  ; enable interrupts
  HALT                ; wait for ON (that's the only interrupt)
  DI
  LD  A, $16          ; Default setting for interrupts
  OUT ($04), A
  jr Wait 

StartPitch:
 ld a,80
 ld (HitCounter),a
 call RAND3
 inc a
 ld (SPEED),a
 ld b,$2F
 ld a,b
 ld (ballX),a
 ld c,$2C
 ld a,c
 ld (ballY),a
 ld hl,ball
 call PutSprite
 ld b,17
Move_Pitch:
 push bc
 call LoadBallData
 call PutSprite
 ld a,c
 inc a
 ld c,a
 ld (ballY),a
 ld hl,ball
 call PutSprite
 bcall(_copygbuf)
 call DELAY2
 call DELAY2
 call DELAY2
 call DELAY2
 call DELAY2

Pitch_Cont:
 pop bc
 djnz Move_Pitch
 call RAND3
 inc a
 dec a
 jp z,Ball2
 jp Strike

SwingBat:
 pop bc
 inc sp
 inc sp
 inc sp
 inc sp
 call LoadSprData
 ld hl,Batter
 call PutSprite
 ld hl,PlayerSwing1
 call PutSprite
 bcall(_copygbuf)

SwingCont:
 ld a,(HitCounter)
 dec a
 jp z,Out_2_First
 dec a
 jp z,Triple_2_Right
 dec a
 jp z,Out_2_Right 
 dec a
 jp z,Single_2_Right
 dec a
 jp z,Out_2_Second
 dec a
 jp z,HomeRun
 dec a
 jp z,Out_2_Short 
 dec a
 jp z,Single_2_Left
 dec a
 jp z,Out_2_Left
 dec a
 jp z,Double_2_Left 
 dec a
 jp z,Out_2_Third
 jp Strike

SwingEnd:
 call OTH_PAUSE
 call DisplayInfo
 call LoadSprData
 ld hl,Batter
 call PutSprite
 bcall(_copygbuf)
 jp Wait
  
Out_2_Short:
 ld b,9
Out1Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 ld b,a
 ld (ballX),a
 call O_Mid
 pop bc
 djnz Out1Move
 jp Out 

Out_2_Second: 
 ld b,9
Out2Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 ld b,a
 ld (ballX),a
 call O_Mid
 pop bc
 djnz Out2Move
 jp Out  

O_Mid:
 ld a,c
 dec a
 dec a
 dec a
 ld c,a
 ld (ballY),a
 call PutSprite
 bcall(_copygbuf)
 call DELAY
 ret


Out_2_Third: 
 ld b,11
Out3Move:
 call Left_Move
 jp Out  

Left_Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 dec a
 ld b,a
 ld (ballX),a
 call Trip
 pop bc
 djnz Left_Move
 ret

Move_Right:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 inc a
 ld b,a
 ld (ballX),a
 call Trip
 pop bc
 djnz Move_Right
 ret

Trip:
 ld a,c
 dec a
 dec a
 ld c,a
 ld (ballY),a
 call PutSprite
 bcall(_copygbuf)
 call DELAY
 ret

Out_2_First: 
 ld b,11
 call Move_Right
 jp Out  

Single_2_Left: 
 ld b,11
Single1Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 dec a
 ld b,a
 ld (ballX),a
 call Sing
 pop bc
 djnz Single1Move
 jp Single 


Single_2_Right: 
 ld b,11
Single2Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 inc a
 ld b,a
 ld (ballX),a
 call Sing
 pop bc
 djnz Single2Move
 jp Single  

Sing:
 ld a,c
 dec a
 dec a
 dec a
 dec a
 ld c,a
 ld (ballY),a
 call PutSprite
 bcall(_copygbuf)
 call DELAY
 ret


Ball2:
 call DerbyCheck
 ld a,(balls)
 inc a
 ld (balls),a
 cp 4
 jr c,ContBall
 call ClearStats
 call Single
ContBall:
 ld de,$1429
 ld hl,I2
 call DMX
 jp SwingEnd


Out_2_Left:
 ld b,12
Out5Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 dec a
 dec a
 ld b,a
 ld (ballX),a
 call Pop_Out
 pop bc
 djnz Out5Move
 jp Out  

Out_2_Right:
 ld b,12
Out6Move:
 push bc
 call LoadBallData
 call PutSprite
 ld a,b
 inc a
 inc a
 ld b,a
 ld (ballX),a
 call Pop_Out
 pop bc
 djnz Out6Move
 jp Out  

Pop_Out:
 ld a,c
 add a,-3
 ld c,a
 ld (ballY),a
 call PutSprite
 bcall(_copygbuf)
 call DELAY
 ret

Strike:
 call DerbyCheck
 ld a,(strikes)
 inc a
 ld (strikes),a
 cp 3
 jr c,ContStrike
 call ClearStats
 ld a,(outs)
 inc a
 ld (outs),a
 cp 3
 jp nc,ChangeTurn
ContStrike:
 ld de,$1426
 ld hl,InfoTxt
 call DMX
 jp SwingEnd


Out:
 call ClearStats
 call DerbyCheck
 ld a,(outs)
 inc a
 ld (outs),a
 cp 3
 jr nc,ChangeTurn
OutDisp:
 ld de,$142B
 ld hl,I3
 call DMX
 jp SwingEnd

ClearStats:
 xor a
 ld (strikes),a
 ld (balls),a
 ret

;
; Scoring and Inning Routines
;


ChangeTurn:
 bcall(_copygbuf)
 ld de,$142B
 ld hl,I3
 call DMX
 call OTH_PAUSE
 xor a
 ld (outs),a 
 inc a
 ld (Base1Flag),a
 ld (Base2Flag),a
 ld (Base3Flag),a
 ld a,(Turn)
 inc a
 ld (Turn),a
 cp 1
 call nc,CheckTwoWin
 ld a,(Turn)
 inc a
 dec a
 cp 2
 jr nc,IncInn
 bcall(_clearlcdf)
 ld a,(players)
 dec a
 jr z,RandomScore
 ld de,$0403
 ld hl,P2
 call DTX
 call OTH_PAUSE
 jp GameStart

RandomScore:
 xor a
 ld (Turn),a
 call RAND3
 cp 1
 jr c,IncInn  ;1/3 chace of no score

 call RAND2
 jr nz,LoadScore ;1/3 chance of one run
 call RAND3
 inc a        ;1/3 chace of 2-4 runs
 inc a
LoadScore:
 ld b,a
 ld       a,(player2score)
 add      a,b
 ld       (player2score),a
 jr IncInn

CheckTwoWin:
 ld a,(innings)
 cp 9
 ret c  ;Return if not 9th
 call LoadScores
 bcall(_cphlde)
 jr c,twowin2
 ret

twowin2:
 inc sp
 inc sp  ;Update Stack
 jp twowin

LoadScores:
 ld hl,player2score
 ld e,(hl)
 ld d,0
 ld hl,player1score
 ld l,(hl)
 ld h,0
 ret

IncInn:
 ld a,(DerbyFlag)
 dec a
 jr nz,Quit
 xor a
 ld (Turn),a
 ld a,(innings)
 inc a
 ld (innings),a
 cp 10
 jr nc,Quit
Inn2:
 bcall(_clearlcdf)
 ld de,$0803
 ld hl,innings
 call DCX2 
 ld de,$0303
 ld hl,Itxt
 call DTX
 call OTH_PAUSE
 jp GameStart

;*
;*  Winning Routines
;*

Quit:
 call LoadScores
 bcall(_cphlde)
 jr nc,onewin
twowin:
 ld a,(SeasonFlag)
 dec a
 call nz,AddLoss
 call ShowFinal
 ld de,$0103
 ld hl,P2
 call DTX
 ld de,$0A03
 ld hl,info_text2+9
 call DTX
 call OTH_PAUSE
 jp quit2

OTH_PAUSE:
 bcall(_getK)
 cp $09
 jr nz,OTH_PAUSE
 ret

onewin:
 call LoadScores
 inc e

 bcall(_cphlde)
 jp c,Inn2
 ld a,(SeasonFlag)
 dec a
 call nz,AddWin
 call ShowFinal
 ld de,$0103
 ld hl,info_text2
 call DTX
 call OTH_PAUSE
 jp quit2

ShowFinal:
 call DisplayInfo
 ld de,$141F
 ld hl,Final
 call DMX
 call OTH_PAUSE
 bcall(_clearlcdf)
 ret

AddWin:
 ld a,(wins)
 inc a
 ld (wins),a
 ld a,(games)
 dec a
 ld (games),a
 jr z,SeasonEnd
 ret

AddLoss:
 ld a,(losses)
 inc a
 ld (losses),a
 ld a,(games)
 dec a
 ld (games),a
 jr z,SeasonEnd
 ret

YouLose:
 set 3,(iy+5)
 ld de,$0203
 ld hl,lost
 call DTX
 res 3,(iy+5)
 call OTH_PAUSE
 jr Ending2
 

SeasonEnd:
 call ShowSeasonInfo
 call OTH_PAUSE
 bcall(_clearlcdf)
 ld a,(wins)
 cp 32
 jr c,YouLose
SEA:
 ld de,0
 ld hl,Ending_1
 call DTX
 inc e
 inc e
 ld hl,e2
 call DTX
 ld de,$0203
 ld hl,title2
 call DTX
 inc e
 ld hl,Seas
 call DTX
 ld de,$0006
 ld hl,e3
 call DTX
 call OTH_PAUSE
Ending2:
 bcall(_clearlcdf)
 ld de,$0D13
 ld hl,Ending_2
 call DMX
 ld hl,aut
 ld de,$141E
 call DMX
 ld hl,e4
 ld de,$1B0B
 call DMX
 ld de,$2608
 call DMX
 ld de,$2C00
 call DMX
 ld de,$3320
 call DMX
 ld b,255
 call D_WAIT
 ld b,150
 call D_WAIT

 bcall(_clearlcdf)
 ld de,$0C1C
 ld hl,Ending_3
 call DMX
 ld de,$141E
 call DMX
 ld de,$1C1C
 call DMX
 ld b,255
 call D_WAIT
 ld b,150
 call D_WAIT
 ld a,1
 ld (SeasonFlag2),a
 jp quit2

DerbyCheck:
 ld a,(DerbyFlag)
 dec a
 ret z
 inc sp
 inc sp
 ld a,(outs)
 inc a
 ld (outs),a
 cp 15
 jp nc,ChangeTurn
 jp OutDisp
 
 

Single:
 call ClearStats
 call DerbyCheck
 ld a,(Base3Flag)
 dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
 dec a
 call nz,MoveSecond1
 ld a,(Base1Flag)
 dec a
 call nz,MoveFirst1
 call SetFirst
 ld de,$1428
 ld hl,I4
 call DMX
 jp SwingEnd

SetFirst:
 ld a,2
 ld (Base1Flag),a
 ret

SetSecond:
 ld a,2
 ld (Base2Flag),a
 ret
 
SetThird:
 ld a,2
 ld (Base3Flag),a
 ret

MoveFirst1:
 ld a,1
 ld (Base1Flag),a
 inc a
 ld (Base2Flag),a
 ret
 
MoveSecond1:
 ld a,1
 ld (Base2Flag),a
 inc a
 ld (Base3Flag),a
 ret

MoveThird1:
 ld a,1
 ld (Base3Flag),a
 jp ScoreRun

MoveFirst2:
 ld a,1
 ld (Base1Flag),a
 inc a
 ld (Base3Flag),a
 ret
 
MoveSecond2:
 ld a,1
 ld (Base2Flag),a
 jp ScoreRun

MoveFirst3:
 ld a,1
 ld (Base1Flag),a
 jp ScoreRun

ShowFirst:
 ld b,$47
 ld c,$28
 ld hl,Base1
 call PutSprite
 ret

ShowSecond:
 ld b,$2D
 ld c,$19
 ld hl,Base2
 call PutSprite
 ret

ShowThird:
 ld b,$15
 ld c,$28
 ld hl,Base3
 call PutSprite
 ret

Double:
 call ClearStats
 call DerbyCheck
 ld a,(Base3Flag)
 dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
 dec a
 call nz,MoveSecond2
 ld a,(Base1Flag)
 dec a
 call nz,MoveFirst2
 call SetSecond
 ld de,$1428
 ld hl,I5
 call DMX
 jp SwingEnd

Double_2_Left:
 call RAND2
 jp z,Out_2_Third 
 ld b,17
Double1Move:
 call Left_Move
 call RAND2
 jr z,Double
 jr Triple 

Triple_2_Right:
 call RAND2
 jp z,Out_2_First 
 ld b,17
TripleMove:
 call Move_Right
 call RAND2
 jp z,Double

Triple:
 call ClearStats
 call DerbyCheck
 ld a,(Base3Flag)
  dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
  dec a
 call nz,MoveSecond2
 ld a,(Base1Flag)
  dec a
 call nz,MoveFirst3
 call SetThird
 ld de,$1428
 ld hl,I6
 call DMX
 jp SwingEnd


PopOut:
 ld b,15
 jr HomeMove

HomeRun:
 call ClearStats
 call RAND2
 inc a
 push af
 dec a
 jr nz,PopOut
 ld b,20
HomeMove:
 push bc
 call LoadBallData
 call PutSprite
 ld a,c
 add a,-3
 ld c,a
 ld (ballY),a
 call PutSprite
 bcall(_copygbuf)
 call DELAY
 pop bc
 djnz HomeMove
 pop af
 dec a
 jp nz,Out
 ld a,(Base3Flag)
  dec a
 call nz,MoveThird1
 ld a,(Base2Flag)
  dec a
 call nz,MoveSecond2
 ld a,(Base1Flag)
  dec a
 call nz,MoveFirst3
 ld a,(SeasonFlag)
 dec a
 call nz,IncHome
 call ScoreRun
 ld de,$1422
 ld hl,I7
 call DMX
 jp SwingEnd

IncHome:
 ld a,(homeruns)
 inc a
 ld (homeruns),a
 ret

IncRun:
 ld a,(runs)
 inc a
 ld (runs),a
 ret

ScoreRun:
 ld a,(Turn)
 dec a
 jr z,Score2
 ld a,(SeasonFlag)
 dec a
 call nz,IncRun
 ld a,(player1score)
 inc a
 ld (player1score),a
 ret

Score2:
 ld a,(player2score)
 inc a
 ld (player2score),a
 ret

;
;Misc Routines
;

PutSprite:
	push    BC
	push    DE
	ld      DE, GRAPH_MEM
convdone:
	ld      A, 63
	sub     C
	ld      C, A
	push    HL
	push    HL
	call    FIND_PIXEL
	add     HL, DE
	ex      DE, HL
	pop     HL
	ld      B, (HL)
	inc     HL
	ld      C, (HL)
	inc     HL
	push    HL
	pop     IX
	ex      DE, HL
PS_NewRow:
	push    BC
	ld      D, (IX)
	inc     IX
	push    AF
	push    HL
PS_NewCol:
	rl      D
	ld      E, A
	jr      nc, PS_NextPixel
	xor     (HL)
	ld      (HL), A
PS_NextPixel:
	ld      A, E
	rrca
	jr      nc, PS_SameByte
	inc     HL
PS_SameByte:
	djnz    PS_NewCol
	pop     HL
	pop     AF
	ld      DE, 12
	add     HL, DE
	pop     BC
	dec     C
	jr      nz, PS_NewRow
	pop     HL
	pop     DE
	pop     BC
      ret

Write:
 push hl
 ld de,0
 ld hl,EnterN
 call DTX            ;Added to save bytes
 ld hl,$0604
 ld (currow),hl
 pop hl
;
;Real routine starts here
;
         push     hl
         ld       b,3
space_loop:
         ld       (hl), ' '
         inc      hl
         djnz     space_loop
         pop      ix

enter_name_loop:
         bcall(_getK)
         or       A
         jr       z,enter_name_loop
         cp       $38
         jr       z,backup
         SUB      9
         ret      z
         dec      a
         jp       m,enter_name_loop
         ld       hl,chartable
         ld       e,a
         ld       d,0
         add      hl,de
         ld       a,3
         cp       b
         jr       z,enter_name_loop
         ld       a,(hl)
         or       a
         jr       z,enter_name_loop
         ld       (ix),a
 bcall(_putc)
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  xor      a
         cp       b
         jr       z,enter_name_loop
         dec      b
         dec      ix
         ld       a,' '

         ld       (ix),a
         ld       hl,curcol
         dec      (hl)
 bcall(_putc)
         dec      (hl)
         jr       enter_name_loop

chartable:
         .db      ":WRMH."
         .DB      "..0VQLG!..ZUPKFC"
         .DB      "..YTOJEBX.>SNIDA"
         .DB      ".12345.."


DisplayInfo:
 bcall(_cleargbuf)
        ld      DE,field           ; HL = address of ZCP compressed data
        ld      HL,GRAPH_MEM+12      ; DE = address of where uncompressed
                                      ;      data will come
        Call DecodeZCP
        ld hl,field2
        ld de,GRAPH_MEM
        ld bc,12
        ldir
 ld a,(Base3Flag)
  dec a
 call nz,ShowThird
 ld a,(Base2Flag)
  dec a
 call nz,ShowSecond
 ld a,(Base1Flag)
  dec a
 call nz,ShowFirst
 set 7,(iy+$14)
 ld de,$3248
 ld hl,player1name
 call DMX
 ld de,$3848
 ld hl,player2name
 call DMX
 ld de,$2C08
 ld hl,strikes
 ld b,1
 call DM_HL_DECI
 ld de,$3208
 ld hl,balls
 ld b,1
 call DM_HL_DECI
 ld de,$3808
 ld hl,outs
 ld b,1
 call DM_HL_DECI
 ld de,$3816
 ld hl,innings
 ld b,2
 call DM_HL_DECI
 ld de,$3257
 ld hl,player1score
 ld b,2
 call DM_HL_DECI
 ld de,$3857
 ld hl,player2score
 ld b,2
 call DM_HL_DECI
 ld a,(DerbyFlag)
 dec a
 call nz,DispDerbyInfo
 res 7,(iy+$14)
 bcall(_copygbuf)
 ret

ShowSeasonInfo:
 bcall(_clearlcdf) 
 ld de,$0904
 ld a,(wins)
 call DCX2 

 ld de,$0905
 ld a,(losses)
 call DCX2

 ld de,$0907
 ld a,(games)
 call DCX2
 ld de,$0901
 ld a,(homeruns)
 call DCX2

 ld de,$0902
 ld a,(runs)
 call DCX2

 set 3,(iy+5) ;inverse text
 ld de,0
 ld hl,Season_1
 call DTX
 res 3,(iy+5)
 ld de,$0101
 call DTX
 ld de,$0102
 call DTX
 ld de,$0104
 call DTX
 ld de,$0105
 call DTX
 ld de,$0106
 call DTX
 ld de,$0007
 call DTX
 ld a,(wins)
 ld b,a
 ld a,(losses)
 add a,b
 or a
 jr z,no_stats
 ld l,b
 ld h,100
 push af
 bcall(hxl)  	; wins*100
 pop af
 bcall($4012) ;  (100*wins)/total
 ld de,$0906
 call DCX3

 ld a,$25
 bcall(_putc)
no_stats:
 ret

DTX:
         ld       (currow),de
 bcall(_puts)         
 ret


DispDerbyInfo:
 ld de,$3802
 ld hl,derbyT
 call DMX
 ld de,$3808
 ld hl,outs
 ld b,2
 call DM_HL_DECI
 ld de,$381A
 ld hl,innings
 ld b,1

DM_HL_DECI:
 ld (pencol),de
 ld l,(hl)            ;Stuff added to save bytes
 ld h,0

;Routine Starts here
 ld de,string+5
 xor a
 ld (de),a
RepUnp:
 dec de
 bcall(_divhlby10)
 add a,48
 ld (de),a
 djnz RepUnp
 ex de,hl
 jr DMX2


DMX:
         ld       (pencol),de
DMX2:
 bcall(_vputs)
         ret

DCX:
 ld (currow),de
 bcall(_putc)
 ret

DCX2:
 ld l,a
 ld h,0
DCX3:
 ld (currow),de
 or a
 jr z,Disp0
 bcall(_disphl)
 ret

Disp0:
 ld a,'0'
 bcall(_putc)
 ret

LoadSprData:
 ld a,(sprX)
 ld b,a
 ld a,(sprY)
 ld c,a
 ret

LoadBallData:
 ld a,(ballX)
 ld b,a
 ld a,(ballY)
 ld c,a
 ld hl,ball
 ret

DELAY:
 ld b,13
D_WAIT:
 EI
 HALT
 DJNZ D_WAIT
 RET




Medium:
 ld a,9
 jr PitchSpeedSet

SortaFast:
 ld a,6
 jr PitchSpeedSet

DELAY2:
 ld a,(HitCounter)
 dec a                ;UpdateHitCOunter
 ld (HitCounter),a
 ld a,(DerbyFlag)
 dec a
 jr nz,Medium
 ld a,(SPEED)
 dec a
 jr z,Medium
 dec a
 jr z,SortaFast
 ld a,3
PitchSpeedSet:
 ld b,a
delay22:
 push bc   
 ld b,90 
 call delaya  
d2:
 pop bc   
 djnz delay22 
 ret

delaya:
      inc sp
      inc sp
delay3:
        push bc  ;temp storage of bc
        pop bc   ;recall bc
        
       call OTH_ARROW

        bit 5,a
        jp z,SwingBat

        djnz delay3 ;b-l->b if b=0 return else do it again
        jr d2

OTH_ARROW:

        PUSH    BC
        LD      A,$fe
        OUT     ($01),A ; Port 1 Keypad
        NOP \ NOP \ NOP \ NOP     
        IN      A,($01) ; Port 1 Keypad
        LD      B,A
        LD      A,$ff
        IN      A,($01) ; Port 1 Keypad
        LD      A,B
        LD      A,$bf
        OUT     ($01),A ; Port 1 Keypad
        IN      A,($01) ; Port 1 Keypad
        OR      $0f
        AND     B
        POP     BC
 ret


OTH_PAUSE2:
 bcall(_getK)
 cp $09
 ret z
 cp $0f
 jr nz,OTH_PAUSE2
 inc sp
 inc sp
 jp quit2




RAND2:
 ld a,2
 call RANDOM
 inc a
 dec a
 ret

RAND3:
 ld a,3
RANDOM:
	ld b,a 				; Create a Random number
 	ld a,r
 	add a,a
 	ld hl,0
 	ld d,0
 	ld e,a
RMul:
 	add hl,de
 	djnz RMul
 	ld a,h				
	ret	

ClearTxt:
 ld hl,TEXT_MEM
 ld bc,127
OTH_CLEAR:
 ld (hl),0
 ld d,h
 ld e,l
 inc de
 ldir
 ret


	
;
; Data
;

wins:
 .db 0
losses:
 .db 0
games:
 .db 50
homeruns:
 .db 0
runs:
 .db 0
SeasonFlag:
 .db 1  ;SeasonGame 1=No ,2=Yes

SeasonFlag2:
 .db 1  ;Default one ;2=Season in Progress

SGAME:
 .db 1  ;Saved Game flag

seasonname:
 .db "   ",0

SaveData:
 .ds 42  ;Back up buffer for SaveGame


;
;  Text Strings
;

title2:   .db      "Baseball '99",0
         .db 0
Copy:
         .db      "Copyright 1999 by:",0
aut:
         .db      "Sam Heald",0
Modes:
         .db      "HomeRun Derby",0
         .db      "Exhibition Mode",0
Seas:
         .db      "Season Mode",0
PlayerChoose:
 .db "Choose player mode",0
 .db "1 player",0
 .db "2 players",0
EnterN:
 .db "Enter your name:",0

P2:
 .db "Player 2",0

Final:
 .db "Final Score",0

lost:
 .db "Game Over!"

InfoTxt:
 .db "Strike",0
I2:
 .db "Ball",0
I3:
 .db "Out",0
I4:
 .db "Single",0
I5:
 .db "Double",0
I6:
 .db "Triple",0
I7:
 .db "Home Run!",0

Itxt:
 .db "Inning:",0

info_text2: .db "Player 1 "
            .db "Wins!",0

derbyT:
 .db "O:00IN:  ",0

Season_1:
 .db  "'99 Season Stats",0
 .db 0
 .db "HomeRuns:",0
 .db "RBIs:",0
 .db "Wins:",0
 .db "Losses:",0
 .db "Win Pct:",0
 .db "Games Left:",0

Season_2:
 .db "Continue season?",0
 .db "Yes",0
 .db "No",0

Ending_1:
 .db  "Congratulations!",0
e2:
 .db  "You have beaten ",0
e3:
 .db  " Now watch the  "
 .db  "   credits...   ",0

Ending_2:
 .db  "Programmed by:",0
e4:
 .db  "evil_sam@hotmail.com",0
 .db  "WebSite: ",0
 .db  "void.calc.org",0
 .db  "ahmed.ticalc.org",0
Ending_3:
 .db  "Graphics by:",0
 .db  "Bill Nagel",0
 .db  "ManjiLump",0

Teams:
 .db "SAM",0  ;The Sam Heald Sox
 .db "ATL",0  ;Braves
 .db "BOS",0  ;Red Sox
 .db "NYY",0  ;Yankees
 .db "NYM",0  ;Mets
 .db "STL",0  ;Cardinals
 .db "FLA",0  ;Marlins
 .db "CUB",0  ;Cubs
 .db "CHI",0  ;White Sox
 .db "DET",0  ;Tigers
 .db "TOR",0  ;BlueJays
 .db "MIN",0  ;Twins
 .db "ARZ",0  ;DiamondBacks
 .db "TEX",0  ;Rangers
 .db "HOU",0  ;Astros
 .db "CLE",0  ;Indians
 .db "LAD",0  ;Dodgers
 .db "ANH",0  ;Angels
 .db "COL",0  ;Rockies
 .db "PHI",0  ;Phillies
 .db "BAL",0  ;Orioles
 .db "MON",0  ;Expos
 .db "KAN",0  ;Royals
 .db "SFG",0  ;Giants
 .db "SDP",0  ;Padres
 .db "SEA",0  ;Mariners
 .db "TBD",0  ;Devil-Rays
 .db "OAK",0  ;A's
 .db "CIN",0  ;Reds
 .db "MIL",0  ;Brewers
 .db "PIT",0  ;Pirates



;
;Sprites
;
ball:
 .db 2,2
 .db %11000000
 .db %11000000

Runner:
 .db 3,6
 .db %01000000
 .db %10100000
 .db %01000000
 .db %11100000
 .db %01000000
 .db %10100000

Base1:
 .db 4,6
 .db %00100000
 .db %01010000
 .db %00100000
 .db %11110000
 .db %01000000
 .db %01000000
Base2:
 .db 4,6
 .db %01000000
 .db %10100000
 .db %01000000
 .db %11100000
 .db %01110000
 .db %01100000

Base3:
 .db 4,6
 .db %01000000
 .db %10100000
 .db %01000000
 .db %11110000
 .db %00100000
 .db %00100000

Batter:
 .db 4,6
 .db %001000000
 .db %110100000
 .db %001000000
 .db %000100000
 .db %001100000
 .db %010100000

PlayerSwing1:
 .db 6,6
 .db %01000000
 .db %10100000
 .db %01011110
 .db %10101110
 .db %01110000
 .db %10100000 



Title1:
 .db $1C,$FF,$3F,$17,$49,$A0,$3F,$10,$4B,$A0,$3F,$0E,$4C,$90,$3F,$0D,$4A,$81
 .db $3F,$10,$49,$82,$C0,$36,$F0,$0B,$50,$90,$35,$E2,$0D,$51,$A0,$34,$C1,$0D
 .db $53,$39,$C0,$C0,$81,$51,$A0,$33,$C0,$C0,$81,$52,$B0,$33,$C0,$C0,$83,$52
 .db $90,$33,$C0,$C0,$86,$BF,$F8,$FC,$37,$C1,$0A,$E3,$FD,$FE,$3A,$C0,$C0,$84
 .db $BF,$49,$3C,$C1,$0A,$C7,$F8,$9C,$3B,$C1,$0A,$C8,$83,$98,$3B,$C2,$0A,$E0
 .db $82,$A0,$3B,$C2,$0B,$C0,$82,$3F,$91,$0B,$F0,$FB,$3F,$88,$C0,$8C,$F0,$93
 .db $3F,$91,$80,$C1,$BF,$82,$3F,$A4,$84,$82,$88,$88,$3F,$C8,$90,$87,$C0,$90
 .db $3E,$CE,$C2,$81,$08,$C0,$3D,$D2,$84,$87,$F0,$C0,$13,$53,$B9,$10,$48,$88
 .db $90,$91,$18,$D2,$23,$C3,$92,$87,$F2,$C0,$12,$CC,$48,$B9,$15,$C1,$C9,$8F
 .db $F9,$C0,$11,$C3,$90,$1E,$C3,$F5,$9F,$48,$17,$F9,$F0,$20,$E0,$BF,$FE,$82
 .db $16,$CC,$9E,$E8,$1A,$C6,$8F,$F8,$84,$15,$C6,$90,$21,$C9,$8F,$F0,$88,$16
 .db $C4,$C0,$21,$EF,$FF,$09,$C0,$14,$CA,$28,$DC,$8B,$C1,$E0,$16,$F8,$28,$F0
 .db $A0,$FC,$A0,$36,$49,$81,$F1,$9F,$E7,$FE,$48,$81,$E0,$BE,$87,$F0,$08,$4A
 .db $81,$F3,$9F,$E7,$FE,$49,$83,$E0,$FC,$8F,$E0,$81,$CF,$FC,$9E,$AF,$FE,$FD
 .db $F3,$DE,$8F,$81,$E0,$9F,$0A,$F3,$EF,$87,$CB,$F7,$DE,$DC,$F3,$C3,$E0,$B8
 .db $83,$C0,$83,$EF,$BC,$BE,$AF,$CE,$F9,$B3,$CE,$8F,$81,$E0,$8E,$0A,$FB,$EF
 .db $8F,$EB,$F3,$DE,$B8,$F3,$C3,$F0,$B8,$83,$C0,$83,$EF,$BC,$BF,$AF,$CC,$F9
 .db $D3,$CE,$8F,$C1,$E0,$8E,$0B,$E7,$FC,$9F,$F7,$F9,$BF,$E5,$EE,$8D,$F0,$F0
 .db $87,$10,$FF,$83,$BC,$48,$9F,$F9,$BF,$C3,$BC,$9C,$81,$E0,$0B,$48,$86,$F8
 .db $48,$9F,$F1,$FF,$86,$F8,$B8,$83,$C0,$0A,$49,$98,$F0,$FF,$9F,$F1,$F3,$CC
 .db $B8,$B8,$83,$C0,$0A,$F9,$F7,$FE,$C7,$F7,$D8,$9C,$FB,$FE,$8E,$80,$F0,$0C
 .db $F9,$F7,$FE,$E7,$F7,$DB,$9C,$FB,$FE,$8E,$8C,$F0,$E0,$83,$E7,$4B,$B5,$FB
 .db $E5,$CE,$BF,$FF,$87,$86,$B8,$B0,$81,$F7,$FE,$9D,$E7,$EF,$9E,$F9,$FE,$8E
 .db $9C,$B9,$E1,$C0,$87,$4C,$9D,$49,$BE,$49,$9F,$E1,$E3,$C7,$BE,$98,$81,$49
 .db $BF,$4E,$9F,$4F,$BC,$FD,$54,$09,$48,$8F,$BF,$9F,$C7,$50,$9E,$BE,$49,$BF
 .db $FC,$12,$E3,$C0,$12,$EC,$39,$E6,$19,$E4,$10,$E7,$C7,$C0,$13,$E6,$1B,$E8
 .db $0F,$EC,$EC,$E0,$10,$F9,$C0,$17,$E6,$0E,$EC,$EC,$E0,$0F,$E3,$C0,$18,$FC
 .db $C0,$0B,$E6,$E6,$12,$E1,$C0,$19,$FE,$A0,$0B,$FC,$FC,$11,$FE,$E0,$1A,$4C
 .db $10,$E0,$E0,$0D,$49,$20,$C1,$FF,$0D,$E0,$E0,$0D,$C3,$F0,$1C,$FC,$81,$09
 .db $E6,$E6,$11,$E0,$A0,$21,$49,$09,$F8,$F8,$0A,$00


field2:
 .db $AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
field:
.db $AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D5,$AA,$D6,$D5,$AA,$D5,$AA
.db $D5,$56,$AA,$D5,$AA,$D5,$AA,$CA,$D5,$AA,$D5,$AB,$FC,$12,$48,$AA,$D5,$AA
.db $D5,$B5,$AA,$D5,$AB,$FC,$84,$12,$C0,$BF,$D5,$AA,$D5,$A5,$AA,$D5,$FE,$0C
.db $C0,$0E,$C0,$80,$48,$AA,$D5,$B5,$AA,$D7,$12,$C0,$0E,$C0,$0D,$F5,$AA,$D2
.db $D5,$AE,$A0,$0D,$C0,$0E,$C0,$0D,$DA,$D5,$AD,$AA,$F8,$A0,$0A,$5C,$10,$C7
.db $AA,$D2,$D5,$C0,$A0,$87,$F0,$18,$FF,$09,$C1,$F5,$AD,$AE,$08,$C7,$F0,$25
.db $FE,$90,$86,$D4,$DC,$09,$FC,$33,$FC,$80,$F5,$D8,$08,$E0,$3A,$E0,$86,$D8
.db $08,$E0,$1C,$C0,$1B,$E0,$87,$0B,$E0,$1D,$D0,$1E,$E0,$0D,$F0,$21,$C0,$1F
.db $E0,$09,$E0,$22,$F0,$22,$E0,$83,$2A,$C0,$23,$E0,$B0,$27,$D0,$26,$E6,$3F
.db $1C,$E0,$3F,$33,$C0,$2C,$C0,$25,$D0,$2C,$D0,$27,$C0,$2C,$C0,$25,$F0,$2C
.db $F0,$27,$C0,$2C,$C0,$25,$D0,$2C,$D0,$3F,$3F,$19,$C0,$0C,$C0,$3F,$81,$A0
.db $B0,$85,$3F,$0C,$C1,$CC,$82,$23,$E0,$20,$F3,$81,$C3,$C0,$1C,$CC,$22,$C9
.db $CC,$C2,$20,$E0,$C0,$1C,$D8,$98,$9A,$C0,$19,$C0,$98,$1E,$C0,$0A,$C0,$1A
.db $E0,$81,$12,$C0,$83,$12,$E0,$18,$C0,$08,$E0,$0A,$D0,$86,$15,$E0,$88,$0E
.db $C0,$0B,$C0,$09,$C0,$90,$16,$C0,$D0,$0A,$E0,$8C,$80,$E0,$80,$F0,$B0,$18
.db $E0,$C0,$08,$C0,$89,$C0,$88,$09,$C3,$10,$C0,$09,$E7,$0B,$E0,$8D,$DC,$81
.db $0A,$D2,$10,$D0,$0C,$C8,$08,$C0,$8D,$95,$08,$E0,$81,$C0,$0D,$C0,$0C,$E8
.db $83,$08,$F5,$D5,$C0,$90,$82,$13,$F0,$0F,$C0,$90,$82,$D5,$4D,$8C,$8C,$12
.db $F8,$11,$E0,$C0,$9A,$D6,$0B,$C1,$99,$12,$D6,$11,$CD,$C0,$9A,$D5,$98,$82
.db $83,$82,$11,$F8,$0F,$C1,$09,$EA,$D6,$C4,$84,$81,$88,$27,$CC,$81,$EA,$D5
.db $90,$82,$08,$F0,$28,$E0,$85,$AA,$D6,$94,$87,$09,$C0,$25,$C0,$8D,$AA,$D5
.db $B0,$82,$F0,$86,$27,$DF,$56,$0C,$EA,$08,$C0,$1F,$E4,$16,$EC,$80,$D5,$C0
.db $98,$1F,$C2,$17,$EA,$C0,$EA,$E0,$84,$1E,$C1,$18,$EC,$80,$D5,$B8,$83,$1C
.db $E0,$A0,$13,$EA,$C0,$EA,$D6,$80,$C0,$14,$C0,$90,$14,$EC,$80,$52,$84,$15
.db $E0,$8C,$16,$E0,$18,$C1,$C0,$0E,$C0,$9A,$17,$EE,$81,$EC,$0A,$C0,$A0,$0C
.db $E0,$8D,$C0,$12,$EA,$C0,$CA,$C0,$88,$83,$0E,$C0,$8D,$A0,$13,$EA,$80,$CA
.db $0A,$F0,$84,$BF,$88,$81,$D6,$17,$EA,$C0,$CA,$C0,$8B,$08,$E8,$AC,$80,$EA
.db $C0,$12,$EE,$81,$EA,$0A,$EC,$80,$E1,$C0,$8E,$D6,$17,$E0,$18,$D7,$09,$C8
.db $80,$D5,$A8,$15,$61,$AB,$08,$E0,$86,$D5,$BF,$55,$00

portmaster: .db "ION Port by Ahmed El-Helw",0

;#include "ZCPdecod.asm"              ; include the decoder
;
;               ZCP decoding routine v2.0 for Ash 3.0/CrASH
;                    Wouter Demuynck (kadem@unicall.be)
;                       Read ZCP.TXT for more info
;
; Revision history :
; - 12/16/1995 (ZShell 4.0)
;     original by Stephane Jantzen(Stephane.Jantzen@scinfo.u-nancy.fr)
; - 02/11/96 (Zshell 4.0)
;     later version by Pascal Bouron(Bouron@YOKO.ENS-cachan.fr) 
; - 26/02/98 (Ash 3.0/Crash 1.x)
;     this version by Wouter Demuynck(kadem@unicall.be)
;     ported to TI-82
;
;
; usage : use '#include "ZCPDECOD.ASM"'
;         or cut and paste this routine in your source
; use 'call DecodeZCP' to decode the data pointed to by DE
; to the address pointed to by HL
; NOTE : if you use #include, be sure to put it at the END of your program,
;        bu before the .end directive
;
;
; DecodeZCP decodes data from address DE to address HL 
; routine size : <80 bytes
;
DecodeZCP: 
        ld      B,$80               ; %1000000 (selection mask)
        Push    DE
_ZCP_Loop:                               
        Pop     DE
        ld      A,(DE)              ; get next byte of compressed data
        or      A                   ; check if A is zero (last data byte)
        ret     Z                   ; quit routine if last byte reached
        inc     DE                  ; put pointer to next byte
        Push    DE
        ld      D,A                 ; save A in D (think Data)
        rlca                        ; rotate left throug carry => bit 7 -> CY
        jr      c,_ZCP_Copy         ; if bit 7 set, we need to copy,
_ZCP_Stream:                        ; otherwise it is a stream
        ld      A,D                 ; load the Data again
        and     $3F                 ; and %00111111 to get the count
        ld      C,A                 ; the count is saved in C
        ld      A,D                 ; load the data again
        and     $40                 ; and %01000000 (mask out the bit that 
_ZCP_StreamLoop:                    ; tells us wether to draw a pixel or not)
        or      A                   ; if no pixel needs to be drawn, loop
        jr      Z,_ZCP_SLSuite
        ld      E,A                 ; save A in E (DE is pushed)
        ld      A,B                 ; load mask in A
        or      (HL)                ; load update to mem in A
        ld      (HL),A              ; load update to mem to the mem
        ld      A,E                 ; restore A from E 
_ZCP_SLSuite:
        srl     B                   ; shift left through carry
        jr      NC,_ZCP_DjnzSL      ; CY set => go on to next byte
        inc     HL
        ld      B,$80               ; load %10000000 in B (necessary ?) 
_ZCP_DjnzSL:
        dec     C                   ; decrease count
        jr      nz,_ZCP_StreamLoop  ; keep looping while not zero
        jr      _ZCP_Loop
_ZCP_Copy:
        ld      C,$07               ; set count to 7 (7 bits to copy)
_ZCP_CopyLoop:                      ; 1 rotate left was already done
        rlca                        ; rotate left through carry
        jr      NC,_ZCP_CLSuite     ; if no pixel to draw, go to next
        ld      E,A
        ld      A,B
        or      (HL)                
        ld      (HL),A              ; set bit
        ld      A,E
_ZCP_CLSuite:
        srl     B
        jr      nc,_ZCP_DjnzCL
        inc     HL
        ld      B,$80
_ZCP_DjnzCL:
        dec     c  
        jr      nz,_ZCP_CopyLoop
        jr      _ZCP_Loop



;-------------------------------------------------------------------------------
;FIND_PIXEL Routine, by Patrick Davidson [From Zkart3d 82]
;-------------------------------------------------------------------------------
FIND_PIXEL_DATA:
         .db      128,64,32,16,8,4,2,1
FIND_PIXEL:
         push     bc
         push     de
         ld       a,b
         and      7
         ld       hl,FIND_PIXEL_DATA
         ld       e,a
         ld       d,0
         add      hl,de
         ld       e,(hl)            ; E = pixel mask
         ld       a,63
         sub      c
         ld       c,a
         add      a,a
         add      a,c               ; A = 3 * Y
         ld       l,a
         ld       h,0
         add      hl,hl
         add      hl,hl             ; HL = 12 * Y
         ld       a,b
         ld       b,0
         rrca
         rrca
         rrca
         and      15
         ld       c,a
         add      hl,bc
         ld       a,e               ; A = pixel mask
         pop      de
         pop      bc
         ret

.end


