#include "ion.inc"

#ifdef TI83

WordCt  = saferam2	; 1  - Number of words skipped 
ExtProg = saferam2+1	; 2  - Place to look for external prog
EngTable = saferam2+3	; 2  - Address of english table
ForTable = saferam2+5	; 2  - Address of foreign table
Word	= saferam2+100	; 10 - Word being inputted 
ForLn	= saferam2+199	; 1  - Number of letters in ForLn
ForWord = saferam2+200	; 15 - Foreign word

#else
wordct = saferamp2
extprog = saferamp2+1
engtable = saferamp2+3
fortable = saferamp2+5
word = saferamp2+100
forln = saferamp2+199
forword = saferamp2+200

#endif

#ifdef TI83P
 .org progstart-2
 .db $BB, $6D
#else
 .org progstart
#endif
 ret
 jr nc,Detect
 .db "Translator",0

Detect:
 ld hl,(Vat)
 ld ix,DetectTxt
 call ionDetect
 ret nz
 ld (ExtProg),de
 ld de,$0104
 push hl
 call FastPuts
 ld a,(hl)
 inc hl
 inc hl
 ld (EngTable),hl
 dec d
 ld e,a
 pop hl
 ld bc,-8
 add hl,bc
 add hl,de
 ld (forTable),hl
 ld e,d
 ld hl,TitleTxt
 call FastPuts 
 inc e
 call FastPuts
 inc e
 inc e 
 call FastPuts
 inc e
 inc e
 call FastPuts
 ld de,$0207
 call FastPuts
 ld bc,0*256+55
 ld de,93*256+55
 ld h,1
 bcall(_iline)

GetKeypress:
 bcall(_getkey)
 cp $45
 jr nz,Begin

NextSet:
 ld hl,(ExtProg)
 ld ix,DetectTxt
 call ionDetect
 jr nz,GetKeypress
 ld (ExtProg),de
 ld de,$0104
 call FastPuts
 ld a,(hl)
 inc hl
 inc hl
 ld (EngTable),hl
 dec d
 ld e,a
 pop hl
 ld bc,-8
 add hl,bc
 add hl,de
 ld (forTable),hl

Begin:
 bcall(_clrlcdfull)
 set ShiftAlock, (iy+ShiftFlags)
 set appAutoScroll, (iy+appFlags)
 set Curable, (iy+CurFlags)
 set 7, (iy+shiftflags)

; Thanks to Joe and Jason for this stuff about interrupts

#ifdef TI83

SetVector:
 ld hl,$8400
 ld a,h
 ld de,$8401
 ld bc,$0100
 ld (hl),$82
 ldir
 ld i,a

LoadInterrupt: 
 ld hl,InterruptStart
 ld de,$8282
 ld bc,interruptend-interruptstart
 ldir

#else

SetVector:
 ld hl,$9900
 ld a,h
 ld de,$9901
 ld bc,$0100
 ld (hl),$98
 ldir
 ld i,a

LoadInterrupt: 
 ld hl,InterruptStart
 ld de,$9898
 ld bc,interruptend-interruptstart
 ldir

#endif
 ld bc,0*256+8
 ld de,94*256+8
 ld h,1
 bcall(_iline)
 ld (hl),b
 ld (WordCt),hl
 im 2

Keypress:
 ld ix,Word-1
 ld hl,$0007
 ld (currow),hl
 ld a,h
 ld (WordCt),a

Getkey:
 bcall(_getkey)
 cp $09				; clear
 jp z,exit
 cp $49				; Y=
 jr z,FindEng
 cp $44				; Graph
 jp z,FindFor
 cp $0A				; del
 jr z,BackSpace
 cp $99
 jp z,space
 sub 57
 cp 'a'
 jr c,getkey
 cp 'z'+1
 jr nc,getkey
 ld b,a
 ld a,(curcol)
 cp 15
 jr z,getkey
 ld a,b
 inc ix				; update buffer
 ld (ix),a			; ASCII char to ix
 bcall(_putc)			; affects char location
 jr getkey

BackSpace:
 ld hl,curcol
 ld a,(hl)
 or a
 jr z,Getkey
 ld a,' '
 bcall(_putmap)
 dec (hl)
 ld a,' '
 bcall(_putmap)			; dont affect char location
 dec ix				; erase last letter
 jr Getkey

FindEng:
 ld hl,(EngTable) ; hl = beginning of english table
 ld a,(WordCt)
 ld e,a
FindEng1:
 ld ix,Word     ; ix = beginning of the word
 xor a
 ld bc,16
 cpir           ; search it
 ld a,(hl)
 or a           ; two zeros in a row?
 jr z,Undef
 inc e
FindEng2:
 ld a,(ix)      ; a <- ix
 cp (hl) 	; same letters?       
 jr nz,FindEng1
 inc ix		
 inc hl		
 ld a,(hl)
 or a           ; terminated 0?
 jr nz,FindEng2
 ld hl,(ForTable); hl = beginning of foreign word table
GetFor:
 xor a
 ld bc,16
 cpir		; search for 0
 dec e		; counter
 jr nz,GetFor 

Disp:
 push hl
 ld de,$0007
 push de
 ld hl,ClearTxt
 call FastPuts
; ld de,$0007
 pop de
 ld (currow),de
 ld a,'*'
 bcall(_putc)
 pop hl
 bcall(_puts)
 bcall(_newline)
 jp Keypress

FindFor:
 ld hl,(ForTable) ; hl = beginning of english table
 ld a,(WordCt)
 ld e,a
FindFor1:
 ld ix,Word     ; ix = beginning of the word
 xor a
 ld bc,16
 cpir           ; search it
 ld a,(hl)
 or a           ; two zeros in a row?
 jr z,Undef
 inc e
FindFor2:
 ld a,(ix)      ; a <- ix
 cp (hl) 	; same letters?       
 jr nz,FindFor1
 inc ix		
 inc hl		
 ld a,(hl)
 or a           ; terminated 0?
 jr nz,FindFor2
 ld hl,(EngTable)	; hl = beginning of foreign word table
GetEng:
 xor a
 ld bc,16
 cpir		; search for 0
 dec e		; counter
 jr nz,GetEng
 jr Disp 

Undef:
 ld de,$0007
 ld hl,UndefTxt
 call FastPuts
 bcall(_newline)
 jp Keypress

Space:
 ld a,' '
 bcall(_putc)
 inc ix
 ld (ix),a
 jp Getkey
 
FastPuts:
 ld (currow),de
 bcall(_puts)
 ret

Exit:
 res ShiftAlock, (iy+ShiftFlags)
 res Curable, (iy+CurFlags)
 res appAutoScroll, (iy+appFlags)
 res 7, (iy+shiftflags)
 im 1
 
 ret

#ifdef TI83
; ld hl,$8282
; ld de,$8283
; ld bc,interruptend-interruptstart
; ld (hl),0
; ldir
; ld hl,$8400
; ld de,$8401
; ld bc,$0100
; ldir
; ret

#else
; ld hl,$9898
; ld de,$9899
; ld bc,interruptend-interruptstart
; ld (hl),0
; ldir
; ld hl,$9900
; ld de,$9901
; ld bc,$0100
; ldir
; ret

#endif

InterruptStart:
 ex	af,af'
 in	a,(3)
 rra
 jr	nc,on_not_pressed
 res	3,(iy+18)

#ifdef TI83

on_not_pressed:
 jp	$0039

#else

on_not_pressed:
 jp $006A

#endif

interruptend:

DetectTxt:
 .db "ztranset",0		; detect string
TitleTxt:
 .db "Translator v1.1",0
AuthorTxt:
 .db "Matthew Landry",0
LevelTxt:
 .db "File set:(mode)",0
TcpaTxt:
 .db "tcpa.calc.org",0
PressClear:
 .db "Press a key",0
ClearTxt:
 .db "               ",0 
UndefTxt:
 .db "Err: undefined",0       

.end
END

