
; Periodic Table v2.0 for 83/83+ (ION)
; TI-83 (SOS) version by Ahmed El-Helw
; 83/83+ (ION) version by Jason Kovacs
; TI-83+ (MirageOS) port made 07/15/00

#include "ti83plus.inc"
#include "mirage.inc"

	.org $9d93
	.db $BB,$6D

	ret
	.db 1
Button:
	.db %00000000,%00000000
	.db %00000000,%00000000
	.db %00111011,%10110000
	.db %00101010,%00101000
	.db %00111011,%00110000
	.db %00100010,%00101000
	.db %00100010,%00101000
	.db %00100011,%10101000
	.db %00000000,%00000000
	.db %00000001,%10001000
	.db %00010100,%10010100
	.db %00010101,%00010100
	.db %00001001,%10101000
	.db %00000000,%00000000
	.db %00000000,%00000000
Description:
	.db "Periodic Table v2.0",0

Start:
	ld a,4			;Set up some coordinates for the box
	ld (selectx),a		;and for _IPoint routine.  Note that
	ld a,61			;the Y-Coordinates are actually flipped
	ld (selecty),a		;due to Ti's _IPoint requirements.
	ld a,1
	ld (current),a 
Restart:
	bcall(_grbufclr)
	call DrawTable		;Draw out the Periodic Table Wireframe
	jp Selector		;Draw out the selector for the first time

KeyLoop:			;The KeyLoop Starts here
	halt
	bcall(_getcsc)		;call GET_KEY
	cp $0F			;Is it Clear?
	ret z			;Exit if so.
	cp $02			;Is it Left?
	jr z,MoveLeft		;Move Left!
	cp $03	 		;Is it right?
	jr z,MoveRight		;Move Right!
	cp $09
	jp z,ElemInfo
	cp $37
	jp z,HelpScreen
	jr KeyLoop		;Reloop.

MoveLeft:			;Similarly to the other routines,
	ld a,(selectx)		;this checks the uncrossable boundries
	cp 4			;and if there is a boundry that shouldn't
	jp z,PrevRow		;be crossed, it doesn't draw it, else,
	cp 19			;moves to the left.
	jp z,ContLeftC
ContLeftMan:
	ld a,(selectx)
	cp 89 			
	jr z,SelectHyd
	cp 19
	jp z,ContLCheck
	cp 64
	jp z,CheckLeft
ContLeft:
	call RemSel
	ld a,(selectx)
	sub 5
	ld (selectx),a
	ld hl,current
	dec (hl)
	jr JP_To_Selector_1

MoveRight:			;Pretty similar to the other routines.
	ld a,(selectx)		;Checks boundries, draws in the right
	cp 89			;location the right box.
	jp z,NextRow
	cp 84
	jp z,LastRow
ContRC:
	ld a,(selectx)
	cp 4 
	jr z,SelectHel
	cp 9
	jp z,CheckRight
	cp 54
	jp z,ContRightC
	cp 84
	jp z,ContRC2
ContRight:
	call RemSel
	ld a,(selectx)
	add a,5
	ld (selectx),a
	ld hl,current
	inc (hl)
	jr JP_To_Selector_1

SelectHyd:
	ld a,(selecty)
	cp 61
	jp nz,ContLeft
	call RemSel
	ld a,4
	ld (selectx),a
	ld hl,current
	dec (hl)
	jr JP_To_Selector_1

SelectHel:
	ld a,(selecty)
	cp 61
	jp nz,ContRight
	call RemSel
	ld a,89
	ld (selectx),a
	ld hl,current
	inc (hl)
	jr JP_To_Selector_1

CheckRight:
	ld a,(selecty)
	cp 48
	jp c,ContRChk
	call RemSel
	ld a,64
	ld (selectx),a
	ld hl,current
	inc (hl)
JP_To_Selector_1:
	jr Selector

ContRChk:
	cp 41
	jp nc,ContRight
	cp 36
	jp z,ContRight
	call RemSel
	ld a,19
	ld (selectx),a
	ld hl,current
	inc (hl)
	jr Selector

ContLCheck:
	ld a,(selecty)
	cp 31
	jp nz,ContLeft
	call RemSel
	ld a,9
	ld (selectx),a
	ld hl,current
	dec (hl)
	jr Selector

CheckLeft:
	ld a,(selecty)
	cp 48
	jp c,ContLeft
	call RemSel
	ld a,9
	ld (selectx),a
	ld hl,current
	dec (hl)

Selector:			;Draws a 4x4 black box at coordinates selectx/selecty
	call DrawSel		;Call the XOR routine
	ld h, 1
	ld bc,63*256+57
	ld de,63*256+33
	bcall(_ILine)
	call DispData		;Display the Data!
	call FastCopy	;Copy it
	jp KeyLoop		;Goto the loop

ContLeftC:
	ld a,(selecty)
	cp 30
	jr c,MoveLBot
	jp ContLeftMan

MoveLBot:
	cp 19
	jr z,RetHistory
	cp 14
	jp nz,KeyLoop
	call RemSel
	ld a,19
	ld (selecty),a
	ld a,84
	ld (selectx),a
	ld hl,current
	dec (hl)
	jr Selector

RetHistory:
	call RemSel
	ld a,31
	ld (selecty),a
	ld a,54
	ld (selectx),a
	ld hl,current
	dec (hl)
	jr Selector

ContRightC:
	ld a,(selecty)
	cp 31
	jp nz,ContRight
	call RemSel
	ld a,(selecty)
	sub 12
	ld (selecty),a
	ld a,19
	ld (selectx),a
	ld hl,current
	inc (hl)
	jr Selector

ContRC2:
	ld a,(selecty)
	cp 30
	jp c,KeyLoop
	jp ContRight

NextRow:
	call RemSel
	ld a,(selecty)
	sub 5
	ld (selecty),a
	ld a,4
	ld (selectx),a
	ld hl,current
	inc (hl)
JP_To_Selector_2:
	jp Selector

LastRow:
	ld a,(selecty)
	cp 19
	jp nz,ContRC
	call RemSel
	ld a,19
	ld (selectx),a
	ld a,(selecty)
	sub 5
	ld (selecty),a
	ld hl,current
	inc (hl)
	jr JP_To_Selector_2

PrevRow:
	ld a,(selecty)
	cp 61
	jp z,KeyLoop
	call RemSel
	ld a,(selecty)
	add a,5
	ld (selecty),a
	ld a,89
	ld (selectx),a
	ld hl,current
	dec (hl)
	jr JP_To_Selector_2

RemSel:				;If we only want to remove it, then save time by not copying the
DrawSel:			;grbuf and by returning rather than going to the KeyLoop.
	ld d,2			;D is set to two here for XOR, so it can be used as an XOR routine.
	ld a,(selectx)
	ld b,a			;X-Position should go into b
	ld a,(selecty)
	ld c,a			;Y-Position should go into c
	call VertLoop		;Draw 3 pixels
	dec c			;Goto next line, this is decrease because 
	call VertLoop		;Ti's _IPoint Y-Coordinates are flipped.
	dec c			;Same with _ILine.  This VertLoop is gone
	call VertLoop		;through four times to achieve 4 lines.
	dec c
VertLoop:		;Displays 4 pixels vertically
	ld a,(selectx)		
	ld b,a			;Reset the X-Coordinate
	ld a,4			;Loop 4 times, using a
Loop:
	bcall(_IPoint)		;Draw the point
	inc b			;Increase the X
	dec a			;Decrease A
	jr nz,Loop		;If its not 0, then reloop.
	ret

DrawTable:		;Draws out the wireframe of the periodic table.
			;This was not very easy to do, as you can imagine :P
	ld h,1
	ld bc,3*256+47
	ld de,93*256+47
	bcall(_ILine)
	ld bc,3*256+42
	ld de,93*256+42
	bcall(_ILine)
	ld bc,3*256+37
	ld de,93*256+37
	bcall(_ILine)
	ld bc,3*256+32
	ld de,93*256+32
	bcall(_ILine)
	ld bc,18*256+27
	ld de,58*256+27
	bcall(_ILine)
	ld bc,63*256+52
	ld de,93*256+52
	bcall(_ILine)
	ld bc,63*256+57
	ld de,93*256+57
	bcall(_ILine)
	ld bc,88*256+62
	ld de,93*256+62
	bcall(_ILine)
	ld bc,3*256+57
	ld de,13*256+57
	bcall(_ILine)
	ld bc,3*256+52
	ld de,13*256+52
	bcall(_ILine)
	ld bc,18*256+10
	ld de,87*256+10
	bcall(_ILine)
	ld bc,18*256+15
	ld de,87*256+15
	bcall(_ILine)
	ld bc,18*256+20
	ld de,87*256+20
	bcall(_ILine)
	ld bc,3*256+62
	ld de,7*256+62
	bcall(_ILine)
	ld bc,3*256+47
	ld de,13*256+47
	bcall(_ILine)
	ld bc,3*256+42
	ld de,13*256+42
	bcall(_ILine)
	ld bc,3*256+37
	ld de,13*256+37
	bcall(_ILine)
	ld bc,3*256+27
	ld de,13*256+27
	bcall(_ILine)
	ld bc,3*256+62
	ld de,3*256+28
	bcall(_ILine)
	ld bc,93*256+62
	ld de,93*256+38
	bcall(_ILine)
	ld bc,8*256+62
	ld de,8*256+28
	bcall(_ILine)
	ld bc,13*256+57
	ld de,13*256+28
	bcall(_ILine)
	ld bc,88*256+62
	ld de,88*256+33
	bcall(_ILine)
	ld bc,83*256+57
	ld de,83*256+33
	bcall(_ILine)
	ld bc,78*256+57
	ld de,78*256+33
	bcall(_ILine)
	ld bc,73*256+57
	ld de,73*256+33
	bcall(_ILine)
	ld bc,68*256+57
	ld de,68*256+33
	bcall(_ILine)
	ld bc,63*256+57
	ld de,63*256+33
	bcall(_ILine)

	ld bc,13*256+47
	ld de,13*256+33
	ld a,16
	call LineLooper

	ld bc,13*256+38
	ld de,13*256+33
	ld a,10
	call LineLooper

	ld bc,13*256+33
	ld de,13*256+28
	ld a,9
	call LineLooper

	ld bc,13*256+20
	ld de,13*256+10
	ld a,15
LineLooper:
	inc b
	inc b
	inc b
	inc b
	inc b
	inc d
	inc d
	inc d
	inc d
	inc d
	bcall(_ILine)
	dec a
	jr nz,LineLooper
	ret

DispData:
	set 7,(iy+$14)
;--------------
	ld hl,6*256+15
	ld (pencol),hl
	ld b,48
DispBlank:			;This code clears the spots
	ld a,' '		;at which we want to write on.
	bcall(_vputmap)
	djnz DispBlank
;--------------
	ld de,0*256+15
	ld hl,Data
	call setvputs
	ld a,(current)
	dec a
	ld hl,Elements
	call getString
	ld de,6*256+15
	call setvputs

	ld de,34*256+61
	ld hl,HelpStr
	call setvputs

	ld de, 56*256+5
	ld hl, Author
	call setvputs
	res 7,(iy+$14)
	ret

ElemInfo:
	call Clear
	bcall(_homeup)
	ld hl,ElemText
	bcall(_puts)

	ld h, 1
	ld bc,11*256+55
	ld de,83*256+55
	bcall(_ILine)

	ld de,14*256+1
	ld hl,Data
	call setvputs
	ld de,21*256+1
	call setvputs
	ld de,28*256+1
	call setvputs
	ld de,35*256+1
	call setvputs

	ld a,(current)
	dec a
	ld de,14*256+45
	ld hl,Elements
	call getString
	call setvputs

	ld a,(current)
	dec a
	ld de,21*256+45
	ld hl,Symbols
	call getString
	call setvputs

	ld a,(current)
	dec a
	ld de,28*256+45
	ld hl,AtomicNo
	call getString
	call setvputs

	ld a,(current)
	dec a
	ld de,35*256+45
	ld hl,MassNo
	call getString
	call setvputs

	jr Common_Getkey_Clear
;	bcall(_getkey)
;RetStart:
;	call Clear
;	jp   Restart

Clear:
	bcall(_grbufclr)
	bcall(_clrlcdfull)
	ret

HelpScreen:
	call Clear
	bcall(_homeup)
	ld hl,HelpText
	bcall(_puts)

	ld de, 56*256+8
	ld hl, Porter
	call setvputs
	ld h, 1
	ld bc,5*256+55
	ld de,89*256+55
	bcall(_ILine)

Common_Getkey_Clear:
	bcall(_getkey)
RetStart:
	call Clear
	jp Restart

;---------= Point hl to string a =---------;
; by: Joe Wingerbermuhle                   ;
; Thanks, this is a lot easier than my     ;
; method of multiplying string # * 12      ;
;                                          ;
; Input: a=string number (0 to 255)        ;
;	 hl->string data                   ;
; Output: hl->string                       ;
;------------------------------------------;

getString:
	or a
	ret z
	ld b,a
	xor a
getStringL1:
	push bc
	ld c,-1
	cpir 
	pop bc
	djnz getStringL1
	ret

;---------------------------------------;
;            Data Begins Here           ;
;---------------------------------------;

selectx:
	.db 0
selecty:
	.db 0
current:
	.db 0

ElemText:
	.db	"  Element Info  ",0
Data:
	.db	"Element:",0
	.db	"Symbol:",0
	.db	"Atomic ",$23,":",0
	.db	"Atomic Mass:",0
HelpStr:
	.db	"Mode: Help",0

HelpText:
	.db	" Periodic Table "
	.db	"                "
	.db	" Arrows  - Move "
	.db	" Enter   - Info "
	.db	" Mode    - Help "
	.db	" Clear   - Quit ",0
Author:
	.db	"Ver 2.0 - By Ahmed El-Helw",0
Porter:
	.db	"Mirage0S Port By Jason K.",0

Elements:
	.db	"Hydrogen",0
	.db	"Helium",0
	.db	"Lithium",0
	.db	"Beryllium",0
	.db	"Boron",0
	.db	"Carbon",0
	.db	"Nitrogen",0
	.db	"Oxygen",0
	.db	"Fluorine",0
	.db	"Neon",0
	.db	"Sodium",0
	.db	"Magnesium",0
	.db	"Aluminum",0
	.db	"Silicon",0
	.db	"Phosphorus",0
	.db	"Sulfur",0
	.db	"Chlorine",0
	.db	"Argon",0
	.db	"Potassium",0
	.db	"Calcium",0
	.db	"Scandium",0
	.db	"Titanium",0
	.db	"Vandium",0
	.db	"Chromium",0
	.db	"Manganese",0
	.db	"Iron",0
	.db	"Cobalt",0
	.db	"Nickel",0
	.db	"Copper",0
	.db	"Zinc",0
	.db	"Gallium",0
	.db	"Germanium",0
	.db	"Arsenic",0
	.db	"Selenium",0
	.db	"Bromine",0
	.db	"Krypton",0
	.db	"Rubidium",0
	.db	"Strontium",0
	.db	"Yttrium",0
	.db	"Zirconium",0
	.db	"Niobium",0
	.db	"Molybdenum",0
	.db	"Technetium",0
	.db	"Ruthenium",0
	.db	"Rhodium",0
	.db	"Palladium",0
	.db	"Silver",0
	.db	"Cadmium",0
	.db	"Indium",0
	.db	"Tin",0
	.db	"Antimony",0
	.db	"Tellurium",0
	.db	"Iodine",0
	.db	"Xenon",0
	.db	"Cesium",0
	.db	"Barium",0
	.db	"Lanthanum",0
	.db	"Hafnium",0
	.db	"Tantalum",0
	.db	"Tungsten",0
	.db	"Rhenium",0
	.db	"Osmium",0
	.db	"Iridum",0
	.db	"Platinum",0
	.db	"Gold",0
	.db	"Mercury",0
	.db	"Thallium",0
	.db	"Lead",0
	.db	"Bismuth",0
	.db	"Polonium",0
	.db	"Astatine",0
	.db	"Radon",0
	.db	"Francium",0
	.db	"Radium",0
	.db	"Actinum",0
	.db	"Unnilquadium",0
	.db	"Unnilpentium",0
	.db	"Unnihexium",0
	.db	"Unnilseptium",0
	.db	"Unniloctium",0
	.db	"Unnilennium",0
	.db	"Ununnilium",0
	.db	"Cerium",0
	.db	"Praseodymium",0
	.db	"Neodymium",0
	.db	"Promethium",0
	.db	"Samarium",0
	.db	"Europium",0
	.db	"Gadolinium",0
	.db	"Terbium",0
	.db	"Dysprosium",0
	.db	"Homium",0
	.db	"Erbium",0
	.db	"Thulium",0
	.db	"Ytterbium",0
	.db	"Lutetium",0
	.db	"Thorium",0
	.db	"Protactinium",0
	.db	"Uranium",0
	.db	"Neptunium",0
	.db	"Plutonium",0
	.db	"Americium",0
	.db	"Curium",0
	.db	"Berkelium",0
	.db	"Californium",0
	.db	"Einsteinium",0
	.db	"Fermium",0
	.db	"Mendelevium",0
	.db	"Nobelium",0
	.db	"Lawrencium",0

AtomicNo:
	.db "1",0
	.db "2",0
	.db "3",0
	.db "4",0
	.db "5",0
	.db "6",0
	.db "7",0
	.db "8",0
	.db "9",0
	.db "10",0
	.db "11",0
	.db "12",0
	.db "13",0
	.db "14",0
	.db "15",0
	.db "16",0
	.db "17",0
	.db "18",0
	.db "19",0
	.db "20",0
	.db "21",0
	.db "22",0
	.db "23",0
	.db "24",0
	.db "25",0
	.db "26",0
	.db "27",0
	.db "28",0
	.db "29",0
	.db "30",0
	.db "31",0
	.db "32",0
	.db "33",0
	.db "34",0
	.db "35",0
	.db "36",0
	.db "37",0
	.db "38",0
	.db "39",0
	.db "40",0
	.db "41",0
	.db "42",0
	.db "43",0
	.db "44",0
	.db "45",0
	.db "46",0
	.db "47",0
	.db "48",0
	.db "49",0
	.db "50",0
	.db "51",0
	.db "52",0
	.db "53",0
	.db "54",0
	.db "55",0
	.db "56",0
	.db "57",0
	.db "72",0
	.db "73",0
	.db "74",0
	.db "75",0
	.db "76",0
	.db "77",0
	.db "78",0
	.db "79",0
	.db "80",0
	.db "81",0
	.db "82",0
	.db "83",0
	.db "84",0
	.db "85",0
	.db "86",0
	.db "87",0
	.db "88",0
	.db "89",0
	.db "104",0
	.db "105",0
	.db "106",0
	.db "107",0
	.db "108",0
	.db "109",0
	.db "110",0
	.db "58",0
	.db "59",0
	.db "60",0
	.db "61",0
	.db "62",0
	.db "63",0
	.db "64",0
	.db "65",0
	.db "66",0
	.db "67",0
	.db "68",0
	.db "69",0
	.db "70",0
	.db "71",0
	.db "90",0
	.db "91",0
	.db "92",0
	.db "93",0
	.db "94",0
	.db "95",0
	.db "96",0
	.db "97",0
	.db "98",0
	.db "99",0
	.db "100",0
	.db "101",0
	.db "102",0
	.db "103",0
	
Symbols:
	.db "H",0
	.db "He",0
	.db "Li",0
	.db "Be",0
	.db "B",0
	.db "C",0
	.db "N",0
	.db "O",0
	.db "F",0
	.db "Ne",0
	.db "Na",0
	.db "Mg",0
	.db "Al",0
	.db "Si",0
	.db "P",0
	.db "S",0
	.db "Cl",0
	.db "Ar",0
	.db "K",0
	.db "Ca",0
	.db "Sc",0
	.db "Ti",0
	.db "V",0
	.db "Cr",0
	.db "Mn",0
	.db "Fe",0
	.db "Co",0
	.db "Ni",0
	.db "Cu",0
	.db "Zn",0
	.db "Ga",0
	.db "Ge",0
	.db "As",0
	.db "Se",0
	.db "Br",0
	.db "Kr",0
	.db "Rb",0
	.db "Sr",0
	.db "Y",0
	.db "Zr",0
	.db "Nb",0
	.db "Mo",0
	.db "Tc",0
	.db "Ru",0
	.db "Rh",0
	.db "Pd",0
	.db "Ag",0
	.db "Cd",0
	.db "In",0
	.db "Sn",0
	.db "Sb",0
	.db "Te",0
	.db "I",0
	.db "Xe",0
	.db "Cs",0
	.db "Ba",0
	.db "La",0
	.db "Hf",0
	.db "Ta",0
	.db "W",0
	.db "Re",0
	.db "Os",0
	.db "Ir",0
	.db "Pt",0
	.db "Au",0
	.db "Hg",0
	.db "Tl",0
	.db "Pb",0
	.db "Bi",0
	.db "Po",0
	.db "At",0
	.db "Rn",0
	.db "Fr",0
	.db "Ra",0
	.db "Ac",0
	.db "Unq",0
	.db "Unp",0
	.db "Unh",0
	.db "Uns",0
	.db "Uno",0
	.db "Une",0
	.db "Uun",0
	.db "Ce",0
	.db "Pr",0
	.db "Nd",0
	.db "Pm",0
	.db "Sm",0
	.db "Eu",0
	.db "Gd",0
	.db "Tb",0
	.db "Dy",0
	.db "Ho",0
	.db "Er",0
	.db "Tm",0
	.db "Yb",0
	.db "Lu",0
	.db "Th",0
	.db "Pa",0
	.db "U",0
	.db "Np",0
	.db "Pu",0
	.db "Am",0
	.db "Cm",0
	.db "Bk",0
	.db "Cf",0
	.db "Es",0
	.db "Fm",0
	.db "Md",0
	.db "No",0
	.db "Lr",0

MassNo:
	.db "1.0079",0
	.db "4.003",0
	.db "6.941",0
	.db "9.012",0
	.db "10.811",0
	.db "12.011",0
	.db "14.007",0
	.db "15.999",0
	.db "18.998",0
	.db "20.180",0
	.db "22.990",0
	.db "24.305",0
	.db "26.982",0
	.db "28.086",0
	.db "30.974",0
	.db "32.066",0
	.db "35.453",0
	.db "39.948",0
	.db "39.098",0
	.db "40.08",0
	.db "44.956",0
	.db "47.88",0
	.db "50.942",0
	.db "51.996",0
	.db "54.938",0
	.db "55.847",0
	.db "58.933",0
	.db "58.69",0
	.db "63.546",0
	.db "65.39",0
	.db "69.723",0
	.db "72.61",0
	.db "74.922",0
	.db "78.96",0
	.db "79.904",0
	.db "83.80",0
	.db "85.47",0
	.db "87.62",0
	.db "88.906",0
	.db "91.224",0
	.db "92.906",0
	.db "95.94",0
	.db "(98)",0
	.db "101.07",0
	.db "102.91",0
	.db "106.42",0
	.db "107.87",0
	.db "112.41",0
	.db "114.82",0
	.db "118.71",0
	.db "121.75",0
	.db "127.60",0
	.db "126.90",0
	.db "131.29",0
	.db "132.90",0
	.db "137.33",0
	.db "138.91",0
	.db "178.49",0
	.db "180.95",0
	.db "183.85",0
	.db "186.21",0
	.db "190.2",0
	.db "192.22",0
	.db "195.08",0
	.db "196.97",0
	.db "200.59",0
	.db "204.38",0
	.db "207.2",0
	.db "208.98",0
	.db "(209)",0
	.db "(210)",0
	.db "(222)",0
	.db "(223)",0
	.db "(226)",0
	.db "(227)",0
	.db "(261)",0
	.db "(262)",0
	.db "(263)",0
	.db "(262)",0
	.db "(265)",0
	.db "(266)",0
	.db "(272)",0
	.db "140.12",0
	.db "140.91",0
	.db "144.24",0
	.db "(145)",0
	.db "150.36",0
	.db "151.96",0
	.db "157.25",0
	.db "158.92",0
	.db "162.50",0
	.db "164.93",0
	.db "167.26",0
	.db "168.93",0
	.db "173.04",0
	.db "174.97",0
	.db "232.04",0
	.db "231.04",0
	.db "238.03",0
	.db "(237.05",0
	.db "(244)",0
	.db "(243)",0
	.db "(247)",0
	.db "(247)",0
	.db "(251)",0
	.db "(254)",0
	.db "(257)",0
	.db "(258)",0
	.db "(259)",0
	.db "(260)",0
	
.end
