; Base Number Converter v1.1
; By Robin Kay
;

; Some code borrowed from CalcSys by Dan Englender (TCPA)

; You may not distribute a modified version of this program. However, you
; may take code from or base your program on this code providing that the
; resulting program is at least 50% of your own work.

.nolist
#include "tse.inc"
.list

.org    userMem-3
.db     $BB,$6D
 ret

.db "TSE",1              ; Header
prgtitle:
.db " Base Converter", 0 ; Title
.dw 74                   ; Stack Required

init:

 ; Clear scroll flag
 res appAutoScroll, (iy+appFlags)

 ; Reset select
 xor a
 ld (select), a

 ; Reset number
 ld hl, 0
 ld (number), hl

start:

 ; Clear Screen 
 bcall(_clrLCDFull)

 ; Disable cursor
 res curable, (iy+curflags)

 ; Move cursor to topleft
 ld hl, 0
 ld (currow), hl

 ; Display title and author
 ld hl, prgtitle + 1
 bcall(_puts)
 bcall(_newline)
 ld hl, author
 bcall(_puts)
 bcall(_newline)
 bcall(_newline)

 ld hl, (number)

 ld a, (select)
 cp 0
 jr nz, notSelHex
 set textInverse, (iy+textFlags)
 ld bc, hex
notSelHex:
 ld de, 0C05h
 ld (currow), de
 call disphexhl
 res textInverse, (iy+textFlags)

 ld a, (select)
 cp 1
 jr nz, notSelDec
 set textInverse, (iy+textFlags)
 ld bc, dec
notSelDec:
 push hl
 ld de, 0B06h
 ld (currow), de
 bcall(_dispHL)
 pop hl
 res textInverse, (iy+textFlags)

 ld a, (select)
 cp 2
 jr nz, notSelBin
 set textInverse, (iy+textFlags)
 ld bc, bin
notSelBin:
 push bc
 ld de, 0007h
 ld (currow), de
 call dispbinhl
 pop bc
 res textInverse, (iy+textFlags)

 ; Save multiplyer base
 ld (mbase), bc

 ; Main input loop
mainloop:
 ei
 halt ; Save power
 bcall(_GetCSC)
 cp skUp
 jr z, Up
 cp skDown
 jr z, Down
 cp sk2nd
 jr z, getnum
 cp skStat
 jr nz, mainloop
 call _tseForceYield
 jp start

Up:
 ld a, (select)
 dec a
 cp -1
 jp z, start
 ld (select), a
 jp start

Down:
 ld a, (select)
 inc a
 cp 3
 jp z, start
 ld (select), a
 jp start

; Routine to display hex number in HL
;
disphexhl:

 ; Call function for each byte of HL
 ld a, h
 call disphexa
 ld a, l

disphexa:

 ; Preserve regs
 push af

 ; Shift four bits to get high nibble
 rrca
 rrca
 rrca
 rrca

 ; Display high digit
 call dispha
 pop af

 ; Display low digit
 call dispha
 ret

dispha:
 and %00001111
 cp 10
 jr nc, dhlet

 ; Offset a for digits 0-9
 add a, 48
 jr disphexd

dhlet:
 ; Offset a for digits A-F
 add a, 55

disphexd:
 ; Display hex digit
 bcall(_putc)
 ret

; Routine to display binary number in HL
dispbinhl:

 ; Call function for each byte of HL
 ld a, h
 call dispbina
 ld a, l

dispbina:

 ; Init djnz counter
 ld b, 8

dispbloop:

 ; Rotate a
 rl a

 ; Preserve a
 push af

 ; Work out what digit it is
 ld a, '0'
 jr nc, dispbind
 inc a

 ; Print character
dispbind:
 bcall(_putc)
 pop af

 ; Loop
 djnz dispbloop
 ret

; Routine to recive textual input from the the keyboard
getnum:

 ; Clear line
 ld a, (select)
 add a, 05h
 ld l, a
 sla a
 sla a
 sla a
 add a, 80h
 bcall(_ClearRow)
 ld h, 0
 ld (currow), hl

 ; Reset length
 xor a
 ld (length), a

 ; Enable cursor
 set curable, (iy+curflags)
 bcall(_ClrTxtShd)

getnumloop:
 ei
 halt ; Save power
 bcall(_GetCSC)

 ; Get function keys
 cp skClear
 jr z, gnClear
 cp sk2nd
 jp z, gn2nd
 cp skStat
 jr nz, dontYield
 call _tseForceYield
 jp start
dontYield:

 ; Reset c
 ld c, 0

 ; Get binary digits
 cp sk0
 jr z, gn0
 cp sk1
 jr z, gn1

 ; If not binary continue
 ld b, a
 ld a, (select)
 cp 2
 ld a, b
 jr z, getnumloop

 ; Get decimal digits
 cp sk2
 jr z, gn2
 cp sk3
 jr z, gn3
 cp sk4
 jr z, gn4
 cp sk5
 jr z, gn5
 cp sk6
 jr z, gn6
 cp sk7
 jr z, gn7
 cp sk8
 jr z, gn8
 cp sk9
 jr z, gn9

 ; If not decimal continue
 ld b, a
 ld a, (select)
 cp 1
 ld a, b
 jr z, getnumloop

 ; Get hex digits
 cp skMath
 jr z, gnA
 cp skApps
 jr z, gnB
 cp skPrgm
 jr z, gnC
 cp skRecip
 jr z, gnD
 cp skSin
 jr z, gnE
 cp skCos
 jr z, gnF

 ; Loop
 jr getnumloop

gnClear:
 jp getnum

gnF:
 inc c
gnE:
 inc c
gnD:
 inc c
gnC:
 inc c
gnB:
 inc c
gnA:
 inc c
gn9:
 inc c
gn8:   
 inc c
gn7:
 inc c
gn6:
 inc c
gn5:
 inc c
gn4:
 inc c
gn3:
 inc c
gn2:
 inc c
gn1:
 inc c
gn0:

getnum2:
 ld a, c
 add a, '0'
 cp '9'+1
 jr c, num
 add a, (-'0')+('A'-10)
num:
 ld b, a
 ld a, (length)
 inc a
 cp 16
 jp z, getnumloop
 ld (length), a
 ld a, b
 bcall(_putc)
 ld a, (length)
 ld l, a
 ld h, 0
 ld de, textbuf - 1
 add hl, de
 ld (hl), c
 jp getnumloop

gn2nd:

 ; Clear number
 ld hl, 0
 ld (number), hl

 ; Get most significant digit
 ld hl, textbuf
 ld a, (length)
 ld b, a
 cp 0
 jr z, finish
loop:

 ; Get digit
 push bc
 ld c, b
 ld b, (hl)
 xor a
 cp b
 jr z, zero

 ; Get multiplyer
 push hl
 ld de, (mbase)
 ld a, c
 dec a
 sla a
 ld l, a
 ld h, 0
 add hl, de
 ld e, (hl)
 inc hl
 ld d, (hl)

 ; Multiply
 ld hl, (number)
addloop:
 add hl, de
 djnz addloop
 ld (number), hl
 pop hl
zero:
 pop bc

 ; Move onto next digit
 inc hl
 djnz loop

 ; Finish
finish:
 jp start

; Digit multipliers
hex:
.dw 1,16,256,4096
dec:
.dw 1,10,100,1000,10000
bin:
.dw 1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768

; Author string
author:
.db "By Robin Kay",0

extdata: ; External data

textbuf .equ extdata
select  .equ textbuf+16
length  .equ select+1
number  .equ length+1
mbase   .equ number+2

.end
