; Resistor Toolkit v1.0 for TSE
; By Robin Kay
;

; You may not distribute a modified version of this program. However, you
; may take code from or base your program on this code providing that the
; resulting program is at least 50% of your own work.

.nolist
#include "tse.inc"
.list

.org    userMem-3
.db     $BB,$6D
 ret

 .db "TSE",1                ; Header
prgtitle:
 .db " Resistor Toolkit", 0 ; Title
 .dw 55                     ; Stack Required

init:
 xor a
 ld hl, bands
 ld (hl), a
 inc hl
 ld (hl), a
 inc hl
 ld (hl), a
 inc hl
 ld (hl), a
 ld a, 4
 ld (select), a

start:

 ; Display title
 bcall(_clrLCDFull)
 ld hl, 0
 ld (currow), hl
 ld hl, prgtitle + 1
 bcall(_puts)
 ld hl, author
 bcall(_puts)
 bcall(_newline)

 ; Display value digits
 ld hl, valuetxt
 call putStr
 ld b, 3
 ld hl, bands
disploop:
 ld a, (hl)
 add a, 30h
 bcall(_putc)
 inc hl
 djnz disploop

 ; Display value multiplyer
 ld hl, multiply - 4
 ld de, 4
 ld a, (zeros)
 ld b, a
 inc b
multiplyloop:
 add hl, de
 djnz multiplyloop
 bcall(_puts)

 ; Display band selector
 ld de, bands
 ld hl, bandstxt - 8
 ld b, 4
bandsloop:
 push bc
 ld bc, 8
 add hl, bc
 pop bc
 push hl
 push bc
 push de
 call putStr

 ld a, (select)
 cp b
 ld a, 20h
 jr nz, notSelect
 ld a, 3Eh
notSelect:
 bcall(_putc)

 ld a, (de)
 ld b, a
 inc b
 ld hl, colours - 7
 ld de, 7
colourloop:
 add hl, de
 djnz colourloop
 bcall(_puts)

 pop de
 pop bc
 pop hl
 inc de
 djnz bandsloop

mainloop:
 ei
 halt ; Save power
 bcall(_GetCSC)
 cp skClear
 jp z, init
 cp skUp
 jr z, moveUp
 cp skDown
 jr z, moveDown
 cp skLeft
 jr z, changeLeft
 cp skRight
 jr z, changeRight
 cp skStat
 jr nz, mainloop
 call _tseForceYield
 jp start

moveUp:
 ld a, (select)
 inc a
 cp 0
 jr nz, dontWrapDown
 ld a, 4
dontwrapDown:
 ld (select), a
 jp start

moveDown:
 ld a, (select)
 dec a
 cp 5
 jr nz, dontWrapUp
 ld a, 1
dontWrapUp:
 ld (select), a
 jp start

changeLeft:
 ld a, (select)
 ld c, a
 ld b, 0
 ld hl, zeros + 1
 or a
 sbc hl, bc
 ld a, (hl)
 dec a
 cp -1
 jr nz, dontWrapRight
 ld a, 9
dontWrapRight:
 ld (hl), a
 jp start

changeRight:
 ld a, (select)
 ld c, a
 ld b, 0
 ld hl, zeros + 1
 or a
 sbc hl, bc
 ld a, (hl)
 inc a
 cp 10
 jr nz, dontWrapLeft
 ld a, 0
dontWrapLeft:
 ld (hl), a
 jp start

; Display string and then advance a line onwards
putStr:
 bcall(_newline)
 bcall(_puts)
 ret

; Display digit in a
putDigit:
 add a, 30h
 bcall(_putc)
 ret

colours:
.db "Black ",0
.db "Brown ",0
.db "Red   ",0
.db "Orange",0
.db "Yellow",0
.db "Green ",0
.db "Blue  ",0
.db "Violet",0
.db "Grey  ",0
.db "White ",0

multiply:
.db "R  ",0
.db "0R ",0
.db "00R",0
.db "K  ",0
.db "0K ",0
.db "00K",0
.db "M  ",0
.db "0M ",0
.db "00M",0
.db "000M",0 ; Can be longer as is last entry

bandstxt:
.db "Band 1 ",0
.db "Band 2 ",0
.db "Band 3 ",0
.db "Band M ",0

author:
.db "By Robin Kay",0
valuetxt:
.db "Value ",0

extdata:
bands    .equ extdata
zeros    .equ bands + 3
select   .equ zeros + 1

.end
