; collision.asm
;  created 10/11/02

; collision for enemy movement
isEnemyValid:
 ld a,(enemyTempX)
 or a
 ret z
 cp 23
 ret nc
 ld l,a
 ld h,0
 ld a,(enemyTempY)
 or a
 ret z
 cp 15
 ret nc
 ld b,a
 ld e,NUMCOLS
 ld d,0
multiplyYvectorE:
 add hl,de
 djnz multiplyYvectorE

noMultYVectorE: 
 ld de,map
 add hl,de

 ; check tile
 ld a,(hl)
 cp 1
 ret z
 cp 2
 ret z

 scf				; carry flag is set if the space is valid
 ret



; collision detection for your movement

isSpaceValid:
 ld a,(xpos)
 ld l,a
 ld h,0
 ld a,(ypos)
 or a
 jr z,noMultYVector
 ld b,a
 ld e,NUMCOLS
 ld d,0
multiplyYvector:
 add hl,de
 djnz multiplyYvector

noMultYVector:
 ld de,map
 add hl,de

 ld a,(hl)
 cp 1
 jr z,makeITvisible
 cp 2
 jr z,canWEknockITdown
 cp 5
 jr z,endOfLevel
 cp 7
 jr z,axeFOUND
 cp 6
 jr nz,spaceValid

 ld a,(scrolls)			; its a scroll!!!
 inc a
 ld (scrolls),a 
 jr spaceValid

axeFOUND:
 ld a,(axes)
 inc a
 ld (axes),a

spaceValid:
 ld (hl),0
 scf				; carry flag is set if the space is valid
 ret

makeITvisible:
 ld (hl),2
 ei
 halt
 ret

endOfLevel:
 ld a,1
 ld (levelEnd),a
 ret

canWEknockITdown:
 ld a,(axes)
 or a
 ret z
 dec a
 ld (axes),a
 
 push hl
 ld a,(ypos)
 ld e,a
 ld a,(xpos)
 ld hl,exit
 call sprite
 B_CALL GrBufCpy

; call delay
 ei
 halt
 halt
 halt
 halt
 halt

 pop hl
 jr spaceValid
