; Rogue - by Harper Maddox

; began: a very long time ago.

 include "ti83plus.inc"

; ---
; equates
;------


 ; initialize

intrptEnPort    equ 3           ; interrupt enable (in/out) 
iall                    equ 1011b 
_LCD_DRIVERON   equ 4978h 
onFlags                 equ 9           ;on key flags 
onRunning               equ 3           ; 1=calculator is running 
monFlags                equ     1       ;monitor flags 
monAbandon              equ     4       ; 1=don't start any long process in put away 
_PutAway                equ 403Ch 
_reloadAppEntryVecs equ 4C36h 
_settblgraphdraw        equ 4C00h 
_ShRAcc		equ 41D4h

diDown		.equ 254 
diLeft		.equ 253 
diRight		.equ 251 
diUp		.equ 247 
diY		.equ 239
diGraph .equ 254
di2nd		.equ 223
diMode		.equ 191
diDel		.equ 127


NUMCOLS .equ 24			; handy equate

;----
; Variables
;------------
; etc
xpos equ appBackUpScreen
ypos equ xpos+1
levelEnd equ ypos+1
enemies equ levelEnd+1
lives equ enemies+1
scrolls equ lives+1
axes equ scrolls+1

map equ axes+1			; 16*24+1 = 385 bytes
maplastline equ map+360
randseed equ appBackUpScreen+765			; randseed is 2 bytes
enemyTempX equ map+385
enemyTempY equ enemyTempX+1
enemy_array equ enemyTempY+1		; 768-399= approx 349 bytes is ArrayMAX
;format
; enemy X = 1st byte
; enemy Y = 2nd byte
; null terminated

;------------------------
;--      HEADER        --
;------------------------

EXT_APP equ 1   ;This definition is required of all apps
cseg            ;This linker directive is required of all apps.

;This is the application header definition area required for all apps.
 db 080h,0Fh    ;Field: Program length
 db   00h,00h,00h,00h ;Length=0 (N/A for unsigned apps)
 db 080h,012h    ;Field: Program type
 db   01h,04h    ;Type= Shareware, TI-83Plus
 db 080h,021h    ;Field: App ID
 db   01h        ;Id = 1
 db 080h,031h    ;Field: App Build
 db   01h        ;Build = 1
 db 080h,048h    ;Field: App Name
 db "Rogue   "   ;Name = "Hello   " must be 8 characters
 db 080h,081h    ;Field: App Pages
 db 01h          ;App Pages = 1
 db 080h,090h    ;No default splash screen
 db 03h,026h ,09h,04h, 04h,06fh,01bh,80h     ;Field: Date stamp- 5/12/1999
 db 02h,0dh,040h                             ;Dummy encrypted TI date stamp signature
 db 0a1h ,06bh ,099h ,0f6h ,059h ,0bch ,067h 
 db 0f5h ,085h ,09ch ,09h ,06ch ,0fh ,0b4h ,03h ,09bh ,0c9h 
 db 03h ,032h ,02ch ,0e0h ,03h ,020h ,0e3h ,02ch ,0f4h ,02dh 
 db 073h ,0b4h ,027h ,0c4h ,0a0h ,072h ,054h ,0b9h ,0eah ,07ch 
 db 03bh ,0aah ,016h ,0f6h ,077h ,083h ,07ah ,0eeh ,01ah ,0d4h 
 db 042h ,04ch ,06bh ,08bh ,013h ,01fh ,0bbh ,093h ,08bh ,0fch 
 db 019h ,01ch ,03ch ,0ech ,04dh ,0e5h ,075h 
 db 80h,7Fh      ;Field: Program Image length
 db   0,0,0,0    ;Length=0, N/A
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 
;End of header data

;------------------------
;-- START PROGRAM CODE --
;------------------------

prog_start:
 ; introduce the game
 include "intro.asm"

 ; now we load the random map
 call randLevel
 call fixBorders

 B_CALL grbufclr

 call displayMAP

 B_CALL GrBufCpy

 ; delay
 ld b,15
showALLofMAP:
 call delay
 djnz showALLofMAP

 ; hide most of the walls.
 call hideWALLS

 ; add an exit
 call addLevelExit

 ; initial position for Rogue (the hero)
 ld a,2
 ld (xpos),a
 ld a,8
 ld (ypos),a

 ; eliminate wall from your current location
 ld hl,map+8*NUMCOLS+2
 ld (hl),0

 ; load the enemies

 call loadEnemies

main:
 B_CALL grbufclr
 call displayMAP

 call moveEnemies
 call showEnemies

 ; check for a collision with an enemy
 ld a,(enemies)
 ld b,a
 ld hl,enemy_array
 ld a,(xpos)
 ld d,a
 ld a,(ypos)
 ld e,a
collideWithEnemy:
 push bc
  ld a,(hl)
  cp d
  jr nz,noCollisionWithEnemy1
  inc hl
  ld a,(hl)
  cp e
  jr nz,noCollisionWithEnemy2

 pop bc

  ; we have a collision!!!

showDeathAnimation:
  call invertScreen  ; flash the screen
  B_CALL grbufcpy
  call delay
  call invertScreen
  B_CALL grbufcpy
    call delay
  call invertScreen  ; flash the screen
  B_CALL grbufcpy
  call delay
  call invertScreen
  B_CALL grbufcpy
  call delay
  call waitUntilKEYup
  ld a,(lives)
  dec a
  jp z,endGame
  ld (lives),a
  jp restartLevel

noCollisionWithEnemy1:
  inc hl
noCollisionWithEnemy2:
 pop bc
 inc hl
 djnz collideWithEnemy

 ld a,(ypos)
 ld e,a
 ld a,(xpos)
 ld hl,rogue
 call sprite

 B_CALL GrBufCpy

 ld a,(levelEnd)
 or a
 jp nz,LevelDONE

 ; wait for keypresses
 call delay

 ; DI keypresses
 ld a,0ffh 			;resets the keypad.
 out (1),a			;'Required syntax' :)
 ld a,0feh 			;Enable group 1.
 out (1),a 			
 in a,(1) 			;'Required Syntax'
 cp diLeft
 jr z,youMOVEleft
 cp diRight
 jr z,youMOVEright
 cp diUp
 jr z,youMOVEup
 cp diDown
 jr z,youMOVEdown

 ; Regular Keypresses
 ld a,0ffh 			;Reset keypad again.
 out (1),a
 ld a,0bfh			;Enable group 2.
 out (1),a 
 in a,(1)
 cp di2nd
 jp z,teleport
 cp diDel
 jp z,showDeathAnimation
 cp diMode
 jp nz,main

 jp quit

youMOVEleft:
 ld a,(xpos)
 or a
 jp z,main
 dec a
 ld (xpos),a

 call isSpaceValid
 jp c,main

 ld hl,xpos
 inc (hl)

 jp main

youMOVEright:
 ld a,(xpos)
 cp 23
 jp z,main
 inc a
 ld (xpos),a

 call isSpaceValid
 jp c,main

 ld hl,xpos
 dec (hl)

 jp main

youMOVEup:
 ld a,(ypos)
 or a
 jp z,main
 dec a
 ld (ypos),a

 call isSpaceValid
 jp c,main

 ld hl,ypos
 inc (hl)

 jp main

youMOVEdown:
 ld a,(ypos)
 cp 15
 jp z,main
 inc a
 ld (ypos),a

 call isSpaceValid
 jp c,main

 ld hl,ypos
 dec (hl)

 jp main

 ; TELEPORT code
 ;  sends you to a random location on the map

teleport:
 ld a,(scrolls)
 or a
 jp z,main
 dec a
 ld (scrolls),a

TelePORTstartover:
 call getrand
 and 11111b
 cp 24
 jr nc,TelePORTstartover
 ld (xpos),a
 
 call getrand
 and 1111b
 ld (ypos),a

 call isSpaceValid
 jr nc,TelePORTstartover

 ld hl,xpos
 inc (hl)

 call isSpaceValid
 jr nc,TelePORTstartover

 ld hl,xpos
 dec (hl)
 jp main


 include "collision.asm"
endGame:
 ; GAME OVER
 B_CALL grbufclr
 call loadTitle

 B_CALL grbufcpy

 ld hl,0305h
 ld (currow),hl
 ld hl,game_text4
 call putsApp

 B_CALL getkey

 ; Continue (y/n)?

quit:
 ; exit code

    b_call  LCD_DRIVERON
    set     onRunning,(iy+onFlags)
    ei

    b_jump  JForceCmdNoChar




 include "map.asm"
 include "enemy.asm"
 include "createboard.asm"
 include "utility.asm"
 include "data.asm"

.end
END






