#include "dwedit.inc"

pos = saferam3
level = SafeRam3+2

tTitle:
#ifndef ZES
  .db     "IceClimb 1.01",0
#endif

DefaultSpriteHeight = 8
#DEFINE NO_MOD_AX

mapram = savesscreen

lblStart:
	ld a,0
	ld (level),a
	jp getlevel
PlayGame:
	call frame
	call waitkey
	ld hl,(pos)
	ld c,12
	cp gLeft
	jr z,moveLeft
	cp gRight
	jr z,moveRight
	cp gUp
	jr z,moveUp
	cp gDown
	jr z,moveDown
	cp gClear
	ret z
	cp g2nd
	jp z,JumpLeft
	cp gMode
	jp z,JumpRight
	cp gAdd
	jp z,NextLevel
	jr PlayGame
moveLeft:
	dec hl
AfterMoveStd:
	ld a,(hl)
	dec a
	jp z,PlayGame
	ld (pos),hl
Fall:
	ld b,0
	ld hl,(pos)
	add hl,bc
	ld a,(hl)
	or a
	jp nz,PlayGame
FallLoop:
	call frame
	ld (pos),hl
	add hl,bc
	ld a,(hl)
	or a
	jr z,FallLoop
	cp 4
	jr z,FallLoop
	cp 2
	jr nz,PlayGame
Death:
	call RenderScreen
	ld b,10
Death2:
	push bc
	ei
Delay2:
	halt
	djnz Delay2
	call InvertScreen
	pop bc
	djnz Death2
	jp repos
moveRight:
	inc hl
	jr AfterMoveStd
moveUp:
	ld a,(hl)
	cp 6
	jp z,NextLevel
	cp 3
	jp nz,PlayGame
	sbc hl,bc
	jr AfterMoveStd
moveDown:
	add hl,bc
	ld a,(hl)
	cp 3
	jp c,PlayGame
	jr AfterMoveStd
JumpStd:
	sbc hl,bc
	ld a,(hl)
	dec a
	jp z,PlayGame
	ld (pos),hl
	call frame
	sbc hl,bc
	ld a,(hl)
	dec a
	jr z,Fall
	ld (pos),hl
	ld b,3
JumpStdLoop:
	call frame
	add hl,de
	ld a,(hl)
	dec a
	jr z,Fall
	ld (pos),hl
	djnz JumpStdLoop
	jr fall
JumpLeft:
	ld de,-1
	jr JumpStd

JumpRight:
	ld de,1
	jr JumpStd

Frame:
	push bc
	push de
	push hl
	call RenderScreen
	ld hl,(pos)
	ld bc,mapram
	sbc hl,bc
	ld a,3
#ifdef TI82
	call _divhlbya
#else
	bcall(_divhlbya)
#endif
	ld a,l
	ld c,a
	cpl
	add a,%01010000
	jr nc,Skipmax
	ld a,255
SkipMax:
	ld b,a
;---------= Make a sound =---------
; c=frequency, b=duration
beep:	di
#ifdef TI82 \ ld e,$FC \ #else \ ld e,$D0 \ #endif
beepl1:	ld	a,c
beepl2:	dec	a
	jr	nz,beepl2
	ld	a,e
#ifdef TI82 \ xor %00111100 \ #else \ xor %00000011 \ #endif
	ld	e,a
	out	(0),a
	djnz	beepl1
	ei
	pop hl
	pop de
	pop bc
	ret

RenderScreen:
Displaycave:
	ld hl,(pos)
	ld bc, 65
	or a
	sbc hl,bc
	ex de, hl
	ld hl, plotsscreen
	ld bc, 8*256+0
DrawmapLoop:
	ld a, (de)
	push de
	push hl
	ld l, a
	ld h, 0
	add hl, hl
	add hl, hl
	add hl, hl
	ld de, sprites
	add hl, de
	ex de, hl
	pop hl
	push bc
	ld b, 8
	push hl
DrawmapLoop2:
	ld a, (de)
	ld (hl),a
	inc de
	push bc
	ld bc, 12
	add hl, bc
	pop bc
	djnz DrawmapLoop2
	pop hl
	pop bc
	pop de
	inc de
	inc hl
	inc c
	ld a, c
	cp 12
	jr nz, Drawmaploop
	ld c,0
	push de
	ld de, 7*12
	add hl, de
	pop de
	djnz Drawmaploop

	ld hl,player
	ld bc,$2828
	call PutSprClp
	call ionfastcopy
	ret

waitkey:
  ei
WKA_loop:
  HALT
#ifndef TI82
	bcall(_getcsc)
#else
	call _getcsc
#endif
  or a
  jr z, WKA_loop
  ret

Victoly:
	bcall(_ClrLCDFull)
	ld hl,0
	ld (currow),hl
	ld hl,tVictoly
	bcall(_PutS)
	call waitkey
	ret
NextLevel:
	ld a,(level)
	inc a
	ld (level),a
	cp 4
	jr z,victoly
GetLevel:
	ld bc,(level)
	sla c
	ld b,0
	ld ix,maps
	add ix,bc
	ld h,(ix+1)
	ld l,(ix+0)
	;======================================
	;  Step 3: Do the real decompression!
	;======================================
	;
	;Prepare for loop
	ld de,mapram
	ld c,0
	;Start a loop
rleloop1:
	;Get the byte at hl
	ld a,(hl)
	;Exit on FF
	cp 255
	jr z, Repos
	;Copy that to b
	ld b,a
	;move top nib of b to bottom
	srl b
	srl b
	srl b
	srl b
	;Increment b
	inc b
	;Remove first 4 bits from a
	and 15
	;Start a loop
rleloop2:
	;Store the data
	ld (de),a
	;Increase the destination address
	inc de
	;repeat b times
	djnz rleloop2
	;Increase source offset
	inc hl
	;Do it again
	jr rleloop1
Repos:
	ld bc,(level)
	sla c
	ld b,0
	ld ix,starts
	add ix,bc
	ld h,(ix+1)
	ld l,(ix+0)
	ld (pos),hl
	jp PlayGame

InvertScreen:
	ld hl,plotsscreen
	ld d,h
	ld e,l
	ld bc,768
InvertLoop:
	ld a,(hl)
	cpl
	ld (hl),a
	ldi
	jp pe,InvertLoop
 	jp ionfastcopy

#INCLUDE "SPR21AX.INC"


player:
	.db %11100011
	.db %11000001
	.db %11000001
	.db %11000001
	.db %11000001
	.db %10000000
	.db %11000001
	.db %11001001

	.db %00011100
	.db %00101010
	.db %00110110
	.db %00111110
	.db %01110111
	.db %00100010
	.db %00111110
	.db %00110110

Sprites:

	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

	.db %11111111
	.db %10100111
	.db %11001101
	.db %10011001
	.db %10110001
	.db %11100001
	.db %11000011
	.db %11111111

	.db %01000100
	.db %01000100
	.db %01000100
	.db %01100110
	.db %11101110
	.db %11101110
	.db %11101110
	.db %11111111

	.db %11000011
	.db %11000011
	.db %11111111
	.db %11000011
	.db %11000011
	.db %11000011
	.db %11111111
	.db %11000011

	.db %11111111
	.db %00100110
	.db %01001101
	.db %11111111
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

	.db %11111111
	.db %10011101
	.db %10111001
	.db %11111111
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000

	.db %11111111
	.db %11000011
	.db %10000001
	.db %10000001
	.db %10000101
	.db %10000101
	.db %10000001
	.db %10000001

#include "icemaps.h"

      ;0123456789ABCDEF
tVictoly:
	.db "A winner is you!"
	.db "    VICTOLY!"    ,0

#ifdef SOS
libs:
 .db "ZGFXL",0,0,0,lib2,vec3
 .db $FF

ionfastcopy = vector3
#endif

.end
END