;Include file needed to access system routines

EXT_APP equ 1   ;This definition is required of all apps
cseg            ;This linker directive is required of all apps.

;This is the application header definition area required for all apps.
 db 080h,0Fh    ;Field: Program length
 db   00h,00h,00h,00h ;Length=0 (N/A for unsigned apps)
 db 080h,012h    ;Field: Program type
 db   01h,04h  ;Type= Shareware, TI-83Plus
 db 080h,021h    ;Field: App ID
 db   01h       ;Id = 1
 db 080h,031h    ;Field: App Build
 db   01h       ;Build = 1
 db 080h,048h    ;Field: App Name
 db "MtSQuest" ;Name must be 8 characters
 db 080h,081h    ;Field: App Pages
 db 01h         ;App Pages = 1
 db 080h,090h    ;No default splash screen
 db 03h,026h ,09h,04h, 04h,06fh,01bh,80h     ;Field: Date stamp- 5/12/1999
 db 02h,0dh,040h                             ;Dummy encrypted TI date stamp signature
 db 0a1h ,06bh ,099h ,0f6h ,059h ,0bch ,067h 
 db 0f5h ,085h ,09ch ,09h ,06ch ,0fh ,0b4h ,03h ,09bh ,0c9h 
 db 03h ,032h ,02ch ,0e0h ,03h ,020h ,0e3h ,02ch ,0f4h ,02dh 
 db 073h ,0b4h ,027h ,0c4h ,0a0h ,072h ,054h ,0b9h ,0eah ,07ch 
 db 03bh ,0aah ,016h ,0f6h ,077h ,083h ,07ah ,0eeh ,01ah ,0d4h 
 db 042h ,04ch ,06bh ,08bh ,013h ,01fh ,0bbh ,093h ,08bh ,0fch 
 db 019h ,01ch ,03ch ,0ech ,04dh ,0e5h ,075h 
 db 80h,7Fh      ;Field: Program Image length
 db   0,0,0,0    ;Length=0, N/A
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved

;End of header data

 include "ti83plus.inc"
 include "keys.inc"

Start:
	B_CALL clrlcdf
	B_CALL grbufclr
	ld hl,Pic1
	ld de,plotsscreen
	ld bc,768
	ldir
	B_CALL grbufcpy
	call Delay
	call Pause
	ld a,23
	ld (CursorX),a
	ld a,42
	ld (CursorY),a
	call Delay
Menu:
	B_CALL grbufclr
	ld hl,Pic2
	ld de,plotsscreen
	ld bc,420
	ldir
	B_CALL grbufcpy
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	ld a,42
	ld (penrow),a
	ld a,33
	ld (pencol),a
	ld hl,txtNew
	call vputsapp
	ld a,49
	ld (penrow),a
	ld a,33
	ld (pencol),a
	ld hl,txtContinue
	call vputsapp
	ld a,56
	ld (penrow),a
	ld a,33
	ld (pencol),a
	ld hl,txtQuit
	call vputsapp
Getkeys:
	B_CALL GetCSC
	cp skUp
	jp z,CursorUp
	cp skDown
	jp z,CursorDown
	cp skPrgm
	jp z,CheatCheck
	cp sk2nd
	jp z,Select
	cp skEnter
	jp z,Select
	cp skClear
	jp z,Quit
	jp nz,Getkeys

CursorUp:
	call ClearCursor
	ld a,(CursorY)
	ld b,7
	sub b
	ld (CursorY),a
	cp 35
	jp z,TooFarUp
	jp nz,Menu

CursorDown:
	call ClearCursor
	ld a,(CursorY)
	ld b,7
	add a,b
	ld (CursorY),a
	cp 63
	jp z,TooFarDown
	jp nz,Menu

TooFarUp:
	ld a,56
	ld (CursorY),a
	jp Menu

TooFarDown:
	ld a,42
	ld (CursorY),a
	jp Menu

Select:
	ld a,(CursorY)
	cp 42
	jp z,NewGame
	cp 49
	jp z,ContinueGame
	cp 56
	jp z,Quit
	jp nz,Start

CheatCheck:
	ld a,(CursorY)
	cp 42
	jp nz,Select
CheatGame:
	ld a,5
	ld (Cheat),a
	ld a,255
	ld (HP),a
	ld (MaxHP),a
	ld (MarcSP),a
	ld (MaxSP),a
	ld a,10
	ld (Level),a
	ld a,100
	ld (Potions),a
	ld (Rings),a
	ld a,255
	ld (Battle),a
	ld a,4
	ld (Specials),a
	jp NewGameText
NewGame:
	xor a
	ld (Cheat),a
	ld a,20
	ld (HP),a
	ld (MaxHP),a
	xor a
	ld (MarcSP),a
	ld (MaxSP),a
	ld a,1
	ld (Level),a
	ld a,5
	ld (Potions),a
	xor a
	ld (Battle),a
	ld (Rings),a
	ld (Specials),a
NewGameText:
	ld a,1
	ld (Map),a
	ld a,3
	ld (Ypos),a
	ld a,6
	ld (Xpos),a
	B_CALL grbufclr
	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtBegin
	call PutSmallText
	call Delay
	call Delay
	call Pause
	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtBegin2
	call PutSmallText
	call Delay
	call Delay
	call Pause
	ld a,(Cheat)
	cp 5
	jp z,PlayGame
	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtNoCheat
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

ContinueGame:
	B_CALL clrlcdf
	call Find
	jp nc,loading
loading:
	inc de
	inc de
	ex de,hl
	ld de,Save
	ld bc,1
	ldir

	ld de,Cheat
	ld bc,1
	ldir

	ld de,Map
	ld bc,1
	ldir

	ld de,Xpos
	ld bc,1
	ldir

	ld de,Ypos
	ld bc,1
	ldir

	ld de,HP
	ld bc,1
	ldir

	ld de,MaxHP
	ld bc,1
	ldir

	ld de,MarcSP
	ld bc,1
	ldir

	ld de,MaxSP
	ld bc,1
	ldir

	ld de,Level
	ld bc,1
	ldir

	ld de,Battle
	ld bc,1
	ldir

	ld de,Potions
	ld bc,1
	ldir

	ld de,Rings
	ld bc,1
	ldir

	ld de,Specials
	ld bc,1
	ldir

	ld a,(Save)
	cp 39
	jp nz,NoLoad
	B_CALL clrlcdf
	xor a			;a=0
	ld (currow),a
	ld (curcol),a
	ld hl,txtGameLoaded
	call putsapp
	call Pause
	jp PlayGame

NoLoad:
	B_CALL clrlcdf
	B_CALL grbufclr
	xor a
	ld (currow),a
	ld (curcol),a
	ld hl,txtNoSave
	call putsapp
	call Delay
	call Delay
	call Pause
	jp Menu

;======================================================
;                 Main part of the Game
;======================================================

PlayGame:
	call ChooseMap
	jp DrawScreen

GetLocation:
  ld   a,(Ypos) ;=1
  add  a,a ;=2
  add  a,a ;=4
  ld   b,a ;=4
  add  a,a ;=8
  add  a,b ;=12
  ld   b,a ;=12
  ld   a,(Xpos) ;=1
  add  a,b ;=13
  ld de, TileMap
  ld   h,0
  ld   l,a
  add  hl,de
  ret  

PutAlignedSprite_And_Or:
  ld   a,(Ypos)
  ld   h,0
  ld   l,a
  add  hl,hl ;2hl
  add  hl,hl ;4hl
  add  hl,hl ;8hl
  add  hl,hl ;16hl
  add  hl,hl ;32hl
  ld   d,h
  ld   e,l
  add  hl,hl ;64hl
  add  hl,de ;96hl
  ld   a,(Xpos)
  ld   d,0
  ld   e,a
  add  hl,de
  ld   de,plotsscreen
  add  hl,de
  ld   ix,imgMarc
  ld   b,8
  ld   de,12
PutAlignedSprite_And_Or2:
  ld   a,(ix)
  ld   (hl),a
  add  hl,de
  inc  ix
  djnz PutAlignedSprite_And_Or2
  ret

;Drawmap Routine
;Map is pointed by DE, all tiles should be located at tiles:
;All tiles are 8x8
Drawmap:
	ld hl, plotsscreen
	ld bc, 8*256+0
DrawmapLoop:
	ld a, (de)
	push de
	push hl
	ld l, a
	ld h, 0
	add hl, hl
	add hl, hl
	add hl, hl
	ld de,Tiles
	add hl, de
	ex de, hl
	pop hl
	push bc
	ld b, 8
	push hl
DrawmapLoop2:
	ld a, (de)
	ld (hl),a
	inc de
	push bc
	ld bc, 12
	add hl,bc
	pop bc
	djnz DrawmapLoop2
	pop hl
	pop bc
	pop de
	inc de
	inc hl
	inc c
	ld a, c
	cp 12
	jr nz, DrawmapLoop
	ld c,0
	push de
	ld de, 7*12
	add hl, de
	pop de
	djnz DrawmapLoop
	ret

DrawScreen:
  B_CALL grbufclr
  ld de, TileMap
  call Drawmap
  call PutAlignedSprite_And_Or
  call FastCopy
MoveKey:
	B_CALL GetCSC
	cp skUp
	jp z,MoveUp
	cp skDown
	jp z,MoveDown
	cp skLeft
	jp z,MoveLeft
	cp skRight
	jp z,MoveRight
	cp skClear
	jp z,Quit
	cp sk2nd
	jp z,SaveStats
	jp nz,MoveKey
MoveLeft:
  ld   a,(Xpos)
  or   a
  jp   z,MoveKey
  call GetLocation
  dec  hl
  ld   a,(hl)
  or a
  jp z,Left
	cp 1
	jp z,ChangeMap
	cp 2
	jp z,CheckHouse
	cp 3
	jp z,CheckCave
	cp 4
	jp z,ChangeMap
	cp 5
	jp z,BattleMechAnna
	cp 6
	jp z,BattleRobotnik
	jp nz,MoveKey

MoveRight:
  ld   a,(Xpos)
  cp   11
  jp   z,MoveKey
  call GetLocation
  inc  hl
  ld   a,(hl)
  or a
  jp z,Right
	cp 1
	jp z,ChangeMap
	cp 2
	jp z,CheckHouse
	cp 3
	jp z,CheckCave
	cp 4
	jp z,ChangeMap
	cp 5
	jp z,BattleMechAnna
	cp 6
	jp z,BattleRobotnik
	jp nz,MoveKey
MoveUp:
  ld   a,(Ypos)
  or   a
  jp   z,MoveKey
  call GetLocation
  or   a			 ;just clears carry flag
  ld   de,12
  sbc  hl,de
  ld   a,(hl)
  or a
  jp z,Up
	cp 1
	jp z,ChangeMap
	cp 2
	jp z,CheckHouse
	cp 3
	jp z,CheckCave
	cp 4
	jp z,ChangeMap
	cp 5
	jp z,BattleMechAnna
	cp 6
	jp z,BattleRobotnik
	jp nz,MoveKey
MoveDown:
  ld   a,(Ypos)
  cp   7
  jp   z,MoveKey
  call GetLocation
  ld   de,12
  add  hl,de
  ld   a,(hl)
  or a
  jp z,Down
	cp 1
	jp z,ChangeMap
	cp 2
	jp z,CheckHouse
	cp 3
	jp z,CheckCave
	cp 4
	jp z,ChangeMap
	cp 5
	jp z,BattleMechAnna
	cp 6
	jp z,BattleRobotnik
	jp nz,MoveKey

Left:
  ld a,(Xpos)
  dec a
  ld (Xpos),a
  call Delay
  jp CheckMonster

Right:
  ld a,(Xpos)
  inc a
  ld (Xpos),a
  call Delay
  jp CheckMonster

Down:
  ld a,(Ypos)
  inc a
  ld (Ypos),a
  call Delay
  jp CheckMonster

Up:
  ld a,(Ypos)
  dec a
  ld (Ypos),a
  call Delay
  jp CheckMonster

SaveStats:
	B_CALL clrlcdf
	B_CALL grbufclr
	jp UsePotionCheck
StatusScreen:
	B_CALL clrlcdf
	B_CALL grbufclr
	xor a
	ld (curcol),a
	ld (currow),a
	ld hl,txtStats
	call putsapp
	ld a,11
	ld (curcol),a
	ld a,1
	ld (currow),a
	ld a,(HP)
	ld l,a
	ld h,0
	B_CALL disphl
	ld a,11
	ld (curcol),a
	ld a,2
	ld (currow),a
	ld a,(MaxHP)
	ld l,a
	ld h,0
	B_CALL disphl
	ld a,11
	ld (curcol),a
	ld a,3
	ld (currow),a
	ld a,(Level)
	ld l,a
	ld h,0
	B_CALL disphl
	ld a,11
	ld (curcol),a
	ld a,4
	ld (currow),a
	ld a,(Battle)
	ld l,a
	ld h,0
	B_CALL disphl
	ld a,11
	ld (curcol),a
	ld a,5
	ld (currow),a
	ld a,(Rings)
	ld l,a
	ld h,0
	B_CALL disphl
	ld a,11
	ld (curcol),a
	ld a,6
	ld (currow),a
	ld a,(Potions)
	ld l,a
	ld h,0
	B_CALL disphl
	call Delay
	call Delay
	call Pause
	call Find
	jp nc,Saving
	ld hl,MtSVar
	rst rMOV9TOOP1
	ld hl,50
	B_CALL CreateAppVar
Saving:
	call checkvar
	inc de
	inc de
	ld a,39
	ld (de),a
	inc de
	ld a,(Cheat)
	ld (de),a
	inc de
	ld a,(Map)
	ld (de),a
	inc de
	ld a,(Xpos)
	ld (de),a
	inc de
	ld a,(Ypos)
	ld (de),a
	inc de
	ld a,(HP)
	ld (de),a
	inc de
	ld a,(MaxHP)
	ld (de),a
	inc de
	ld a,(MarcSP)
	ld (de),a
	inc de
	ld a,(MaxSP)
	ld (de),a
	inc de
	ld a,(Level)
	ld (de),a
	inc de
	ld a,(Battle)
	ld (de),a
	inc de
	ld a,(Potions)
	ld (de),a
	inc de
	ld a,(Rings)
	ld (de),a
	inc de
	ld a,(Specials)
	ld (de),a
	inc de
	B_CALL clrlcdf
	xor a			;a=0
	ld (currow),a
	ld (curcol),a
	ld hl,txtGameSaved
	call putsapp
	call Pause
	jp PlayGame

CheckMonster:
	ld a,(Map)
	cp 1
	jp z,DrawScreen
	cp 3
	jp z,DrawScreen
	cp 6
	jp z,DrawScreen
	cp 8
	jp z,DrawScreen
	cp 11
	jp z,DrawScreen
	cp 12
	jp z,DrawScreen
	ld a,(Level)
	cp 10
	jp z,Level10Battles
	ld b,5
	call Random
	or a
	jp z, BeginBattling
	jp nz, DrawScreen

Level10Battles:
	ld b,10
	call Random
	or a
	jp z,BeginBattling
	jp nz, DrawScreen

UsePotionCheck:
	ld a,(Potions)
	or a
	jp z,StatusScreen
	ld a,(MaxHP)
	ld b,a
	ld a,(HP)
	cp b
	jp z,StatusScreen
	xor a
	ld (curcol),a
	ld (currow),a
	ld hl,txtAskPotion
	call putsapp
	jp PotionKeys

PotionKeys:
	B_CALL GetCSC
	cp sk1
	jp z,UsePotion
	cp skLog
	jp z,StatusScreen
	jp nz,PotionKeys

UsePotion:
	ld a,(Potions)
	dec a
	ld (Potions),a
	ld a,(MaxHP)
	ld (HP),a
	jp StatusScreen
	
ChangeMap:
	ld a,(Map)
	cp 1
	jp z,CheckChange2
	cp 2
	jp z,CheckChange3
	cp 3
	jp z,CheckChange4
	cp 4
	jp z,CheckChange5
	cp 5
	jp z,CheckChange6
	cp 6
	jp z,CheckChange7
	cp 8
	jp z,CheckChange9
	cp 9
	jp z,CheckChange10
	cp 10
	jp z,CheckChange11
	jp nz,Quit

CheckChange2:			;Map1 check
	ld a,(Xpos)
	cp 1
	jp z,CheckChange22
	cp 6
	jp nz,PlayGame
	ld a,(Ypos)
	cp 1
	jp z,CheckChangeTo2
	jp nz,PlayGame
CheckChange22:
	ld a,(Ypos)
	cp 4
	jp z,CheckChangeTo3
	jp nz,PlayGame

CheckChange3:			;Map2 check
	ld a,(Xpos)
	cp 6
	jp nz,PlayGame
	ld a,(Ypos)
	cp 6
	jp z,CheckChangeTo1
	jp nz,PlayGame
	
CheckChange4:			;Map3 check
	ld a,(Xpos)
	cp 6
	jp nz,PlayGame
	ld a,(Ypos)
	cp 1
	jp z,CheckChangeTo4
	jp nz,PlayGame

CheckChange5:			;Map4 check
	ld a,(Xpos)
	cp 6
	jp z,CheckChange55
	cp 10
	jp nz,PlayGame
	ld a,(Ypos)
	cp 2
	jp z,CheckChangeTo5
	jp nz,PlayGame
CheckChange55:
	ld a,(Ypos)
	cp 6
	jp z,CheckChangeTo3
	jp nz,PlayGame

CheckChange6:			;Map5 check
	ld a,(Xpos)
	cp 9
	jp z,CheckChange66
	cp 1
	jp nz,PlayGame
	ld a,(Ypos)
	cp 3
	jp z,CheckChangeTo41
	jp nz,PlayGame
CheckChange66:
	ld a,(Ypos)
	cp 6
	jp z,CheckChangeTo6
	jp nz,PlayGame

CheckChange7:			;Map6 check
	ld a,(Xpos)
	cp 8
	jp nz,PlayGame
	ld a,(Ypos)
	cp 1
	jp z,CheckChangeTo51
	jp nz,PlayGame

CheckChange9:			;Map8 check
	ld a,(Xpos)
	cp 10
	jp nz,PlayGame
	ld a,(Ypos)
	cp 4
	jp z,CheckChangeTo9
	jp nz,PlayGame

CheckChange10:			;Map9 check
	ld a,(Xpos)
	cp 10
	jp z,CheckChange1010
	cp 1
	jp nz,PlayGame
	ld a,(Ypos)
	cp 3
	jp z,CheckChangeTo8
	jp nz,PlayGame
CheckChange1010:
	ld a,(Ypos)
	cp 4
	jp z,CheckChangeTo10
	jp nz,PlayGame

CheckChange11:			;Map10 check
	ld a,(Xpos)
	cp 7
	jp z,CheckChange1111
	cp 1
	jp nz,PlayGame
	ld a,(Ypos)
	cp 2
	jp z,CheckChangeTo91
	jp nz,PlayGame
CheckChange1111:
	ld a,(Ypos)
	cp 1
	jp z,CheckChangeTo11
	jp nz,PlayGame

CheckChangeTo1:
	ld a,6
	ld (Xpos),a
	ld a,1
	ld (Ypos),a
	ld a,1
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo2:
	ld a,6
	ld (Xpos),a
	ld a,6
	ld (Ypos),a
	ld a,2
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo3:
	ld a,5
	ld (Xpos),a
	ld a,3
	ld (Ypos),a
	ld a,3
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo4:
	ld a,6
	ld (Xpos),a
	ld a,6
	ld (Ypos),a
	ld a,4
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo41:
	ld a,10
	ld (Xpos),a
	ld a,2
	ld (Ypos),a
	ld a,4
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo5:
	ld a,1
	ld (Xpos),a
	ld a,3
	ld (Ypos),a
	ld a,5
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo51:
	ld a,9
	ld (Xpos),a
	ld a,6
	ld (Ypos),a
	ld a,5
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo6:
	ld a,8
	ld (Xpos),a
	ld a,1
	ld (Ypos),a
	ld a,6
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo7:
	ld a,10
	ld (Xpos),a
	ld a,1
	ld (Ypos),a
	ld a,7
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo71:
	ld a,3
	ld (Xpos),a
	ld a,6
	ld (Ypos),a
	ld a,7
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo8:
	ld a,10
	ld (Xpos),a
	ld a,4
	ld (Ypos),a
	ld a,8
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo9:
	ld a,1
	ld (Xpos),a
	ld a,3
	ld (Ypos),a
	ld a,9
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo91:
	ld a,10
	ld (Xpos),a
	ld a,4
	ld (Ypos),a
	ld a,9
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo10:
	ld a,1
	ld (Xpos),a
	ld a,2
	ld (Ypos),a
	ld a,10
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckChangeTo11:
	ld a,6
	ld (Xpos),a
	ld a,6
	ld (Ypos),a
	ld a,11
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckCave:
	ld a,(Map)
	cp 6
	jp z,CheckChangeTo7
	cp 8
	jp z,CheckChangeTo71
	cp 7
	jp z,CaveTunnel

CaveTunnel:
	ld a,(Xpos)
	cp 1
	jp z,CheckTunnel1
	cp 2
	jp z,LeaveToMap8
	cp 3
	jp z,CheckTunnel1
	cp 4
	jp z,Tunnel2
	cp 6
	jp z,Tunnel3
	cp 8
	jp z,Tunnel4
	cp 10
	jp z,LeaveToMap6
	jp nz,PlayGame

CheckTunnel1:
	ld a,(Ypos)
	cp 1
	jp z,MoveTunnel1
	cp 6
	jp z,LeavingToMap8
	jp nz,PlayGame

LeaveToMap8:
	ld a,(Ypos)
	cp 5
	jp z,LeavingToMap8
	jp nz,PlayGame

Tunnel2:
	ld a,(Ypos)
	cp 6
	jp z,MoveTunnel2
	jp nz,PlayGame

Tunnel3:
	ld a,(Ypos)
	cp 4
	jp z,MoveTunnel3
	jp nz,PlayGame

Tunnel4:
	ld a,(Ypos)
	cp 2
	jp z,MoveTunnel4
	jp nz,PlayGame

LeaveToMap6:
	ld a,(Ypos)
	cp 1
	jp z,LeavingToMap6
	jp nz,PlayGame

MoveTunnel1:
	ld a,8
	ld (Xpos),a
	ld a,2
	ld (Ypos),a
	ld a,7
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

MoveTunnel2:
	ld a,6
	ld (Xpos),a
	ld a,4
	ld (Ypos),a
	ld a,7
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

MoveTunnel3:
	ld a,4
	ld (Xpos),a
	ld a,6
	ld (Ypos),a
	ld a,7
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

MoveTunnel4:
	ld a,1
	ld (Xpos),a
	ld a,1
	ld (Ypos),a
	ld a,7
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

LeavingToMap6:
	ld a,1
	ld (Xpos),a
	ld a,3
	ld (Ypos),a
	ld a,6
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

LeavingToMap8:
	ld a,1
	ld (Xpos),a
	ld a,1
	ld (Ypos),a
	ld a,8
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

CheckHouse:
	ld a,(Map)
	cp 2
	jp z,House2
	cp 3
	jp z,House3
	cp 6
	jp z,House6
	cp 8
	jp z,House8
	cp 10
	jp z,House10
	jp nz,PlayGame

House2:
	ld a,(Xpos)
	cp 2
	jp nz,PlayGame
	ld a,(Ypos)
	cp 1
	jp z,HealersHut
	jp nz,PlayGame

House3:
	ld a,(Xpos)
	cp 4
	jp z,CheckHouse1
	cp 5
	jp z,CheckHouse1
	cp 6
	jp z,CheckHouse1
	cp 7
	jp z,CheckHouse2
	cp 9
	jp z,CheckHouse2
	jp nz,PlayGame

CheckHouse1:
	ld a,(Ypos)
	cp 1
	jp z,CheckChangeTo1
	cp 2
	jp z,CheckChangeTo1
	cp 3
	jp z,CheckChangeTo1
	cp 4
	jp z,CheckChangeTo1
	jp nz,PlayGame

CheckHouse2:
	ld a,(Ypos)
	cp 1
	jp z,VisitHouse1
	cp 2
	jp z,VisitHouse1
	cp 3
	jp z,VisitHouse2
	cp 4
	jp z,VisitHouse2
	cp 5
	jp z,VisitHouse2
	jp nz,PlayGame

House6:
	ld a,(Xpos)
	cp 2
	jp z,CheckHouse3
	cp 3
	jp z,CheckHouse3
	cp 4
	jp z,CheckHouse3
	cp 7
	jp z,CheckHouse4
	cp 8
	jp z,CheckHouse4
	cp 9
	jp z,CheckHouse4
	cp 10
	jp z,CheckHouse4
	jp nz,PlayGame

CheckHouse3:
	ld a,(Ypos)
	cp 1
	jp z,HealersHut
	cp 2
	jp z,HealersHut
	cp 3
	jp z,VisitHouse3
	cp 4
	jp z,VisitHouse3
	cp 5
	jp z,VisitHouse3
	jp nz,PlayGame

CheckHouse4:
	ld a,(Ypos)
	cp 1
	jp z,VisitHouse4
	cp 2
	jp z,VisitHouse4
	cp 3
	jp z,VisitHouse4
	cp 4
	jp z,VisitHouse5
	cp 5
	jp z,VisitHouse5
	cp 6
	jp z,VisitHouse5

House8:
	ld a,(Xpos)
	cp 1
	jp z,CheckHouse5
	cp 2
	jp z,CheckHouse6
	cp 3
	jp z,CheckHouse7
	cp 4
	jp z,CheckHouse7
	jp nz,PlayGame
	
CheckHouse5:
	ld a,(Ypos)
	cp 2
	jp z,HealersHut
	cp 4
	jp z,HealersHut
	jp nz,PlayGame

CheckHouse6:
	ld a,(Ypos)
	cp 3
	jp z,HealersHut
	cp 5
	jp z,VisitHouse6

CheckHouse7:
	ld a,(Ypos)
	cp 4
	jp z,VisitHouse6
	cp 5
	jp z,VisitHouse6
	cp 6
	jp z,VisitHouse6
	
House10:
	ld a,(Xpos)
	cp 8
	jp nz,PlayGame
	ld a,(Ypos)
	cp 5
	jp z,UncleChuck
	jp nz,PlayGame

VisitHouse1:
	B_CALL clrlcdf
	ld hl,txtHouse2
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

VisitHouse2:
	B_CALL clrlcdf
	ld hl,txtHouse1
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

VisitHouse3:
	B_CALL clrlcdf
	ld hl,txtHouse2
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

VisitHouse4:
	B_CALL clrlcdf
	ld hl,txtHouse1
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

VisitHouse5:
	B_CALL clrlcdf
	ld hl,txtHouse3
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

VisitHouse6:
	B_CALL clrlcdf
	ld hl,txtHouse4
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp PlayGame

UncleChuck:
	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtUncleChuck
	call PutSmallText
	ld a,(MaxHP)
	ld (HP),a
	ld a,10
	B_CALL setxxop1
	ld a,(Level)
	B_CALL setxxop2
	B_CALL fpmult
	B_CALL convop1
	ld (Choice),a
	ld b,a
	ld a,(Potions)
	add a,b
	ld (Potions),a
	call Delay
	call Delay
	call Pause
	ld a,3
	ld (Ypos),a
	B_CALL clrlcdf
	jp PlayGame

HealersHut:
	ld a,(HP)
	ld b,a
	ld a,(MaxHP)
	cp b
	jp z,NoHealerHut
	jp nz,Healer

NoHealerHut:
	B_CALL clrlcdf
	ld a,1
	ld (pencol),a
	ld (penrow),a
	ld hl,txtNoHeal
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp PlayGame

Healer:
	B_CALL clrlcdf

	ld a,1
	ld (penrow),a
	ld a,23
	ld (pencol),a
	ld hl,txtHealersHut
	call vputsapp
	ld a,7
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtHealBar
	call vputsapp

	ld a,14
	ld (penrow),a
	ld hl,txtHealerMenu
	call PutSmallText

HealerKey:
	B_CALL GetCSC
	cp skCos
	jp z,FullHeal	;Full Heal
	cp skRParen		;Leave
	jp z,PlayGame
	jp nz,HealerKey

FullHeal:
	B_CALL clrlcdf
	xor a
	ld (curcol),a
	ld (currow),a
	ld hl,txtFullHeal
	call putsapp
	ld a,6
	ld (currow),a
	ld a,9
	ld (curcol),a
	ld a,(Rings)
	ld l,a
	ld h,0
	B_CALL disphl
	ld a,(Level)
	B_CALL setxxop1
	ld a,10
	B_CALL setxxop2
	B_CALL fpmult
	B_CALL convop1
	ld (HealMoney),a
	ld l,a
	ld h,0
	ld a,7
	ld (currow),a
	ld a,9
	ld (curcol),a
	B_CALL disphl
	call Delay
	call Delay
	call Pause
	jp FullHealKey

FullHealKey:
	B_CALL GetCSC
	cp sk2nd
	jp z,FullCheck
	cp skEnter
	jp z,FullCheck
	jp nz,Pause

FullCheck:
	ld a,(HealMoney)
	ld b,a
	ld a,(Rings)
	cp b
	jp m,NotEnough
	jp FullHealed

FullHealed:
	B_CALL clrlcdf
	ld a,(HealMoney)
	ld b,a
	ld a,(Rings)
	sub b
	ld (Rings),a
	ld a,(MaxHP)
	ld (HP),a
	xor a
	ld (curcol),a
	ld (currow),a
	ld hl,txtFullyHealed
	call putsapp
	call Delay
	call Delay
	call Pause
	jp PlayGame

NotEnough:
	B_CALL clrlcdf
	xor a
	ld (curcol),a
	ld (currow),a
	ld hl,txtNotEnough
	call putsapp
	call Delay
	call Delay
	call Pause
	jp HealersHut

BattleMechAnna:
	B_CALL clrlcdf
	ld hl,txtMechAnna1
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtMechAnna2
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp BeginBattling
WinMechAnna:
	B_CALL clrlcdf
	ld hl,txtMechAnna3
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	B_CALL clrlcdf
	ld hl,txtMechAnna4
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	ld a,6
	ld (Xpos),a
	ld (Ypos),a
	ld a,12
	ld (Map),a
	B_CALL clrlcdf
	jp PlayGame

BattleRobotnik:
	B_CALL clrlcdf
	ld hl,txtFightRobotnik
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp BeginBattling
WinRobotnik:
	B_CALL clrlcdf
	ld hl,txtEnd1
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld hl,txtEnd2
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld hl,txtEnd3
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld hl,txtEnd4
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld hl,txtEnd5
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld hl,txtEnd6
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld hl,txtEnd7
	ld a,-6
	ld (penrow),a
	call PutSmallText
	call Delay
	call Delay
	call Pause

WonTheGame:
	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtStaff
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtTesters
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtTesters2
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtThanks
	call PutSmallText
	call Delay
	call Delay
	call Pause

	B_CALL clrlcdf
	ld a,-6
	ld (penrow),a
	ld hl,txtOther
	call PutSmallText
	call Delay
	call Delay
	call Pause
	ld a,(Cheat)
	cp 5
	jp z,EndPic
	B_CALL clrlcdf
	xor a
	ld (currow),a
	ld (curcol),a
	ld hl,txtCongrats
	call putsapp
	call Delay
	call Delay
	call Pause
EndPic:
	B_CALL clrlcdf
	B_CALL grbufclr
	ld hl,Pic1
	ld de,plotsscreen
	ld bc,768
	ldir
	B_CALL grbufcpy
	call Delay
	call Delay
	call Pause
	jp Quit

;======================================================
;                    Battle Routine************
;======================================================
BeginBattling:
	B_CALL clrlcdf
	B_CALL grbufclr
	ld a,1
	ld (CursorX),a
	xor a
	ld (currow),a
	ld (curcol),a
FindMonster:
    ld a,(Map)
    cp 2
    jp z,CheckMap2
    cp 4
    jp z,CheckMap4
    cp 5
    jp z,CheckMap5
    cp 7
    jp z,CheckMap7
    cp 9
    jp z,CheckMap9
    cp 10
    jp z,CheckMap10
    cp 11
    jp z,CheckMap11
    cp 12
    jp z,CheckMap12

CheckMap2:
	ld b,4
	call Random
	inc a
	ld (Robot),a
	jp MonsterStats

CheckMap4:
	ld b,3
	call Random
	add a,2
	ld (Robot),a
	jp MonsterStats

CheckMap5:
	ld b,5
	call Random
	add a,2
	ld (Robot),a
	jp MonsterStats

CheckMap7:
	ld b,3
	call Random
	add a,6
	ld (Robot),a
	jp MonsterStats

CheckMap9:
	ld b,8
	call Random
	inc a
	ld (Robot),a
	jp MonsterStats

CheckMap10:
	ld b,8
	call Random
	inc a
	ld (Robot),a
	jp MonsterStats

CheckMap11:
	ld a,9
	ld (Robot),a
	jp MonsterStats

CheckMap12:
	ld a,10
	ld (Robot),a
	jp MonsterStats

Fight:
	B_CALL clrlcdf
	B_CALL grbufclr
	ld a,1
	ld (Choice),a
	call BeginBattle
	call MenuCursor
	ld a,(RHP)
	or a
	jp z,YouWin
	ld a,(HP)
	or a
	jp z,YouLose
MarcMenu:
	call Delay
	jp MenuKey

BeginBattle:
	B_CALL clrlcdf
	ld b,0	;
	ld c,32	;
	ld d,96	; horizontal
	ld e,32	;
	ld h,1	;
	B_CALL iline
	ld b,48	;
	ld c,0	;
	ld d,48	; vertical
	ld e,64	;
	ld h,1	;
	B_CALL iline
	call DispEnemy
	SET textwrite,(iy+sgrflags)
	call vputsapp

	ld a,9
	ld (penrow),a
	ld a,8
	ld (pencol),a
	ld hl,(RHP)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtBar
	call vputsapp
	ld hl,(RMaxHP)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a

	ld a,25
	ld (penrow),a
	ld b,4
	ld hl,txtBattleMenu
BatMenLoop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,10
	ld (pencol),a
	call vputsapp
	inc hl
	djnz BatMenLoop

	ld a,32
	ld (penrow),a
	ld a,56
	ld (pencol),a
	ld hl,txtHP
	call vputsapp

	ld a,38
	ld (penrow),a
	ld a,58
	ld (pencol),a
	ld hl,(HP)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtBar
	call vputsapp
	ld hl,(MaxHP)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a

	ld a,46
	ld (penrow),a
	ld a,56
	ld (pencol),a
	ld hl,txtSP
	call vputsapp

	ld a,52
	ld (penrow),a
	ld a,58
	ld (pencol),a
	ld hl,(MarcSP)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtBar
	call vputsapp
	ld hl,(MaxSP)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	RES textwrite,(iy+sgrflags)
	B_CALL grbufcpy
	ret

MenuKey:
	B_CALL GetCSC
	cp skDown
	jp z,MenuDown
	cp skUp
	jp z,MenuUp
	cp sk2nd
	jp z,BattleSelect
	cp skEnter
	jp z,BattleSelect
	jp nz,MenuKey

MenuUp:
	ld a,(Choice)
	dec a
	ld (Choice),a
	or a
	call z,MenuTooFarUp
	call MenuCursor
	jp MarcMenu

MenuDown:
	ld a,(Choice)
	inc a
	ld (Choice),a
	cp 5
	call z,MenuTooFarDown
	call MenuCursor
	jp MarcMenu

MenuTooFarUp:
	ld a,4
	ld (Choice),a
	ret

MenuTooFarDown:
	ld a,1
	ld (Choice),a
	ret

MenuCursor:
	call ClearCursor
	ld a,(Choice)
	cp 1
	jp z,CursorAttack
	cp 2
	jp z,CursorSpecial
	cp 3
	jp z,CursorPotion
	cp 4
	jp z,CursorRun

CursorAttack:
	ld a,32
	ld (CursorY),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	ret

CursorSpecial:
	ld a,39
	ld (CursorY),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	ret

CursorPotion:
	ld a,46
	ld (CursorY),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	ret

CursorRun:
	ld a,53
	ld (CursorY),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	ret

BattleSelect:
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	ld a,(Choice)
	cp 1
	jp z,MarcAttack
	cp 2
	jp z,MarcSpecial
	cp 3
	jp z,MarcPotion
	cp 4
	jp z,RunCheck
	jp nz,Fight

DispEnemy:
	ld a,(Robot)
	cp 1
	jp z,DispCrabmeat
	cp 2
	jp z,DispKobun
	cp 3
	jp z,DispBuzzBot
	cp 4
	jp z,DispSWATBot
	cp 5
	jp z,DispKron
	cp 6
	jp z,DispTI83
	cp 7
	jp z,DispDiablos
	cp 8
	jp z,DispGriever
	cp 9
	jp z,DispMechAnna
	cp 10
	jp z,DispRobotnik

DispCrabmeat:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtCrabmeat
	ret

DispKobun:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtKobun
	ret

DispBuzzBot:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtBuzzBot
	ret

DispSWATBot:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtSWATBot
	ret

DispKron:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtKron
	ret

DispTI83:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtTI83
	ret

DispDiablos:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtDiablos
	ret

DispGriever:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtGriever
	ret

DispMechAnna:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtMechAnna
	ret

DispRobotnik:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtRobotnik
	ret

;======================================================
;                    Marc Attack
;======================================================

MarcAttack:
	call DamageLoop
	ld a,(Damage)
	ld b,a
	call Random
	ld (Damage),a
	ld a,(Level)
	ld b,a
	ld a,(Damage)
	cp b
	jp p,DamageRobot
	jp Missed

Missed:
	call TextClear
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtMissed
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp RobotAtk

DamageRobot:
	ld a,(RHP)
	ld (HPLoop),a
	call Hurting
	ld a,(HPLoop)
	ld (RHP),a

	call TextClear
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtRobotDamage
	call vputsapp
	ld a,39
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,(Damage)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtDamage
	call vputsapp
	call Delay
	call Delay
	call Pause
	ld a,(RHP)
	or a
	jp z,YouWin
	jp nz,RobotAtk

;======================================================
;                    Robot Attacking
;======================================================

RobotAtk:
	call TextClear
	call Delay
	call Delay
	call RDLoop
	ld a,(Damage)
	ld b,a
	call Random
	ld (Damage),a
	or a
	jp z,RMiss
	jp nz,MarcHurt

RMiss:
	call TextClear
	ld a,25
	ld (penrow),a
	ld b,2
	ld hl,txtRobotMissed
RMissedLoop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,1
	ld (pencol),a
	call vputsapp
	djnz RMissedLoop
	call Delay
	call Delay
	call Pause
	jp Fight

MarcHurt:
	ld a,(HP)
	ld (HPLoop),a
	call Hurting
	ld a,(HPLoop)
	ld (HP),a

	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtMarcDamage
	call vputsapp

	ld a,39
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,(Damage)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtDamage
	call vputsapp
	call AddSP
	call Delay
	call Delay
	call Pause
	ld a,(HP)
	or a
	jp z,YouLose
	jp nz,Fight

AddSP:
	ld a,(MarcSP)
	ld b,a
	ld a,(MaxSP)
	cp b
	ret z
	ld a,(Damage)
	ld b,a
AddSPLoop:
	ld a,(MarcSP)
	inc a
	ld (MarcSP),a
	ld a,(MarcSP)
	ld c,a
	ld a,(MaxSP)
	cp c
	ret z
	djnz AddSPLoop
	ret

DamageLoop:
	ld a,(Level)
	ld b,a
	ld c,4
DLoop:
	add a,c
	djnz DLoop
	ld (Damage),a
	ret

RDLoop:
	ld a,(Level)
	ld b,a
	ld c,3
RDLoop2:
	add a,c
	djnz RDLoop2
	ld (Damage),a
	ret

Hurting:
	ld a,(Damage)
	ld b,a
HurtingLoop:
	ld a,(HPLoop)
	dec a
	ld (HPLoop),a
	or a
	ret z
	ld (HPLoop),a
	djnz HurtingLoop
	ret

;======================================================
;                    Use a Special
;======================================================

MarcSpecial:
	call TextClear
	ld a,25
	ld (penrow),a
	ld a,(Specials)
	or a
	jp z,NoSpecials
	ld a,(Specials)
	ld b,a
	ld hl,txtSpecial
SpecialsLoop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,10
	ld (pencol),a
	call vputsapp
	inc hl
	djnz SpecialsLoop
	ld a,1
	ld (CursorX),a
	ld a,32
	ld (CursorY),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
SpecialKey:
	B_CALL GetCSC
	cp skDown
	jp z,SpecialDown
	cp skUp
	jp z,SpecialUp
	cp sk2nd
	jp z,SelectSpecial
	cp skEnter
	jp z,SelectSpecial
	cp skClear
	jp z,Fight
	jp nz,SpecialKey

SpecialUp:
	call ClearCursor
	ld a,(CursorY)
	sub 7
	ld (CursorY),a
	cp 25
	jp z,SpecialsTooFarUp
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	jp SpecialKey

SpecialDown:
	call ClearCursor
	call SpecialMult
	ld a,(SpecialCursor)
	ld b,a
	ld a,(CursorY)
	cp b
	jp z,SpecialsTooFarDown
	ld a,(CursorY)
	add a,7
	ld (CursorY),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	jp SpecialKey

SpecialsTooFarUp:
	call ClearCursor
	call SpecialMult
	ld a,(SpecialCursor)
	ld (CursorY),a
	ld a,1
	ld (CursorX),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	jp SpecialKey

SpecialsTooFarDown:
	call ClearCursor
	ld a,32
	ld (CursorY),a
	ld a,1
	ld (CursorX),a
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursor
	call vputsapp
	call Delay
	call Delay
	jp SpecialKey

SpecialMult:
	ld a,(Specials)
	ld b,a
	xor a
MultLoop:
	add a,7
	djnz MultLoop
	add a,25
	ld (SpecialCursor),a
	ret

NoSpecials:
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtNoSpecials
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp Fight

SelectSpecial:
	ld a,(CursorY)
	cp 32
	jp z,SlashNDash
	cp 39
	jp z,Heal
	cp 46
	jp z,Blaster
	cp 53
	jp z,Ultima
	jp nz,Fight

SlashNDash:
	ld a,5
	ld (SPNeeded),a
	call MinSP
	ld a,(SPNeeded)
	ld b,a
	ld a,(MarcSP)
	cp b
	jp c,NeedSP
	ld hl,SPNeeded
	ld a,(MarcSP)
	sub (hl)
	ld (MarcSP),a
	ld a,(SPNeeded)
	ld (Damage),a
	jp DamageRobot

Heal:
	ld a,10
	ld (SPNeeded),a
	call MinSP
	ld a,(SPNeeded)
	ld b,a
	ld a,(MarcSP)
	cp b
	jp c,NeedSP
	ld hl,SPNeeded
	ld a,(MarcSP)
	sub (hl)
	ld (MarcSP),a
	jp Healing

Blaster:
	ld a,15
	ld (SPNeeded),a
	call MinSP
	ld a,(SPNeeded)
	ld b,a
	ld a,(MarcSP)
	cp b
	jp c,NeedSP
	ld hl,SPNeeded
	ld a,(MarcSP)
	sub (hl)
	ld (MarcSP),a
	ld a,(SPNeeded)
	ld (Damage),a
	jp DamageRobot

Ultima:
	ld a,20
	ld (SPNeeded),a
	call MinSP
	ld a,(SPNeeded)
	ld b,a
	ld a,(MarcSP)
	cp b
	jp c,NeedSP
	ld a,(SPNeeded)
	ld b,a
	ld a,(MarcSP)
	sub b
	ld (MarcSP),a
	ld a,(SPNeeded)
	ld (Damage),a
	jp DamageRobot

MinSP:
	xor a
	ld (HPLoop),a
	ld a,(Level)
	ld b,a
MinSPLoop:
	ld a,(HPLoop)
	ld c,a
	ld a,(SPNeeded)
	add a,c
	ld (HPLoop),a
	djnz MinSPLoop
	ld a,(HPLoop)
	ld (SPNeeded),a
	ret

NeedSP:
	call TextClear
	ld a,32
	ld (penrow),a
	ld hl,txtNeedSP
	ld a,1
	ld (pencol),a
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp RobotAtk

;======================================================
;                    Use Potion
;======================================================

MarcPotion:
	ld a,(Potions)
	or a
	jp z,NoPotions
	jp nz,BattleUsePotion

NoPotions:
	call TextClear
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtNoPotions
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp Fight

BattleUsePotion:
	ld a,(Potions)
	dec a
	ld (Potions),a
Healing:
	call TextClear
	ld a,(HP)
	ld b,a
	ld a,(MaxHP)
	sub b
	ld (HPLoop),a
	ld a,39
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,(HPLoop)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtHealth
	call vputsapp
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtGained
	call vputsapp
	ld a,(MaxHP)
	ld (HP),a
	call Delay
	call Delay
	call Pause
	jp RobotAtk

;======================================================
;                    Run Checking
;======================================================

RunCheck:
	ld a,(Map)
	cp 11
	jp z,RunFail
	cp 12
	jp z,RunFail
	ld b,3
	call Random
	or a
	jp z,RunFail
	jp nz,RunSuccess

RunSuccess:
	call TextClear
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtRunSuccess
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp ReturnGame

RunFail:
	call TextClear
	ld a,32
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtRunFail
	call vputsapp
	call Delay
	call Delay
	call Pause
	jp RobotAtk

;======================================================
;                    End of battle
;======================================================

YouLose:
	B_CALL clrlcdf
	B_CALL grbufclr
	ld a,-6
	ld (penrow),a
	ld hl,txtLose
	call PutSmallText
	call Delay
	call Delay
	call Pause
	jp Quit

YouWin:
	ld a,2
	ld (penrow),a
	ld a,5
	ld (pencol),a
	ld hl,txtDead
	call vputsapp
	call Delay
	call Delay
	B_CALL clrlcdf
	B_CALL grbufclr
	xor a
	ld (penrow),a
	ld (pencol),a
	ld hl,txtWon
	call vputsapp
	ld a,7
	ld (penrow),a
	xor a
	ld (pencol),a
	ld hl,txtFound
	call vputsapp
	ld b,10
	call Random
	cp 5
	call nc,GivePotion
RandRing:
	ld b,50
	call Random
	inc a
	ld (Choice),a
	ld a,43
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,(Choice)
	ld h,0
	B_CALL setxxxxop2
	B_CALL op2toop1
	ld a,5
	B_CALL dispop1a
	ld hl,txtRings
	call vputsapp
	ld a,(Choice)
	ld b,a
	ld a,(Rings)
	add a,b
	ld (Rings),a
	cp 100
	call nc,BuyPotion
	call Delay
	call Delay
	call Pause
	call LevelUpCheck
	jp ReturnGame

GivePotion:
	ld a,22
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtEarnedPotion
	call vputsapp
	ld a,(Potions)
	inc a
	ld (Potions),a
	cp 101
	call nc,TooManyPotions
	ld a,29
	ld (penrow),a
	ld a,30
	ld (pencol),a
	ld hl,txtAnd
	call vputsapp
	ret

BuyPotion:
	ld a,50
	ld (penrow),a
	ld a,1
	ld (pencol),a
	ld hl,txtBuyPotion
	call vputsapp
	ld a,(Rings)
	sub 100
	ld (Rings),a
	ld a,(Potions)
	inc a
	ld (Potions),a
	cp 100
	jp nc,TooManyPotions
	ret

TooManyPotions:
	ld a,100
	ld (Potions),a
	ret

LevelUpCheck:
	ld a,(Level)
	cp 10
	ret z
	ld a,(Battle)
	inc a
	ld (Battle),a
	cp 10
	jp z,LevelUp
	cp 25
	jp z,LevelUp
	cp 40
	jp z,LevelUp
	cp 60
	jp z,LevelUp
	cp 95
	jp z,LevelUp
	cp 130
	jp z,LevelUp
	cp 150
	jp z,LevelUp
	cp 200
	jp z,LevelUp
	cp 255
	jp z,LevelUp
	ld a,(Map)
	cp 11
	jp z,LevelFromAnna
	ret

LevelUp:
	ld a,(Level)
	inc a
	ld (Level),a
	cp 2
	jp z,Level2		;Special1
	cp 3
	jp z,Level3
	cp 4
	jp z,Level4		;Special2
	cp 5
	jp z,Level5
	cp 6
	jp z,Level6
	cp 7
	jp z,Level7		;Special3
	cp 8
	jp z,Level8
	cp 9
	jp z,Level9
	cp 10
	jp z,Level10	;Special4

Level2:		;Special 1
	B_CALL clrlcdf
	ld a,34
	ld (HP),a
	ld (MaxHP),a
	ld a,10
	ld (MaxSP),a
	ld a,1
	ld (Specials),a
	call DispSpecGain
	ld a,8
	ld (penrow),a
	ld b,2
	ld hl,txtSpecial1
Special1Loop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,1
	ld (pencol),a
	call vputsapp
	djnz Special1Loop
	call Delay
	call Delay
	call Pause
	ret

Level3:
	B_CALL clrlcdf
	ld a,70
	ld (HP),a
	ld (MaxHP),a
	ld a,25
	ld (MaxSP),a
	ld a,1
	ld (pencol),a
	ld (penrow),a
	ld hl,txtLevelUp
	call vputsapp
	call Delay
	call Delay
	call Pause
	ret

Level4:		;Special 2
	B_CALL clrlcdf
	ld a,95
	ld (HP),a
	ld (MaxHP),a
	ld a,40
	ld (MaxSP),a
	ld a,2
	ld (Specials),a
	call DispSpecGain
	ld a,8
	ld (penrow),a
	ld b,2
	ld hl,txtSpecial2
Special2Loop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,1
	ld (pencol),a
	call vputsapp
	djnz Special2Loop
	call Delay
	call Delay
	call Pause
	ret

Level5:
	B_CALL clrlcdf
	ld a,135
	ld (HP),a
	ld (MaxHP),a
	ld a,65
	ld (MaxSP),a
	ld a,1
	ld (pencol),a
	ld (penrow),a
	ld hl,txtLevelUp
	call vputsapp
	call Delay
	call Delay
	call Pause
	ret

Level6:
	B_CALL clrlcdf
	ld a,155
	ld (HP),a
	ld (MaxHP),a
	ld a,90
	ld (MaxSP),a
	ld a,1
	ld (pencol),a
	ld (penrow),a
	ld hl,txtLevelUp
	call vputsapp
	call Delay
	call Delay
	call Pause
	ret

Level7:		;Special 3
	B_CALL clrlcdf
	ld a,175
	ld (HP),a
	ld (MaxHP),a
	ld a,105
	ld (MaxSP),a
	ld a,3
	ld (Specials),a
	call DispSpecGain
	ld a,8
	ld (penrow),a
	ld b,2
	ld hl,txtSpecial3
Special3Loop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,1
	ld (pencol),a
	call vputsapp
	djnz Special3Loop
	call Delay
	call Delay
	call Pause
	ret

Level8:
	B_CALL clrlcdf
	ld a,190
	ld (HP),a
	ld (MaxHP),a
	ld a,150
	ld (MaxSP),a
	ld a,1
	ld (pencol),a
	ld (penrow),a
	ld hl,txtLevelUp
	call vputsapp
	call Delay
	call Delay
	call Pause
	ret

Level9:
	B_CALL clrlcdf
	ld a,225
	ld (HP),a
	ld (MaxHP),a
	ld a,200
	ld (MaxSP),a
	ld a,1
	ld (pencol),a
	ld (penrow),a
	ld hl,txtLevelUp
	call vputsapp
	call Delay
	call Delay
	call Pause
	ret

LevelFromAnna:
	B_CALL clrlcdf
	ld a,10
	ld (Level),a
Level10:		;Special 4
	ld a,255
	ld (HP),a
	ld (MaxHP),a
	ld (MaxSP),a
	ld a,4
	ld (Specials),a
	ld a,8
	ld (penrow),a
	ld b,4
	ld hl,txtSpecial4
Special4Loop:
	ld a,(penrow)
	add a,7
	ld (penrow),a
	ld a,1
	ld (pencol),a
	call vputsapp
	djnz Special4Loop
	call Delay
	call Delay
	call Pause
	ret

DispSpecGain:
	ld a,-6
	ld (penrow),a
	ld hl,txtSpecials
	call PutSmallText
	ret


ReturnGame:
	ld a,(Cheat)
	cp 5
	call z,ReloadStats
	ld a,(Map)
	cp 11
	jp z,WinMechAnna
	cp 12
	jp z,WinRobotnik
	jp nz,PlayGame

ReloadStats:
	ld a,255
	ld (HP),a
	ld (MarcSP),a
	ld a,100
	ld (Potions),a
	ld (Rings),a
	ld a,255
	ld (Battle),a
	ret

;======================================================
;                     Routines
;======================================================

Quit:
	B_CALL clrlcdf
	B_CALL grbufclr
	xor a
	ld (curcol),a
	ld (currow),a
	ld hl,txtQuitting
	call putsapp
	call Delay
	call Pause
	B_CALL grbufclr
	B_CALL clrlcdf
	B_JUMP JForceCmdNoChar

Delay:
	ld b,10
	ei
Delay2:
	halt
	djnz Delay2
	ret

Find:
	call checkvar
	ld a,b
	or a
	jr z,notarchived
	B_CALL Arc_Unarc
notarchived:
	call checkvar
	ld (appvarloc),de
	ret

checkvar:
	ld hl,MtSVar
	rst 20h
	B_CALL chkfindsym
	ret

ClearCursor:
	ld a,(CursorY)
	ld (penrow),a
	ld a,(CursorX)
	ld (pencol),a
	ld hl,txtCursorClear
	call vputsapp
	ret

Pause:
	B_CALL GetCSC
	cp skEnter
	jp nz,Pause
	call Delay
	ret

;=======================================;
; Rectangle Filling Routine Version 1.0 ;
; By Jason Kovacs & The TCPA - 10/11/99 ;
;=======================================;

; Input:  D = Top Left X Coordinate, E = Top Left Y Coordinate
;         H = Bottom Right X Coord,  L = Bottom Right Y Coord
;         C = Color of Lines (0-White, 1-Black, 2-XORed)
;
; Output: A Rectangle is drawn to the Graph Buffer with its border
;    and everything within it Filled in according to the value in
;    reg C which specifies the Color.
;
; Registers Affected: AF Destroyed; B=0 ; C, DE, HL Preserved.
;    The Index Registers and the Shadow Registers Aren't Used.

TextClear:
	ld c,0
	ld d,0
	ld e,32
	ld h,47
	ld l,64
	call Rectangle_Filled
	call FastCopy
	ret

;=======================================;
; Horizontal and Verticle Line Routines ;
; By Jason Kovacs & The TCPA - 10/11/99 ;
;=======================================;

; For H_Line and V_Line:
;
; Input:  B = Length of Line (Number of Pixels)
;         C = Color of Line (0-White, 1-Black, 2-XORed)
;         D = X Coordinate Start of the Line
;         E = Y Coordinate Start of the Line
;
; Output: Lines are Drawn to the Graph Buffer, and the Starting
;    Byte and Pixel Mask are Automatically determined according
;    to the Input of the Coordinates in DE.
;
; Registers Affected:  All Registers are Preserved Except AF.

V_Line:
        push de
        push hl
        push bc
        ld a, d
        call Getpix
        pop bc
        push bc
        ld d, c
        ld c, a
        ld a, d
        ld de, 12
        or a
        call z, V_White_Line
        dec a
        call z, V_Black_Line
        dec a
        call z, V_XORed_Line
        pop bc
        pop hl
        pop de
        ret

V_White_Line:
        ld a, c
        CPL
        ld c, a 
V_White_Line_2:
        ld a, (hl)
        and c
        ld (hl), a
        add hl, de
        DJNZ V_White_Line_2
        xor a
        ret

V_Black_Line:
        ld a, (hl)
        or c
        ld (hl), a
        add hl, de
        DJNZ V_Black_Line
        xor a
        ret

V_XORed_Line:
        ld a, (hl)
        xor c
        ld (hl), a
        add hl, de
        DJNZ V_XORed_Line
        ret

H_Line:
        push de
        push hl
        push bc
        ld a, d
        call Getpix
        pop bc
        push bc
        ld d, c
        ld c, a
        ld a, d
        or a
        call z, H_White_Line
        dec a
        call z, H_Black_Line
        dec a
        call z, H_XORed_Line
        pop bc
        pop hl
        pop de
        ret

H_White_Line:
        ld a, c
        CPL
        ld c, a
H_White_Line_2:
        ld a, (hl)
        and c
        ld (hl), a
        RR c
        jr c, Cont_H_White_Line 
        inc hl
        RR c
Cont_H_White_Line:
        DJNZ H_White_Line
        xor a
        ret

H_Black_Line:
        ld a, (hl)
        or c
        ld (hl), a
        RR c
        jr nc, Cont_H_Black_Line
        inc hl
        RR c
Cont_H_Black_Line:
        DJNZ H_Black_Line
        xor a
        ret

H_XORed_Line:
        ld a, (hl)
        xor c
        ld (hl), a
        RR c
        jr nc, Cont_H_XORed_Line
        inc hl
        RR c
Cont_H_XORed_Line:
        DJNZ H_XORed_Line
        ret

Getpix: ld d, 0
        ld h, d
        ld l, e
        add hl, de
        add hl, de
        add hl, hl
        add hl, hl
        ld de, plotsscreen
        add hl, de
Getbit: ld b, 0
        ld c, a
        and 07h
        srl c
        srl c
        srl c
        add hl, bc
        ld b, a
        inc b
        ld a, %00000001
GBLoop: RRCA
        djnz GBLoop
        ret

;=======================================;
; Rectangle Filling Routine Version 1.0 ;
; By Jason Kovacs & The TCPA - 10/11/99 ;
;=======================================;

; Input:  D = Top Left X Coordinate, E = Top Left Y Coordinate
;         H = Bottom Right X Coord,  L = Bottom Right Y Coord
;         C = Color of Lines (0-White, 1-Black, 2-XORed)
;
; Output: A Rectangle is drawn to the Graph Buffer with its border
;    and everything within it Filled in according to the value in
;    reg C which specifies the Color.
;
; Registers Affected: AF Destroyed; B=0 ; C, DE, HL Preserved.
;    The Index Registers and the Shadow Registers Aren't Used.

Rectangle_Filled:
        ld a, l
        sub e
        inc a
        ld b, a
        ld a, h
        sub d
        inc a   
        push de
Rect_Fill_Loop:
        push af
        call V_Line
        pop af
        inc d
        dec a
        jr nz, Rect_Fill_Loop
        pop de
        ret

;=======================================;
; Rectangle Outline Routine Version 1.0 ;
; By Jason Kovacs & The TCPA - 10/11/99 ;
;=======================================;

; Input:  D = Top Left X Coordinate, E = Top Left Y Coordinate
;         H = Bottom Right X Coord,  L = Bottom Right Y Coord
;         C = Color of Lines (0-White, 1-Black, 2-XORed)
;
; Output: The Border of a Rectangle is drawn to the Graph Buffer,
;    and the inside of it is unaffected. The Color of the Lines
;    of the Rectangle Outline depend on the value in Register C.
;
; Registers Affected: AF Destroyed; B=0 ; C, DE, HL Preserved.
;    The Index Registers and the Shadow Registers Aren't Used.

Rectangle_Outline:
        ld a, l
        sub e
        inc a
        ld b, a
        call V_Line
        push de
        ld d, h
        call V_Line     
        pop de
        ld a, h
        sub d
        dec a
        ld b, a
        inc d
        call H_Line
        push de
        ld e, l
        call H_Line
        pop de
        ret

MonsterStats:
	ld a,(Robot)
	cp 1
	jp z,LoadCrabmeat
	cp 2
	jp z,LoadKobun
	cp 3
	jp z,LoadBuzzBot
	cp 4
	jp z,LoadSWATBot
	cp 5
	jp z,LoadKron
	cp 6
	jp z,LoadTI83
	cp 7
	jp z,LoadDiablos
	cp 8
	jp z,LoadGriever
	cp 9
	jp z,LoadMechAnna
	cp 10
	jp z,LoadRobotnik
;	jp nz,FindMonster
	ld a,(Robot)
	ld l,a
	ld h,0
	B_CALL DispHL
	call Pause
;	jp FindMonster
	jp Quit

LoadCrabmeat:
    ld a,10
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadKobun:
    ld a,12
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadBuzzBot:
    ld a,13
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadSWATBot:
    ld a,15
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadKron:
    ld a,17
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadTI83:
    ld a,(Level)
    cp 10
    jp z,HP83
    ld a,8
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

HP83:
    ld a,83
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadDiablos:
    ld a,19
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadGriever:
    ld a,20
    ld (RHP),a
    B_CALL setxxop1
    ld a,(Level)
    B_CALL setxxop2
    B_CALL fpmult
    B_CALL convop1
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadMechAnna:
    ld a,200
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

LoadRobotnik:
    ld a,255
    ld (RHP),a
    ld (RMaxHP),a
    jp Fight

ChooseMap:
 	ld a,(Map)
 	or a
 	jp z,Quit
 	ld hl,Screen1-96
 	ld b,a
 	ld de,96
ChooseMapAdd:
 	add hl,de
 	djnz ChooseMapAdd
 	ld de,TileMap
 	ld bc,96
 	ldir
 	ret

 include "Goodies.inc"

;======================================================
;                    Data
;======================================================
imgMarc: 
	 db 38h
	 db 28h
	 db 38h
	 db 10h
	 db 38h
	 db 10h
	 db 28h
	 db 28h

Tiles:
Tile0:
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h

Tile1:
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h
	 db 00h

Tile2:
	 db 018h
	 db 024h
	 db 042h
	 db 0FFh
	 db 042h
	 db 05Ah
	 db 05Ah
	 db 07Eh

Tile3:
	 db 03Ch
	 db 07Eh
	 db 0FFh
	 db 0FFh
	 db 0FFh
	 db 0FFh
	 db 0FFh
	 db 0FFh

Tile4:
	 db 0FFh
	 db 081h
	 db 081h
	 db 087h
	 db 087h
	 db 081h
	 db 081h
	 db 0FFh

Tile5:
	 db 038h
	 db 068h
	 db 0B8h
	 db 010h
	 db 038h
	 db 010h
	 db 028h
	 db 028h

Tile6:
	 db 038h
	 db 028h
	 db 038h
	 db 010h
	 db 038h
	 db 010h
	 db 028h
	 db 028h

Tile7:
	 db 03Ch
	 db 042h
	 db 081h
	 db 081h
	 db 081h
	 db 081h
	 db 081h
	 db 07Eh

Tile8:
	 db 066h
	 db 099h
	 db 042h
	 db 024h
	 db 024h
	 db 024h
	 db 024h
	 db 07Eh

Tile9:
	 db 0FFh
	 db 0A7h
	 db 0CFh
	 db 09Dh
	 db 0B9h
	 db 0F3h
	 db 0E5h
	 db 0FFh

Screen1:
	 db 9,9,9,9,9,9,4,9,9,9,9,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 4,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,9,9,9,9,9,9,9,9,9,9,9

Screen2:
	 db 8,8,8,8,8,8,8,7,8,8,8,8
	 db 8,2,0,8,8,8,0,0,0,8,8,8
	 db 8,8,0,0,0,0,0,8,8,0,0,8
	 db 8,7,7,0,7,8,8,7,0,0,8,7
	 db 7,7,0,0,7,7,7,7,0,7,7,7
	 db 7,7,0,7,0,0,0,0,0,7,0,7
	 db 7,0,0,0,0,7,0,7,0,0,0,7
	 db 9,9,9,9,9,9,4,9,9,9,9,9

Screen3:
	 db 8,8,8,8,8,8,1,8,8,8,8,8
	 db 8,0,0,0,0,0,0,0,0,0,0,8
	 db 8,0,0,0,0,2,0,0,2,0,0,8
	 db 8,0,0,0,0,0,0,0,0,0,0,8
	 db 8,0,0,0,0,0,0,0,2,0,0,8
	 db 8,0,0,7,7,7,0,0,0,0,0,8
	 db 8,0,0,7,0,7,0,0,0,0,0,8
	 db 8,7,7,7,0,7,7,7,7,7,7,8

Screen4:
	 db 8,8,8,8,8,8,8,8,8,8,8,8
	 db 8,0,0,0,0,8,8,0,0,0,0,8
	 db 8,0,8,0,0,0,0,0,8,0,0,1
	 db 8,0,8,8,8,8,8,7,8,0,8,8
	 db 8,0,0,8,0,0,0,8,0,8,0,8
	 db 8,8,0,8,8,8,0,8,0,8,0,8
	 db 8,0,0,0,0,0,0,0,0,0,0,8
	 db 8,8,8,8,8,8,1,8,8,8,8,8

Screen5:
	 db 8,8,8,8,8,8,8,8,8,8,8,8
	 db 8,8,0,0,0,0,0,8,8,8,8,8
	 db 8,0,0,8,8,8,8,8,2,8,8,8
	 db 1,0,8,0,8,8,8,8,8,8,8,8
	 db 8,0,8,0,0,0,8,0,0,0,0,8
	 db 8,0,0,0,8,0,0,0,8,0,0,8
	 db 8,0,8,0,8,0,7,0,8,0,8,8
	 db 8,8,8,8,8,8,8,8,8,1,8,8

Screen6:
	 db 8,8,8,8,8,8,8,8,1,8,8,8
	 db 7,0,0,2,0,0,0,0,0,0,0,7
	 db 7,0,0,0,0,0,0,0,0,2,0,7
	 db 3,0,0,0,0,0,0,0,0,0,0,7
	 db 7,0,0,2,0,0,0,0,0,0,0,7
	 db 7,0,0,0,0,0,0,0,2,0,0,7
	 db 7,0,0,0,0,0,0,0,0,0,0,7
	 db 7,7,7,7,7,7,7,7,7,7,7,7

Screen7:
	 db 7,7,7,7,7,7,7,7,7,7,7,7
	 db 7,0,0,0,7,7,7,7,0,0,0,3
	 db 7,3,7,0,7,7,7,3,0,7,7,7
	 db 7,7,7,0,7,7,7,7,7,7,0,7
	 db 7,0,0,0,7,3,0,7,0,0,0,7
	 db 7,0,0,0,7,7,7,7,0,0,0,7
	 db 7,0,3,0,0,0,0,0,0,0,0,7
	 db 7,7,7,7,3,7,7,7,7,7,7,7

Screen8:
	 db 7,3,7,7,7,7,7,7,0,0,0,0
	 db 7,0,0,0,0,0,0,7,0,0,0,0
	 db 7,0,0,0,0,0,0,7,0,0,0,0
	 db 7,2,0,0,0,0,0,8,9,9,9,9
	 db 7,0,0,0,0,0,0,0,0,0,0,1
	 db 7,0,0,2,0,0,0,8,9,9,9,9
	 db 7,0,0,0,0,0,0,7,0,0,0,0
	 db 7,7,7,8,7,7,7,7,0,0,0,0

Screen9:
	 db 9,9,9,9,9,9,9,9,9,9,9,9
	 db 9,0,0,0,0,0,9,0,0,0,0,9
	 db 9,0,9,9,9,0,9,0,9,9,0,9
	 db 1,0,9,0,0,0,9,0,9,9,0,9
	 db 9,0,9,0,9,9,0,0,9,9,0,1
	 db 9,0,9,0,9,0,0,0,9,2,9,9
	 db 9,0,9,0,0,0,9,0,9,8,9,9
	 db 9,9,9,9,9,9,9,9,9,9,9,9

Screen10:
	 db 9,9,9,9,9,9,9,1,9,9,9,0
	 db 9,0,0,0,0,9,9,0,9,9,9,0
	 db 1,0,9,9,0,9,0,0,9,9,9,0
	 db 9,9,0,9,0,9,9,0,0,9,9,0
	 db 9,0,0,0,0,0,9,9,2,9,9,0
	 db 9,0,9,9,9,9,9,0,0,9,9,0
	 db 9,0,0,0,0,0,0,0,9,8,9,0
	 db 9,9,9,9,9,9,9,9,9,9,9,0

Screen11:
	 db 9,9,9,9,9,9,5,9,9,9,9,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,9,9,9,9,9,9,9,9,9,9,9

Screen12:
	 db 9,9,9,9,9,9,6,9,9,9,9,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,0,0,0,0,0,0,0,0,0,0,9
	 db 9,9,9,9,9,9,9,9,9,9,9,9

;======================================================
;                      Menu
;======================================================

txtNew:  db "NEW GAME",0
txtContinue:  db "CONTINUE",0
txtQuit:  db "QUIT",0
txtGameLoaded:  db "GAME LOADED!",0
txtNoSave:
 db "THERE WAS NO    "
 db "SAVE FILE TO    "
 db "LOAD FROM",0
txtQuitting:
 db "THANKS FOR      "
 db "PLAYING!        ",0
txtGameSaved: db "GAME SAVED!",0

;======================================================
;                      New Game
;======================================================

txtBegin:
 db "MARC: ...THIS ALL REALLY",0
 db "  BEGAN YESTERDAY MORNING.",0
 db "  ACTUALLY, IT BEGAN WHEN",0
 db "  YOU CAPTURED ANNA. UP",0
 db "  UNTIL A FEW HOURS AGO,",0
 db "  I THOUGHT YOU KILLED HER.",0
 db "  IT WAS THEN THAT I",0
 db "  REALIZED THAT YOU NEED",0
 db "  TO BE STOPPED.",0,0

txtBegin2:
 db "  YOU WENT TOO FAR THIS",0
 db "  TIME. I PICKED UP MY",0
 db "  SWORD AND SET OUT FOR",0
 db "  ROBOTROPOLIS.",0,0

txtNoCheat:
 db "  BUT...NOT UNTIL I WORKED",0
 db "  OUT A LITTLE IN THE",0
 db "  TRAINING SIMULATION ROOM",0
 db "  I INSTALLED IN THE NORTH",0
 db "  PART OF MY HUT.",0,0

;======================================================
;                      Stats Screen
;======================================================

txtAskPotion:
 db "USE A POTION    "
 db "(Y/N)           ",0

txtStats:
 db "STATS:          "
 db "HP:             "
 db "MAX HP:         "
 db "LEVEL:          "
 db "BATTLES:        "
 db "RINGS:          "
 db "POTIONS:        ",0

;======================================================
;                      Healers Hut
;======================================================
txtNoHeal:  db "THEY SEE NO NEED TO HEAL YOU",0

txtHealBar   db "-----------------------",0
txtHealersHut:  db "HEALER",027h,"S NEST",0

txtHealerMenu:
 db "F)ULL HEAL",0
 db "L)EAVE",0

txtFullHeal:
 db "FULL HEAL       "
 db "                "
 db "                "
 db "                "
 db "                "
 db "                "
 db "RINGS:          "
 db "YOU NEED:      ",0

txtNotEnough:  db "NOT ENOUGH!",0
txtFullyHealed:  db "FULLY HEALED!",0

;======================================================
;                      House 1
;======================================================
txtHouse1:
 db "MY GIRLFRIEND HAS BEEN",0
 db "CAPTURED BY ROBOTNIK. I",027h,"M",0
 db "GONNA GO WITH YOU AND",0
 db "FIGHT TOO!",0,0

;======================================================
;                      House 2
;======================================================
txtHouse2:
 db "ARE YOU LEADING THE",0
 db "ATTACK ON ROBOTROPOLIS?",0
 db "GOOD LUCK, MARC.",0,0

;======================================================
;                      House 3
;======================================================
txtHouse3:
 db "WHEN WILL ROBOTNIK",027h,"S",0
 db "TYRANNY END?! WILL",0
 db "SOMEONE PLEASE TELL ME?",0,0

;======================================================
;                      House 4
;======================================================
txtHouse4:
 db "M-M-M-MOMMY? WHERE",027h,"S MY",0
 db "MOMMY? HAVE YOO SEEN HER?",0
 db "I LOST HER SOMEWHERE",0
 db "NEAR ROBOT-LAND. IF YOO",0
 db "FIND HER, COULD YOO TELL",0
 db "TO COME BACK HOME?",0,0

;======================================================
;                      Uncle Chuck
;======================================================
txtUncleChuck:
 db "UNCLE CHUCK: MARC, M",027h,"BOY!",0
 db "SO GOOD TO SEE YOU! I SEE",0
 db "YOU ARE LEADING THE ATTACK",0
 db "ON ROBOTROPOLIS. I",027h,"D HELP",0
 db "BUT...I",027h,"M MORE USE TO YOU",0
 db "HERE, I",027h,"LL HEAL YOU!",0
 db "AND GIVE SOME POTIONS",0,0

;======================================================
;                      MechAnna
;======================================================
txtMechAnna1:
 db "MARC:   ANNA!",0
 db "MECHANNA:   ...",0
 db "MARC:   I",027h,"M SO GLAD YOU",027h,"RE OK!",0
 db "      I THOUGHT YOU WERE DEAD!",0
 db "MECHANNA:   ...",0
 db "MARC:   ANNA? ANNA!  WHAT",027h,"S",0
 db "      HAPPENED TO YOU?!",0,0

txtMechAnna2:
 db "MECHANNA:   PRIORITY 1: KILL",0
 db "       THE SUPERKID!",0
 db "MARC:   ANNA! STOP! NO!",0,0

txtMechAnna3:
 db "MARC: AFTER I",027h,"D BEATEN THIS",0
 db " MECH...ANNA, I RAN MY TEST",0
 db " PROGRAM THAT REVERSES THE",0
 db " ROBOTIZATION PROCESS.",0
 db " GUESS I GOT REALLY LUCKY.",0
 db " UNFORTUNATELY, MY VICTORY",0
 db "  WAS SHORT LIVED. AS I",0
 db " HELD ANNA",027h,"S TENDER BODY,",0
 db " BLACK ROBOTNIK ATTACKED.",0,0

txtMechAnna4:
 db "ROBOTNIK:   YES, AND WE ALL",0
 db " KNOW THAT YOU BEAT IT AND",0
 db " INCREASED YOUR STRENGTH. ",0
 db "MARC:   YEAH, AND NOW, THANKS",0
 db " TO YOUR OWN CREATION, I",027h,"M",0
 db " MORE THAN STRONG ENOUGH",0
 db " TO TAKE YOU DOWN AND STOP",0
 db " YOUR REIGN OF TERROR.",0,0

;======================================================
;                      Robotnik
;======================================================
txtFightRobotnik:
 db "MARC:   SO, THAT",027h,"S MY STORY,",0
 db "   WHAT",027h,"S YOURS?",0
 db "WITHOUT WARNING, ROBOTNIK",0
 db "CHARGES AT MARC.",0
 db "MARC SHAKES HIS HEAD AND",0
 db "PREPARES FOR BATTLE.",0,0

;======================================================
;                      End
;======================================================
txtEnd1:
 db "MARC:   ...WHY?",0
 db "ROBOTNIK:   BECAUSE YOU",0
 db "   KILLED MY WIFE!",0
 db "MARC:   DON",027h,"T GIVE ME THAT",0
 db "   CRAP! I NEVER EVEN KNEW",0
 db "   MOM!",0
 db "   I",027h,"M GONNA MAKE SURE",0
 db "   YOU NEVER DO THIS AGAIN",0,0

txtEnd2:
 db "*OUTSIDE ROBOTROPOLIS*",0
 db "ANNA:   LOOK AT ALL THAT",0
 db "   ENERGY GATHERING!",0
 db "MECHAMARC:   IT",027h,"S GOTTA BE",0
 db "   MARC! BUT, HE",027h,"S GONE",0
 db "   PAST THE LEVEL 4 RAGE",0
 db "   BREAK POWER! TOO FAR!",0
 db "   HE",027h,"S AT LEVEL 7!",0,0

txtEnd3:
 db "SONIC:   CAN HE SURVIVE IT?",0
 db "MECHA:   WE CAN ONLY HOPE.",0
 db "ALL:   MARC...MARC...MARC!",0
 db "...MARC!...MARC!...",0,0

txtEnd4:
 db "AN ENORMOUS BEAM OF ENERGY",0
 db "APPEARS, COMING OUT OF THE",0
 db "GROUND. THE ENERGY TURNS",0
 db "ROBOTROPOLIS TO DUST",0
 db "MARC AND HIS ENERGY CAN",0
 db "BE FAINTLY SEEN FROM THE",0
 db "FOREST. THEY ARE HOVERING",0
 db "IN THE AIR, BUT ONLY",0
 db "UNTIL MARC GATHERS",0,0

txtEnd5:
 db "THE ENERGY AROUND THEM.",0
 db "HE CHANNELS THE ENERGY",0
 db "INTO HIS BODY THEN",0
 db "RELEASES IT IN A LARGE,",0
 db "POWERFUL BURST OF ENERGY.",0
 db "ROBOTNIK IS SENT FLYING",0
 db "FROM THE POWER. SOON, HE",0
 db "IS NO MORE.",0,0

txtEnd6:
 db "LATER...",0
 db "MARC STANDS AT THE EDGE OF",0
 db "THE GREAT FOREST. ANNA",0
 db "WALKS UP TO HER SAVIOR",0
 db "AND HOLDS HIM",0
 db "ANNA:   IS IT OVER?",0
 db "MARC:   YES.",0
 db "ANNA:   WHAT NOW?",0
 db "MARC:   ",03Ch,"SIGH",03Eh," DON",027h,"T KNOW",0,0

txtEnd7:
 db "IN THE RUBBLE OF ROBO-",0
 db "TROPOLIS SOMETHING STIRS",0
 db "A ROBOT SHAPED LIKE AN",0
 db "ARMY GENERAL CLIMBS OUT",0
 db "PACKBELL:   HAHAHAHAHAHA",0
 db "THE END...?",0,0

;======================================================
;                      End of the Game
;======================================================

txtStaff:
 db "Lead Programmer:",0
 db "Marc Ryan",0
 db " ",0
 db "Graphics Designer:",0
 db "Marc Ryan",0
 db " ",0
 db "Special Effects:",0
 db "Marc Ryan",0,0

txtTesters:
 db "Testers:",0
 db "Marc Ryan",0
 db "Joe Flint",0
 db "Joe Pemberton",0
 db "Jeff Gray",0
 db "Jack Trades",0
 db "Vahn Stryker",0
 db "Ryan Scadding",0
 db "Burak Gul",0,0

txtTesters2:
 db "Iziren Okhamafe",0
 db "Vincent Junemann",0
 db "Danny Knopp",0
 db "Wes Erbsen",0
 db "Taiwo Eric Egun",0
 db "BRJrebel",0
 db "Brian Nelson Van Klaveren",0
 db "Zac Targac",0,0

txtThanks:
 db "Special Thanks To:",0
 db "Joe Flint",0
 db "Joe Pemberton",0
 db "Joel Seligstein",0
 db "Jack Trades",0
 db "Vahn Stryker",0,0

txtOther:
 db "Based on the stories of",0
 db "The Superkid Chronicles",0
 db "By Jack Trades and",0
 db "Vahn Stryker",0
 db " ",0
 db "Questions, comments, etc.",0
 db "Send to:",0
 db "MMfan",05Bh,"rocketmail.com",0
 db "AIM: VahnRPG",0,0

txtCongrats:
 db "CONGRATULATIONS!"
 db "YOU HAVE BEATEN "
 db "MtSQUEST!       "
 db "                "
 db "Press PRGM on   "
 db "NEW GAME to find"
 db "the cheat!      ",0

;======================================================
;                      Battle
;======================================================
txtBattleMenu:
 db "ATTACK",0
 db "SPECIAL",0
 db "POTION",0
 db "RUN",0,0

txtRunSuccess:
 db "YOU ESCAPED!",0

txtRunFail:
 db "CAN",027h,"T ESCAPE!",0

txtGained:
 db "YOU GAINED:",0

txtHealth:
 db "HEALTH",0

txtRobotDamage:
 db "YOU HIT FOR",0

txtMarcDamage:
 db "YOU TOOK",0

txtDamage:
 db "DAMAGE",0

txtNeedSP:
 db "NOT ENOUGH SP",0

txtMissed:
 db "YOU MISSED",0

txtRobotMissed:
 db "YOU DODGED",0
 db "THE ATTACK",0,0

txtNoPotions:
 db "YOU ARE OUT",0
 db "OF POTIONS!",0,0

txtSpecial:
 db "SLASH",0
 db "HEAL",0
 db "BLASTER",0
 db "ULTIMA",0

txtNoSpecials:
 db "NO SPECIALS",0

txtWon:  db "YOU WON!",0
txtFound:  db "YOU FOUND",0
txtAnd:  db "AND",0
txtRings:  db " RINGS",0
txtEarnedPotion:  db "A POTION!",0
txtBuyPotion:  db "YOU BOUGHT A POTION!",0

txtLevelUp:
 db "YOU GAINED A LEVEL!",0

txtSpecials:
 db "YOU GAINED A LEVEL!",0
 db "AND A SPECIAL ATTACK:",0,0

txtSpecial1:
 db "DASH N SLASH",0
 db "WHICH REQUIRES 5*LEV. SP",0,0

txtSpecial2:
 db "MYSTIC HEAL",0
 db "WHICH REQUIRES 10*LEV. SP",0,0

txtSpecial3:
 db "PULSAR BLASTER",0
 db "WHICH REQUIRES 15*LEV. SP",0,0

txtSpecial4:
 db "YOU REACHED THE FINAL LEVEL",0
 db "AND THE ULTIMATE SPECIAL:",0
 db "ULTIMA",0
 db "WHICH REQUIRES 20*LEV. SP",0,0

txtLose:
 db "YOU LOST. MAYBE",0
 db "YOU SHOULD TRY AGAIN",0
 db "LATER...",0,0
txtCursor:  db "->",0
txtCursorClear:  db "         ",0
txtHP:  db "HP:",0
txtSP:  db "SP:",0
txtDead:  db "        DEAD         ",0
txtBar:  db "/",0
txtCrabmeat:  db "Crabmeat",0
txtKobun:  db "Kobun",0
txtBuzzBot:  db "BuzzBot",0
txtSWATBot:  db "SWAT-Bot",0
txtKron:  db "Kron",0
txtTI83:  db "TI-83+",0
txtDiablos:  db "Diablos",0
txtGriever:  db "Griever",0
txtMechAnna:  db "MechAnna",0
txtRobotnik:  db "Robotnik",0

;======================================================
;                       Temp Data
;======================================================

CursorY	EQU saveSScreen
CursorX	EQU CursorY+2
Cheat		EQU CursorX+2
Map		EQU Cheat+2
Xpos		EQU Map+2
Ypos		EQU Xpos+2
HP		EQU Ypos+2
MaxHP		EQU HP+2
MarcSP		EQU MaxHP+2
MaxSP		EQU MarcSP+2
Level		EQU MaxSP+2
Potions	EQU Level+2	;22
Battle	EQU Potions+2
Rings		EQU Battle+2
Specials	EQU Rings+2
Robot		EQU Specials+2
RHP	EQU Robot+2
RMaxHP	EQU RHP+2
Location	EQU RMaxHP+2
Choice	EQU Location+2
CheckHP	EQU Choice+2
SPNeeded	EQU CheckHP+2
Damage	EQU SPNeeded+2
HPLoop	EQU Damage+2
HealMoney	EQU HPLoop+2  ;72
SpecialCursor	EQU HealMoney+2
Save	EQU SpecialCursor+2
appvarloc EQU Save+2
TileMap	EQU appBackUpScreen

MtSVar: db AppVarObj,"MtSQVar",0

;======================================================
;                     Variable Data
;======================================================

;======================================================
;                     Pictures
;======================================================

Pic1:
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,060h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,0E0h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,0E0h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,0E0h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,001h,0E0h,000h,000h
  db 000h,000h,000h,000h,004h,000h,000h,000h,083h,0E0h,000h,000h
  db 000h,000h,000h,000h,01Eh,000h,000h,001h,086h,0E0h,000h,000h
  db 000h,000h,000h,000h,07Eh,000h,000h,003h,006h,0E0h,000h,000h
  db 000h,000h,000h,000h,06Ch,000h,000h,002h,00Eh,0E0h,000h,000h
  db 000h,000h,000h,002h,068h,000h,000h,000h,08Eh,0E0h,000h,000h
  db 000h,000h,000h,00Eh,0E0h,000h,000h,001h,08Eh,0E0h,000h,000h
  db 000h,000h,000h,03Eh,0E2h,000h,000h,003h,08Eh,0E0h,000h,000h
  db 000h,000h,000h,0F6h,0E6h,000h,008h,003h,08Eh,0E0h,000h,000h
  db 000h,000h,001h,0E4h,0ECh,000h,038h,0C3h,08Fh,0E0h,000h,000h
  db 000h,000h,001h,0E0h,0ECh,000h,039h,083h,08Fh,080h,000h,000h
  db 000h,000h,010h,0E0h,0FCh,000h,03Bh,003h,086h,000h,000h,000h
  db 000h,000h,070h,0E0h,0F8h,000h,03Bh,003h,080h,000h,000h,000h
  db 000h,010h,0F8h,0E0h,060h,000h,03Fh,003h,080h,000h,000h,000h
  db 000h,031h,0B8h,0E0h,000h,000h,03Eh,003h,080h,000h,000h,000h
  db 000h,071h,0B8h,0E0h,000h,007h,03Eh,003h,000h,000h,000h,000h
  db 004h,073h,0B8h,0E0h,000h,00Fh,0BFh,002h,000h,000h,000h,000h
  db 00Eh,0F3h,0B8h,0E0h,000h,01Dh,0BFh,0C0h,000h,000h,000h,000h
  db 00Fh,0F1h,0BCh,0C0h,000h,038h,03Fh,0C0h,000h,000h,000h,000h
  db 00Fh,0F3h,0BCh,000h,000h,078h,039h,080h,000h,000h,000h,000h
  db 00Fh,0F3h,0BFh,0DCh,000h,038h,039h,000h,000h,000h,000h,000h
  db 00Fh,0F3h,0F9h,058h,006h,038h,038h,000h,000h,000h,000h,000h
  db 00Fh,0F3h,0E1h,058h,01Eh,038h,030h,000h,000h,000h,000h,000h
  db 00Eh,071h,081h,07Ch,06Eh,038h,000h,000h,000h,000h,000h,000h
  db 00Eh,070h,001h,058h,06Eh,038h,000h,000h,000h,000h,000h,000h
  db 00Eh,070h,001h,05Ch,0FCh,038h,000h,000h,000h,003h,080h,000h
  db 00Eh,070h,000h,000h,0F8h,038h,000h,000h,000h,005h,040h,000h
  db 00Eh,060h,000h,03Ch,0E2h,020h,000h,000h,000h,008h,020h,000h
  db 00Eh,000h,000h,0DCh,0E4h,000h,000h,000h,000h,00Fh,0E0h,000h
  db 00Eh,000h,001h,0DCh,0ECh,000h,000h,000h,000h,00Ah,0A0h,000h
  db 008h,000h,001h,0DCh,0FCh,000h,000h,000h,000h,008h,020h,000h
  db 000h,000h,019h,0DCh,0F8h,000h,000h,000h,000h,008h,0A0h,000h
  db 000h,000h,039h,0DCh,060h,000h,000h,000h,000h,007h,043h,080h
  db 000h,060h,0B9h,0DCh,000h,000h,000h,000h,000h,00Fh,0E4h,040h
  db 001h,0F3h,0B9h,0D8h,000h,000h,000h,000h,000h,017h,0DFh,0C0h
  db 003h,0F3h,0B9h,0F8h,000h,000h,000h,000h,008h,038h,03Ch,040h
  db 003h,063h,0B9h,0F0h,000h,000h,000h,01Fh,0F7h,0D3h,095h,040h
  db 007h,003h,0B9h,0C0h,000h,000h,000h,002h,014h,014h,056h,0C0h
  db 007h,063h,0B9h,0C0h,000h,000h,000h,001h,0F7h,0F4h,05Ch,040h
  db 007h,0F3h,0B9h,0C0h,000h,000h,000h,000h,008h,054h,05Ah,0C0h
  db 007h,0F3h,0F9h,0C0h,000h,000h,000h,000h,000h,054h,056h,0C0h
  db 007h,0F3h,0E1h,0C0h,000h,000h,000h,000h,000h,094h,056h,0C0h
  db 003h,0F1h,081h,080h,000h,000h,000h,000h,000h,094h,052h,080h
  db 000h,070h,000h,000h,000h,000h,000h,000h,000h,094h,053h,000h
  db 000h,060h,078h,000h,000h,000h,001h,080h,000h,093h,092h,000h
  db 001h,0E0h,0FCh,000h,000h,000h,003h,080h,000h,088h,022h,000h
  db 007h,0E1h,0CEh,077h,01Fh,00Fh,0CFh,0E0h,000h,08Fh,0D1h,000h
  db 007h,0C1h,0CEh,077h,03Bh,09Ch,003h,080h,000h,092h,051h,000h
  db 003h,001h,0CEh,077h,03Fh,09Fh,083h,080h,000h,0A4h,051h,000h
  db 000h,001h,0FEh,077h,038h,00Fh,0C3h,080h,001h,048h,051h,000h
  db 000h,000h,0FCh,077h,03Bh,081h,0C3h,080h,001h,050h,071h,000h
  db 000h,000h,0FEh,03Fh,01Fh,01Fh,081h,0F0h,001h,048h,051h,000h
  db 000h,000h,00Ch,004h,020h,008h,000h,000h,001h,024h,050h,080h
  db 000h,000h,000h,004h,03Fh,0EFh,0F8h,000h,002h,014h,050h,080h
  db 000h,000h,000h,00Ch,002h,020h,088h,000h,002h,01Ch,070h,080h
  db 000h,000h,000h,014h,00Eh,023h,088h,000h,03Ch,022h,088h,080h
  db 000h,000h,000h,03Ch,00Dh,0C3h,070h,000h,044h,01Ch,070h,080h
  db 000h,000h,000h,0C6h,008h,002h,000h,000h,048h,064h,051h,000h
  db 000h,000h,001h,006h,010h,004h,000h,000h,029h,094h,0A9h,000h
  db 000h,000h,002h,003h,018h,006h,000h,000h,01Fh,0FFh,0FEh,000h

Pic2:
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,0fch,000h,018h,000h,031h,0f9h,080h,000h,000h,000h
  db 000h,000h,0c0h,000h,018h,000h,060h,061h,080h,000h,000h,000h
  db 000h,000h,0c0h,000h,018h,000h,060h,061h,080h,000h,000h,000h
  db 000h,000h,0c0h,0f8h,0f8h,01eh,070h,061h,0f1h,0e0h,000h,000h
  db 000h,000h,0f8h,0edh,098h,033h,060h,061h,0dbh,030h,000h,000h
  db 000h,000h,0c0h,0cdh,098h,033h,060h,061h,09bh,0f0h,000h,000h
  db 000h,000h,0c0h,0cdh,098h,033h,060h,061h,09bh,000h,000h,000h
  db 000h,000h,0c0h,0cdh,098h,033h,060h,061h,09bh,030h,000h,000h
  db 000h,000h,0fch,0cch,0f8h,01eh,060h,061h,099h,0e0h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,001h,0f8h,001h,080h,000h,000h,0d8h,000h,000h,000h
  db 000h,000h,001h,08ch,001h,080h,006h,000h,018h,000h,000h,000h
  db 000h,000h,001h,08ch,001h,080h,006h,000h,018h,000h,000h,000h
  db 000h,000h,001h,08ch,079h,0f1h,0e7h,07ch,0dbh,000h,000h,000h
  db 000h,000h,001h,0f8h,0cdh,09bh,036h,076h,0deh,000h,000h,000h
  db 000h,000h,001h,08ch,0cdh,09bh,036h,066h,0dch,000h,000h,000h
  db 000h,000h,001h,08ch,0cdh,09bh,036h,066h,0deh,000h,000h,000h
  db 000h,000h,001h,08ch,0cdh,09bh,036h,066h,0dbh,000h,000h,000h
  db 000h,000h,001h,08ch,079h,0f1h,0e3h,066h,0d9h,080h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,0c0h,030h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,0c0h,030h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,066h,060h,000h,000h,000h,000h,000h,000h
  db 000h,000h,000h,000h,066h,063h,0ceh,070h,000h,000h,000h,000h
  db 000h,000h,000h,000h,066h,060h,06ch,0d8h,000h,000h,000h,000h
  db 000h,000h,000h,000h,03fh,0c3h,0ech,060h,000h,000h,000h,000h
  db 000h,000h,000h,000h,03fh,0c6h,06ch,030h,000h,000h,000h,000h
  db 000h,000h,000h,000h,019h,086h,06ch,0d8h,000h,000h,000h,000h
  db 000h,000h,000h,000h,019h,083h,0ech,070h,000h,000h,000h,000h

.end
END