DECLARE FUNCTION bin2dec (chbin$)
DECLARE FUNCTION existfile (ftotest$)
DECLARE FUNCTION dec2str$ (decima%)
DECLARE FUNCTION trait$ (entree$)
DECLARE SUB affichebmp (fichierbmp$)
DECLARE SUB writepic82 (fichierpic$, pictID$)
DECLARE SUB writepic83 (fichierpic$, pictID$)
DECLARE SUB writepic83p (fichierpic$, pictID$)
DECLARE SUB UpdateChecksum (check$)
DECLARE SUB menu10 ()

OPTION BASE 1
DIM SHARED transit(12, 63) AS INTEGER
DIM SHARED valu AS INTEGER
DIM SHARED col AS INTEGER
DIM SHARED ligne AS INTEGER
DIM SHARED xxl AS INTEGER
DIM SHARED xxy AS INTEGER
fifi$ = COMMAND$

CLS : COLOR 7
PRINT "BMP2PIC 2.00 - Convertor for Ti 82/83/83+"
PRINT "Copyright (c) 2002 - Cdric Sad KEFIF"
PRINT

IF fifi$ = "" THEN
 PRINT "Usage: bmp2pic <filetoconvert.bmp>"
 END
END IF

IF INSTR(fifi$, ".") = 0 THEN
 fifi$ = fifi$ + ".BMP"
END IF

IF existfile(fifi$) = 0 THEN
  PRINT "File does not exist!!!"
  END
END IF

CALL affichebmp(fifi$)
CALL menu10
x$ = dec2str$(xxl)

numfichier$ = trait$(x$)
n82$ = "pic" + x$ + ".82i"
n83$ = "pic" + x$ + ".83i"
n8x$ = "pic" + x$ + ".8xi"

CALL writepic82(n82$, numfichier$)
CALL writepic83(n83$, numfichier$)
CALL writepic83p(n8x$, numfichier$)

CALL UpdateChecksum(n82$)
CALL UpdateChecksum(n83$)
CALL UpdateChecksum(n8x$)

LOCATE 6, 1
COLOR 7: PRINT "Done."
END


'82
DATA 42,42,84,73,56,50,42,42
DATA 26,10,0
DATA 80,105,99,116,32,102,105,108,101,32,109,97,100,101,32,98,121,32,66,77,80,50,80,73,67,44,32,80,97,114,97,110,111,105,39,72,97,99,107,0,0,0
DATA 5,3
DATA 11,0
DATA 246,2
DATA 7
DATA 96,0,0,0,0,0,0,0
DATA 246,2
DATA 244,2

'83
DATA 42,42,84,73,56,51,42,42
DATA 26,10,0
DATA 80,105,99,116,32,102,105,108,101,32,109,97,100,101,32,98,121,32,66,77,80,50,80,73,67,44,32,80,97,114,97,110,111,105,39,72,97,99,107,0,0,0
DATA 5,3
DATA 11,0
DATA 246,2
DATA 7
DATA 96,0,0,0,0,0,0,0
DATA 246,2
DATA 244,2

'83+
DATA 42,42,84,73,56,51,70,42
DATA 26,10,0
DATA 80,105,99,116,32,102,105,108,101,32,109,97,100,101,32,98,121,32,66,77,80,50,80,73,67,44,32,80,97,114,97,110,111,105,39,72,97,99,107,0,0,0
DATA 7,3
DATA 13,0
DATA 246,2
DATA 7
DATA 96,0,0,0,0,0,0,0,0,0
DATA 246,2
DATA 244,2

SUB affichebmp (fichierbmp$)

OPEN fichierbmp$ FOR BINARY AS #1
header$ = SPACE$(14)
sizing$ = SPACE$(4)
GET #1, 1, header$
GET #1, 15, sizing$
bmpinfosize = CVI(sizing$)

infoheader$ = SPACE$(40)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))
     palet$ = SPACE$(8)
     GET #1, bmpinfosize + 15, palet$

er = 0
ft$ = MID$(header$, 1, 2)
  IF NOT ft$ = "BM" THEN
  er = 1
  PRINT "* This file is not a valid BMP !"
  END IF

picwidth = CVL(MID$(infoheader$, 5, 4))
  IF NOT picwidth = 96 THEN
  er = 1
  PRINT "* This file has not 96 pixels width !"
  END IF

picheight = CVL(MID$(infoheader$, 9, 4))
  IF NOT picheight = 63 THEN
  er = 1
  PRINT "* This file has not 63 pixels height !"
  END IF

colorsused = CVL(MID$(infoheader$, 33, 4))
  IF nbits <> 1 THEN
  er = 1
  PRINT nbits
  PRINT "* This is not a 1bit coded file !"
  END IF

IF er = 1 THEN END

da$ = SPACE$(1)

SEEK #1, 63
FOR col = 1 TO 63
 FOR ligne = 1 TO 12
 GET #1, , da$
 transit(ligne, 64 - col) = ASC(da$)
 transit(ligne, 64 - col) = transit(ligne, 64 - col) XOR 255
 NEXT ligne
NEXT col

CLOSE #1

END SUB

FUNCTION bin2dec (chbin$)
DIM lchbin AS INTEGER
DIM i AS INTEGER
DIM k AS INTEGER

lchbin = LEN(chbin$)
FOR i = lchbin TO 1 STEP -1
 x$ = MID$(chbin$, i, 1)
 IF x$ = "1" THEN k = k + 2 ^ (lchbin - i)
NEXT i
bin2dec = k

END FUNCTION

FUNCTION dec2str$ (decima%)
SELECT CASE decima%
 CASE 0: dec2str$ = "0"
 CASE 1: dec2str$ = "1"
 CASE 2: dec2str$ = "2"
 CASE 3: dec2str$ = "3"
 CASE 4: dec2str$ = "4"
 CASE 5: dec2str$ = "5"
 CASE 6: dec2str$ = "6"
 CASE 7: dec2str$ = "7"
 CASE 8: dec2str$ = "8"
 CASE 9: dec2str$ = "9"
END SELECT
END FUNCTION

FUNCTION existfile (ftotest$)

OPEN ftotest$ FOR BINARY AS #1
 IF LOF(1) < 2 THEN
  CLOSE
  KILL ftotest$
  existfile = 0
 ELSE
  CLOSE
  existfile = 1
 END IF

END FUNCTION

SUB menu10

xxl = 0: xxy = 8
COLOR 7: PRINT "Number: ";
COLOR 14: PRINT "0";
COLOR 15: PRINT "  1  2  3  4  5  6  7  8  9"

DO: checkx = xxl
SELECT CASE INKEY$
  CASE CHR$(0) + "K"          'gauche
  IF xxl >= 1 THEN
  xxl = xxl - 1
  xxy = xxy - 3
  END IF

  CASE CHR$(0) + "M"          'droite
  IF xxl <= 8 THEN
  xxl = xxl + 1
  xxy = xxy + 3
  END IF

  CASE CHR$(13): EXIT DO      'entree

  CASE ELSE                   'securite
END SELECT

IF checkx < xxl THEN
LOCATE 4, xxy - 3: COLOR 15
PRINT xxl - 1;
LOCATE 4, xxy: COLOR 14
PRINT xxl;
END IF

IF checkx > xxl THEN
LOCATE 4, xxy + 3: COLOR 15
PRINT xxl + 1;
LOCATE 4, xxy: COLOR 14
PRINT xxl;
END IF
LOOP

END SUB

FUNCTION trait$ (entree$)
SELECT CASE entree$
 CASE "0": trait$ = CHR$(9)
 CASE "1": trait$ = CHR$(0)
 CASE "2": trait$ = CHR$(1)
 CASE "3": trait$ = CHR$(2)
 CASE "4": trait$ = CHR$(3)
 CASE "5": trait$ = CHR$(4)
 CASE "6": trait$ = CHR$(5)
 CASE "7": trait$ = CHR$(6)
 CASE "8": trait$ = CHR$(7)
 CASE "9": trait$ = CHR$(8)
END SELECT
END FUNCTION

SUB UpdateChecksum (check$)

DIM checksum AS INTEGER
DIM chkhi AS INTEGER
DIM chklo AS INTEGER

OPEN check$ FOR BINARY AS #1
a$ = " "
checksum = 0

FOR bytenumber = 56 TO (LOF(1) - 2)
GET #1, bytenumber, a$
checksum = checksum + ASC(a$)
NEXT

checksum = checksum MOD 2 ^ 16

chkhi = INT(checksum / 256)
chklo = checksum MOD 256
pdsfort$ = CHR$(chkhi)
pdsfaible$ = CHR$(chklo)

PUT #1, LOF(1) - 1, pdsfaible$
PUT #1, LOF(1), pdsfort$

CLOSE #1
END SUB

SUB writepic82 (fichierpic$, pictID$)
OPEN fichierpic$ FOR BINARY AS #1

FOR i = 1 TO 72
 READ valu
 n$ = CHR$(valu)
 PUT #1, , n$
NEXT

merde$ = pictID$
FOR securite = 7 TO 9
 IF merde$ = CHR$(securite) THEN
 merde$ = CHR$(0)
 END IF
NEXT

PUT #1, 62, merde$

SEEK #1, 73
FOR col = 1 TO 63
FOR ligne = 1 TO 12
 da$ = CHR$(transit(ligne, col))
 PUT #1, , da$
NEXT ligne, col

checksu$ = SPACE$(2)
PUT #1, , checksu$
CLOSE #1

END SUB

SUB writepic83 (fichierpic$, pictID$)
OPEN fichierpic$ FOR BINARY AS #1

FOR i = 1 TO 72
 READ valu
 n$ = CHR$(valu)
 PUT #1, , n$
NEXT

PUT #1, 62, pictID$

SEEK #1, 73
FOR col = 1 TO 63
FOR ligne = 1 TO 12
  da$ = CHR$(transit(ligne, col))
  PUT #1, , da$
NEXT ligne, col

checksu$ = SPACE$(2)
PUT #1, , checksu$
CLOSE #1

END SUB

SUB writepic83p (fichierpic$, pictID$)
OPEN fichierpic$ FOR BINARY AS #1

FOR i = 1 TO 74
 READ valu
 n$ = CHR$(valu)
 PUT #1, , n$
NEXT

PUT #1, 62, pictID$

SEEK #1, 75
FOR col = 1 TO 63
FOR ligne = 1 TO 12
 da$ = CHR$(transit(ligne, col))
 PUT #1, , da$
NEXT ligne, col

checksu$ = SPACE$(2)
PUT #1, , checksu$
CLOSE #1

END SUB

