;Archive Recover
;By: Dan Englender
;Feel free to use any of this code, but please give me credit.
; -------- Includes ----------
#include		"ti83plus.inc"
#include        "mirage.inc"
; ----------------------------


  .org    $9d93
  .db     $BB,$6D



  ret
  .db	1
button:
	.db	%00000000,%00000000
	.db	%00010011,%00011000
	.db	%00101010,%10100000
	.db	%00111011,%00100000
	.db	%00101010,%10011000
	.db	%00000000,%00000000
	.db	%00000111,%11000000
	.db	%00000011,%10000000
	.db	%00000001,%00000000
	.db	%01110000,%00011100
	.db	%01001110,%10010000
	.db	%01100100,%10011000
	.db	%01000100,%10010000
	.db	%01001110,%11011100
	.db	%00000000,%00000000
desc:
	.db     "Archive Recover",0
	ld	a,2
	call	setupint
	in	a,(6)
	ld	(appbackupscreen),a
	ld	b,$08
findfpage:
	ld	a,b
	cp	$16
	jp	z,quit
	out	(6),a
	ld	a,($4000)
	cp	$F0
	jr	z,foundfpage
	inc	b
	jr	findfpage
foundfpage:
	ld	hl,$4001
findprogloop:
	ld	a,(hl)
	cp	$F0
	jr	z,foundprog
	cp	$FF
	jp	z,quit
nofound
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	add	hl,de
nofoundcont:
	bit	7,h
	jr	z,findprogloop
	res	7,h
	set	6,h
	in	a,(6)
	inc	a
	out	(6),a
	jr	findprogloop
foundprog:
	ld	de,3
	add	hl,de
	ld	a,(hl)
	cp	6
	jr	z,ok
	or	a
	sbc	hl,de
	jr	nofound
ok:	
	push	hl
	bcall(_clrlcdfull)
	ld	hl,0
	ld	(currow),hl
	pop	hl
	ld	de,6
	add	hl,de
	ld	c,(hl)
	ld	b,d
	ld	de,appbackupscreen+2

	inc	hl
	ldir
	xor	a
	ld	(de),a
	push	hl
	ld	hl,appbackupscreen+1
	ld	(hl),5
	rst	20h
	bcall(_chkfindsym)
	jr	c,prognoex
	pop	hl
	push	hl
	bcall(_ldhlind)
	ex	de,hl
	pop	hl
	add	hl,de
	inc	hl
	inc	hl
	jr	nofoundcont
prognoex:
	ld	hl,appbackupscreen+2

	bcall(_puts)
	ld	hl,1
	ld	(currow),hl
	ld	hl,recovtxt
	bcall(_puts)
	ld	hl,appbackupscreen+1
	ld	(hl),5
	rst	20h
getkeyl:
	bcall(_getkey)
	cp	kcapy
	jr	z,recover
	cp	kcapn
	jr	nz,getkeyl
	pop	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	add	hl,de
	jp	findprogloop
recover:
	ld	hl,appbackupscreen+1
	ld	(hl),5
	rst	20h
	pop	hl
	push	hl
	bcall(_ldhlind)
	bcall(_enoughmem)
	ex	de,hl
	jr	c,noram
	push	hl
	bcall(_createprotprog)
	pop	bc
	pop	hl
	inc	bc
	inc	bc		;(instead of incrementing both hl and de twice)
ldiloop:
	ldi
	jp	po,findprogloop
	bit	7,h
	jr	z,ldiloop
	res	7,h
	set	6,h
	in	a,(6)
	inc	a
	out	(6),a
	jr	ldiloop
noram:
	pop	hl
	ld	hl,noramtxt
	jr	donewtxt
quit:
	ld	hl,quittxt
donewtxt:
	push	hl
	bcall(_clrlcdfull)
	ld	hl,0
	ld	(currow),hl
	pop	hl
	bcall(_puts)
	bcall(_getkey)
	ld	a,(appbackupscreen)
	out	(6),a
	ret
quittxt:
	.db	"Search Complete",0
recovtxt:
	.db	"Recover? Y/N",0
noramtxt:
	.db	"Not Enough RAM",0
.end

