
;==========================================;
;== Source To Graphical Button Interface ==;
;==========================================;

#define bcall(label) RST 28h \ .dw label
#define bjump(label) call 50h \ .dw label

#include "ti83plus.inc"
#include "mirage.inc"
#include "mirgui.inc"

tempcoords      = GUIsaferam1+0    ;(2)    Holds the Coordinates for Options Cursor.
tempgoodprog    = GUIsaferam1+2    ;(2)    Temporary Pointer for the Current Good Program.
firstgoodprog   = GUIsaferam1+4    ;(2)    Pointer to the First Valid Program of the List.
lastgoodprog    = GUIsaferam1+6    ;(2)    Pointer to the Last Valid Program of the List.
numgoodmove     = GUIsaferam1+8    ;(1)    How many times Cursor can move over (Buttons).

	.org $9d93
	.db $BB,$6D
	.db $C9,$02
	.db 4,24,"Graphical   Buttons",0

Button_Interface_Start:
	ld de, 1*256+10
	ld (cursorcoords), de
;	xor a
	ld a, 1	;
	ld (topprognum), a
	ld (curprognum), a
Button_Restart_Interface:
	bcall(_grbufclr)
	call Find_Num_Good_Progs
	or a
	jr z, No_Good_Progs_Cont
	call Get_Curgoodprog_Ptr
	ld a, (topprognum)
	ld b, a
	call Skip_Forward_B_From_Top
	ld (topgoodprog), hl
Find_Pointers:
	ld hl, $0000
	call getnextgoodprog
	ld (firstgoodprog), hl
Find_1st_Lst_Cur_GPs_Loop:
	call getnextgoodprog
	jr z, Find_1st_Lst_Cur_GPs_Loop
	ld (lastgoodprog), hl
No_Good_Progs_Cont:
	call Put_MirageOS_Header
	call Put_Folder_Name_Top
	call Put_Black_Desc_Bar
	ld hl, Plotsscreen+(63*12)
	call Invert_1_Line
	ld h, 0
	call Button_Verticle_Fastlines
	ld h, 34
	call Button_Verticle_Fastlines
	ld h, 95
	call Button_Verticle_Fastlines
	ld a, 59
	ld l, 57
	call Put_Size_Graphic
	ld a, (numgoodprogs)
	or a
	jp z, Button_No_Good_Programs

Redraw_Buttons:
	ld hl, Plotsscreen+120
	ld de, Plotsscreen+121
	ld bc, (12*37)-1
	ld (hl), 0
	LDIR
	ld a, (topprognum)
	dec a
	ld b, a
	ld a, (numgoodprogs)
	sub b
	cp 11
	jr c, Button_10_Or_Less
	ld a, 10
Button_10_Or_Less:
	ld b, a
	set fastinfo,(iy+mirflags)
	call Put_Button_Routine
	res fastinfo,(iy+mirflags)

Button_Cursor_Sequence:
	call Put_Black_Desc_Bar
	ld hl, 1*256+56
	ld de, 33*256+62
	xor a
	call FilledRectangle
	ld hl, (curgoodprog)
	call getinfo
	ld de, (ramsize)
	push de
	ld hl, (cursorcoords)
	call Draw_Inverse_Button
	ld de, 56*256+2
	ld hl, OP2
	call setvputs
	ld de, 49*256+2
	ld hl, ramdesc
	SET textinverse, (IY+textflags)
	call setvputs
	RES textinverse, (IY+textflags)
;	Size in DE, but put it into BC
	pop bc
;	DE = Coordinates to put Size Value
	ld de, 56*256+91
	ld a, 5
	call Right_Align_Value
	call fastcopy

Button_Cursor_Getkey_Loop:
	bcall(_getcsc)
	cp $04
	jr z, Button_Cursor_Up			; UP = Cursor Up / Scroll Up
	cp $01
	jr z, Button_Cursor_Down		; DOWN = Cursor Down / Scroll Down
	cp $03
	jp z, Button_Cursor_Right		; RIGHT = Cursor Right
	cp $02
	jp z, Button_Cursor_Left		; LEFT = Cursor Left
	cp $31
	jp z, Button_Page_Right			; GRAPH = Page Buttons Right
	cp $32
	jp z, Button_Page_Left			; (Y=) = Page Buttons Left
	cp $09
	jr z, Button_Run_Program		; ENTER = Execute Current Program
	cp $36
	jr z, Button_Run_Program		; 2ND = Execute Current Program
	cp $28
	jr z, Button_Call_Folder_Menu	; X VAR = Goto Folders Menu
	cp $30
	jr z, Button_To_Options_Screen	; ALPHA = Goto The Options Screen
	cp $2A
	jr z, Button_Move_GUI_Prog		; STO = Move Current Prog to New Folder

	call General_Key_Routine		; MODE = Exit, (+) = Inc, (-) = Dec Contrast
	jr Button_Cursor_Getkey_Loop

Button_Cursor_Up:
	ld hl, (cursorcoords)
	ld a, l
	cp 10
	jr z, Button_Cursor_Getkey_Loop
	call Erase_And_Draw_Normal
	ld hl, curprognum
	dec (hl)
	ld hl, (curgoodprog)
	call getprevgoodprog
	ld (curgoodprog), hl
	ld a, 10
	ld (cursorcoords), a
	jp Button_Cursor_Sequence

Button_Cursor_Down:
	ld hl, (curgoodprog)
	call getnextgoodprog
	jr nz, Button_Cursor_Getkey_Loop
	ld hl, (cursorcoords)
	ld a, l
	cp 29
	jr z, Button_Cursor_Getkey_Loop
	call Erase_And_Draw_Normal
	ld hl, curprognum
	inc (hl)
	ld hl, (curgoodprog)
	call getnextgoodprog
	ld (curgoodprog), hl
	ld a, 29
	ld (cursorcoords), a
	jp Button_Cursor_Sequence

Button_Move_GUI_Prog:
	call Move_GUI_Prog
	jp Button_Interface_Start

Button_Run_Program:
	ld hl, (curgoodprog)
	call runprog
	jp Button_Restart_Interface

Button_Call_Folder_Menu:
	call Folder_Menu_Start
	jp Button_Interface_Start

Button_To_Options_Screen:
	call Options_Screen
	jp Button_Restart_Interface

Button_Cursor_Right:
	call Button_Cur_Right_Routine
Jump_Back_After_Cur_Right:
Jump_Back_After_Cur_Left:
	jp z, Button_Cursor_Getkey_Loop
Jump_Back_To_Cur_Sequence:
	jp Button_Cursor_Sequence
Button_Cursor_Left:
	call Button_Cur_Left_Routine
	jr Jump_Back_After_Cur_Left

Button_Return_Can_Not_Move:
	xor a
	ret
Button_Return_Can_Move:
	xor a
	dec a
	ret

Button_Cur_Right_Routine:
	ld hl, (curgoodprog)
	call getnextgoodprog
	jr nz, Button_Return_Can_Not_Move
	call getnextgoodprog
	jp nz, Shift_Rt_On_Bot_Move_Left
Cont_Button_Cur_Right_Routine:
	ld hl, (cursorcoords)
	call Erase_And_Draw_Normal
	ld a, (cursorcoords+1)
	cp 77
	jp z, Button_Shift_Left
	add a, 19
	ld (cursorcoords+1), a
	call Skip_Forward_2_Good_Progs
	ld hl, curprognum
	inc (hl)
	inc (hl)
	jr Button_Return_Can_Move

Button_Cur_Left_Routine:
	ld hl, (curgoodprog)
	ld bc, (firstgoodprog)
	call cphlbc
	jr z, Button_Return_Can_Not_Move
	call getprevgoodprog
	ld bc, (firstgoodprog)
	call cphlbc
	jr z, Button_Return_Can_Not_Move
	ld hl, (cursorcoords)
	call Erase_And_Draw_Normal
	ld a, (cursorcoords+1)
	cp 1
	jp z, Button_Shift_Right
	sub 19
	ld (cursorcoords+1), a
	call Skip_Back_2_Good_Progs
	ld hl, curprognum
	dec (hl)
	dec (hl)
Jump_To_Button_Ret_Can_Move:
	jr Button_Return_Can_Move

Button_Shift_Right:
	call Skip_Back_2_Top_Progs
	call Skip_Back_2_Good_Progs
	call Button_Shift_Right_Seq
	ld hl, topprognum
	dec (hl)
	dec (hl)
	ld hl, curprognum
	dec (hl)
	dec (hl)
	jr Jump_To_Button_Ret_Can_Move

Button_Shift_Right_Seq:
	call Shift_Right_Routine
	ld hl, Plotsscreen+108
	call Erase_Button_Column
	ld hl, 16*256+10
	ld de, 18*256+46
	call FilledRectangle
	ld a, (cursorcoords)
	cp 29
	jr z, Shift_Right_Cur_On_Bot
	ld hl, (curgoodprog)
Shift_Right_Cur_On_Top:
	ld (tempgoodprog), hl
	ld de, 1*256+10
	ld (tempcoords), de
	jp Put_Side_Col_Buttons
Shift_Right_Cur_On_Bot:
	ld hl, (curgoodprog)
	call getprevgoodprog
	jr Shift_Right_Cur_On_Top

Button_Shift_Left:
	call Button_Shift_Left_Seq
	call Skip_Forward_2_Top_Progs
	call Skip_Forward_2_Good_Progs
	ld hl, topprognum
	inc (hl)
	inc (hl)
	ld hl, curprognum
	inc (hl)
	inc (hl)
	jp Jump_To_Button_Ret_Can_Move

Button_Shift_Left_Seq:
	call Shift_Left_Routine
	ld hl, Plotsscreen+118
	call Erase_Button_Column
	ld hl, 77*256+10
	ld de, 79*256+46
	call FilledRectangle
	ld hl, (curgoodprog)
	call getnextgoodprog
	ld a, (cursorcoords)
	cp 10
	jr z, Shift_Left_Cur_On_Top
Shift_Left_Cur_On_Bot:
	ld (tempgoodprog), hl
	ld de, 77*256+10
	ld (tempcoords), de
	jr Put_Side_Col_Buttons
Shift_Left_Cur_On_Top:
	call getnextgoodprog
	jr Shift_Left_Cur_On_Bot	

Shift_Rt_On_Bot_Move_Left:
	ld a, (numgoodprogs)
	BIT 0, a
	jp z, Button_Return_Can_Not_Move
	ld a, (cursorcoords)
	cp 10
	jp z, Cont_Button_Cur_Right_Routine
	ld a, (cursorcoords+1)
	cp 77
	jp nz, Button_Return_Can_Not_Move
	call Skip_Forward_2_Top_Progs
	call Button_Shift_Left_Seq
	ld de, 58*256+29
	ld (cursorcoords), de
	ld hl, topprognum
	inc (hl)
	inc (hl)
	jp Jump_To_Button_Ret_Can_Move

Put_Side_Col_Buttons:
	call getinfo
	call Draw_Normal_Button
	ld hl, (tempgoodprog)
	call getnextgoodprog
	ret nz
	call getinfo
	ld a, 29
	ld (tempcoords+0), a
	jp Draw_Normal_Button
Button_Pop_And_Ret:
	pop ix
	ret

Button_Page_Left:
	ld hl, (curgoodprog)
	ld bc, (firstgoodprog)
	call cphlbc
	jp z, Button_Cursor_Getkey_Loop
	call getprevgoodprog
	ld bc, (firstgoodprog)
	call cphlbc
	jp z, Button_Cursor_Getkey_Loop
	ld hl, (cursorcoords)
	call Erase_And_Draw_Normal
	ld de, cursorcoords+1
	ld a, (de)
	cp 1
	jr z, Cont_Button_Page_Left
Button_Jump_To_Left_Side:
	ld hl, (topgoodprog)
	dec de
	ld a, (de)
	call Left_Top_Prog_To_Cur_Prog
	ld a, 1
	ld (cursorcoords+1), a
	jp Button_Cursor_Sequence
Cont_Button_Page_Left:
	ld hl, (topgoodprog)
	ld b, 5
	call Button_Page_Left_Loop
	ld (topgoodprog), hl
	ld a, (cursorcoords)
	call Left_Top_Prog_To_Cur_Prog	
	jp Redraw_Buttons

Button_Page_Left_Loop:
	push bc
	call getprevgoodprog
	jr nz, Button_Pop_And_Ret
	call getprevgoodprog
	ld a, (topprognum)
	sub 2
	ld (topprognum), a
	ld a, (curprognum)
	sub 2
	ld (curprognum), a
	pop bc
	DJNZ Button_Page_Left_Loop
	ret
Left_Top_Prog_To_Cur_Prog:
	cp 29
;	call z, getnextgoodprog
	jr z, Left_Top_Prog_Bot_Row
Left_Top_Prog_Not_Bot_Row:
	ld (curgoodprog), hl
	ld a, (topprognum)
	ld (curprognum), a
	ret
Left_Top_Prog_Bot_Row:
	call getnextgoodprog
	ld (curgoodprog), hl
	ld a, (topprognum)
	inc a
	ld (curprognum), a
	ret

Button_Page_Right:
	ld hl, (curgoodprog)
	call getnextgoodprog
	jp nz, Button_Cursor_Getkey_Loop
	call getnextgoodprog
	ld ix, Jump_Back_After_Cur_Right
	push ix
	jp nz, Shift_Rt_On_Bot_Move_Left
	pop ix
	ld hl, (cursorcoords)
	call Erase_And_Draw_Normal
	ld a, (cursorcoords+1)
	cp 77
	jr z, Cont_Button_Page_Right

Button_Jump_To_Right_Side:
	call Button_Jump_To_Rt_Side_Loop
	jp Button_Cursor_Sequence

Button_Jump_To_Rt_Side_Loop:
	ld hl, (curgoodprog)
	call getnextgoodprog
	ret nz
	call getnextgoodprog
	ret nz
	ld (curgoodprog), hl
	ld hl, curprognum
	inc (hl)
	inc (hl)
	ld a, (cursorcoords+1)
	add a, 19
	ld (cursorcoords+1), a
	cp 77
	ret z
	jr Button_Jump_To_Rt_Side_Loop

Cont_Button_Page_Right:
	ld hl, (curgoodprog)
	xor a
	ld (numgoodmove), a
	ld b, 5
	call Button_Page_Right_Loop
	ld a, (numgoodmove)
	SLA a
	ld b, a
	ld hl, (curgoodprog)
Page_Rt_Get_Cur_Prog_Loop:
	push bc
	call getnextgoodprog
	jr nz, Page_Rt_Bot_Move_Back_1
	pop bc
	DJNZ Page_Rt_Get_Cur_Prog_Loop
	ld (curgoodprog), hl
Page_Right_Redraw_Buttons:
	jp Redraw_Buttons

Page_Rt_Bot_Move_Back_1:
	pop ix
	call getprevgoodprog
	ld (curgoodprog), hl
	ld a, 58
	ld (cursorcoords+1),a
	jr Page_Right_Redraw_Buttons

Button_Page_Right_Loop:
	push bc
	call getnextgoodprog
	jp nz, Button_Pop_And_Ret
	call getnextgoodprog
	jp nz, Button_Page_Rt_Check_Odd
	call Button_Page_Rt_Move_Top
	ld a, (topprognum)
	add a, 2
	ld (topprognum), a
	ld a, (curprognum)
	add a, 2
	ld (curprognum), a
	pop bc
	DJNZ Button_Page_Right_Loop
	ret
Button_Page_Rt_Check_Odd:
	ld a, (numgoodprogs)
	BIT 0, a
	call nz, Button_Page_Rt_Move_Top
	jp Button_Pop_And_Ret

Button_Page_Rt_Move_Top:
	ld a, (numgoodmove)
	inc a
	ld (numgoodmove), a
	push hl
	call Skip_Forward_2_Top_Progs
	pop hl
	ret

Erase_Button_Column:	; HL = Plotsscreen Start Byte, B = Number of Rows
	ld de, 11
	xor a
	ld b, 39
Erase_Button_Col_Loop:
	ld (hl), a
	inc hl
	ld (hl), a
	add hl, de
	DJNZ Erase_Button_Col_Loop
	ret

Shift_Left_Routine:
    ld hl, Plotsscreen+(10*12)+2
    ld de, Plotsscreen+(10*12)
    ld bc, 35*12-2
	LDIR
    SCF
	CCF
    ld b,3
Shift_Left_Loop3:
    ld d,b
	ld hl, Plotsscreen+(10*12)+(35*12)-1
	ld b, 35
Shift_Left_Loop1:
    ld c, b
    ld b, 12
Shift_Left_Loop2:
    dec hl
    RL (hl)
    DJNZ Shift_Left_Loop2
    ld b, c
    DJNZ Shift_Left_Loop1
    ld b, d
    DJNZ Shift_Left_Loop3
    ret

Shift_Right_Routine:
    ld hl, Plotsscreen+(47*12)-2
    ld de, Plotsscreen+(47*12)
    ld bc, 38*12-2
	LDDR
    SCF
	CCF
    ld b, 3
Shift_Right_Loop3:
    ld d, b
    ld hl, Plotsscreen+(10*12)
	ld b, 37
Shift_Right_Loop1:
    ld c,b
    ld b,12
Shift_Right_Loop2:
    inc hl
    RR (hl)
    DJNZ Shift_Right_Loop2
    ld b, c
    DJNZ Shift_Right_Loop1
    ld b, d
    DJNZ Shift_Right_Loop3
    ret

Button_Verticle_Fastlines:
	ld l, 56
	ld e, 62
	ld d, h
	jp fastlineb 

Button_Outline_Graphic:
	.db %11111111,%11111111,%10000000
	.db %10000000,%00000000,%10000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %10000000,%00000000,%11000000
	.db %11111111,%11111111,%11000000
	.db %00111111,%11111111,%11000000

Put_Button_Routine:
	ld hl, (topgoodprog)
	ld de, 1*256+10
	ld (tempcoords), de
Put_Button_Loop:
	push bc
	push hl
	ld de, (tempcoords)
	push de
	call getinfo
	pop hl
	push hl
	ld a, h
	inc a
	inc l
	ld bc, 15*256+2
	ld ix, rambutton
	call LargeSprite
	pop hl
	push hl
	ld a, h
	ld bc, 18*256+3
	ld ix, Button_Outline_Graphic
	call Largesprite
	pop de
	ld a, e
	xor 23
	ld e, a
	cp 10
	jr nz, Button_No_Next_Col
	ld a, d
	add a, 19
	ld d, a
Button_No_Next_Col:
	ld (tempcoords), de
	pop hl
	call getnextgoodprog
	jp nz, Button_Pop_And_Ret
	pop bc
	DJNZ Put_Button_Loop
	ret
	
Erase_And_Draw_Normal:
	call Erase_Button
	call Get_Cur_Prog_Button
	jr Cont_Draw_Normal_Button
Draw_Normal_Button:
	call Find_Button_Coords
Cont_Draw_Normal_Button:
	call Put_Button_Graphic
	push hl
	push de
	dec d
	dec e
	ld a, 1
	call FastRectangle
	pop de
	pop hl
	push de
	ld a, e
	sub 15
	ld l, a
	ld h, d
	call fastlineb
	pop de
	ld a, d
	sub 15
	ld h, a
	ld l, e
	jp fastlineb

Draw_Inverse_Button:
	call Erase_Button
	inc h
	inc l
	call Put_Button_Graphic
	ld a, 2
	call FilledRectangle_Save
	ld a, h
	add a, 16
	ld h, a
	jp fastlineb

Put_Button_Graphic:
	push hl
	push de
	ld a, h
	inc a
	inc l
	ld bc, 15*256+2
	ld ix, rambutton
	call LargeSprite
	pop de
	pop hl
	ret

Erase_Button:
	ld (tempcoords), hl
	call Find_Button_Coords
	xor a
	jp FilledRectangle_Save

Find_Button_Coords:
	ld hl, (tempcoords)
	ld a, h
	add a, 17
	ld d, a
	ld a, l
	add a, 17
	ld e, a
	ret

Get_Cur_Prog_Button:
	push de
	push hl
	ld hl, (curgoodprog)
	call getinfo
	pop hl
	pop de
	ret

Put_Black_Desc_Bar:
	ld hl, Plotsscreen+(49*12)
	ld de, Plotsscreen+(49*12)+1
	ld bc, 7*12-1
	ld (hl), $FF
	LDIR
	ret

Skip_Back_2_Good_Progs:
	ld hl, (curgoodprog)
	call getprevgoodprog
	call getprevgoodprog
	ld (curgoodprog), hl
	ret
Skip_Forward_2_Good_Progs:
	ld hl, (curgoodprog)
	call getnextgoodprog
	call getnextgoodprog
	ld (curgoodprog), hl
	ret
Skip_Back_2_Top_Progs:
	ld hl, (topgoodprog)
	call getprevgoodprog
	call getprevgoodprog
	ld (topgoodprog), hl
	ret
Skip_Forward_2_Top_Progs:
	ld hl, (topgoodprog)
	call getnextgoodprog
	call getnextgoodprog
	ld (topgoodprog), hl
	ret

None_Text:
	.db "None",0
No_Progs_Text:
	.db "This Folder Is Empty",0

Button_No_Good_Programs:
	ld bc, $0000
	ld de, 56*256+91
	call Right_Align_Value
	ld de, 56*256+10
	ld hl, None_Text
	call setvputs
	ld hl, No_Progs_Text
	ld de, 25*256+15
	call setvputs
	call fastcopy
Button_No_Progs_Getkey_Loop:
	bcall(_getcsc)
	cp $09
	jr z, No_Progs_Call_Folder_Menu		; ENTER = Goto Folders Menu
	cp $36
	jr z, No_Progs_Call_Folder_Menu		; 2ND = Goto Folders Menu
	cp $28
	jr z, No_Progs_Call_Folder_Menu		; X VAR = Goto Folders Menu
	cp $30
	jp z, Button_To_Options_Screen		; ALPHA = Goto The Options Screen

	call General_Key_Routine			; MODE = Exit, (+) = Inc, (-) = Dec Contrast
	jr Button_No_Progs_Getkey_Loop

No_Progs_Call_Folder_Menu:
	jp Button_Call_Folder_Menu

.end
