;---------
;Z-DOS 2.0
;---------
;
;Programmed by David Lindstrm 
;okvin@tiscali.se
;Member of the Cirrus Programming group.
;Visit us at http://cirrus.tigalaxy.com



#include "ti83plus.inc"
#define kommando appbackupscreen
#define stringpointer appbackupscreen+20 ;Variable that contains the current position in textbuffer
#define textbuffer appbackupscreen		  ;Inputted text is stored here
#define antalkommandon 18
#define Lspace 20h
#define Lbackslash 5Ch
#define prog_executing 1
#define variabel keytostrram

.org usermem-2
 .db $BB,$6D
 xor a
 jr nc,beginnen
titel:
.db " Z-DOS 2.0 ",0
beginnen:
 call rensatopp
 ld hl,titel
 call skrivinverterad
ny:
 call in		;Mata in en strng...
 ld hl,kommando
 bcall(_strlength)
 ld a,Lspace
 cpir
 jr nz,strkontroll
 xor a
 dec hl
 ld (hl),a

strkontroll
;Kanon! Nu sk den frsta delstrngen i kommandot kollas
 ld hl,kommandotexter
 ld b,antalkommandon
kontrolloop:
 ld de,kommando
inreloop:
 ld a,(de)
 or (hl)		;(de) och (hl)=0?
 jr z,kommando_hittat
 ld a,(de)
 xor (hl)
 inc de
 inc hl
 jr z,inreloop
 push bc
 dec hl
 bcall(_strlength)
 add hl,bc
 inc hl
 pop bc

 djnz kontrolloop
 ld de,$9871			;Suck...
;Om indata ej e ett kommando (B=0)s kan d ju va 1 programnamn. Drfre kontrollera det
 ld a,b
 jp hitta
;Kommando ej giltigt el (program)
programfel:		;Om programmet ej finns
 ld hl,syntaxfeltxt

nesta:
 call skrivinverterad
 jr ny

kommandotexter:
		;Dubbelkommandon
		.db "H",0			;
		.db "L",0			;
		.db "UL",0			;
		.db "A",0			;
		.db "UA",0			;
		.db "C",0			;
		.db "DEL",0			;
		.db "UH",0			;
		;Enkelkommandon
		.db "RESET",0		;
		.db "CLS",0			;
		.db "HELP",0		;
		.db "X",0			;
		.db "INFO",0		;
		.db "HA",0			;
		.db "UHA",0			;
		.db "LS",0			;3
		.db "LWRON",0		;2
		.db "LWROFF",0		;1

kommando_hittat:
 ld a,b
 dec a
 jr nz,kontroll1
			 ;Sm bokstver avaktiveras
			 res lwrcaseactive,(iy+applwrcaseflag)
			 ld hl,lwrofftxt
			 jr nesta
kontroll1
 dec a
 jr nz,kontroll2
			 ;Sm bokstver aktiveras
			 set lwrcaseactive,(iy+applwrcaseflag)
			 ld hl,lwrontxt
			 jr nesta
kontroll2
 dec a
 jr nz,kontroll3
 		;Programlista
		ld hl,5
		ld (op1),hl
		call rensatopp
listloop:
		bcall(_findalphaup)
		jr c,nesta+3
		ld hl,op1+1
		call skrivnylinje
		call paus
		jr listloop

kontroll3
 dec a
 jr nz,kontroll4
			;ALLA SYNLIGGRS
			 ld hl,allasynligtxt
			 push hl
			 xor a
						
mixtrasymbol
			 ld (iy+asm_flag1),a
			 call symboltabell
			 pop hl
			 jr kontroll2-2
			

kontroll4
 dec a
 jr Nz,kontroll5
 ;ALLA OSYNLIGGRS
			 ld hl,allaosynligtxt
			 push hl
			 ld a,255
			 jr mixtrasymbol
kontroll5
 dec a
 jr nz,kontroll6
			  ;Visa systeminformation	
			  call rensatopp
			  bcall(808ah)		;Dispbootver, undocumented rom call ;-)
			  bcall(_newline)
			  ld hl,ramtxt
			  bcall(_puts)
			  bcall(_memchk)
			  bcall(_dispHL)
			  bcall(_newline)
			  ld hl,batteritxt
			  bcall(_puts)
			  bcall(_chk_batt_low)
			  push af
			  ld hl,okstr
			  call nz,skrivnylinje
			  pop af
			  ld hl,svagstr	
			  call z,skrivnylinje
ny2
			  jp ny
			
kontroll6
 dec a
 jr nz,kontroll16	  ;X avslutar
 call rensatopp
 ret

kontroll16
 dec a
 jr nz,kontroll7
		 ;LIsta kommandon
		 call rensatopp
		 ld hl,kommandontxt
		 call skrivinverterad
		
		 ld hl,kommandotexter
		 ld b,antalkommandon
listakommandon
		 bcall(_PutS)
		 bcall(_newline)
		 call paus
		 djnz listakommandon
		 jr ny2

kontroll7
 dec a
 jp z,usermem
 dec a
 jp z,$EFFF		;Krasha

;----------------
;PROGRAMKOMMANDON
;----------------

 dec a
 jr z,synlig	;Vi mste strunta i programnamnet om vi ska gra synlig

hitta:
 call flyttakontroll
 jp c,programfel
 dec a
 jr z,radera
 dec a
 jr z,kopiera
 dec a
 jr z,fran_arkiv
 dec a
 jr z,arkivera
 dec a
 jr z,oskydda
 dec a
 jr z,skydda
 dec a
;Allts kan det bara va 1 kvar
 jr z,osynlig
 jp exekvera

radera:
 bcall(_chkfindsym)
 bcall(_delvararc)	;Utdata frn _chkfindsym intakt
 ld hl,raderatxt
 jr nesta2

osynlig:
 ld de,osynligtxt
 push de
 ld d,40h
 jr addera

synlig:
 inc de
 ld a,(de)
 sub 40h
 ld (de),a
 dec de
 call flyttakontroll
 ld bc,synligtxt	;DE=pekare till programmet som skall gras synligt, drfr
 jp c,programfel
 push bc 			;anvnd icke!
 ld d,-40h


addera:	;Indata: HL-pekare till VAT
 ld bc,-7
 add hl,bc
 ld a,(hl)
 sub d	;41h fr osynlig...	
 ld (hl),a
 pop HL	;Strngadressen
nesta2
 jp nesta

arkivera:
 xor a
 cp b		;B intakt
 bcallz(_arc_unarc)
 ld hl,archivedtxt
 jp nesta
fran_arkiv:
 xor a
 cp b
 jr z,i_ram
 bcall(_arc_unarc)
i_ram:
 ld hl,unarchivedtxt
 jr nesta2


skydda:
 ld b,protprogobj
 ld de,locktxt
 jr lagradatatyp
oskydda:
 ld de,unlocktxt
 ld b,5
lagradatatyp:
 ld a,(hl)
 and %11100000
 or b
 ld (hl),a
 ex de,hl
 jr nesta2

;Tvdelade kommandon



kopiera:
 ld a,b
 or a
 ld hl,arkivfeltxt
 jr Nz,nesta3
;DE=Pekare till klldata
;Ls storlekn
 ex de,hl
 ld c,(hl)
 inc hl
 ld b,(hl)
 push bc	;Storlek, adressen ndras d vi skapar ett nytt program


 ld hl,kopiera_tilltxt
 call skrivinverterad
 bcall(_op1toop3)					;Spara kllnamn i OP3
 call in					;mata in
 call flyttakontrollapp

 jp nc,programfel		;Se om programmet existerar
;(OP1)=programnamn
;
 pop hl
 push hl
 bcall(_createprog)
;DE=pekare till destinationen
 push de
 bcall(_op3toop1)
 bcall(_chkfindsym)
 ex de,hl
 pop de
 pop bc
 inc bc
 inc bc
 ldir
 ld hl,kopieratxt
nesta3
 jr nesta2


exekvera:
 ld a,b
 or a				;Is program archived?
 jr nz,readflash	;Then read the size and the two first bytes from archived prog.
 ex de,hl
 push AF		;Flash page=0	
 ld c,(hl)
 inc hl
 ld b,(hl)
 push bc		;save size
 push HL		;And address
 inc hl


 bcall(_ldhlind)
 ld de,$6DBB	 ;See if the first 2 bytes of the program=AsmPrgm token
 bcall(_cpHLDE)  ;Compare with de
 jr z,asmprogram ;If asm program, jump and run it
 pop HL
 pop HL
 pop HL
runbasic:
 set prog_executing,(iy+newdispf)	;Needs to be set when running basic programs
 bcall(_parseinp)					;Run IT
 bcall(_cleanall)		;Delete temporary vars generated by the program
 call deltempprog		;Delete prgmN141.
 jp ny

readflash:

 push af	;Save the flash page
 ex de,hl	;HL=pointer to archived program
 inc hl					;Skip the data valid flag
 push hl				;Save the flash address

 bcall(_loaddeindpaged) ;This will load DE with program size
;Calculate Name length... 
 ex de,hl			;DE=program size, now in HL
 ld d,a

 push hl
 ld hl,op1
 bcall(_strlength)
 ld a,8
 cp c
 jr c,add8 
 ld a,c
 DEC A
add8
 add a,9
 ld c,a
 pop hl

  
 scf
 sbc hl,bc	;Subtract bc from hl
 ld a,d		;A=flash page
 pop DE		;Address->DE
 inc hl
 push HL	;Save new size

 ex de,hl	;Address->HL
 add HL,BC	
 	;
 ld b,a
 inc hl
 push HL	;Save new address
 inc hl
 bcall(_loaddeindpaged)	

 ld hl,$6DBB
 bcall(_cphlde)	;IF Z=1, then it's an asm program
 jr z,asmprogram
;Archived basic program...
 call deltempprog

 pop de
 pop HL		;Size
 push de
 push HL	;Save size
 bcall(_createprog)
 inc de
 inc de		;Skip size bytes

 pop bc
 pop HL
 inc hl
 pop af
 bcall(_flashtoram)
 ld hl,tempprog
 rst 20h	
 jr runbasic
 


asmprogram:
 ld hl,insertmem
 rst 20h		;Copy memory insert routine to OP1
;Set up the Regs for _insertmem
 pop bc	;Address
 pop HL	;Size
 push BC
;Save amount
 bcall(_enoughmem)
 ex de,hl
 jp c,memerror
 push HL
 ld de,usermem
 jp OP1			;Jump to our mem insert routine in op1

;BC=Size
;Stack entry #1=Address
;#2=Flash page
installer:
 pop HL
 inc hl
 inc hl
 inc hl
 ld de,usermem
 pop AF
 push BC	
 or a
 jr nz,copyz80
 Add hl,bc	;Get the right pointer to the program if in RAM

copyz80:
 bcall(_flashtoram)	;Copy from FLASH->RAM
 							;psst! If a=0, flashtoram will copy from RAM to RAM :)
runZ80:
 call usermem		;Run the program
cleanupprog:
 pop bc
 ld hl,delmem
 add hl,bc
 push BC
 rst 20h	;Copy our clean up routine to OP1
 pop DE	;Size
 jp OP1 	;Delete the program from usermem and redraw GUI

insertmem:
 bcall(_insertmem)
 pop bc
 ld hl,installer
 add hl,bc
 jp (hl)

delmem:
 ld hl,usermem
 bcall(_delmem)
m2:
 jp ny


memerror:;Come here if not enough RAM
 pop HL	;Address
 pop HL	;Flash page
 jr m2



;~~~~~~~~~~
;Subrutiner
;~~~~~~~~~~


deltempprog:		;Delete prgmN141 generated when running archived programs
 ld hl,tempprog	
 rst 20h
 bcall(_chkfindsym)
 bcallnc(_delvararc)	;Delete N141 if already present
 ret

symboltabell
 LD HL,symtable ; HL = pointer to first symbol entry
 LD D,0
 LD BC,(pTemp) ; BC = pointer to byte after the end
loop:
 OR A
 SBC HL,BC ; current - end, if CA then done with  search
 RET C ; return if no more syms to check
 RET Z ; return if no more to check

 ADD HL,BC ; restore current search pointer
 LD A,(HL) ; get symbol entry type
 AND 1Fh ; mask off variable type

 LD E,6 ; DE = offset to NL or first byte of name
 SBC HL,DE ; (HL) = NL or first byte of name

 LD E,3 ; DE = offset to next entry if not a program/list/group/AppVar
 CP AppVarObj ; current entry an AppVar
 JR Z,movetonext ; yes, get NL to find next entry

 CP ProgObj ; current entry a program
 JR Z,hideprog ; yes, get NL to find next entry

 CP ProtProgObj ; current entry a program
 JR Z,hideprog ; yes, get NL to find next entry

 CP TempProgObj ; current entry a program
 JR Z,movetonext ; yes, get NL to find next entry

 CP groupobj ; current entry a group var
 JR Z,movetonext ; yes, get NL to find next entry

 DEC HL ; (HL) = tVarLst if a list
 LD A,(HL)
 INC HL ; fix
 CP tVarLst ; current entry a list
 JR NZ,movetonext1 ; no
Movetonext:
 LD E,(HL) ; DE = length of name
 INC E ; DE = length of name + 1

; move HL to next symbol table entry sign digit

Movetonext1:
 OR A
 SBC HL,DE ; HL = next symbol table entry address
 JR loop
 
hideprog:
 dec hl
 call giltigtprogram
 ld a,(hl)
 jr z,systemprog+1
 cp 41h
 jr c,synliggor	;om mindre n 41h=gmt
;Annars r det ett vanligt program
 bit 0,(iy+asm_flag1)
 jr z,systemprog
 sub 40h
 jr systemprog

synliggor
 bit 0,(iy+asm_flag1)
 jr nz,systemprog
 add a,40h

systemprog:
 ld (hl),a
 inc hl
 jr movetonext

rensatopp
 bcall(_clrscrnfull)
 bcall(_homeup)
 ret

skrivinverterad:
 set textinverse,(iy+textflags)
skrivnylinje:
 bcall(_PutS)
 res textinverse,(iy+textflags)
 bcall(_newline)
 ret

giltigtprogram:
 ld a,(hl)
 cp '!'
 ret z
 cp '#'
 ret z
 ;Kontrollera om ZDOS2
 cp 'Z'
 ret nz
 dec hl
 ld a,(hl)
 inc hl
 cp 'D'
 ret

in:
 set appautoscroll,(iy+appflags)
 bcall(_runindicoff)
 bcall(_enableAPD)
 ld a,$DF
 bcall(_putmap)

 ld hl,appbackupscreen
 push hl
 bcall(_bufclr)
 pop hl
 ld (stringpointer),hl	;Initiate the variable

 set shiftalock, (iy+shiftflags)	;Enable alpha-lock
 set shiftalpha, (iy+shiftflags)
;Markrposition
 ld a,2
 ld (curcol),a
 bcall(_eraseEOL)


getkey:
 bcall(_Cursoron)					;Turn on cursor
 bcall(_getkey)					;Wait for keypress
 res oninterrupt,(iy+onflags) 
 push af
 bcall(_cursoroff)
 pop af
 pop hl
 cp kquit
 ret z
 push hl

 cp kEnter			
 jr z,xit 							;If enter was pressed, goto exit
 cp Kclear
 jr z,in								;if clear was pressed, restart this program

;Giltigt knapptryck...
;kontrollera om piltangenter och vidta tgrder.

 ld hl,(stringpointer)
 cp kright
 jr z,hoger
 cp kdel
 jr z,sudda

;Antingen r det frgan om vnster eller ett tecken
 cp kleft
 jr nz,bokstav

venster
 ld a,$72
 cp L
 jr z,getkey	;Uppdatera icke om den redan r p frsta
 push hl
 ld hl,curcol
 dec (hl)
 pop hl
 dec hl
 jr lagra

 
bokstav
 ld e,a						;Load the keycode returned by _getkey into e
 ld d,0						;We won't use any 2-byte keys, therefore loading 0 into d
 ld a,L
 cp $7F
 jr z,jrg
 bcall(_keytostring)		;Convert the key-code to it's appropriate string
 ld a,(hl)					;Get the size of the string.
 cp 1							;See if it's 1
 jr nz,getkey				;If it not 1, a "bad key" has been pressed. If so, goto getkey
;Kontroll nummel tv...
 inc hl
 ld a,(hl)
 cp '?'
 jr z,jrg
 bcall(_putC)				;If the keypress is valid, display the char and advance cursor
 ld a,(keytostrram+1)	;Now, the accumulator holds the character
 ld hl, (stringpointer)	;Load hl with the memory address to store the char to
 ld (hl),a					;Store the char in textbuffer (appbackupscreen)
 inc hl						;Increase pointer
 ld (stringpointer),hl	;Update the variable
jrg
 jr getkey					;Repeat 


sudda:
 ld a,(hl)
 or a
 jr z,getkey
 bcall(_strlength)
 ld d,h
 ld e,l
 inc hl
 ldir
 ld a,(curcol)
 push af
 ld a,2
 ld (curcol),a
 bcall(_eraseeol)
 ld hl,appbackupscreen
 bcall(_puts)
 pop af
 ld (curcol),a
 jr jrg

xit:
 ld a,(appbackupscreen)
 or a
 jr z,jrg		;Tomma prompter tillts ej
; res shiftalock, (iy+shiftflags)
 res shiftalpha, (iy+shiftflags)	;Disable alpha-lock
 bcall(_newline)					;Insert a new line on the screen
 ret 

hoger
 push hl
 ld hl,curcol
 inc (HL)
 pop hl
 ld a,(hl)
 inc hl
 or (hl)	;om (HL) och (HL+1) e 0, uppdatera icke
 inc hl
 dec hl
 jr z,venster
lagra
 ld (stringpointer),hl
 jr jrg


flyttakontrollapp
 ld de,$9871
flyttakontroll:
 push af
 ex de,hl
 rst 20h		;mov9toop1
 ld a,progobj
 ld (op1),a
 bcall(_chkfindsym)
 ld a,b		;b mste sparas
 pop bc		;b=a
 ld c,b		;b,c=a
 ld b,a
 ld a,c
 ret

paus:  
		 ld a,(currow)
		 cp 7
		 ret nz
		 push bc
		 push hl
		 rst 18h	;_pushrealo1
		 bcall(_getkey)
		 call rensatopp
		 bcall(_poprealo1)
		 pop hl
		 pop bc
		 ret

tempprog:
.db progobj,"N141",0
syntaxfeltxt:
.db "Bad CMD/PROG",0
kommandontxt
.db "Commands",$CE,0
kopiera_tilltxt
.db "Copy To:",0


;Bekrftelser


lwrontxt:
.db "Lwrcase On",0
lwrofftxt:
.db "Lwrcase Off",0

allasynligtxt
.db "All "
synligtxt:
.db "Unhidden",0
allaosynligtxt
.db "All "
osynligtxt:
.db "Hidden",0
locktxt:
.db "Locked",0
unlocktxt:
.db "Unlocked",0
arkivfeltxt
.db "ERR: "
archivedtxt:
.db "Archived",0
unarchivedtxt:
.db "Unarchived",0
raderatxt:
.db "Deleted",0
kopieratxt:
.db "Copied",0

okstr:
.db "Ok",0
svagstr:
.db "Weak",0

;INFO
ramtxt:
.db "Free RAM:",0
batteritxt:
.db "Batteries:",0

.end