;##################################################################
;
;   Phoenix-82 (Screen display routines)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 9, 2001.
;
;##################################################################   

;############## Display -1 terminated list of strings at (HL)

display_hl_msgs:
        ld      de,0
show_loop:
        ld      (CURSOR_ROW),de
        push    de
        ROM_CALL(D_ZT_STR)
        pop     de
        ld      a,(hl)
        inc     a
        ret     z
        inc     e
        jr      show_loop

;############## Prepares on-screen shield indicator

prepare_indicator:
        ld      a,(player_pwr)
        or      a
        ret     z
        ret     m
        ld      b,a
        ld      hl,GFX_AREA+1024-3
        ld      de,-16
loop_ind:
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        set     0,(hl)
        add     hl,de
        djnz    loop_ind
        ret

;############## Clears screen buffer

clear_buffer:
        ld      (smc_savesp+1),sp
        ld      hl,0
        ld      sp,GFX_AREA+1024
        ld      b,63
loop_super_clear:
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        push    hl
        djnz    loop_super_clear
smc_savesp:
        ld      sp,0

        ld      hl,GFX_AREA+2
        ld      bc,11
        jp      OTH_CLEAR

;############## Display entire screen from buffer

#ifdef  TI83P
display_screen:
        jp      $0

display_screen_se:
        ld      a,$80           ; 7
        out     ($10),a         ; 11
        ld      hl,GFX_AREA+2-16-(-(16*64)+1)    ; 10
        ld      a,$20           ; 7
        ld      c,a             ; 4     ; 43
slowCopyAgain:
        ld      b,64            ; 7
        inc     c               ; 4
        ld      de,-(16*64)+1   ; 10

        call    waste_time_disp
        out     ($10),a         ; 11
        add     hl,de           ; 11
        ld      de,15           ; 10
slowCopyLoop:
        call    waste_time_disp
        add     hl,de           ; 11
        inc     hl              ; 6
        ret     c               ; 5
        ld      a,(hl)          ; 7
        out     ($11),a         ; 11
        djnz    slowCopyLoop    ; 13/8  ; 3392
        ld      a,c             ; 4
        cp      $2B+1           ; 7
        jr      nz,slowCopyAgain; 12/7
        ret     ; 11    ; 18

waste_time_disp:
        push    ix
        pop     ix
        nop
        ret

display_screen_normal:
#else
display_screen:
#endif
        ld      a,$80           ; 7
        out     ($10),a         ; 11
        ld      hl,GFX_AREA+2-16-(-(16*64)+1)    ; 10
        ld      a,$20           ; 7
        ld      c,a             ; 4     ; 43
fastCopyAgain:
        ld      b,64            ; 7
        inc     c               ; 4
        ld      de,-(16*64)+1   ; 10
#ifdef __TI83__
        nop
        nop
#endif
        out     ($10),a         ; 11
        add     hl,de           ; 11
        ld      de,15           ; 10
fastCopyLoop:
#ifdef SLOWDOWN
        nop
        nop
#endif
        add     hl,de           ; 11
        inc     hl              ; 6
        ret     c               ; 5
        ld      a,(hl)          ; 7
        out     ($11),a         ; 11
        djnz    fastCopyLoop    ; 13/8  ; 3392
        ld      a,c             ; 4
        cp      $2B+1           ; 7
        jr      nz,fastCopyAgain; 12/7
        ret     ; 11    ; 18
