;##################################################################
;
;   P H O E N I X         F O R        T I - 8 3 / +      ( I o n )
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated September 9, 2001.
;
;##################################################################     

#define __TI83__
#define SLOWDOWN

#include "ion.inc"
#include "keys.inc"

#define TEXT_MEM saferam2+200

#define ROM_CALL(kewl_routinez) bcall(kewl_routinez)

#ifdef TI83P
        .org    progstart-2
        .db     $BB,$6D

interrupt_entry =$9898
interrupt_byte  =$98
interrupt_table =$9900
interrupt_reg   =$99
backup_storage  =$9A01

#else
        .org    progstart

interrupt_entry =$8282
interrupt_byte  =$82
interrupt_table =$8300
interrupt_reg   =$83
backup_storage  =$8401

#endif

GFX_AREA        =plotsscreen

    ret
    jr  nc,start

D_ZT_STR        =_puts
D_HL_DECI       =_disphl
TX_CHARPUT      =_putc
CLEARLCD        =_clrlcdf
CURSOR_ROW      =currow
CURSOR_COL      =curcol

#include "phoenixz.h"

        .db     "Phoenix for Ion",0

start:

#ifdef  TI83P                           ; silver edition check
        ld      hl,display_screen_normal
        ld      (display_screen+1),hl
        bcall($4c6f)                    ; getBaseVer (A.B)
        cp      1
        jr      c,not_se                ; A=0 -> rom < 1.13 -> not se
        jr      nz,at_least_113
        ld      a,b
        cp      13
        jr      c,not_se                ; B < 12 -> rom < 1.13 -> not se 
at_least_113:
        bcall($50e0)                    ; nzIf83Plus
        jr      nz,not_se
        ld      hl,display_screen_se    ; se -> use slower display code
        ld      (display_screen+1),hl
not_se:
#endif
        call    main
        ld      (iy+13),6
        ret

GET_KEY:
        bcall(_getcsc)
        ret

LD_HL_MHL:
        ld      a,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,a
        ret

CP_HL_DE:
        push    hl
        and     a
        sbc     hl,de
        pop     hl
        ret

;############## Include remainder of game files

#include "main12.asm"
#include "extlev12.asm"
#include "exchange.asm"
#include "lib12.asm"
#include "lib.asm"
#include "new12.asm"
#include "disp12.asm"
#include "drwspr.asm"
#include "player12.asm"
#include "shoot.asm"
#include "bullets.asm"
#include "enemies.asm"
#include "init.asm"
#include "enemyhit.asm"
#include "collide.asm"
#include "ebullets.asm"
#include "hityou.asm"
#include "shop12.asm"
#include "helper.asm"
#include "eshoot.asm"
#include "score12.asm"
#include "images.asm"
#include "data.asm"
#include "levels.asm"
#include "storage.asm"

        .end
