;##################################################################
;
;   Phoenix III for the TI-86 - Bonuses
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated April 10, 2001.
;
;##################################################################

;############## Bonus deployer (called at enemy destruction)

deploy_bonus:
        ld      a,r
        and     7
        ret     nz

        push    hl
        call    find_enemy_bullet
        jr      nz,deploy_done

        ld      d,h
        ld      e,l                 ; DE -> empty enemy bullet

        ld      a,(game_timer)
        and     %11000
        ld      hl,bonus_data
        call    ADD_HL_A            ; HL -> bonus description

        push    de
        ld      bc,8
        ldir                        ; copy bonus data

        pop     de                  ; DE -> enemy bullet
        pop     hl                  ; HL -> original enemy
        push    hl

        inc     hl
        inc     de
        ldi                         ; copy X
        inc     hl
        inc     de
        ldi                         ; copy Y

deploy_done:
        pop     hl
        ret

;############## Receive bonus (of type in A)

receive_bonus:
        inc     a
        jr      z,free_points
        inc     a
        jr      z,weapon_boost
shield_boost:
        ld      de,number+2
        ld      a,5
        ld      (de),a
        ld      hl,shield+2
        jp      ADD_BCD
free_points:
        ld      de,number+2
        ld      a,$50
        ld      (de),a
        ld      hl,score+2
        jp      ADD_BCD
weapon_boost:
        inc     a
        ld      (weapon_power),a
        ret

;############## Bonus data structures and images

bonus_data:
        .db     4,0,7,0,7,-1
        .dw     bonus_points
        .db     4,0,7,0,7,-2
        .dw     bonus_weapon
        .db     4,0,7,0,7,-1
        .dw     bonus_points
        .db     4,0,7,0,7,-3
        .dw     bonus_shield

bonus_shield:
        .db     7
        .db     %01000100
        .db     %10101010
        .db     %10010010
        .db     %10000010
        .db     %01000100
        .db     %00101000
        .db     %00010000
        .db     %01000100
        .db     %11101110
        .db     %11111110
        .db     %11111110
        .db     %01111100
        .db     %00111000
        .db     %00010000

bonus_weapon:
        .db     7
        .db     %10000010
        .db     %10000010
        .db     %10000010
        .db     %10000010
        .db     %10000010
        .db     %10000010
        .db     %10000010
        .db     %00000000
        .db     %00000000
        .db     %00010000
        .db     %00111000
        .db     %00010000
        .db     %00000000
        .db     %00000000

bonus_points:
        .db     7
        .db     %00111000
        .db     %00101000
        .db     %11101110
        .db     %10000010
        .db     %11101110
        .db     %00101000
        .db     %00111000
        .db     %00111000
        .db     %00111000
        .db     %11111110
        .db     %11111110
        .db     %11111110
        .db     %00111000
        .db     %00111000
