;##################################################################
;
;   Phoenix III for the TI-86 - Main enemy handling
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated April 1, 2001.
;
;##################################################################

;############## Main enemy processing

process_enemies:
        ld      hl,enemies
        ld      b,e_num
procen_loop:
        ld      a,(hl)
        or      a
        jp      z,no_enemy
        push    bc
        push    hl

;############## Load coordinates

        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      e,(hl)

;############## Firing

        push    hl
        ld      bc,e_fire_timer-e_y
        add     hl,bc
        inc     (hl)
        ld      a,(hl)
        dec     hl
        cp      (hl)
        jr      nz,not_firing
        inc     hl
        ld      (hl),0
        inc     hl
        ld      a,(hl)
        push    de
        call    enemy_shoot
        pop     de
not_firing:        
        pop     hl

;############## Display image

        ld      bc,6
        add     hl,bc           ; HL -> e_image_pos
        push    hl
        call    _ldHLind
        call    _ldHLind
        call    drw_spr

;############## Cycle through image if appropriate

        pop     hl
        push    hl
        inc     hl
        inc     hl              ; HL -> e_image_cnt
        ld      a,(hl)
        or      a
        jr      z,static_image
        dec     (hl)
        jr      nz,static_image

        dec     hl
        ld      d,(hl)
        dec     hl
        ld      e,(hl)
        ex      de,hl           ; HL = path pointer, DE -> e_image_path
        inc     hl
        inc     hl
looped_back:
        ld      a,(hl)          ; A = new countdown
        bit     7,a
        jr      z,no_loopback
        ld      c,a
        ld      b,$FF
        add     hl,bc
        jr      looped_back
no_loopback:
        inc     hl

        ex      de,hl           ; DE = path pointer, HL -> e_image_path
        ld      (hl),e
        inc     hl
        ld      (hl),d
        inc     hl
        ld      (hl),a
static_image:

;############## Cycle through path data

        pop     hl
        dec     hl              ; HL -> e_path_cnt
        dec     (hl)            ; count down by one
        dec     hl
        dec     hl              ; HL -> e_path_pos 
        jr      nz,no_end       ; If not end of countdown, no new direction

        ld      e,(hl)
        inc     hl
        ld      d,(hl)          ; DE = path pointer
        ex      de,hl           ; HL = path pointer
        inc     hl
        inc     hl
        ld      a,(hl)          ; A = new countdown
        or      a
        jr      z,enemy_end
        inc     hl              ; HL = new path pointer
        ex      de,hl           ; DE = new path pointer

        inc     hl
        ld      (hl),a
        dec     hl
        ld      (hl),d          ; store new path pointer
        dec     hl
        ld      (hl),e

;############## Read current path data and update coordinates

no_end: call    _ldHLind
        call    _ldHLind        ; L = XV, H = YV
        ld      b,h
        call    div4
        ld      e,b             ; E = Y pixel change
        ld      b,l             
        call    div4            ; B = X pixel change

        pop     hl
        push    hl

        inc     hl
        ld      a,(hl)
        add     a,b
        ld      (hl),a
        inc     hl
        inc     hl
        ld      a,(hl)
        add     a,e
        ld      (hl),a

        pop     hl
enemy_killed:
        pop     bc
no_enemy:
        ld      de,e_size
        add     hl,de
        dec     b
        jp      nz,procen_loop
        ret

enemy_end:
        pop     hl
        ld      a,(hl)
        add     a,a
        call    z,deploy_bonus
        ld      (hl),0
        jr      enemy_killed

;############## Divide B by 4 with rotating rounding
;
; This routine divides B by 4 with rounding of fractional values up or
; down decided by the cycle counter.  If the fraction is 1/4, it will be
; rounded up 1/4 of the time, 1/2 is rounded up 1/2 of the time, and 3/4
; is rounded up 3/4 of the time.  This is used for moving objects with
; fractional velocities in such a way that (over many frames) the velocity
; averages out to the specified fraction.  If the fraction is 1/2, the
; distance will every other frame, rather than having two frames in a row
; of each value, as this gives smoother motion.
;
; Returns result in B.  Modifies A and B.

div4:   ld      a,b
        sra     b
        sra     b
        and     3
        ret     z
        dec     a
        jr      z,onefourth
        dec     a
        jr      z,onehalf

threefourths:
        ld      a,(game_timer)
        inc     a
        and     3
        ret     z
        inc     b
        ret

onehalf:
        ld      a,(game_timer)
        bit     0,a
        ret     nz
        inc     b
        ret

onefourth:
        ld      a,(game_timer)
        and     3
        ret     nz
        inc     b
        ret
