;##################################################################
;
;   Phoenix III for the TI-86 - Main enemy handling
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated April 10, 2001.
;
;##################################################################

;############## Fire enemy bullets
;
; A = firing type, D = X coordinate, E = Y coordinate
; Changes all registers

enemy_shoot:
        ld      (shoot_select+1),a
shoot_select:
        jr      shoot_none
shoot_none:
        ret
        jp      shoot_1

shoot_2:
        push    de
        call    find_enemy_bullet
        pop     de
        ret     nz

        ld      (hl),7
        inc     hl
        inc     d
        inc     d
        ld      (hl),d
        inc     hl
        ld      (hl),2
        inc     hl
        inc     e
        inc     e
        inc     e
        ld      (hl),e
        inc     hl
        ld      (hl),5
        inc     hl
        ld      (hl),$97
        ret

shoot_1:
        push    de
        call    find_enemy_bullet
        pop     de
        ret     nz

        ld      (hl),1
        inc     hl
        inc     d
        inc     d
        ld      (hl),d
        inc     hl
        ld      (hl),4
        inc     hl
        inc     e
        inc     e
        ld      (hl),e
        inc     hl
        ld      (hl),4
        inc     hl
        ld      (hl),$98

        inc     hl
        ld      (hl),1
        ld      a,(player_x)
        sub     d
        jr      nc,player_not_right
        ld      (hl),-1
player_not_right:

        inc     hl
        ld      (hl),1
        ld      a,(player_y)
        sub     e
        ret     nc
        ld      (hl),-1
        ret       

;############## Locate an unused enemy bullet
;
; Modifies all registers
; Returns HL pointing to bullet
; Zero flag set = empty bullet found

find_enemy_bullet:
        ld      hl,flak
        ld      de,f_size
        ld      b,f_count
        xor     a
loop_find_enemy_bullet:
        cp      (hl)
        ret     z
        add     hl,de
        djnz    loop_find_enemy_bullet
        ret

;############## Enemy bullet images

simple_bullet:
        .db     4
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
