;##################################################################
;
;   Phoenix III - TI-86 startup code
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated June 12, 2001.
;
;##################################################################
                                     
#include "phx3ti86.h"
#include "phoenix3.h"
#define __STARTUP__

;############## Program header

        .org    _asm_exec_ram

        nop
        jp      startup
        .dw     0
        .dw     title

;############## Permanent program data

data_start:
        .db     0
        .ds     vars_end-variables-1
#include "scores.h"
data_end:

;############## Main program text

title:  .db     "Phoenix III 0.20 by Patrick D",0
name:   .db     $12,8,"phoenix3"
data:   .db     $12,8,"phx3data"
code:   .db     $12,8,"phx3code"

;############## Essential TI-86 initialization

startup:
        call    _flushAllMenus
        call    _runindicoff

        di

;############## Move the stack

        ld      hl,$FC00-400
        ld      de,_plotSScreen+$400-400
        ld      bc,400
        ldir
        ld      (oldsp+1),sp
        ld      hl,_plotSScreen+$400-$FC00
        add     hl,sp
        ld      sp,hl

;############## Load data files

        ld      hl,code
        ld      de,$807d
        call    load_file

        ld      hl,data
        ld      de,$a000
        call    load_file

;############## Run the program

        call    main_code

;############## Exit routines

program_exit:
        di

        ld      hl,textShadow
        ld      de,textShadow+1
        ld      (hl),' '
        ld      bc,167
        ldir
        call    _clrLCD
        ld      hl,0
        ld      (_curRow),hl
        ld      (iy+13),6

;############## Save data

        ld      hl,name
        call    _MOV10TOOP1
        call    _FINDSYM                ; BDE -> start of program
        ld      hl,data_start+4-_asm_exec_ram
        ld      a,b
        add     hl,de
        adc     a,0                     ; AHL -> perm storage in variable
        call    _SET_ABS_DEST_ADDR
        ld      a,0
        ld      hl,data_start
        call    _SET_ABS_SRC_ADDR
        ld      a,0
        ld      hl,data_end-data_start
        call    _SET_MM_NUM_BYTES
        call    _mm_ldir             

;############## Restore stack to original location

oldsp:  ld      sp,0
        ld      de,$FC00-400
        ld      hl,_plotSScreen+$400-400
        ld      bc,400
        ldir

        im      1
        ei
        ret

;############## Decompression code and area

load_file:
        push    de
        call    _MOV10TOOP1
        call    _FINDSYM                ; BDE -> start of string
        jp      c,oldsp
        ld      a,b
        ex      de,hl
        call    _SET_ABS_SRC_ADDR
        xor     a
        ld      hl,temp_area
        call    _SET_ABS_DEST_ADDR
        xor     a
        ld      hl,2
        call    _SET_MM_NUM_BYTES
        call    _mm_ldir
        xor     a
        ld      hl,temp_area
        call    _SET_ABS_DEST_ADDR
        xor     a
        ld      hl,(temp_area)
        call    _SET_MM_NUM_BYTES
        call    _mm_ldir

        ld      a,%01000001
        out     (6),a

        ld      hl,temp_area
        pop     de       

#include "lite86.asm"

temp_area:

        .end
