;##################################################################
;
;   Phoenix III for the TI-Z80 - variable allocations
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated May 27, 2001.
;
;##################################################################

;############## Permanent variables

saved_flag          =variables
ycoord              =variables+1        ; Y coorinate in map
map_pos             =variables+2        ; position of map data in use
game_timer          =variables+4        ; number of game ticks from beginning
player_y            =variables+6   
player_x            =variables+7
bullets             =variables+8
enemies             =variables+$50
flak                =variables+$1d0     ; Enemy bullets
level               =variables+$210     ; 3-byte BCD values
score               =variables+$213
shield              =variables+$216
weapon_power        =variables+$219
level_pointer       =variables+$21a
level_delay         =variables+$21c
extra_power         =variables+$21e
vars_end            =variables+$21f

scores              =vars_end
#ifdef __TI83__
scores_end          =scores+(16*7)
#else
scores_end          =scores+(20*7)
#endif

vars_size           =vars_end-saved_flag

;############## Enemy bullet structure description

f_type              =0
f_x                 =1
f_w                 =2
f_y                 =3
f_h                 =4
f_dmg               =5
f_misc              =6
f_size              =8
f_count             =8

;############## Bullet structure description

b_type              =0
b_x                 =1
b_w                 =2
b_y                 =3
b_h                 =4
b_misc              =5
b_size              =6

b_count             =12

;############## Enemy structure description

e_active            =0                  ; 0 - dead, 1 - normal, 128 - boom
e_x                 =1
e_w                 =2
e_y                 =3
e_h                 =4
e_dmg               =5
e_path_pos          =6                  ; pointer to position in path list
e_path_cnt          =8                  ; number of clocks to path advance
e_image_pos         =9                  ; pointer to position in image list
e_image_cnt         =11                 ; number of clocks to image advance
e_fire_rate         =12
e_fire_timer        =13
e_fire_type         =14
e_size              =24

e_num               =16

;############## Temporary variables

gs_page             =textShadow         ; F0 = F000 / F400, F8 = F800 / FC00
gs_counter          =textShadow+1       ; 0/2 = plane 1, 4 = plane 2
gfx_buffer          =textShadow+2       ; graphics buffer
scroll_line         =textShadow+4       ; # of lines from bottom for the top
scroll_size         =textShadow+5       ; size of those lines
noscroll_size       =textShadow+7       ; size of rest of screen
num_cycles          =textShadow+9       ; # grayscale frames since last swap
jp2nd               =textShadow+10      ; was 2nd held at last frame?
game_over           =textShadow+11      ; should scoring be done?

;############## Addresses within level data

#define map_ptr             universe_data
#define map_end_ptr         universe_data+2
#define tiles_ptr           universe_data+4
#define title_picture_ptr   universe_data+6
#define level_data          universe_data+$10
