;##################################################################
;
;   Phoenix III for the TI-86 - main code
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated May 27, 2001.
;
;##################################################################

#ifndef __TI85__

#include "phx3ti86.h"
#include "phoenix3.h"
#define ROM_CALL(xyz) call xyz

        .org    main_code

        jp      init

#endif

#include "lowlevel.asm"

;############## Initialize game

main:
        call    init_panel

        ld      a,(saved_flag)
        or      a
        jr      nz,saved_game

        ld      hl,variables
        ld      de,variables+1
        ld      bc,vars_end-1-variables
        ld      (hl),0
        ldir

        ld      hl,$4856
        ld      (player_y),hl

        ld      a,$10
        ld      (shield+2),a

;############## Title screen

        call    initialize_background
        ei

        call    SUPER_GET_KEY
        call    initialize_enemies
title_loop:
        call    wait_next_frame
        call    display_scrolled
        call    scroll_screen
        call    do_player
        call    show_title_picture
        call    SUPER_GET_KEY
        call    handle_keys
        cp      K_SECOND
        jr      nz,title_loop
        jr      gameplay_loop

;############## Restore saved game

saved_game:
        xor     a
        ld      (saved_flag),a
        call    initialize_background
        ei

        call    SUPER_GET_KEY

;############## Main game loop

gameplay_loop:
        call    wait_next_frame         ; Wait next frame, swap screen

        call    display_scrolled        ; Render background into buffer
        call    scroll_screen           ; Move background to new position

        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl

        call    add_next_enemy

        call    do_player
        call    process_bullets
        call    process_enemies
        call    hit_enemies
        call    hit_player
        call    enemy_bullets

        call    show_panel              ; Draw information panel

        call    SUPER_GET_KEY
        cp      K_ENTER
        jr      z,pause_game
        cp      K_SECOND
        jp      z,player_shoot
        call    handle_keys
        cp      K_MORE
        jr      nz,gameplay_loop

save:   ld      a,68
        ld      (saved_flag),a
        ret

pause_game:
        call    wait_next_frame
        ld      de,(gfx_buffer)
        ld      a,$08
        xor     d
        ld      h,a
        ld      l,e
        ld      bc,$800
        ldir

pause_loop:
        call    wait_next_frame
        call    SUPER_GET_KEY
        call    handle_keys
        cp      K_ENTER
        jr      nz,pause_loop
        jr      gameplay_loop

;############## Generic key handling

handle_keys:
        cp      K_PLUS
        push    af
        call    z,contrast_up
        pop     af
        cp      K_MINUS
        push    af
        call    z,contrast_down
        pop     af
        cp      K_EXIT
        ret     nz
        pop     af
        ret

contrast_up:
        ld      a,(CONTRAST)
        cp      $1f
        ret     z
        inc     a
        out     (2),a
        ld      (CONTRAST),a
        ret

contrast_down:
        ld      a,(CONTRAST)
        or      a
        ret     z
        dec     a
        out     (2),a
        ld      (CONTRAST),a
        ret

;############## Display title picture

show_title_picture:
        ld      de,(gfx_buffer)
        ld      hl,$102
        add     hl,de
        ld      de,(title_picture_ptr)

        ld      b,32
show_title_oloop:
        push    bc
        ld      b,8
show_title_iloop:
        ld      a,(de)
        ld      c,a
        inc     d
        ld      a,(de)
        or      c
        cpl
        ld      c,a                     ; A = mask, C = mask
    
        and     (hl)
        ld      (hl),a
        ld      a,(de)
        or      (hl)
        ld      (hl),a                  ; write first plane
    
        inc     h
        inc     h
        inc     h
        inc     h                      
        dec     d
        ld      a,c
        and     (hl)
        ld      (hl),a
        ld      a,(de)
        or      (hl)
        ld      (hl),a                  ; write second plane
        dec     h
        dec     h
        dec     h
        dec     h

        inc     de
        inc     l
        djnz    show_title_iloop
        ld      bc,8
        add     hl,bc
        pop     bc
        djnz    show_title_oloop
        ret

;############## Miscellaneous

        .include "drwspr.asm"
        .include "player.asm"
        .include "info.asm"
        .include "bullets.asm"
        .include "enemies.asm"
        .include "entry.asm"
        .include "enemyhit.asm"
        .include "collide.asm"
        .include "hityou.asm"
        .include "eshoot.asm"
        .include "ebullets.asm"
        .include "bonuses.asm"
        .include "scores.asm"

        .end  
