;##################################################################
;
;   P H O E N I X        I I I        F O R        T I - 8 3 +
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated June 23, 2001.
;
;##################################################################

;############## TI-83+ system header

#define TI83P

#include "ion.inc"
#include "keys.inc"

#define TEXT_MEM saferam2+200
#define textShadow TEXT_MEM

#define __TI83__

#define ROM_CALL(kewl_routinez) bcall(kewl_routinez)

        .org    progstart-2
        .db     $BB,$6D
        ret
        jr  nc,start

interrupt_entry =$9898
interrupt_byte  =$98
interrupt_table =$9900
interrupt_reg   =$99
backup_storage  =$9A01

GFX_AREA        =plotsscreen

K_ENTER         =G_ENTER
K_PLUS          =G_PLUS
K_MINUS         =G_MINUS
K_SECOND        =G_2nd
K_EXIT          =G_DEL
K_MORE          =G_MODE
K_CLEAR         =G_CLEAR
K_DEL           =G_DEL

D_ZT_STR        =_puts
D_HL_DECI       =_disphl
TX_CHARPUT      =_putc
CLEARLCD        =_clrlcdf
_clrLCD         =_clrlcdf
CURSOR_ROW      =currow
CURSOR_COL      =curcol
_curRow         =currow
_curCol         =curcol

        .db     "Phoenix III 0.20 for Ion/83+",0

start:
        ld      (iy+13),0
        ROM_CALL(CLEARLCD)
        ld      hl,0
        ld      (currow),hl
        ld      hl,message
        ROM_CALL(D_ZT_STR)

        ld      hl,show_frame+4
loop_choose_gfx:
        call    SUPER_GET_KEY
        cp      G_1
        jr      z,gfx1
        cp      G_2
        jr      z,gfx2
        cp      G_3
        jr      z,gfx3
        jr      loop_choose_gfx

gfx2:   ld      (hl),2
        jr      gfxcd

gfx3:   ld      (hl),0
        jr      gfxcd

gfx1:   ld      (hl),4

gfxcd:  call    init
        im      1
        ld      (iy+13),6
        ret

message:
        .db     "Choose gfx mode:"
        .db     "1: Grayscale    "
        .db     "2: Black & White"
        .db     " light gr.=White"
        .db     "3: Black & White"
        .db     " light gr.=Black",0

;############## Data

variables:
#include "phoenix3.h"
        .db     0
        .ds     vars_size-1
#include "scores.h"

;############## Game initialization

phoenix3:
        ld      a,(saved_flag)
        or      a
        jr      nz,saved_game

        ld      hl,variables
        ld      de,variables+1
        ld      bc,vars_end-1-variables
        ld      (hl),0
        ldir

        ld      hl,$4856
        ld      (player_y),hl

        ld      a,$10
        ld      (shield+2),a

;############## Title screen

        call    initialize_background
        ei

        call    SUPER_GET_KEY
        call    initialize_enemies
title_loop:
        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl
        call    show_frame
        call    display_scrolled
        call    scroll_screen
        call    do_player
        call    show_title_picture
        call    SUPER_GET_KEY
        call    handle_keys
        cp      K_SECOND
        jr      nz,title_loop
        jr      gameplay_loop

;############## Restore saved game

saved_game:
        xor     a
        ld      (saved_flag),a
        call    initialize_background
        ei

        call    SUPER_GET_KEY

;############## Main game loop

gameplay_loop:
        call    show_frame              ; Wait next frame, swap screen

        call    display_scrolled        ; Render background into buffer
        call    scroll_screen           ; Move background to new position

        ld      hl,(game_timer)
        inc     hl
        ld      (game_timer),hl

        call    add_next_enemy

        call    do_player
        call    process_bullets
        call    process_enemies
        call    hit_enemies
        call    hit_player
        call    enemy_bullets

        call    show_panel              ; Draw information panel

        call    SUPER_GET_KEY
        cp      K_ENTER
        jr      z,pause_game
        cp      K_SECOND
        jp      z,player_shoot
        call    handle_keys
        cp      K_MORE
        jr      nz,gameplay_loop

save:   ld      a,68
        ld      (saved_flag),a
        ret

pause_game:
        ld      de,(gfx_buffer)
        ld      a,$08
        xor     d
        ld      h,a
        ld      l,e
        ld      bc,$800
        ldir

pause_loop:
        call    SUPER_GET_KEY
        call    handle_keys
        cp      K_ENTER
        jr      nz,pause_loop
        jr      gameplay_loop

;############## Generic key handling

handle_keys:
        cp      K_PLUS
        push    af
        call    z,contrast_up
        pop     af
        cp      K_MINUS
        push    af
        call    z,contrast_down
        pop     af
        cp      K_EXIT
        ret     nz
        pop     af
        ret

contrast_up:
        ld      a,(contrast)
        cp      $27
        ret     z
        inc     a

set_contrast:
        ld      (contrast),a
        add     a,$18
        or      $c0
        out     ($10),a
        ret

contrast_down:
        ld      a,(contrast)
        or      a
        ret     z
        dec     a
        jr      set_contrast

;############## Display title picture

show_title_picture:
        ld      de,main_plane0
        ld      hl,$102
        add     hl,de
        ld      de,title_picture

        ld      b,32
show_title_oloop:
        push    bc
        ld      b,8
show_title_iloop:
        ld      a,(de)
        ld      c,a
        inc     d
        ld      a,(de)
        or      c
        cpl
        ld      c,a                     ; A = mask, C = mask
    
        and     (hl)
        ld      (hl),a
        ld      a,(de)
        or      (hl)
        ld      (hl),a                  ; write first plane
    
        inc     h
        inc     h
        inc     h
        inc     h                      
        dec     d
        ld      a,c
        and     (hl)
        ld      (hl),a
        ld      a,(de)
        or      (hl)
        ld      (hl),a                  ; write second plane
        dec     h
        dec     h
        dec     h
        dec     h

        inc     de
        inc     hl
        djnz    show_title_iloop
        ld      bc,8
        add     hl,bc
        pop     bc
        djnz    show_title_oloop
        ret

;############## Other extremely important code

        .include "lowlti83.asm"
        .include "drwspr.asm"
        .include "player.asm"
        .include "info.asm"
        .include "bullets.asm"
        .include "enemies.asm"
        .include "entry.asm"
        .include "enemyhit.asm"
        .include "collide.asm"
        .include "hityou.asm"
        .include "eshoot.asm"
        .include "ebullets.asm"
        .include "bonuses.asm"
        .include "scores.asm"

;############## Buffers

background_plane0:
        .ds     1024
background_plane1:
        .ds     1024
main_plane0:
        .ds     1024
main_plane1:
        .ds     1024
TEMP_AREA:
        .ds     1216

test_coords:
        .dw     0,0

;############## Actual level data

universe_data:
        .dw     map
        .dw     map_end
        .dw     tiles
        .dw     title_picture
        .dw     0,0,0,0

        .include "levels.asm"

        .include "images.asm"
map:    .include "map.h"
map_end:
tiles:  .include "tiles.h"
title_picture:

        .end
