;##################################################################
;
;   P H O E N I X        I I I        F O R        T I - 8 5
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated June 23, 2001.
;
;##################################################################

#define __TI85__

#include "usgard.h"
#include "phx3ti85.h"

        .org    $9800

        .db     "Phoenix III 0.20 by Patrick D",0

        ld      hl,(PROGRAM_ADDR)
        ld      de,memory_initialize-$9800
        add     hl,de
        ld      de,DELC_LEN
        ld      bc,memory_initialize_end-memory_initialize
        ldir
        jp      DELC_LEN

;############## MEMORY SWAPPING CODE (RUN FROM DELC_LEN)

memory_initialize:
        nop
        ld      hl,(PROGRAM_ADDR)     
        ld      de,$9800
        ld      bc,end_of_code-$9800
        call    memory_exchange

        call    main_program

        ld      de,(PROGRAM_ADDR)
        ld      hl,$9800
        ld      bc,end_of_code-$9800

memory_exchange =$-memory_initialize+DELC_LEN

#include "exchange.asm"

memory_initialize_end:

;############## START OF NORMAL CODE (RUN WITH PROGRAM STARTING AT $9800)
;
; This section of code must rearrange memory to make temporary storage
; available, including storage from $E800 to $F7FF for video buffers.
; The first step is to check if necessary free memory exists; this requires
; computing the end of "used" space (last variable data or end of program,
; whichever is greater);
;
; Then the VAT and stack can be backed up into the memory area immediately
; before $E740, and the program run with the SP adjusted.

main_program:
        ld      de,(FIRST_FREE)         ; DE = first byte unused (by VAT)
        ld      hl,end_of_code          ; HL = first byte unused (by code)
        call    CP_HL_DE                ; test HL - DE
        jr      nc,not_past_first_free  ; skip if positive (HL greater)
        ex      de,hl                   ; HL = first byte unused (by VAT)
not_past_first_free:                    ; HL = forst byte unused

        ld      de,$1400+192            ; DE = size of storage 
        add     hl,de                   ; HL = end of empty space needed
        ld      de,(VAT_END)
        call    CP_HL_DE
        jr      c,enough_mem

        call    CLEARLCD
        ld      (CURSOR_ROW),de
        ld      hl,no_mem
        call    D_ZT_STR
        jp      OTH_PAUSE

no_mem: .db     "ERROR: 5.25K FREE RAM"
        .db     "REQUIRED!",0

enough_mem:
        di

        xor     a
        ld      hl,$FBFF                ; one byte before last to be saved
        ld      de,(VAT_END)            ; one byte before first to be saved
        sbc     hl,de                   ; size to save
        ld      b,h
        ld      c,l
        ld      hl,$FBFF
        ld      de,$E73F
        lddr                            ; save data

        ld      hl,$E740-$FC00
        add     hl,sp
        ld      sp,hl                   ; adjust stack pointer

        ld      hl,GRAPH_MEM+$C0        ; save data right after GRAPH_MEM
        ld      de,$E740
        ld      bc,$C0
        ldir

        call    init

        di

        ld      de,GRAPH_MEM+$C0        ; restore data right after GRAPH_MEM
        ld      hl,$E740
        ld      bc,$C0
        ldir

        ld      hl,$FC00-$E740
        add     hl,sp
        ld      sp,hl                   ; adjust stack pointer

        xor     a
        ld      hl,$FBFF                ; one byte before last to be saved
        ld      de,(VAT_END)            ; one byte before first to be saved
        sbc     hl,de                   ; size to save
        ld      b,h
        ld      c,l
        ld      de,$FBFF
        ld      hl,$E73F
        lddr                            ; save data

        ei
        ret

;############## Data

variables:
#include "phoenix3.h"
        .db     0
        .ds     vars_size-1
#include "scores.h"

;############## Main program

#include "phx3code.asm"

;############## Actual level data

universe_data:
        .dw     map
        .dw     map_end
        .dw     tiles
        .dw     title_picture
        .dw     0,0,0,0

        .include "levels.asm"

        .include "images.asm"
map:    .include "map.h"
map_end:
tiles:  .include "tiles.h"
title_picture:

end_of_code     =title_picture+512
